/* -------------------------------------------------------------------- */
/*	TRAP.CPP					Citadel 								*/
/* -------------------------------------------------------------------- */
/*	Trap file and aide message code 									*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "msg.h"
#include "events.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	trap()				Record a line to the trap file					*/
/*	SaveAideMess()		Save aide message being created 				*/
/*	amPrintf()			aide message printf 							*/
/*	amZap() 			Zap aide message being created					*/
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*	trap()				Record a line to the trap file					*/
/* -------------------------------------------------------------------- */
void trap(const char *string, int what)
	{
	char dtstr[20];
	char temp[128];

	if (what == T_LOGIN || what == T_NEWROOM || what == T_ERROR)
		{
		addStatusText(string, time(NULL));
		}

	switch (what)
		{
		case T_CARRIER: 	doEvent(EVT_CARRIER);	break;
		case T_NEWROOM: 	doEvent(EVT_NEWROOM);	break;
		case T_ANONYMOUS:	doEvent(EVT_ANONYMOUS); break;
		case T_CHAT:		doEvent(EVT_CHAT);		break;
		case T_PASSWORD:	doEvent(EVT_PASSWORD);	break;
		case T_AIDE:		doEvent(EVT_AIDE);		break;
		case T_SYSOP:		doEvent(EVT_SYSOP); 	break;
		case T_UPLOAD:		doEvent(EVT_UPLOAD);	break;
		case T_DOWNLOAD:	doEvent(EVT_DOWNLOAD);	break;
		case T_ERROR:		doEvent(EVT_ERROR); 	break;
		case T_NETWORK: 	doEvent(EVT_NETWORK);	break;
		case T_ACCOUNT: 	doEvent(EVT_ACCOUNT);	break;
		case T_CRON:		doEvent(EVT_CRON);		break;
		case T_HACK:		doEvent(EVT_HACK);		break;
		}

	// check to see if we are supposed to log this event
	if (!cfg.trapit[what])
		{
		return;
		}

	strftime(dtstr, 19, getmsg(130), 0l);

	if (strlen(string) < 128)
		{
		strcpy(temp, string);
		stripansi(temp);
		}

	if (!onConsole || !cfg.NoConsoleTrap)
		{
		#ifdef WINCIT
			trapDisp(getmsg(134), dtstr,
					(strlen(string) < 128) ? temp : string, ns);
		#else
			fprintf(trapfl, getmsg(134), dtstr,
					(strlen(string) < 128) ? temp : string, bn);

			fflush(trapfl);
		#endif
		}
	}

/* -------------------------------------------------------------------- */
/*	SaveAideMess()		Save aide message being created 				*/
/* -------------------------------------------------------------------- */
void SaveAideMess(const char *group, r_slot RoomNumber)
	{
	if (TI()AideMsg)
		{
		if (strlen(TI()AideMsg->GetText()) > 10)
			{
			TI()AideMsg->SetRoomNumber(RoomNumber);

			if (group)
				{
				TI()AideMsg->SetGroup(group);
				}

			systemMessage(TI()AideMsg);
			}

		delete TI()AideMsg;
		TI()AideMsg = NULL;
		}
	}

/* -------------------------------------------------------------------- */
/*	amPrintf()			aide message printf 							*/
/* -------------------------------------------------------------------- */
void cdecl amPrintf(const char *fmt, ... )
	{
	// no message in progress? make one!
	if (TI()AideMsg == NULL)
		{
		TI()AideMsg = new Message;
		}

	if (TI()AideMsg)
		{
		va_list ap;
		char Buffer[128];

		va_start(ap, fmt);
		vsprintf(Buffer, fmt, ap);
		va_end(ap);

		TI()AideMsg->AppendText(Buffer);
		}
	}

/* -------------------------------------------------------------------- */
/*	amZap() 			Zap aide message being created					*/
/* -------------------------------------------------------------------- */
void amZap(void)
	{
	if (TI()AideMsg)
		{
		delete TI()AideMsg;
		TI()AideMsg = NULL;
		}
	}

/* -------------------------------------------------------------------- */
/*	f4 trap stuff														*/
/* -------------------------------------------------------------------- */
void addStatusText(const char *string, time_t when)
	{
#ifndef WINCIT
	statRecord *theStatus;

	if ((theStatus = addStatus()) != NULL)
		{
		strncpy(theStatus->theStatus, string, 60);
		theStatus->theStatus[60] = 0;
		theStatus->theTime = when;
		updateStatus = TRUE;
		StatusLine.Update();
		}
#endif
	}

statRecord *addStatus(void)
	{
	int old_end = sl_end;

	sl_end = ++sl_end % cfg.statnum;
	if (sl_end == sl_start)
		{
		sl_start++;
		}
	return (&statList[old_end]);
	}
