// --------------------------------------------------------------------------
// Citadel: TallyBuf.H
//
// How to use the talley buffer subsystem.

#include "auxtab.h"
typedef struct
	{
	m_slot	Total;					// total number of messages in the room
	m_slot	Messages;				// # messages user can see in room
	m_slot	New;					// # messages new to the user in room

#if defined(AUXMEM) || defined(WINCIT)
	uint	MsgRoom;				// # messages user left this call
#else
	uint	MsgRoom 	: 8;		// # messages user left this call
#endif
	Bool	HasMail 	: 1;		// if user has new mail in the room
	Bool	HasOldMail	: 1;		// if user has new mail in the room
	Bool	Visited 	: 1;		// if user has seen the room this call
	Bool	Bypassed	: 1;		// if user has bypassed room this call
	AUXMEMWINCODE(Bool Valid : 1;)	// if it is valid for this room.
	} talleyBuffer;


#ifdef AUXMEM
	#define TALLEYBUFPERPAGE	(AUXPAGESIZE / sizeof(talleyBuffer))

	typedef struct
		{
		int 	talleyBlocksInHeap;
		auxTabList *tbList;
		} talleyTaskInfo;
#endif


#ifdef AUXMEM
	#define getTalleyBuf(s) ((talleyBuffer *) (LoadAuxmemBlock((s), \
						&(((talleyTaskInfo *) (TI()talleyInfo))->tbList), \
						TALLEYBUFPERPAGE, sizeof(talleyBuffer))))
#else
	#define getTalleyBuf(s) (&((talleyBuffer *) TI()talleyInfo)[(r_slot)(s)])
#endif

// TALLYBUF.CPP
#ifdef MULTI
Bool CreateTalleyBuffer(taskInfo *NewTask);
void DestroyTalleyBuffer(taskInfo *OldTask);
#else
Bool CreateTalleyBuffer(void);
void DestroyTalleyBuffer(void);
#endif
int GetMessagesEnteredInRoom(r_slot RoomIndex);
void IncrementMessagesEnteredInRoom(r_slot RoomIndex);
Bool WasRoomBypassed(r_slot RoomIndex);
m_slot GetRoomNewMessages(r_slot RoomIndex);
void SetRoomNewMessages(r_slot RoomIndex, m_slot NumNew);
void IncrementRoomNewMessages(r_slot RoomIndex);
void DecrementRoomNewMessages(r_slot RoomIndex);
void SetRoomBypass(r_slot RoomIndex, Bool BypassState);
void SetRoomVisited(r_slot RoomIndex, Bool VisitState);
void SetRoomHasMail(r_slot RoomIndex, Bool MailState);
void SetRoomHasOldMail(r_slot RoomIndex, Bool OldMailState);
void SetRoomMessagesEntered(r_slot RoomIndex, int Messages);
m_slot GetRoomMessages(r_slot RoomIndex);
void IncrementRoomMessages(r_slot RoomIndex);
void DecrementRoomMessages(r_slot RoomIndex);
m_slot GetRoomTotalMessages(r_slot RoomIndex);
void IncrementRoomTotalMessages(r_slot RoomIndex);
void DecrementRoomTotalMessages(r_slot RoomIndex);
Bool IsRoomMail(r_slot RoomIndex);
Bool IsRoomOldMail(r_slot RoomIndex);
Bool IsRoomVisited(r_slot RoomIndex);
void DebugAuxmemTalleyBuf(void);
void roomtalley(void);
