/* -------------------------------------------------------------------- */
/*	SETINFO.CPP 				Citadel 								*/
/* -------------------------------------------------------------------- */
/*		This module deals with FILEINFO.DAT and the .RI commands		*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "infofile.h"
#include "log.h"
#include "msg.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	SetFileInfo()	menu level .as routine sets entry to aide's name    */
/*					if none present or leaves original uploader 		*/
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*	SetFileInfo()	menu level .as routine sets entry to aide's name    */
/*					if none present or leaves original uploader 		*/
/* -------------------------------------------------------------------- */
void SetFileInfo(void)
	{
	label filename;
	label uploader;
	char comments[64];
	char path[80];
	fInfo old;

	SetDoWhat(AIDESETINFO);

	memset(&old, 0, sizeof(old));

	doCR();
	getNormStr(getmsg(1073), filename, LABELSIZE, ECHO);

	if (!*filename)
		{
		return;
		}

	/* no bad file names */
	if (!IsFilenameLegal(filename, FALSE))
		{
		CRmPrintfCR(getmsg(1050), filename);
		return;
		}

	sprintf(path, sbs, GetCurrentRoomDirectory(), filename);

	if (!filexists(path))
		{
		CRmPrintfCR(getmsg(1050), filename);
		return;
		}

	if (!GetSingleFileInfo(GetCurrentRoomDirectory(), filename, &old))
		{
		strcpy(uploader, TI()CurrentUser->GetName());
		}
	else
		{
		strcpy(uploader, old.uploader);
		}

	getNormStr(getmsg(1061), comments, 63, TRUE);

	if (*comments)
		{
		UpdateInfoFile(GetCurrentRoomDirectory(), filename, uploader,
				comments, 0, 0);

		Message *Msg = new Message;

		if (Msg)
			{
			Msg->SetTextWithFormat(getmsg(1074), filename,
					TI()CurrentUser->GetName());

			trap(Msg->GetText(), T_AIDE);

			Msg->AppendText(getmsg(1504));
			Msg->AppendText(bn);
			Msg->AppendText(spc);
			Msg->AppendText(comments);

			Msg->SetRoomNumber(TI()thisRoom);

			systemMessage(Msg);

			delete Msg;
			}
		else
			{
			mPrintf(getmsg(188), getmsg(1357));
			}
		}
	}
