// --------------------------------------------------------------------------
// Citadel: ScrFUsr.CPP
//
// User... internal script functions.

#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"

#include "log.h"

///////////////////////////// USER STUFF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
void sfUserUseCurrentUser(strList *)
	{
	if (!CurScript->UseCU)
		{
		delete CurScript->UsrUsr;
		}

	CurScript->UseCU = TRUE;
	CurScript->UsrUsr = TI()CurrentUser;
	}

void sfUserStart(strList *)
	{
	if (!CurScript->UseCU)
		{
		delete CurScript->UsrUsr;
		}

	CurScript->UsrUsr = new LogEntry(cfg.maxrooms, cfg.maxgroups,
			cfg.maxjumpback);
	CurScript->UseCU = FALSE;

	SETBOOL(CurScript->UsrUsr != NULL);
	}

void sfUserClear(strList *)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->Clear();
		}
	}

void sfUserDump(strList *)
	{
	if (!CurScript->UseCU)
		{
		delete CurScript->UsrUsr;
		}

	CurScript->UsrUsr = NULL;
	CurScript->UseCU = FALSE;
	}

void sfUserSave(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->Save(evaluateInt(params->string)));
		}
	}

void sfUserLoad(strList *params)
	{
	sfUserDump(NULL);

	const l_index Index = evaluateInt(params->string);

	if (TI()loggedIn && (Index == TI()ThisLog))
		{
		sfUserUseCurrentUser(NULL);
		SETBOOL(TRUE);
		}
	else
		{
		sfUserStart(NULL);

		if (CurScript->UsrUsr)
			{
			SETBOOL(CurScript->UsrUsr->Load(Index));
			}
		// else... sfUserStart() did the SETBOOL() for us.
		}
	}

void sfUserIsInuse(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsInuse());
		}
	}

void sfUserSetInuse(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetInuse(evaluateBool(params->string));
		}
	}

void sfUserIsUpperOnly(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsUpperOnly());
		}
	}

void sfUserSetUpperOnly(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetUpperOnly(evaluateBool(params->string));
		}
	}

void sfUserIsLinefeeds(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsLinefeeds());
		}
	}

void sfUserSetLinefeeds(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetLinefeeds(evaluateBool(params->string));
		}
	}

void sfUserIsExpert(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsExpert());
		}
	}

void sfUserSetExpert(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetExpert(evaluateBool(params->string));
		}
	}

void sfUserIsAide(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsAide());
		}
	}

void sfUserSetAide(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetAide(evaluateBool(params->string));
		}
	}

void sfUserIsTabs(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsTabs());
		}
	}

void sfUserSetTabs(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetTabs(evaluateBool(params->string));
		}
	}

void sfUserIsOldToo(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsOldToo());
		}
	}

void sfUserSetOldToo(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetOldToo(evaluateBool(params->string));
		}
	}

void sfUserIsProblem(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsProblem());
		}
	}

void sfUserSetProblem(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetProblem(evaluateBool(params->string));
		}
	}

void sfUserIsUnlisted(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsUnlisted());
		}
	}

void sfUserSetUnlisted(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetUnlisted(evaluateBool(params->string));
		}
	}

void sfUserIsPermanent(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsPermanent());
		}
	}

void sfUserSetPermanent(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPermanent(evaluateBool(params->string));
		}
	}

void sfUserIsSysop(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsSysop());
		}
	}

void sfUserSetSysop(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetSysop(evaluateBool(params->string));
		}
	}

void sfUserIsNode(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsNode());
		}
	}

void sfUserSetNode(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetNode(evaluateBool(params->string));
		}
	}

void sfUserIsNetUser(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsNetUser());
		}
	}

void sfUserSetNetUser(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetNetUser(evaluateBool(params->string));
		}
	}

void sfUserIsAccounting(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsAccounting());
		}
	}

void sfUserSetAccounting(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetAccounting(evaluateBool(params->string));
		}
	}

void sfUserIsMail(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsMail());
		}
	}

void sfUserSetMail(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMail(evaluateBool(params->string));
		}
	}

void sfUserIsViewRoomDesc(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewRoomDesc());
		}
	}

void sfUserSetViewRoomDesc(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewRoomDesc(evaluateBool(params->string));
		}
	}

void sfUserGetNumKillUser(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(getLLCount(CurScript->UsrUsr->GetKillUserPointer()));
		}
	}

void sfUserGetKillUser(strList *params)
	{
	SETSTR(ns);

	if (CurScript->UsrUsr)
		{
		const strList *theKill = (strList *) getLLNum(CurScript->UsrUsr->
				GetKillUserPointer(), evaluateInt(params->string));

		if (theKill)
			{
			SETSTR(theKill->string);
			}
		}
	}

void sfUserAddKillUser(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->AddKillUser(evaluateString(params->string)));
		}
	}

void sfUserRemoveKillUser(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->RemoveKillUser(evaluateString(params->string)));
		}
	}

void sfUserIsKillUser(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsKillUser(evaluateString(params->string)));
		}
	}

void sfUserGetNumKillNode(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(getLLCount(CurScript->UsrUsr->GetKillNodePointer()));
		}
	}

void sfUserGetKillNode(strList *params)
	{
	SETSTR(ns);

	if (CurScript->UsrUsr)
		{
		const strList *theKill = (strList *) getLLNum(CurScript->UsrUsr->
				GetKillNodePointer(), evaluateInt(params->string));

		if (theKill)
			{
			SETSTR(theKill->string);
			}
		}
	}

void sfUserAddKillNode(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->AddKillNode(evaluateString(params->string)));
		}
	}

void sfUserRemoveKillNode(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->RemoveKillNode(evaluateString(params->string)));
		}
	}

void sfUserIsKillNode(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsKillNode(evaluateString(params->string)));
		}
	}

void sfUserGetNumKillText(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(getLLCount(CurScript->UsrUsr->GetKillTextPointer()));
		}
	}

void sfUserGetKillText(strList *params)
	{
	SETSTR(ns);

	if (CurScript->UsrUsr)
		{
		const strList *theKill = (strList *) getLLNum(CurScript->UsrUsr->
				GetKillTextPointer(), evaluateInt(params->string));

		if (theKill)
			{
			SETSTR(theKill->string);
			}
		}
	}

void sfUserAddKillText(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->AddKillText(evaluateString(params->string)));
		}
	}

void sfUserRemoveKillText(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->RemoveKillText(evaluateString(params->string)));
		}
	}

void sfUserIsKillText(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsKillText(evaluateString(params->string)));
		}
	}

void sfUserGetNumKillRegion(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(getLLCount(CurScript->UsrUsr->GetKillRegionPointer()));
		}
	}

void sfUserGetKillRegion(strList *params)
	{
	SETSTR(ns);

	if (CurScript->UsrUsr)
		{
		const strList *theKill = (strList *) getLLNum(CurScript->UsrUsr->
				GetKillRegionPointer(), evaluateInt(params->string));

		if (theKill)
			{
			SETSTR(theKill->string);
			}
		}
	}

void sfUserAddKillRegion(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->AddKillRegion(evaluateString(params->string)));
		}
	}

void sfUserRemoveKillRegion(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->RemoveKillRegion(evaluateString(params->string)));
		}
	}

void sfUserIsKillRegion(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsKillRegion(evaluateString(params->string)));
		}
	}

void sfUserIsWordInDictionary(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsWordInDictionary(evaluateString(params->string)));
		}
	}

void sfUserAddWordToDictionary(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->AddWordToDictionary(evaluateString(params->string)));
		}
	}

void sfUserRemoveWordFromDictionary(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->RemoveWordFromDictionary(evaluateString(params->string)));
		}
	}

void sfUserGetName(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetName());
		}
	}

void sfUserSetName(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetName(evaluateString(params->string));
		}
	}

void sfUserGetInitials(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetInitials());
		}
	}

void sfUserSetInitials(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetInitials(evaluateString(params->string));
		}
	}

void sfUserGetPassword(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetPassword());
		}
	}

void sfUserSetPassword(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPassword(evaluateString(params->string));
		}
	}

void sfUserGetSurname(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetSurname());
		}
	}

void sfUserSetSurname(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetSurname(evaluateString(params->string));
		}
	}

void sfUserGetTitle(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetTitle());
		}
	}

void sfUserSetTitle(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetTitle(evaluateString(params->string));
		}
	}

void sfUserGetRealName(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetRealName());
		}
	}

void sfUserSetRealName(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetRealName(evaluateString(params->string));
		}
	}

void sfUserGetPhoneNumber(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetPhoneNumber());
		}
	}

void sfUserSetPhoneNumber(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPhoneNumber(evaluateString(params->string));
		}
	}

void sfUserGetForwardAddr(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetForwardAddr());
		}
	}

void sfUserSetForwardAddr(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetForwardAddr(evaluateString(params->string));
		}
	}

void sfUserGetForwardAddrNode(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetForwardAddrNode());
		}
	}

void sfUserSetForwardAddrNode(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetForwardAddrNode(evaluateString(params->string));
		}
	}

void sfUserGetForwardAddrRegion(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetForwardAddrRegion());
		}
	}

void sfUserSetForwardAddrRegion(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetForwardAddrRegion(evaluateString(params->string));
		}
	}

void sfUserGetPromptFormat(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetPromptFormat());
		}
	}

void sfUserSetPromptFormat(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPromptFormat(evaluateString(params->string));
		}
	}

void sfUserGetDateStamp(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetDateStamp());
		}
	}

void sfUserSetDateStamp(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDateStamp(evaluateString(params->string));
		}
	}

void sfUserGetVerboseDateStamp(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetVerboseDateStamp());
		}
	}

void sfUserSetVerboseDateStamp(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetVerboseDateStamp(evaluateString(params->string));
		}
	}

void sfUserGetSignature(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetSignature());
		}
	}

void sfUserSetSignature(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetSignature(evaluateString(params->string));
		}
	}

void sfUserGetNetPrefix(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetNetPrefix());
		}
	}

void sfUserSetNetPrefix(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetNetPrefix(evaluateString(params->string));
		}
	}

void sfUserGetMailAddr1(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetMailAddr1());
		}
	}

void sfUserSetMailAddr1(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMailAddr1(evaluateString(params->string));
		}
	}

void sfUserGetMailAddr2(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetMailAddr2());
		}
	}

void sfUserSetMailAddr2(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMailAddr2(evaluateString(params->string));
		}
	}

void sfUserGetMailAddr3(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetMailAddr3());
		}
	}

void sfUserSetMailAddr3(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMailAddr3(evaluateString(params->string));
		}
	}

void sfUserGetAlias(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetAlias());
		}
	}

void sfUserSetAlias(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetAlias(evaluateString(params->string));
		}
	}

void sfUserGetLocID(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetLocID());
		}
	}

void sfUserSetLocID(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetLocID(evaluateString(params->string));
		}
	}

void sfUserGetMorePrompt(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetMorePrompt());
		}
	}

void sfUserSetMorePrompt(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMorePrompt(evaluateString(params->string));
		}
	}

void sfUserGetOccupation(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetOccupation());
		}
	}

void sfUserSetOccupation(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetOccupation(evaluateString(params->string));
		}
	}

void sfUserGetWhereHear(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetWhereHear());
		}
	}

void sfUserSetWhereHear(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetWhereHear(evaluateString(params->string));
		}
	}

void sfUserGetLastRoom(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetLastRoom());
		}
	}

void sfUserSetLastRoom(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetLastRoom(evaluateString(params->string));
		}
	}

void sfUserGetLastHall(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetLastHall());
		}
	}

void sfUserSetLastHall(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetLastHall(evaluateString(params->string));
		}
	}

void sfUserGetDefaultRoom(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetDefaultRoom());
		}
	}

void sfUserSetDefaultRoom(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDefaultRoom(evaluateString(params->string));
		}
	}

void sfUserGetDefaultHall(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetDefaultHall());
		}
	}

void sfUserSetDefaultHall(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDefaultHall(evaluateString(params->string));
		}
	}

void sfUserGetBirthDate(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetBirthDate());
		}
	}

void sfUserSetBirthDate(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetBirthDate(evaluateLong(params->string));
		}
	}

void sfUserGetFirstOn(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetFirstOn());
		}
	}

void sfUserSetFirstOn(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetFirstOn(evaluateLong(params->string));
		}
	}

void sfUserGetSex(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetSex());
		}
	}

void sfUserSetSex(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		uint Sex = evaluateInt(params->string);

		// Make unknown sexes unknown.
		if (Sex > 2)
			{
			Sex = 0;
			}

		CurScript->UsrUsr->SetSex((SexE) Sex);
		}
	}

void sfUserGetNulls(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetNulls());
		}
	}

void sfUserSetNulls(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetNulls(evaluateInt(params->string));
		}
	}

void sfUserGetWidth(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetWidth());
		}
	}

void sfUserSetWidth(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetWidth(evaluateInt(params->string));
		}
	}

void sfUserGetLinesPerScreen(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetLinesPerScreen());
		}
	}

void sfUserSetLinesPerScreen(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetLinesPerScreen(evaluateInt(params->string));
		}
	}

void sfUserGetNumUserShow(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetNumUserShow());
		}
	}

void sfUserSetNumUserShow(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetNumUserShow(evaluateInt(params->string));
		}
	}

void sfUserGetDefaultProtocol(strList *)
	{
	if (CurScript->UsrUsr)
		{
		char Prot[2];

		Prot[0] = CurScript->UsrUsr->GetDefaultProtocol();
		Prot[1] = 0;

		SETSTR(Prot);
		}
	}

void sfUserSetDefaultProtocol(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDefaultProtocol(evaluateString(params->string)[0]);
		}
	}

void sfUserGetCallTime(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetCallTime());
		}
	}

void sfUserSetCallTime(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCallTime(evaluateLong(params->string));
		}
	}

void sfUserGetCallNumber(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(CurScript->UsrUsr->GetCallNumber());
		}
	}

void sfUserSetCallNumber(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCallNumber(evaluateUlong(params->string));
		}
	}

void sfUserGetTotalTime(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetTotalTime());
		}
	}

void sfUserSetTotalTime(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetTotalTime(evaluateLong(params->string));
		}
	}

void sfUserGetCredits(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetCredits());
		}
	}

void sfUserSetCredits(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCredits(evaluateLong(params->string));
		}
	}

void sfUserGetLogins(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetLogins());
		}
	}

void sfUserSetLogins(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetLogins(evaluateLong(params->string));
		}
	}

void sfUserGetPosted(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetPosted());
		}
	}

void sfUserSetPosted(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPosted(evaluateLong(params->string));
		}
	}

void sfUserGetRead(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetRead());
		}
	}

void sfUserSetRead(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetRead(evaluateLong(params->string));
		}
	}

void sfUserGetPasswordChangeTime(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetPasswordChangeTime());
		}
	}

void sfUserSetPasswordChangeTime(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPasswordChangeTime(evaluateLong(params->string));
		}
	}

void sfUserGetCallsToday(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetCallsToday());
		}
	}

void sfUserSetCallsToday(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCallsToday(evaluateInt(params->string));
		}
	}

void sfUserGetCallLimit(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetCallLimit());
		}
	}

void sfUserSetCallLimit(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCallLimit(evaluateInt(params->string));
		}
	}

void sfUserGetLastMessage(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(CurScript->UsrUsr->GetLastMessage());
		}
	}

void sfUserSetLastMessage(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetLastMessage(evaluateUlong(params->string));
		}
	}

void sfUserGetDL_Bytes(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(CurScript->UsrUsr->GetDL_Bytes());
		}
	}

void sfUserSetDL_Bytes(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDL_Bytes(evaluateUlong(params->string));
		}
	}

void sfUserGetDL_Num(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETUINT(CurScript->UsrUsr->GetDL_Num());
		}
	}

void sfUserSetDL_Num(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDL_Num(evaluateUint(params->string));
		}
	}

void sfUserGetUL_Bytes(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(CurScript->UsrUsr->GetUL_Bytes());
		}
	}

void sfUserSetUL_Bytes(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetUL_Bytes(evaluateUlong(params->string));
		}
	}

void sfUserGetUL_Num(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETUINT(CurScript->UsrUsr->GetUL_Num());
		}
	}

void sfUserSetUL_Num(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetUL_Num(evaluateUint(params->string));
		}
	}

void sfUserGetPoopcount(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETLONG(CurScript->UsrUsr->GetPoopcount());
		}
	}

void sfUserSetPoopcount(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPoopcount(evaluateLong(params->string));
		}
	}

void sfUserIsDungeoned(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsDungeoned());
		}
	}

void sfUserSetDungeoned(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDungeoned(evaluateBool(params->string));
		}
	}

void sfUserIsForwardToNode(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsForwardToNode());
		}
	}

void sfUserSetForwardToNode(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetForwardToNode(evaluateBool(params->string));
		}
	}

void sfUserIsAutoNextHall(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsAutoNextHall());
		}
	}

void sfUserSetAutoNextHall(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetAutoNextHall(evaluateBool(params->string));
		}
	}

void sfUserIsEnterBorders(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsEnterBorders());
		}
	}

void sfUserSetEnterBorders(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetEnterBorders(evaluateBool(params->string));
		}
	}

void sfUserIsVerified(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsVerified());
		}
	}

void sfUserSetVerified(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetVerified(evaluateBool(params->string));
		}
	}

void sfUserIsSurnameLocked(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsSurnameLocked());
		}
	}

void sfUserSetSurnameLocked(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetSurnameLocked(evaluateBool(params->string));
		}
	}

void sfUserIsDefaultHallLocked(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsDefaultHallLocked());
		}
	}

void sfUserSetDefaultHallLocked(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDefaultHallLocked(evaluateBool(params->string));
		}
	}

void sfUserIsPsycho(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsPsycho());
		}
	}

void sfUserSetPsycho(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPsycho(evaluateBool(params->string));
		}
	}

void sfUserIsViewTitleSurname(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewTitleSurname());
		}
	}

void sfUserSetViewTitleSurname(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewTitleSurname(evaluateBool(params->string));
		}
	}

void sfUserIsViewSubjects(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewSubjects());
		}
	}

void sfUserSetViewSubjects(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewSubjects(evaluateBool(params->string));
		}
	}

void sfUserIsViewSignatures(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewSignatures());
		}
	}

void sfUserSetViewSignatures(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewSignatures(evaluateBool(params->string));
		}
	}

void sfUserIsIBMGraph(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsIBMGraph());
		}
	}

void sfUserSetIBMGraph(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetIBMGraph(evaluateBool(params->string));
		}
	}

void sfUserIsIBMANSI(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsIBMANSI());
		}
	}

void sfUserSetIBMANSI(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetIBMANSI(evaluateBool(params->string));
		}
	}

void sfUserIsIBMColor(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsIBMColor());
		}
	}

void sfUserSetIBMColor(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetIBMColor(evaluateBool(params->string));
		}
	}

void sfUserIsTwirly(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsTwirly());
		}
	}

void sfUserSetTwirly(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetTwirly(evaluateBool(params->string));
		}
	}

void sfUserIsAutoVerbose(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsAutoVerbose());
		}
	}

void sfUserSetAutoVerbose(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetAutoVerbose(evaluateBool(params->string));
		}
	}

void sfUserIsPauseBetweenMessages(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsPauseBetweenMessages());
		}
	}

void sfUserSetPauseBetweenMessages(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPauseBetweenMessages(evaluateBool(params->string));
		}
	}

void sfUserIsMinibin(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsMinibin());
		}
	}

void sfUserSetMinibin(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMinibin(evaluateBool(params->string));
		}
	}

void sfUserIsClearScreenBetweenMessages(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsClearScreenBetweenMessages());
		}
	}

void sfUserSetClearScreenBetweenMessages(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetClearScreenBetweenMessages(evaluateBool(params->string));
		}
	}

void sfUserIsViewRoomInfoLines(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewRoomInfoLines());
		}
	}

void sfUserSetViewRoomInfoLines(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewRoomInfoLines(evaluateBool(params->string));
		}
	}

void sfUserIsViewHallDescription(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewHallDescription());
		}
	}

void sfUserSetViewHallDescription(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewHallDescription(evaluateBool(params->string));
		}
	}

void sfUserIsViewCensoredMessages(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewCensoredMessages());
		}
	}

void sfUserSetViewCensoredMessages(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewCensoredMessages(evaluateBool(params->string));
		}
	}

void sfUserIsViewBorders(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewBorders());
		}
	}

void sfUserSetViewBorders(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewBorders(evaluateBool(params->string));
		}
	}

void sfUserIsOut300(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsOut300());
		}
	}

void sfUserSetOut300(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetOut300(evaluateBool(params->string));
		}
	}

void sfUserIsUserSignatureLocked(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsUserSignatureLocked());
		}
	}

void sfUserSetUserSignatureLocked(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetUserSignatureLocked(evaluateBool(params->string));
		}
	}

void sfUserIsHideMessageExclusions(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsHideMessageExclusions());
		}
	}

void sfUserSetHideMessageExclusions(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetHideMessageExclusions(evaluateBool(params->string));
		}
	}

void sfUserIsDownload(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsDownload());
		}
	}

void sfUserSetDownload(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetDownload(evaluateBool(params->string));
		}
	}

void sfUserIsUpload(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsUpload());
		}
	}

void sfUserSetUpload(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetUpload(evaluateBool(params->string));
		}
	}

void sfUserIsChat(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsChat());
		}
	}

void sfUserSetChat(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetChat(evaluateBool(params->string));
		}
	}

void sfUserIsPrintFile(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsPrintFile());
		}
	}

void sfUserSetPrintFile(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPrintFile(evaluateBool(params->string));
		}
	}

void sfUserGetSpellCheckMode(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETINT(CurScript->UsrUsr->GetSpellCheckMode());
		}
	}

void sfUserSetSpellCheckMode(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetSpellCheckMode(evaluateInt(params->string));
		}
	}

void sfUserIsMakeRoom(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsMakeRoom());
		}
	}

void sfUserSetMakeRoom(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMakeRoom(evaluateBool(params->string));
		}
	}

void sfUserIsVerboseLogOut(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsVerboseLogOut());
		}
	}

void sfUserSetVerboseLogOut(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetVerboseLogOut(evaluateBool(params->string));
		}
	}

void sfUserIsConfirmNoEO(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsConfirmNoEO());
		}
	}

void sfUserSetConfirmNoEO(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetConfirmNoEO(evaluateBool(params->string));
		}
	}

void sfUserIsUsePersonalHall(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsUsePersonalHall());
		}
	}

void sfUserSetUsePersonalHall(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetUsePersonalHall(evaluateBool(params->string));
		}
	}

void sfUserIsYouAreHere(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsYouAreHere());
		}
	}

void sfUserSetYouAreHere(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetYouAreHere(evaluateBool(params->string));
		}
	}

void sfUserIsIBMRoom(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsIBMRoom());
		}
	}

void sfUserSetIBMRoom(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetIBMRoom(evaluateBool(params->string));
		}
	}

void sfUserIsWideRoom(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsWideRoom());
		}
	}

void sfUserSetWideRoom(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetWideRoom(evaluateBool(params->string));
		}
	}

void sfUserIsMusic(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsMusic());
		}
	}

void sfUserSetMusic(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetMusic(evaluateBool(params->string));
		}
	}

void sfUserIsCheckApostropheS(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsCheckApostropheS());
		}
	}

void sfUserSetCheckApostropheS(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCheckApostropheS(evaluateBool(params->string));
		}
	}

void sfUserIsCheckAllCaps(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsCheckAllCaps());
		}
	}

void sfUserSetCheckAllCaps(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCheckAllCaps(evaluateBool(params->string));
		}
	}

void sfUserIsCheckDigits(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsCheckDigits());
		}
	}

void sfUserSetCheckDigits(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetCheckDigits(evaluateBool(params->string));
		}
	}

void sfUserIsExcludeEncryptedMessages(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsExcludeEncryptedMessages());
		}
	}

void sfUserSetExcludeEncryptedMessages(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetExcludeEncryptedMessages(evaluateBool(params->string));
		}
	}

void sfUserIsViewCommas(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsViewCommas());
		}
	}

void sfUserSetViewCommas(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetViewCommas(evaluateBool(params->string));
		}
	}

void sfUserIsPUnPauses(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsPUnPauses());
		}
	}

void sfUserIsRoman(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsRoman());
		}
	}

void sfUserSetPUnPauses(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetPUnPauses(evaluateBool(params->string));
		}
	}

void sfUserSetRoman(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetRoman(evaluateBool(params->string));
		}
	}

void sfUserIsMainSysop(strList *)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsMainSysop());
		}
	}

void sfUserIsInGroup(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsInGroup(evaluateInt(params->string)));
		}
	}

void sfUserSetInGroup(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetInGroup(evaluateInt(params->string),
				evaluateBool(params->next->string));
		}
	}

void sfUserIsInRoom(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsInRoom(evaluateInt(params->string)));
		}
	}

void sfUserSetInRoom(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetInRoom(evaluateInt(params->string),
				evaluateBool(params->next->string));
		}
	}

void sfUserIsRoomExcluded(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsRoomExcluded(evaluateInt(params->string)));
		}
	}

void sfUserSetRoomExcluded(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetRoomExcluded(evaluateInt(params->string),
				evaluateBool(params->next->string));
		}
	}

void sfUserIsRoomInPersonalHall(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsRoomInPersonalHall(evaluateInt(params->string)));
		}
	}

void sfUserSetRoomInPersonalHall(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetRoomInPersonalHall(evaluateInt(params->string),
				evaluateBool(params->next->string));
		}
	}

void sfUserGetRoomNewPointer(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETULONG(CurScript->UsrUsr->GetRoomNewPointer(evaluateInt(params->string)));
		}
	}

void sfUserSetRoomNewPointer(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		CurScript->UsrUsr->SetRoomNewPointer(evaluateInt(params->string),
				evaluateUlong(params->next->string));
		}
	}

void sfUserGetUserDefined(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETSTR(CurScript->UsrUsr->GetUserDefined(evaluateString(params->string)));
		}
	}

void sfUserSetUserDefined(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->SetUserDefined(evaluateString(params->string),
				evaluateString(params->next->string)));
		}
	}

void sfUserIsUserDefined(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->IsUserDefined(evaluateString(params->string)));
		}
	}

void sfUserRemoveUserDefined(strList *params)
	{
	if (CurScript->UsrUsr)
		{
		SETBOOL(CurScript->UsrUsr->RemoveUserDefined(evaluateString(params->string)));
		}
	}

void sfKillUser(strList *params)
	{
	SETBOOL(killuser(params ? evaluateString(params->string) : NULL));
	}
