/* -------------------------------------------------------------------- */
/*	SCRFROOM.CPP					Citadel 							*/
/* -------------------------------------------------------------------- */
/*	This file contains all the internal functions for user scripts		*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"

#include "room.h"
#include "tallybuf.h"
#include "hall.h"

/* -------------------------------------------------------------------- */
/*							ROOM TABLE STUFF							*/
/* -------------------------------------------------------------------- */

void sfIsroominuse(strList *params)
	{
	SETBOOL(IsRoomInuse(evaluateInt(params->string)));
	}

void sfIsroompublic(strList *params)
	{
	SETBOOL(!IsRoomHidden(evaluateInt(params->string)));
	}

void sfIsroomdir(strList *params)
	{
	SETBOOL(IsRoomDirectory(evaluateInt(params->string)));
	}

void sfIsroomperm(strList *params)
	{
	SETBOOL(IsRoomPermanent(evaluateInt(params->string)));
	}

void sfIsroomgrponly(strList *params)
	{
	SETBOOL(IsRoomGroupOnly(evaluateInt(params->string)));
	}

void sfIsroomreadonly(strList *params)
	{
	SETBOOL(IsRoomReadOnly(evaluateInt(params->string)));
	}

void sfIsroomdownonly(strList *params)
	{
	SETBOOL(IsRoomDownloadOnly(evaluateInt(params->string)));
	}

void sfIsroomshared(strList *params)
	{
	SETBOOL(IsRoomShared(evaluateInt(params->string)));
	}

void sfIsroommoderated(strList *params)
	{
	SETBOOL(IsRoomModerated(evaluateInt(params->string)));
	}

void sfIsroomapplic(strList *params)
	{
	SETBOOL(IsRoomApplication(evaluateInt(params->string)));
	}

void sfIsroombio(strList *params)
	{
	SETBOOL(IsRoomBIO(evaluateInt(params->string)));
	}

void sfIsroomuponly(strList *params)
	{
	SETBOOL(IsRoomUploadOnly(evaluateInt(params->string)));
	}

void sfIsroomprivgrp(strList *params)
	{
	SETBOOL(IsRoomPrivGroup(evaluateInt(params->string)));
	}

void sfIsroomanon(strList *params)
	{
	SETBOOL(IsRoomAnonymous(evaluateInt(params->string)));
	}

void sfIsroomsubject(strList *params)
	{
	SETBOOL(IsRoomSubject(evaluateInt(params->string)));
	}

void sfIsroomgrpmod(strList *params)
	{
	SETBOOL(IsRoomGroupModerated(evaluateInt(params->string)));
	}

void sfGetroomname(strList *params)
	{
	SETSTR(GetRoomName(evaluateInt(params->string)));
	}

void sfGetnetid(strList *params)
	{
	SETSTR(GetRoomNetID(evaluateInt(params->string)));
	}

void sfGetroomgroup(strList *params)
	{
	SETINT(GetRoomGroupNumber(evaluateInt(params->string)));
	}

void sfGetroomtotal(strList *params)
	{
	SETLONG((long) GetRoomTotalMessages(evaluateInt(params->string)));
	}

void sfGetroommsgs(strList *params)
	{
	SETLONG((long) GetRoomMessages(evaluateInt(params->string)));
	}

void sfGetroomnew(strList *params)
	{
	SETLONG((long) GetRoomNewMessages(evaluateInt(params->string)));
	}

void sfGetroomentered(strList *params)
	{
	SETINT(GetMessagesEnteredInRoom(evaluateInt(params->string)));
	}

void sfGetroomhasmail(strList *params)
	{
	SETBOOL(IsRoomMail(evaluateInt(params->string)));
	}

void sfGetroomhasoldmail(strList *params)
	{
	SETBOOL(IsRoomOldMail(evaluateInt(params->string)));
	}

void sfGetroomvisited(strList *params)
	{
	SETBOOL(IsRoomVisited(evaluateInt(params->string)));
	}

void sfGetroombypass(strList *params)
	{
	SETBOOL(WasRoomBypassed(evaluateInt(params->string)));
	}

void sfFindRoomByName(strList *params)
	{
	r_slot slot;

	if (evaluateBool(params->next->string))
		{
		slot = PartialRoomExists(evaluateString(params->string), TI()thisRoom,
			TRUE);
		}
	else
		{
		slot = RoomExists(evaluateString(params->string));
		}

	SETINT(slot);
	}

void sfGetroomdir(strList *)
	{
	SETSTR(GetCurrentRoomDirectory());
	}

void sfKillRoom(strList *params)
	{
	SETBOOL(killroom(params ? evaluateString(params->string) : NULL));
	}

void sfFindRoomByNetID(strList *params)
	{
	SETINT(IdExists(evaluateString(params->string),
		evaluateInt(params->next->string)));
	}

void sfIsroomwindow(strList *params)
	{
	SETBOOL(iswindow(evaluateInt(params->string)));
	}
