/* -------------------------------------------------------------------- */
/*								SCRFNET.CPP 							*/
/* -------------------------------------------------------------------- */
/*	This file contains all the internal functions for user scripts		*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"

#include "log.h"
#include "net.h"
#include "tallybuf.h"

///////////////////////////// NETWORK STUFF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
void sfNet69fetch(strList *params)
	{
	if (params)
		{
		const char *rnode = evaluateString(params->string);
		LogEntry SaveLog(cfg.maxrooms, cfg.maxgroups, cfg.maxjumpback);
		l_slot oldthisLog;
		Bool OldLoggedIn;

		if (!read_net_messages())
			{
			cPrintf(getmsg(59));
			return;
			}

		oldthisLog = TI()ThisLog;
		SaveLog = *TI()CurrentUser;
		OldLoggedIn = TI()loggedIn;

		if (getnode(&TI()node, rnode, NOMODCON, TRUE))
			{
			if (LoadPersonByName(TI()node->GetName()))
				{
				LogEntry5 Log5(cfg.maxrooms);

				TI()loggedIn = TRUE;

				TI()menu69 = TRUE;

				amZap();

				Log5.CopyRoomNewPointers(*TI()CurrentUser);

				if (!net69_fetch(TRUE))
					{
					TI()CurrentUser->CopyRoomNewPointers(Log5);
					}

				TI()menu69 = FALSE;

				SaveAideMess(NULL);

				TI()CurrentUser->SetCallNumber(cfg.callno);
				time(&TI()logtimestamp);
				TI()CurrentUser->SetCallTime(TI()logtimestamp);
				slideLTab(TI()ThisSlot);
				storeLog();

				TI()ThisLog = oldthisLog;
				*TI()CurrentUser = SaveLog;
				TI()loggedIn = OldLoggedIn;

				roomtalley();
				}
			}

		dump_net_messages();

		freeNode(&TI()node);
		}
	}

void sfNet69incorporate(strList *)
	{
	if (!read_net_messages())
		{
		cPrintf(getmsg(59));
		return;
		}

	amZap();
	net69_incorporate();
	SaveAideMess(NULL);

	roomtalley();

	dump_net_messages();

	freeNode(&TI()node);
	}

void sfNet86fetch(strList *params)
	{
	if (params)
		{
		const char *rnode = evaluateString(params->string);
		LogEntry SaveLog(cfg.maxrooms, cfg.maxgroups, cfg.maxjumpback);
		l_slot oldthisLog;
		Bool OldLoggedIn;

		if (!read_net_messages())
			{
			cPrintf(getmsg(59));
			return;
			}

		oldthisLog = TI()ThisLog;
		SaveLog = *TI()CurrentUser;
		OldLoggedIn = TI()loggedIn;

		if (getnode(&TI()node, rnode, NOMODCON, FALSE))
			{
			if (LoadPersonByName(TI()node->GetName()))
				{
				LogEntry5 Log5(cfg.maxrooms);

				TI()loggedIn = TRUE;

				TI()menu69 = TRUE;

				amZap();

				Log5.CopyRoomNewPointers(*TI()CurrentUser);

				if (!net86_fetch())
					{
					TI()CurrentUser->CopyRoomNewPointers(Log5);
					}

				TI()menu69 = FALSE;

				SaveAideMess(NULL);

				TI()CurrentUser->SetCallNumber(cfg.callno);
				time(&TI()logtimestamp);
				TI()CurrentUser->SetCallTime(TI()logtimestamp);
				slideLTab(TI()ThisSlot);
				storeLog();

				TI()ThisLog = oldthisLog;
				*TI()CurrentUser = SaveLog;
				TI()loggedIn = OldLoggedIn;

				roomtalley();
				}
			}

		dump_net_messages();

		freeNode(&TI()node);
		}
	}

void sfNet86incorporate(strList *params)
	{
	if (params)
		{
		if (!read_net_messages())
			{
			cPrintf(getmsg(59));
			return;
			}

		const char *rnode = evaluateString(params->string);

		if (*rnode && getnode(&TI()node, rnode, NOMODCON, FALSE))
			{
			amZap();
			net86_incorporate();
			SaveAideMess(NULL);
			roomtalley();
			}

		dump_net_messages();

		freeNode(&TI()node);
		}
	}

void sfDial(strList *params)
	{
	if (params && params->next)
		{
		if (!read_net_messages())
			{
			cPrintf(getmsg(59));
			return;
			}

		SETINT(dial(evaluateString(params->string),
				evaluateInt(params->next->string)));

		dump_net_messages();
		}
	}

void sfIsNetIDInNetIDCit(strList *params)
	{
	SETBOOL(IsNetIDInNetIDCit(evaluateString(params->string)));
	}

void sfAddNetIDToNetIDCit(strList *params)
	{
	label NetID;

	CopyStringToBuffer(NetID, evaluateString(params->string), LABELSIZE);

	SETBOOL(AddNetIDToNetIDCit(NetID, evaluateString(params->next->string)));
	}

void sfRemoveNetIDFromNetIDCit(strList *params)
	{
	SETBOOL(RemoveNetIDFromNetIDCit(evaluateString(params->string)));
	}

void sfGetCommentOfNetIDInNetIDCit(strList *params)
	{
	char Comment[256];

	GetCommentOfNetIDInNetIDCit(evaluateString(params->string), Comment, 255);

	SETSTR(Comment);
	}

void sfStringIsAddress(strList *params)
	{
	SETBOOL(isaddress(evaluateString(params->string)));
	}

void sfFindNodeByNameOrAddress(strList *params)
	{
	SETINT(nodexists(evaluateString(params->string)));
	}

void sfDoNetwork(strList *params)
	{
	SETBOOL(net_callout(evaluateString(params->string)));
	}

void sfNet69RoomReq(strList *params)
	{
	if (!read_net_messages())
		{
		cPrintf(getmsg(59));
		SETBOOL(FALSE);
		return;
		}

	const char *rnode = evaluateString(params->string);

	if (*rnode)
		{
		NetLogEntryC Log;

		if (Log.IsValid())
			{
			if (Log.LoadByName(rnode))
				{
				SETBOOL(Log.MakeNet69RoomRequestFile(NOMODCON));
				}
			else
				{
				SETBOOL(FALSE);
				}
			}
		else
			{
			SETBOOL(FALSE);
			}
		}

	dump_net_messages();
	}
