// --------------------------------------------------------------------------
// Citadel: ScrFMsg.CPP
//
// Msg... internal script functions.

#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"

#include "room.h"
#include "log.h"
#include "net.h"
#include "msg.h"
#include "maillist.h"


///////////////////////////// MESSAGE STUFF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
void sfGetNumberOfMessages(strList *)
	{
	SETLONG(sizetable());
	}

void sfMsgTabIsMail(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsMail());
	}

void sfMsgTabIsReceived(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsReceived());
	}

void sfMsgTabIsRepliedTo(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsReply());
	}

void sfMsgTabIsProblem(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsProblem());
	}

void sfMsgTabIsMadevis(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsMadevis());
	}

void sfMsgTabIsLimited(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsLimited());
	}

void sfMsgTabIsModerated(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsModerated());
	}

void sfMsgTabIsCopy(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsCopy());
	}

void sfMsgTabIsNetMail(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsNet());
	}

void sfMsgTabIsForwarded(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsForwarded());
	}

void sfMsgTabIsNetworked(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsNetworked());
	}

void sfMsgTabIsMassemail(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsMassemail());
	}

void sfMsgTabIsCensored(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsCensored());
	}

void sfMsgTabIsLocal(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsLocal());
	}

void sfMsgTabIsInuse(strList *params)
	{
	SETBOOL(getFlags(evaluateLong(params->string))->IsInuse());
	}

void sfMsgTabGetLocation(strList *params)
	{
	SETLONG(getLocation(evaluateLong(params->string)));
	}

void sfMsgTabGetRoomNum(strList *params)
	{
	SETINT(getRoomNum(evaluateLong(params->string)));
	}

void sfMsgTabGetToHash(strList *params)
	{
	SETINT(getToHash(evaluateLong(params->string)));
	}

void sfMsgTabGetAuthHash(strList *params)
	{
	SETINT(getAuthHash(evaluateLong(params->string)));
	}

void sfMsgTabGetOriginID(strList *params)
	{
	SETUINT(getOriginID(evaluateLong(params->string)));
	}

void sfMsgTabGetPrevRoomMsg(strList *params)
	{
	#if defined(AUXMEM) || defined(WINCIT)
		SETLONG(getPrevRoomMsg(evaluateLong(params->string)));
	#else
		SETLONG(M_SLOT_ERROR);
	#endif
	}

void sfMsgTabGetNextRoomMsg(strList *params)
	{
	#if defined(AUXMEM) || defined(WINCIT)
		SETLONG(getNextRoomMsg(evaluateLong(params->string)));
	#else
		SETLONG(M_SLOT_ERROR);
	#endif
	}

void sfMsgTabGetCopyOffset(strList *params)
	{
	SETLONG(getCopy(evaluateLong(params->string)));
	}

void sfMsgStart(strList *)
	{
	delete CurScript->UsrMsg;
	CurScript->UsrMsg = new Message;

	SETBOOL(CurScript->UsrMsg != NULL);
	}

void sfMsgClear(strList *)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->ClearAll();
		}
	}

void sfMsgHeaderClear(strList *)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->ClearHeader();
		}
	}

void sfMsgDump(strList *)
	{
	delete CurScript->UsrMsg;
	CurScript->UsrMsg = NULL;
	}

void sfMsgSave(strList *)
	{
	if (CurScript->UsrMsg)
		{
		label Buffer;
		CurScript->UsrMsg->SetLocalID(ltoa(cfg.newest + 1, Buffer, 10));

		// save it for netting...
		if (*CurScript->UsrMsg->GetToNodeName())
			{
			// room names get included in networked mail
			CurScript->UsrMsg->SetCreationRoom(GetRoomName(CurScript->UsrMsg->GetRoomNumber()));

			if (!save_mail(CurScript->UsrMsg, FALSE))
				{
				SETBOOL(FALSE);
				return;
				}
			}

		putAndNoteMessage(CurScript->UsrMsg, FALSE);

		if (*CurScript->UsrMsg->GetToUser() && !*CurScript->UsrMsg->GetToNodeName() &&
				IsMailingList(CurScript->UsrMsg->GetToUser()))
			{
			SendMailToList(CurScript->UsrMsg);
			}

		SETBOOL(TRUE);
		}
	}

void sfMsgLoad(strList *params)
	{
	delete CurScript->UsrMsg;

	CurScript->UsrMsg = LoadMessageByID(evaluateLong(params->string),
			params->next ? evaluateBool(params->next->string) : FALSE, FALSE);

	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->Decompress();
		}

	SETBOOL(CurScript->UsrMsg != NULL);
	}

void sfMsgShow(strList *)
	{
	if (CurScript->UsrMsg)
		{
		PrintMessage(CurScript->UsrMsg);
		}
	}

void sfMsgIsReceived(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsReceived());
		}
	}

void sfMsgIsRepliedTo(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsRepliedTo());
		}
	}

void sfMsgIsMadeVisible(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsMadeVisible());
		}
	}

void sfMsgIsCompressed(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->WasEverCompressed());
		}
	}

void sfMsgIsCensored(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsCensored());
		}
	}

void sfMsgIsLocal(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsLocal());
		}
	}

void sfMsgSetCensored(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetCensored(evaluateBool(params->string));
		}
	}

void sfMsgSetLocal(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetLocal(evaluateBool(params->string));
		}
	}

void sfMsgAppendText(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		for (; params; params = (strList *) getNextLL(params))
			{
			CurScript->UsrMsg->AppendText(evaluateString(params->string));
			}
		}
	}

void sfMsgSetText(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetText(ns);

		sfMsgAppendText(params);
		}
	}

void sfMsgGetHeadLoc(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETLONG(CurScript->UsrMsg->GetHeadLoc());
		}
	}

void sfMsgGetRoomNumber(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETINT(CurScript->UsrMsg->GetRoomNumber());
		}
	}

void sfMsgIsReceiptConfirmationRequested(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsReceiptConfirmationRequested());
		}
	}

void sfMsgIsEncrypted(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsEncrypted());
		}
	}

void sfMsgGetEncryptionKey(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetEncryptionKey());
		}
	}

void sfMsgGetAuthor(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetAuthor());
		}
	}

void sfMsgGetRealName(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetRealName());
		}
	}

void sfMsgGetSurname(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetSurname());
		}
	}

void sfMsgGetTitle(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetTitle());
		}
	}

void sfMsgGetForward(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetForward());
		}
	}

void sfMsgGetOriginNodeName(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetOriginNodeName());
		}
	}

void sfMsgGetOriginRegion(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetOriginRegion());
		}
	}

void sfMsgGetOriginCountry(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetOriginCountry());
		}
	}

void sfMsgGetTwitRegion(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetTwitRegion());
		}
	}

void sfMsgGetTwitCountry(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetTwitCountry());
		}
	}

void sfMsgGetOriginPhoneNumber(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetOriginPhoneNumber());
		}
	}

void sfMsgGetCit86Country(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetCit86Country());
		}
	}

void sfMsgGetDestinationAddress(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetDestinationAddress());
		}
	}

void sfMsgGetCreationRoom(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetCreationRoom());
		}
	}

void sfMsgGetSignature(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetSignature());
		}
	}

void sfMsgGetUserSignature(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetUserSignature());
		}
	}

void sfMsgGetSubject(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetSubject());
		}
	}

void sfMsgGetOriginSoftware(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetOriginSoftware());
		}
	}

void sfMsgGetSourceID(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetSourceID());
		}
	}

void sfMsgGetFromPath(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetFromPath());
		}
	}

void sfMsgSetFromPath(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetFromPath(evaluateString(params->string));
		}
	}

void sfMsgGetToUser(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetToUser());
		}
	}

void sfMsgGetPublicToUser(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetPublicToUser());
		}
	}

void sfMsgGetToNodeName(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetToNodeName());
		}
	}

void sfMsgGetToRegion(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetToRegion());
		}
	}

void sfMsgGetToCountry(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetToCountry());
		}
	}

void sfMsgGetToPhoneNumber(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetToPhoneNumber());
		}
	}

void sfMsgGetToPath(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetToPath());
		}
	}

void sfMsgGetLocalID(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetLocalID());
		}
	}

void sfMsgGetCopyOfMessage(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetCopyOfMessage());
		}
	}

void sfMsgGetGroup(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetGroup());
		}
	}

void sfMsgGetCreationTime(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetCreationTime());
		}
	}

void sfMsgGetEZCreationTime(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetEZCreationTime());
		}
	}

void sfMsgGetReplyToMessage(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetReplyToMessage());
		}
	}

void sfMsgGetX(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetX());
		}
	}

void sfMsgGetFileLink(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetFileLink());
		}
	}

void sfMsgGetSourceRoomName(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(CurScript->UsrMsg->GetSourceRoomName());
		}
	}

void sfMsgSetRoomNumber(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetRoomNumber(evaluateInt(params->string));
		}
	}

void sfMsgSetReceiptConfirmationRequested(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->SetReceiptConfirmationRequested(
				evaluateBool(params->string)));
		}
	}

void sfMsgSetEncrypted(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->SetEncrypted(evaluateBool(params->string)));
		}
	}

void sfMsgSetEncryptionKey(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetEncryptionKey(evaluateString(params->string));
		}
	}

void sfMsgSetAuthor(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetAuthor(evaluateString(params->string));
		}
	}

void sfMsgSetRealName(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetRealName(evaluateString(params->string));
		}
	}

void sfMsgSetSurname(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetSurname(evaluateString(params->string));
		}
	}

void sfMsgSetTitle(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetTitle(evaluateString(params->string));
		}
	}

void sfMsgSetForward(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetForward(evaluateString(params->string));
		}
	}

void sfMsgSetDestinationAddress(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetDestinationAddress(evaluateString(params->string));
		}
	}

void sfMsgSetCreationRoom(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetCreationRoom(evaluateString(params->string));
		}
	}

void sfMsgSetSignature(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetSignature(evaluateString(params->string));
		}
	}

void sfMsgSetUserSignature(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetUserSignature(evaluateString(params->string));
		}
	}

void sfMsgSetSubject(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetSubject(evaluateString(params->string));
		}
	}

void sfMsgSetToUser(strList *params)
	{
	Bool Set = TRUE;

	if (CurScript->UsrMsg)
		{
		label SaveToUser;
		label SaveToNodeName;
		label SaveToRegion;
		label SaveDestinationAddress;

		strcpy(SaveToUser, CurScript->UsrMsg->GetToUser());
		strcpy(SaveToNodeName, CurScript->UsrMsg->GetToNodeName());
		strcpy(SaveToRegion, CurScript->UsrMsg->GetToRegion());
		strcpy(SaveDestinationAddress, CurScript->UsrMsg->GetDestinationAddress());

		char destination[LABELSIZE + LABELSIZE + LABELSIZE + LABELSIZE + 7];

		strcpy(destination, evaluateString(params->string));

		if (*destination)
			{
			if (SameString(destination, spc))
				{
				CurScript->UsrMsg->SetToUser(ns);
				CurScript->UsrMsg->SetToNodeName(ns);
				CurScript->UsrMsg->SetToRegion(ns);
				CurScript->UsrMsg->SetDestinationAddress(ns);
				}
			else
				{
				label ToUser, ToNode, ToRegion, ToAddress;

				parseNetAddress(destination,
					ToUser, ToNode, ToRegion, ToAddress);

				if (!*ToUser)
					{
					strcpy(ToUser, getmsg(1020));
					}

				CurScript->UsrMsg->SetToUser(ToUser);
				CurScript->UsrMsg->SetToNodeName(ToNode);
				CurScript->UsrMsg->SetToRegion(ToRegion);
				CurScript->UsrMsg->SetDestinationAddress(ToAddress);
				}
			}

		if (*CurScript->UsrMsg->GetToUser())
			{
			Set = ResolveMessageAddressingIssues(CurScript->UsrMsg, NOMODCON);

			if (!Set)
				{
				CurScript->UsrMsg->SetToUser(SaveToUser);
				CurScript->UsrMsg->SetToNodeName(SaveToNodeName);
				CurScript->UsrMsg->SetToRegion(SaveToRegion);
				CurScript->UsrMsg->SetDestinationAddress(SaveDestinationAddress);
				}
			}
		}
	else
		{
		Set = FALSE;
		}

	SETBOOL(Set);
	}

void sfMsgSetPublicToUser(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetPublicToUser(evaluateString(params->string));
		}
	}

void sfMsgSetToPhoneNumber(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetToPhoneNumber(evaluateString(params->string));
		}
	}

void sfMsgSetToPath(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetToPath(evaluateString(params->string));
		}
	}

void sfMsgSetGroup(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetGroup(evaluateString(params->string));
		}
	}

void sfMsgSetCreationTime(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetCreationTime(evaluateString(params->string));
		}
	}

void sfMsgSetEZCreationTime(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetEZCreationTime(evaluateString(params->string));
		}
	}

void sfMsgSetReplyToMessage(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetReplyToMessage(evaluateString(params->string));
		}
	}

void sfMsgSetX(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetX(evaluateString(params->string));
		}
	}

void sfMsgSetFileLink(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetFileLink(evaluateString(params->string));
		}
	}

void sfMsgSetSourceRoomName(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetSourceRoomName(evaluateString(params->string));
		}
	}

void sfMsgIsViewDuplicate(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->IsViewDuplicate());
		}
	}

void sfMsgGetOriginalID(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETULONG(CurScript->UsrMsg->GetOriginalID());
		}
	}

void sfMsgGetOriginalAttribute(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETINT(CurScript->UsrMsg->GetOriginalAttribute());
		}
	}

void sfMsgGetOriginalRoom(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETINT(CurScript->UsrMsg->GetOriginalRoom());
		}
	}

void sfMsgSetOriginalRoom(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		CurScript->UsrMsg->SetOriginalRoom(evaluateInt(params->string));
		}
	}

void sfMsgGetOriginAddress(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETSTR(oaddress(CurScript->UsrMsg));
		}
	}

void sfMsgSaveTextToFile(strList *params)
	{
	Bool Worked = FALSE;

	if (CurScript->UsrMsg)
		{
		FILE *fd = fopen(evaluateString(params->string), FO_WB);
		if (fd)
			{
			dFormat(CurScript->UsrMsg->GetText(), fd);
			fclose(fd);

			Worked = TRUE;
			}
		}

	SETBOOL(Worked);
	}

void sfMsgLoadTextFromFile(strList *params)
	{
	Bool Worked = FALSE;

	if (CurScript->UsrMsg)
		{
		FILE *fd = fopen(evaluateString(params->string), FO_RB);
		if (fd)
			{
			GetFileMessage(fd, CurScript->UsrMsg->GetTextPointer(), MAXTEXT);
			fclose(fd);

			Worked = TRUE;
			}
		}

	SETBOOL(Worked);
	}

void sfMsgIsMoreFlag(strList *params)
	{
	if (CurScript->UsrMsg && params)
		{
		const char Flag = evaluateString(params->string)[0];

		SETBOOL(Flag ? CurScript->UsrMsg->IsMoreFlag(Flag) : FALSE);
		}
	}

void sfMsgSetMoreFlag(strList *params)
	{
	if (CurScript->UsrMsg && params && params->next)
		{
		const char Flag = evaluateString(params->string)[0];

		SETBOOL(Flag ?
				CurScript->UsrMsg->SetMoreFlag(Flag,
					evaluateBool(params->next->string)) :
				FALSE);
		}
	}

void sfMsgGetCommentCount(strList *)
	{
	if (CurScript->UsrMsg)
		{
		SETLONG(CurScript->UsrMsg->GetCommentCount());
		}
	}

void sfMsgGetComment(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		const char *Cmt = CurScript->UsrMsg->GetComment(evaluateLong(params->string));

		if (Cmt)
			{
			SETSTR(Cmt);
			}
		else
			{
			SETSTR(ns);
			}
		}
	}

void sfMsgAddComment(strList *params)
	{
	if (CurScript->UsrMsg)
		{
		SETBOOL(CurScript->UsrMsg->AddComment(evaluateString(params->string)));
		}
	}

// These three are not really scrfmsg functions, but i didn't want to include
// msg.h in scrfunc.cpp
extern Message *NetCommandMsg;
extern Message *NetCmdReplyMsg;

void sfAppendToNetCommandReply(strList *params)
	{
	if (NetCmdReplyMsg)
		{
		for (; params; params = (strList *) getNextLL(params))
			{
			NetCmdReplyMsg->AppendText(evaluateString(params->string));
			}
		}
	}

void sfGetNetCommandText(strList *)
	{
	if (NetCommandMsg)
		{
		SETSTR(NetCommandMsg->GetText());
		}
	else
		{
		SETSTR(ns);
		}
	}

void sfGetNetCommandTextToFile(strList *params)
	{
	Bool Worked = FALSE;

	if (NetCommandMsg)
		{
		FILE *fd;

		if ((fd = fopen(evaluateString(params->string), FO_WB)) != NULL)
			{
			dFormat(NetCommandMsg->GetText(), fd);
			fclose(fd);

			Worked = TRUE;
			}
		}

	SETBOOL(Worked);
	}

void sfStartMessageEditor(strList *params)
	{
	Bool WeMadeIt = FALSE;

	if (!CurScript->UsrMsg)
		{
		CurScript->UsrMsg = new Message;
		WeMadeIt = TRUE;
		}

	if (CurScript->UsrMsg)
		{
		const Bool Saved = makeMessage(CurScript->UsrMsg, NULL,
				evaluateInt(params->string));

		if (WeMadeIt)
			{
			delete CurScript->UsrMsg;
			CurScript->UsrMsg = NULL;
			}

		SETBOOL(Saved);
		}
	else
		{
		SETBOOL(FALSE);
		}
	}
