/* -------------------------------------------------------------------- */
/*	SCRFLOG.CPP 					Citadel 							*/
/* -------------------------------------------------------------------- */
/*	This file contains all the internal functions for user scripts		*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"

#include "log.h"

/* -------------------------------------------------------------------- */
/*							CURRENT USER STUFF							*/
/* -------------------------------------------------------------------- */

void sfGetusername(strList *)
	{
	SETSTR(TI()CurrentUser->GetName());
	}

void sfGetuserin(strList *)
	{
	SETSTR(TI()CurrentUser->GetInitials());
	}

void sfGetuserpw(strList *)
	{
	SETSTR(TI()CurrentUser->GetPassword());
	}

void sfGetuserfwd(strList *)
	{
	SETSTR(TI()CurrentUser->GetForwardAddr());
	}

void sfGetuserfwdnode(strList *)
	{
	SETSTR(TI()CurrentUser->GetForwardAddrNode());
	}

void sfGetusersurname(strList *)
	{
	SETSTR(TI()CurrentUser->GetSurname());
	}

void sfGetusertitle(strList *)
	{
	SETSTR(TI()CurrentUser->GetTitle());
	}

void sfGetuserdefhall(strList *)
	{
	SETSTR(TI()CurrentUser->GetDefaultHall());
	}

void sfGetusernulls(strList *)
	{
	SETINT(TI()CurrentUser->GetNulls());
	}

void sfGetuserwidth(strList *)
	{
	SETINT(TI()CurrentUser->GetWidth());
	}

void sfGetusercalltime(strList *)
	{
	SETLONG(TI()CurrentUser->GetCallTime());
	}

void sfGetusercallno(strList *)
	{
	SETULONG(TI()CurrentUser->GetCallNumber());
	}

void sfGetusercredits(strList *)
	{
	SETLONG(TI()CurrentUser->GetCredits());
	}

void sfSetusercredits(strList *params)
	{
	TI()CurrentUser->SetCredits(evaluateLong(params->string));
	}

void sfGetuserlastpointer(strList *)
	{
	SETULONG(TI()CurrentUser->GetLastMessage());
	}

void sfGetuserlasthall(strList *)
	{
	SETSTR(TI()CurrentUser->GetLastHall());
	}

void sfGetuserlastroom(strList *)
	{
	SETSTR(TI()CurrentUser->GetLastRoom());
	}

void sfGetuserlines(strList *)
	{
	SETINT(TI()CurrentUser->GetLinesPerScreen());
	}

//attributes

void sfGetuserproto(strList *)
	{
	SETINT(TI()CurrentUser->GetDefaultProtocol());
	}

void sfGetuserprompt(strList *)
	{
	SETSTR(TI()CurrentUser->GetPromptFormat());
	}

void sfGetuserdstamp(strList *)
	{
	SETSTR(TI()CurrentUser->GetDateStamp());
	}

void sfGetuservdstamp(strList *)
	{
	SETSTR(TI()CurrentUser->GetVerboseDateStamp());
	}

void sfGetusersig(strList *)
	{
	SETSTR(TI()CurrentUser->GetSignature());
	}

void sfGetusernetpref(strList *)
	{
	SETSTR(TI()CurrentUser->GetNetPrefix());
	}

void sfGetuseraddr1(strList *)
	{
	SETSTR(TI()CurrentUser->GetMailAddr1());
	}

void sfGetuseraddr2(strList *)
	{
	SETSTR(TI()CurrentUser->GetMailAddr2());
	}

void sfGetuseraddr3(strList *)
	{
	SETSTR(TI()CurrentUser->GetMailAddr3());
	}

void sfGetuserpoop(strList *)
	{
	SETLONG(TI()CurrentUser->GetPoopcount());
	}

void sfIsuserinuse(strList *)
	{
	SETBOOL(TI()CurrentUser->IsInuse());
	}

void sfIsuseruponly(strList *)
	{
	SETBOOL(TI()CurrentUser->IsUpperOnly());
	}

void sfIsuserlf(strList *)
	{
	SETBOOL(TI()CurrentUser->IsLinefeeds());
	}

void sfIsuserexpert(strList *)
	{
	SETBOOL(TI()CurrentUser->IsExpert());
	}

void sfIsuseraide(strList *)
	{
	SETBOOL(TI()CurrentUser->IsAide());
	}

void sfIsusertabs(strList *)
	{
	SETBOOL(TI()CurrentUser->IsTabs());
	}

void sfIsuserlastold(strList *)
	{
	SETBOOL(TI()CurrentUser->IsOldToo());
	}

void sfIsuserproblem(strList *)
	{
	SETBOOL(TI()CurrentUser->IsProblem());
	}

void sfIsuserunlisted(strList *)
	{
	SETBOOL(TI()CurrentUser->IsUnlisted());
	}

void sfIsuserperm(strList *)
	{
	SETBOOL(TI()CurrentUser->IsPermanent());
	}

void sfIsusersysop(strList *)
	{
	SETBOOL(TI()CurrentUser->IsSysop());
	}

void sfIsusernode(strList *)
	{
	SETBOOL(TI()CurrentUser->IsNode());
	}

void sfIsusernet(strList *)
	{
	SETBOOL(TI()CurrentUser->IsNetUser());
	}

void sfIsusernoacct(strList *)
	{
	SETBOOL(!TI()CurrentUser->IsAccounting());
	}

void sfIsusernomail(strList *)
	{
	SETBOOL(!TI()CurrentUser->IsMail());
	}

void sfIsuserroomtell(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewRoomDesc());
	}

void sfIsuserfwdnode(strList *)
	{
	SETBOOL(TI()CurrentUser->IsForwardToNode());
	}

void sfIsusernexthall(strList *)
	{
	SETBOOL(TI()CurrentUser->IsAutoNextHall());
	}

void sfIsuserentborders(strList *)
	{
	SETBOOL(TI()CurrentUser->IsEnterBorders());
	}

void sfIsuserverified(strList *)
	{
	SETBOOL(!TI()CurrentUser->IsVerified());
	}

void sfIsusersurlock(strList *)
	{
	SETBOOL(TI()CurrentUser->IsSurnameLocked());
	}

void sfIsuserhalllock(strList *)
	{
	SETBOOL(TI()CurrentUser->IsDefaultHallLocked());
	}

void sfIsuserpsycho(strList *)
	{
	SETBOOL(TI()CurrentUser->IsPsycho());
	}

void sfIsuserdisplayts(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewTitleSurname());
	}

void sfIsusersubjects(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewSubjects());
	}

void sfIsusersignatures(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewSignatures());
	}

void sfIsuseribmgraph(strList *)
	{
	SETBOOL(TI()CurrentUser->IsIBMGraph());
	}

void sfIsuseribmansi(strList *)
	{
	SETBOOL(TI()CurrentUser->IsIBMANSI());
	}

void sfIsuseribmcolor(strList *)
	{
	SETBOOL(TI()CurrentUser->IsIBMColor());
	}

void sfIsusertwirly(strList *)
	{
	SETBOOL(TI()CurrentUser->IsTwirly());
	}

void sfIsuserverbose(strList *)
	{
	SETBOOL(TI()CurrentUser->IsAutoVerbose());
	}

void sfIsusermsgpause(strList *)
	{
	SETBOOL(TI()CurrentUser->IsPauseBetweenMessages());
	}

void sfIsuserminibin(strList *)
	{
	SETBOOL(TI()CurrentUser->IsMinibin());
	}

void sfIsusermsgcls(strList *)
	{
	SETBOOL(TI()CurrentUser->IsClearScreenBetweenMessages());
	}

void sfIsuserroominfo(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewRoomInfoLines());
	}

void sfIsuserhalltell(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewHallDescription());
	}

void sfIsuservcont(strList *)
	{
	SETBOOL(TI()CurrentUser->IsVerboseContinue());
	}

void sfIsuserviewcensor(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewCensoredMessages());
	}

void sfIsuserseeborders(strList *)
	{
	SETBOOL(TI()CurrentUser->IsViewBorders());
	}

void sfIsuserout300(strList *)
	{
	SETBOOL(TI()CurrentUser->IsOut300());
	}

void sfIsuserlocksig(strList *)
	{
	SETBOOL(TI()CurrentUser->IsUserSignatureLocked());
	}

void sfIsuserhideexcl(strList *)
	{
	SETBOOL(TI()CurrentUser->IsHideMessageExclusions());
	}

void sfIsusernodownload(strList *)
	{
	SETBOOL(!TI()CurrentUser->IsDownload());
	}

void sfIsusernoupload(strList *)
	{
	SETBOOL(!TI()CurrentUser->IsUpload());
	}

void sfIsusernochat(strList *)
	{
	SETBOOL(!TI()CurrentUser->IsChat());
	}

void sfIsuserprint(strList *)
	{
	SETBOOL(TI()CurrentUser->IsPrintFile());
	}

void sfGetuserrealname(strList *)
	{
	SETSTR(TI()CurrentUser->GetRealName());
	}

void sfGetuserphone(strList *)
	{
	SETSTR(TI()CurrentUser->GetPhoneNumber());
	}


/* -------------------------------------------------------------------- */
/*							LOG TABLE STUFF 							*/
/* -------------------------------------------------------------------- */
void sfGetltpwhash(strList *params)
	{
	SETINT(LogTab->GetEntry(evaluateInt(params->string))->GetPasswordHash());
	}

void sfGetltinhash(strList *params)
	{
	SETINT(LogTab->GetEntry(evaluateInt(params->string))->GetInitialsHash());
	}

void sfGetltname(strList *params)
	{
	SETSTR(LogTab->GetEntry(evaluateInt(params->string))->GetName());
	}

void sfGetltalias(strList *params)
	{
	SETSTR(LogTab->GetEntry(evaluateInt(params->string))->GetAlias());
	}

void sfGetltlocid(strList *params)
	{
	SETSTR(LogTab->GetEntry(evaluateInt(params->string))->GetLocID());
	}

void sfGetltlogslot(strList *params)
	{
	SETINT(LogTab->GetEntry(evaluateInt(params->string))->GetLogIndex());
	}

void sfGetltcallno(strList *params)
	{
	SETULONG(LogTab->GetEntry(evaluateInt(params->string))->GetCallNumber());
	}

void sfGetltinuse(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsInuse());
	}

void sfGetltucmask(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsUpperOnly());
	}

void sfGetltlfmask(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsLinefeeds());
	}

void sfGetltexpert(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsExpert());
	}

void sfGetltaide(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsAide());
	}

void sfGetlttabs(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsTabs());
	}

void sfGetltoldtoo(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsOldToo());
	}

void sfGetltproblem(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsProblem());
	}

void sfGetltunlisted(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsUnlisted());
	}

void sfGetltpermanent(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsPermanent());
	}

void sfGetltsysop(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsSysop());
	}

void sfGetltnode(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsNode());
	}

void sfGetltnetuser(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsNetUser());
	}

void sfGetltnoaccount(strList *params)
	{
	SETBOOL(!LogTab->GetEntry(evaluateInt(params->string))->IsAccounting());
	}

void sfGetltnomail(strList *params)
	{
	SETBOOL(!LogTab->GetEntry(evaluateInt(params->string))->IsMail());
	}

void sfGetltroomtell(strList *params)
	{
	SETBOOL(LogTab->GetEntry(evaluateInt(params->string))->IsViewRoomDesc());
	}

void sfIsingroup(strList *params)
	{
	SETBOOL(TI()CurrentUser->IsInGroup(evaluateInt(params->string)));
	}

void sfFindUserByName(strList *params)
	{
	l_slot slot;

	if (evaluateBool(params->next->string))
		{
		slot = FindPersonByPartialName(evaluateString(params->string));
		}
	else
		{
		slot = FindPersonByName(evaluateString(params->string));
		}

	SETINT(slot);
	}
