// --------------------------------------------------------------------------
// Citadel: ScrFFile.CPP
//
// File-related internal script functions.

#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"

#include "filerdwr.h"


void sfOpenfile(strList *params)
	{
	int i = evaluateInt(params->string);
	const char *name = evaluateString(params->next->string);

	if (CurScript->UsrFile[i])
		{
		fclose(CurScript->UsrFile[i]);
		}

	changedir(cfg.homepath);

	CurScript->UsrFile[i] = fopen(name, FO_RPB);

	if (!CurScript->UsrFile[i])
		{
		CurScript->UsrFile[i] = fopen(name, FO_WPB);
		}

	SETBOOL(CurScript->UsrFile[i] != NULL);
	}

void sfClosefile(strList *params)
	{
	int i = evaluateInt(params->string);

	if (CurScript->UsrFile[i])
		{
		fclose(CurScript->UsrFile[i]);
		}

	CurScript->UsrFile[i] = NULL;
	}

void sfDeletefile(strList *params)
	{
	SETBOOL(unlink(evaluateString(params->string)) != -1);
	}

void sfFileeof(strList *params)
	{
	SETBOOL(feof(CurScript->UsrFile[evaluateInt(params->string)]));
	}

void sfReadstr(strList *params)
	{
	char str[256];

	net69_GetStr(CurScript->UsrFile[evaluateInt(params->string)], str, 256);
	SETSTR(str);
	}

void sfReadint(strList *params)
	{
	int i;

	fread(&i, sizeof(i), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	SETINT(i);
	}

void sfReaduint(strList *params)
	{
	uint ui;

	fread(&ui, sizeof(ui), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	SETUINT(ui);
	}

void sfReadlong(strList *params)
	{
	long l;

	fread(&l, sizeof(l), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	SETLONG(l);
	}

void sfReadulong(strList *params)
	{
	ulong ul;

	fread(&ul, sizeof(ul), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	SETLONG(ul);
	}

void sfReadbool(strList *params)
	{
	int b;

	fread(&b, sizeof(b), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	SETBOOL(b);
	}

void sfReadChar(strList *params)
	{
	char C;

	fread(&C, sizeof(char), 1, CurScript->UsrFile[evaluateInt(params->string)]);

	SETINT(C);
	}

void sfWriteChar(strList *params)
	{
	char C = evaluateInt(params->next->string);

	fwrite(&C, sizeof(char), 1,
			CurScript->UsrFile[evaluateInt(params->string)]);
	}

void sfWritestr(strList *params)
	{
	const char *str = evaluateString(params->next->string);
	int fn = evaluateInt(params->string);

	fwrite(str, sizeof(char), strlen(str), CurScript->UsrFile[fn]);

	switch (evaluateInt(params->next->next->string))
		{
		case 1:
			{
			char c = 0;
			fwrite(&c, sizeof(c), 1, CurScript->UsrFile[fn]);
			break;
			}

		case 2:
			{
			char c = 13;	// cr
			fwrite(&c, sizeof(c), 1, CurScript->UsrFile[fn]);
			c = 10; 		// lf
			fwrite(&c, sizeof(c), 1, CurScript->UsrFile[fn]);
			break;
			}
		}
	}

void sfWriteint(strList *params)
	{
	int i = evaluateInt(params->next->string);

	fwrite(&i, sizeof(i), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	}

void sfWriteuint(strList *params)
	{
	uint ui = evaluateUint(params->next->string);

	fwrite(&ui, sizeof(ui), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	}

void sfWritelong(strList *params)
	{
	long l = evaluateLong(params->next->string);

	fwrite(&l, sizeof(l), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	}

void sfWriteulong(strList *params)
	{
	ulong ul = evaluateUlong(params->next->string);

	fwrite(&ul, sizeof(ul), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	}

void sfWritebool(strList *params)
	{
	int b = evaluateInt(params->next->string);

	fwrite(&b, sizeof(b), 1, CurScript->UsrFile[evaluateInt(params->string)]);
	}

void sfSeekfile(strList *params)
	{
	fseek(CurScript->UsrFile[evaluateInt(params->string)],
			evaluateLong(params->next->string),
			evaluateInt(params->next->next->string));
	}

void sfTellfile(strList *params)
	{
	SETULONG(ftell(CurScript->UsrFile[evaluateInt(params->string)]));
	}

void sfReadAplOnExit(strList *)
	{
	CurScript->ReadAplOnExit = TRUE;
	}

void sfWriteapl(strList *params)
	{
	FILE *fl;
	char path[128];

	sprintf(path, sbs, cfg.aplpath, inputApl);

	if ((fl = fopen(path, FO_A)) != NULL)
		{
		CurScript->ReadAplOnExit = TRUE;

		fprintf(fl, getmsg(1496), evaluateInt(params->string),
				evaluateString(params->next->string), bn);
		fclose(fl);
		SETBOOL(TRUE);
		}
	else
		{
		SETBOOL(FALSE);
		}
	}

void sfFileexists(strList *params)
	{
	if (params->next)
		{
		changedir(evaluateString(params->next->string));
		}
	else
		{
		if (!strchr(evaluateString(params->string), '\\') &&
				!strchr(evaluateString(params->string), ':'))
			{
			changedir(cfg.ScriptPath);
			}
		}

	SETBOOL(filexists(evaluateString(params->string)));
	}

void sfChangedir(strList *params)
	{
	if (params)
		{
		changedir(evaluateString(params->string));
		}
	else
		{
		changedir(cfg.homepath);
		}
	}

void sfGetDirectory(strList *params)
	{
	if (*evaluateString(params->string))
		{
		changedir(evaluateString(params->string));
		}

	delete [] CurScript->Files;
	CurScript->Files = filldirectory(evaluateString(params->next->string),
			evaluateInt(params->next->next->string), OldAndNew,
			evaluateBool(params->next->next->next->string));

	SETBOOL(!!CurScript->Files);
	}

void sfCountDirectory(strList *)
	{
	if (CurScript->Files)
		{
		for (int entries = 0; CurScript->Files[entries].name[0]; ++entries);
		SETINT(entries);
		}
	else
		{
		SETINT(0);
		}
	}

void sfDumpDirectory(strList *)
	{
	delete [] CurScript->Files;
	CurScript->Files = NULL;
	}

void sfDirectoryGetTime(strList *params)
	{
	if (CurScript->Files)
		{
		uint date = CurScript->Files[evaluateInt(params->string) - 1].date;
		struct date fdate;
		fdate.da_year = (date >> 9) + 1980;
		fdate.da_day = date & 31;
		fdate.da_mon = (date >> 5) & 15;

		uint time = CurScript->Files[evaluateInt(params->string) - 1].time;
		struct time ftime;
		ftime.ti_hour = (time >> 11) & 0x1f;
		ftime.ti_min = (time >> 5) & 0x3f;
		ftime.ti_sec = (time & 0x1f) * 2;
		ftime.ti_hund = 0;

		SETLONG(dostounix(&fdate, &ftime));
		}
	}

void sfDirectoryGetSize(strList *params)
	{
	if (CurScript->Files)
		{
		SETLONG(CurScript->Files[evaluateInt(params->string) - 1].size);
		}
	}

void sfDirectoryGetName(strList *params)
	{
	if (CurScript->Files)
		{
		SETSTR(CurScript->Files[evaluateInt(params->string) - 1].name);
		}
	}

void sfIsFilenameLegal(strList *params)
	{
	Bool AllowSpace = params->next ?
			evaluateBool(params->next->string) : FALSE;

	SETBOOL(IsFilenameLegal(evaluateString(params->string), AllowSpace));
	}

void sfRenamefile(strList *params)
	{
	char temp[128];
	CopyStringToBuffer(temp, evaluateString(params->next->string),
			sizeof(temp) - 1);

	SETBOOL(rename(evaluateString(params->string), temp) != -1);
	}
