/* -------------------------------------------------------------------- */
/*								SCRFDBG.CPP 							*/
/* -------------------------------------------------------------------- */
/*	This file contains all the internal functions for user scripts		*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"
#include "miscovl.h"


///////////////////////////// DEBUG STUFF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
void sfSetDebugScript(strList *params)
	{
	CurScript->Debug = evaluateBool(params->string);
	}

void sfPauseScript(strList *)
	{
	CurScript->Debug = TRUE;
	CurScript->Pause = TRUE;
	}

void sfDebuggingMsg(strList *params)
	{
	if (CurScript->Debug)
		{
		DebuggingMsg(evaluateString(params->string));
		}
	}

void sfSetBreakpoint(strList *params)
	{
	if (CurScript->Debug)
		{
		Breakpoints *bp;

		for (bp = CurScript->BPoints; bp; bp = (Breakpoints *) getNextLL(bp))
			{
			if (bp->LineNum == evaluateInt(params->string))
				{
				break;
				}
			}

		if (!bp)
			{
			bp = (Breakpoints *) addLL((void **) &CurScript->BPoints, sizeof(*bp));

			if (bp)
				{
				bp->LineNum = evaluateInt(params->string);
				SETBOOL(TRUE);
				}
			else
				{
				SETBOOL(FALSE);
				}
			}
		else
			{
			SETBOOL(TRUE);
			}
		}
	else
		{
		SETBOOL(FALSE);
		}
	}

void sfClearBreakpoint(strList *params)
	{
	if (CurScript->Debug)
		{
		Breakpoints *bp;
		int i;

		for (i = 1, bp = CurScript->BPoints; bp; i++, bp = (Breakpoints *) getNextLL(bp))
			{
			if (bp->LineNum == evaluateInt(params->string))
				{
				break;
				}
			}

		if (bp)
			{
			deleteLLNode((void **) &CurScript->BPoints, i);
			SETBOOL(TRUE);
			}
		else
			{
			SETBOOL(FALSE);
			}
		}
	else
		{
		SETBOOL(FALSE);
		}
	}

void sfAddWatch(strList *params)
	{
	if (CurScript->Debug)
		{
		SETBOOL(AddWatch(evaluateString(params->string)));
		}
	else
		{
		SETBOOL(FALSE);
		}
	}

void sfRemoveWatch(strList *params)
	{
	if (CurScript->Debug)
		{
		SETBOOL(RemoveWatch(evaluateString(params->string)));
		}
	else
		{
		SETBOOL(FALSE);
		}
	}

void sfSetDebugSystem(strList *params)
	{
	CurScript->oldSystemDebug = evaluateBool(params->string);

	SETBOOL(CurScript->oldSystemDebug ? TurnDebugOn() : TurnDebugOff());
	}

void sfGetDebugSystem(strList *)
	{
	SETBOOL(debug);
	}
