// --------------------------------------------------------------------------
// CItadel: ScrFCfg.CPP
//
// Script Functions dealing with the system's Configuration.

#include "ctdl.h"
#pragma hdrstop

#include "scrfunc.h"
#include "miscovl.h"


///////////////////////////// CONFIG STUFF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

void sfGetmaxhalls(strList *)
	{
	SETINT(cfg.maxhalls);
	}

void sfGetmaxgroups(strList *)
	{
	SETINT(cfg.maxgroups);
	}

void sfGetmaxrooms(strList *)
	{
	SETINT(cfg.maxrooms);
	}

void sfGetmaxlogtab(strList *)
	{
	SETINT(cfg.MAXLOGTAB);
	}

void sfGetnmessages(strList *)
	{
	SETLONG((long) cfg.nmessages);
	}

void sfGetcallno(strList *)
	{
	SETLONG(cfg.callno);
	}

void sfGetoldest(strList *)
	{
	SETLONG(cfg.oldest);
	}

void sfGetnewest(strList *)
	{
	SETLONG(cfg.newest);
	}

void sfGetmtoldest(strList *)
	{
	SETLONG(cfg.mtoldest);
	}

void sfGetnodename(strList *)
	{
	SETSTR(cfg.nodeTitle);
	}

void sfGetsysopname(strList *)
	{
	SETSTR(cfg.sysop);
	}

void sfGetforwardsys(strList *)
	{
	SETBOOL(cfg.forward);
	}

void sfGetnoderegion(strList *)
	{
	SETSTR(cfg.nodeRegion);
	}

void sfGetnodecountry(strList *)
	{
	SETSTR(cfg.nodeCountry);
	}

void sfGetCit86Country(strList *)
	{
	SETSTR(cfg.Cit86Country);
	}

void sfGetCit86Domain(strList *)
	{
	SETSTR(cfg.Cit86Domain);
	}

void sfGetnodesig(strList *)
	{
	SETSTR(cfg.nodeSignature);
	}

void sfGettwitregion(strList *)
	{
	SETSTR(cfg.twitRegion);
	}

void sfGettwitcountry(strList *)
	{
	SETSTR(cfg.twitCountry);
	}

void sfGetalias(strList *)
	{
	SETSTR(cfg.alias);
	}

void sfGetnodephone(strList *)
	{
	SETSTR(cfg.nodephone);
	}

void sfGetmdata(strList *)
	{
	SETINT(cfg.mdata);
	}

void sfGetdumbmodem(strList *)
	{
	SETINT(cfg.dumbmodem);
	}

void sfGetinitbaud(strList *)
	{
	SETLONG(bauds[cfg.initbaud]);
	}

void sfGetminbaud(strList *)
	{
	SETLONG(connectbauds[cfg.minbaud]);
	}

void sfGetmodsetup(strList *)
	{
	SETSTR(cfg.modsetup);
	}

void sfGetmodunsetup(strList *)
	{
	SETSTR(cfg.modunsetup);
	}

void sfGetdownshift(strList *)
	{
	SETSTR(cfg.downshift);
	}

void sfGetdialsetup(strList *)
	{
	SETSTR(cfg.dialsetup);
	}

void sfGetdialpref(strList *)
	{
	SETSTR(cfg.dialpref);
	}

void sfGetdialring(strList *)
	{
	SETSTR(cfg.dialring);
	}

void sfGetupday(strList *params)
	{
	SETBOOL(cfg.updays[evaluateInt(params->string)]);
	}

void sfGetuphour(strList *params)
	{
	SETBOOL(cfg.uphours[evaluateInt(params->string)]);
	}

void sfGethangupdelay(strList *)
	{
	SETINT(cfg.hangupdelay);
	}

void sfGethangup(strList *)
	{
	SETSTR(cfg.hangup);
	}

void sfGetoffhookstr(strList *)
	{
	SETSTR(cfg.offhookstr);
	}

void sfGethomepath(strList *)
	{
	SETSTR(cfg.homepath);
	}

void sfGetmsgpath(strList *)
	{
	SETSTR(cfg.msgpath);
	}

void sfGethelppath(strList *)
	{
	SETSTR(cfg.helppath);
	}

void sfGethelppath2(strList *)
	{
	SETSTR(cfg.helppath2);
	}

void sfGettemppath(strList *)
	{
	SETSTR(cfg.temppath);
	}

void sfGetroompath(strList *)
	{
	SETSTR(cfg.roompath);
	}

void sfGettrapfile(strList *)
	{
	SETSTR(cfg.trapfile);
	}

void sfGetapplpath(strList *)
	{
	SETSTR(cfg.aplpath);
	}

void sfGetdirpath(strList *)
	{
	SETSTR(cfg.dirpath);
	}

void sfGettranspath(strList *)
	{
	SETSTR(cfg.transpath);
	}

void sfGetprinter(strList *)
	{
	SETSTR(cfg.printer);
	}

void sfGetdlpath(strList *)
	{
	SETSTR(cfg.dlpath);
	}

void sfGetlogextdir(strList *)
	{
	SETSTR(cfg.logextdir);
	}

void sfGetfilebufsize(strList *)
	{
	SETINT(cfg.filebufsize);
	}

void sfGetautoansi(strList *)
	{
	SETINT(cfg.autoansi);
	}

void sfGetentername(strList *)
	{
	SETSTR(cfg.enter_name);
	}

void sfGetnewuserapp(strList *)
	{
	SETSTR(cfg.newuserapp);
	}

void sfGetoldcount(strList *)
	{
	SETINT(cfg.oldcount);
	}

void sfGetlclosedsys(strList *)
	{
	SETBOOL(cfg.l_closedsys);
	}

void sfGetlverified(strList *)
	{
	SETBOOL(cfg.l_verified);
	}

void sfGetlquestionnaire(strList *)
	{
	SETBOOL(cfg.NUQuest[0] != NUQ_NUMQUEST);
	}

void sfGetlsysmsg(strList *)
	{
	SETBOOL(cfg.l_sysop_msg);
	}

void sfGetlcreate(strList *)
	{
	SETBOOL(cfg.l_create);
	}

void sfGetunlogtimeout(strList *)
	{
	SETINT(cfg.unlogtimeout);
	}

void sfGettimeout(strList *)
	{
	SETINT(cfg.timeout);
	}

void sfGetunlogbal(strList *)
	{
	SETLONG(cfg.unlogbal);
	}

void sfGetdefdatestamp(strList *)
	{
	SETSTR(cfg.datestamp);
	}

void sfGetdefvdatestamp(strList *)
	{
	SETSTR(cfg.vdatestamp);
	}

void sfGetdefrprompt(strList *)
	{
	SETSTR(cfg.prompt);
	}

void sfGetmsgnym(strList *)
	{
	SETSTR(cfg.Lmsg_nym);
	}

void sfGetmsgsnym(strList *)
	{
	SETSTR(cfg.Lmsgs_nym);
	}

void sfGetcreditnym(strList *)
	{
	SETSTR(cfg.Lcredit_nym);
	}

void sfGetcreditsnym(strList *)
	{
	SETSTR(cfg.Lcredits_nym);
	}

void sfGetmsgverb(strList *)
	{
	SETSTR(cfg.Lmsg_done);
	}

void sfGetborder(strList *params)
	{
	SETSTR(&(borders[81 * evaluateInt(params->string)]));
	}

void sfGetmaxborders(strList *)
	{
	SETINT(cfg.maxborders);
	}

void sfGetdefnetprefix(strList *)
	{
	SETSTR(cfg.netPrefix);
	}

void sfGetnopwecho(strList *)
	{
	SETINT(cfg.nopwecho);
	}

void sfGetanonauthor(strList *)
	{
	SETSTR(cfg.anonauthor);
	}

void sfGettwirly(strList *)
	{
	SETSTR(cfg.twirly);
	}

void sfGettwirlypause(strList *)
	{
	SETINT(cfg.twirlypause);
	}

void sfGetmessagek(strList *)
	{
	SETLONG(cfg.messagek);
	}

void sfGetmaxfiles(strList *)
	{
	SETINT(cfg.maxfiles);
	}

void sfGetsetmsgnym(strList *)
	{
	SETBOOL(cfg.msgNym);
	}

void sfGetsysborders(strList *)
	{
	SETBOOL(cfg.borders);
	}

void sfGetforcelogin(strList *)
	{
	SETBOOL(cfg.forcelogin);
	}

void sfGetoffhook(strList *)
	{
	SETINT(cfg.offhook);
	}

void sfGetaccounting(strList *)
	{
	SETBOOL(cfg.accounting);
	}

void sfGetnetmail(strList *)
	{
	SETBOOL(cfg.netmail);
	}

void sfGetsubhubs(strList *)
	{
	SETINT(cfg.subhubs);
	}

void sfGetcolors(strList *)
	{
	SETBOOL(cfg.colors);
	}

void sfGetmoreprompt(strList *)
	{
	SETSTR(cfg.moreprompt);
	}

void sfGetsleepprompt(strList *)
	{
	SETSTR(cfg.sleepprompt);
	}

void sfGetsetcensor(strList *)
	{
	SETBOOL(cfg.censor);
	}

void sfGetcountbeep(strList *)
	{
	SETBOOL(cfg.countbeep);
	}

void sfGetsleepcount(strList *)
	{
	SETINT(cfg.sleepcount);
	}

void sfGetdialmacro(strList *params)
	{
	SETSTR(cfg.dialmacro[evaluateInt(params->string)]);
	}

void sfGetdiskfree(strList *)
	{
	SETLONG(cfg.diskfree);
	}

void sfGetaidechathour(strList *params)
	{
	SETBOOL(cfg.aideChatHours[evaluateInt(params->string)]);
	}

void sfGetentersur(strList *)
	{
	SETBOOL(cfg.entersur);
	}

void sfGetaidehall(strList *)
	{
	SETBOOL(cfg.aidehall);
	}

void sfGetreadluser(strList *)
	{
	SETBOOL(cfg.readluser);
	}

void sfGetenterok(strList *)
	{
	SETBOOL(cfg.unlogEnterOk);
	}

void sfGetreadok(strList *)
	{
	SETBOOL(cfg.unlogReadOk);
	}

void sfGetroomok(strList *)
	{
	SETBOOL(cfg.nonAideRoomOk);
	}

void sfGetaidemoderate(strList *)
	{
	SETBOOL(cfg.moderate);
	}

void sfGetsurnames(strList *)
	{
	SETBOOL(cfg.surnames);
	}

void sfGetnetsurnames(strList *)
	{
	SETBOOL(cfg.netsurname);
	}

void sfGettitles(strList *)
	{
	SETBOOL(cfg.titles);
	}

void sfGetnettitles(strList *)
	{
	SETBOOL(cfg.nettitles);
	}

void sfGetbios(strList *)
	{
	SETBOOL(cfg.bios);
	}

void sfGetattr(strList *)
	{
	SETINT(cfg.attr);
	}

void sfGetwattr(strList *)
	{
	SETINT(cfg.wattr);
	}

void sfGetcattr(strList *)
	{
	SETINT(cfg.cattr);
	}

void sfGetbattr(strList *)
	{
	SETINT(cfg.battr);
	}

void sfGetuttr(strList *)
	{
	SETINT(cfg.uttr);
	}

void sfGetscreensave(strList *params)
	{
	switch (evaluateInt(params->string))
		{
		case 1:
			{
			SETINT(cfg.screensave);
			break;
			}

		case 2:
			{
			SETBOOL(cfg.fucking_stupid);
			break;
			}

		case 3:
			{
			SETBOOL(cfg.really_fucking_stupid);
			break;
			}

		case 4:
			{
			SETINT(cfg.turboClock);
			break;
			}

		case 5:
			{
			SETBOOL(cfg.really_really_fucking_stupid);
			break;
			}
		}
	}

void sfGetconnectwait(strList *)
	{
	SETINT(cfg.connectwait);
	}

void sfGetidletimeout(strList *)
	{
	SETINT(cfg.idle);
	}

void sfGetf6pass(strList *)
	{
	SETSTR(cfg.f6pass);
	}

void sfGetmessageroom(strList *)
	{
	SETINT(cfg.MessageRoom);
	}

void sfGetchaton(strList *)
	{
	SETBOOL(!cfg.noChat);
	}

void sfGetbells(strList *)
	{
	SETINT(cfg.noBells);
	}

void sfGetmcion(strList *)
	{
	SETBOOL(cfg.mci);
	}

void sfGetmciname(strList *)
	{
	SETSTR(cfg.mci_name);
	}

void sfGetmcifirstname(strList *)
	{
	SETSTR(cfg.mci_firstname);
	}

void sfGetmcitime(strList *)
	{
	SETSTR(cfg.mci_time);
	}

void sfGetmcidate(strList *)
	{
	SETSTR(cfg.mci_date);
	}

void sfGetmcipoop(strList *)
	{
	SETSTR(cfg.mci_poop);
	}

void sfGetvmemfile(strList *)
	{
#ifdef AUXMEM
	SETSTR(cfg.vmemfile);
#else
	SETSTR(ns);
#endif
	}

void sfGetcheckcts(strList *)
	{
	SETBOOL(cfg.checkCTS);
	}

void sfGetreadall(strList *)
	{
	SETINT(cfg.readall);
	}

void sfGetpoop(strList *)
	{
	SETINT(cfg.poop);
	}

void sfGetmaxpoop(strList *)
	{
	SETLONG(cfg.maxpoop);
	}

void sfGetpoopuser(strList *)
	{
	SETSTR(cfg.poopuser);
	}

void sfGetprinterprompt(strList *)
	{
	SETBOOL(cfg.printerprompt);
	}

void sfGetscrollsize(strList *)
	{
	SETLONG(cfg.scrollSize);
	}

void sfGetscrollcolors(strList *)
	{
	SETBOOL(cfg.scrollColors);
	}

void sfGetscrolltimeout(strList *)
	{
	SETINT(cfg.scrollTimeOut);
	}

void sfGetmsgcompress(strList *)
	{
	SETBOOL(cfg.msgCompress);
	}

void sfGetrestoremode(strList *)
	{
	SETBOOL(cfg.restore_mode);
	}

void sfGetexpire(strList *)
	{
	SETINT(cfg.expire);
	}

void sfGetmaxjumpback(strList *)
	{
	SETINT(cfg.maxjumpback - 1);
	}

void sfGetfuelbarempty(strList *)
	{
	SETINT(cfg.fuelbarempty);
	}

void sfGetfuelbarfull(strList *)
	{
	SETINT(cfg.fuelbarfull);
	}

void sfGetstatnum(strList *)
	{
	SETINT(cfg.statnum);
	}

void sfSetidletimeout(strList *params)
	{
	cfg.idle = evaluateInt(params->string);
	}

void sfSetnodename(strList *params)
	{
	CopyStringToBuffer(cfg.nodeTitle, evaluateString(params->string), LABELSIZE);
	}

void sfSetsysopname(strList *params)
	{
	CopyStringToBuffer(cfg.sysop, evaluateString(params->string), LABELSIZE);
	}

void sfSetforwardsys(strList *params)
	{
	cfg.forward = evaluateBool(params->string);
	}

void sfSetnoderegion(strList *params)
	{
	CopyStringToBuffer(cfg.nodeRegion, evaluateString(params->string), LABELSIZE);
	}

void sfSetnodecountry(strList *params)
	{
	CopyStringToBuffer(cfg.nodeCountry, evaluateString(params->string), LABELSIZE);
	}

void sfSetCit86Country(strList *params)
	{
	CopyStringToBuffer(cfg.Cit86Country, evaluateString(params->string), LABELSIZE);
	}

void sfSetCit86Domain(strList *params)
	{
	CopyStringToBuffer(cfg.Cit86Domain, evaluateString(params->string), LABELSIZE);
	}

void sfSettwitregion(strList *params)
	{
	CopyStringToBuffer(cfg.twitRegion, evaluateString(params->string), LABELSIZE);
	}

void sfSettwitcountry(strList *params)
	{
	CopyStringToBuffer(cfg.twitCountry, evaluateString(params->string), LABELSIZE);
	}

void sfSetnodephone(strList *params)
	{
	CopyStringToBuffer(cfg.nodephone, evaluateString(params->string), LABELSIZE);
	}

void sfSetmdata(strList *params)
	{
	cfg.mdata = evaluateInt(params->string);
	}

void sfSetdumbmodem(strList *params)
	{
	cfg.dumbmodem = evaluateInt(params->string);
	}

void sfSetinitbaud(strList *params)
	{
	PortSpeedE PS = digitbaud(evaluateLong(params->string));

	if (PS != PS_ERROR)
		{
		cfg.initbaud = PS;
		SETBOOL(TRUE);
		}
	else
		{
		SETBOOL(FALSE);
		}
	}

void sfSetminbaud(strList *params)
	{
	ModemSpeedE MS = digitConnectbaud(evaluateLong(params->string));

	if (MS != MS_ERROR)
		{
		cfg.minbaud = MS;
		SETBOOL(TRUE);
		}
	else
		{
		SETBOOL(FALSE);
		}
	}

void sfSetmodsetup(strList *params)
	{
	CopyStringToBuffer(cfg.modsetup, evaluateString(params->string),
			sizeof(cfg.modsetup) - 1);
	}

void sfSetmodunsetup(strList *params)
	{
	CopyStringToBuffer(cfg.modunsetup, evaluateString(params->string),
			sizeof(cfg.modunsetup) - 1);
	}

void sfSetdownshift(strList *params)
	{
	CopyStringToBuffer(cfg.downshift, evaluateString(params->string), LABELSIZE);
	}

void sfSetdialsetup(strList *params)
	{
	CopyStringToBuffer(cfg.dialsetup, evaluateString(params->string),
			sizeof(cfg.dialsetup) - 1);
	}

void sfSetdialpref(strList *params)
	{
	CopyStringToBuffer(cfg.dialpref, evaluateString(params->string), LABELSIZE);
	}

void sfSetdialring(strList *params)
	{
	CopyStringToBuffer(cfg.dialring, evaluateString(params->string), LABELSIZE);
	}

void sfSetupday(strList *params)
	{
	cfg.updays[evaluateInt(params->string)] = evaluateBool(params->next->string);
	}

void sfSetuphour(strList *params)
	{
	cfg.uphours[evaluateInt(params->string)] = evaluateBool(params->next->string);
	}

void sfSethangupdelay(strList *params)
	{
	cfg.hangupdelay = evaluateInt(params->string);
	}

void sfSethangup(strList *params)
	{
	CopyStringToBuffer(cfg.hangup, evaluateString(params->string), LABELSIZE);
	}

void sfSetoffhookstr(strList *params)
	{
	CopyStringToBuffer(cfg.offhookstr, evaluateString(params->string), LABELSIZE);
	}

void sfSethomepath(strList *params)
	{
	CopyStringToBuffer(cfg.homepath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetmsgpath(strList *params)
	{
	CopyStringToBuffer(cfg.msgpath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSethelppath(strList *params)
	{
	CopyStringToBuffer(cfg.helppath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSethelppath2(strList *params)
	{
	CopyStringToBuffer(cfg.helppath2, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSettemppath(strList *params)
	{
	CopyStringToBuffer(cfg.temppath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetroompath(strList *params)
	{
	CopyStringToBuffer(cfg.roompath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSettrapfile(strList *params)
	{
	CopyStringToBuffer(cfg.trapfile, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetapplpath(strList *params)
	{
	CopyStringToBuffer(cfg.aplpath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetdirpath(strList *params)
	{
	CopyStringToBuffer(cfg.dirpath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSettranspath(strList *params)
	{
	CopyStringToBuffer(cfg.transpath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetprinter(strList *params)
	{
	CopyStringToBuffer(cfg.printer, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetdlpath(strList *params)
	{
	CopyStringToBuffer(cfg.dlpath, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetlogextdir(strList *params)
	{
	CopyStringToBuffer(cfg.logextdir, evaluateString(params->string), DOSPATHSIZE);
	}

void sfSetautoansi(strList *params)
	{
	cfg.autoansi = evaluateInt(params->string);
	}

void sfSetentername(strList *params)
	{
	CopyStringToBuffer(cfg.enter_name, evaluateString(params->string), LABELSIZE);
	}

void sfSetnewuserapp(strList *params)
	{
	CopyStringToBuffer(cfg.newuserapp, evaluateString(params->string), LABELSIZE);
	}

void sfSetoldcount(strList *params)
	{
	cfg.oldcount = evaluateInt(params->string);
	}

void sfSetlclosedsys(strList *params)
	{
	cfg.l_closedsys = evaluateBool(params->string);
	}

void sfSetlverified(strList *params)
	{
	cfg.l_verified = evaluateBool(params->string);
	}

void sfSetlsysmsg(strList *params)
	{
	cfg.l_sysop_msg = evaluateBool(params->string);
	}

void sfSetlcreate(strList *params)
	{
	cfg.l_create = evaluateBool(params->string);
	}

void sfSetunlogtimeout(strList *params)
	{
	cfg.unlogtimeout = evaluateInt(params->string);
	}

void sfSettimeout(strList *params)
	{
	cfg.timeout = evaluateInt(params->string);
	}

void sfSetunlogbal(strList *params)
	{
	cfg.unlogbal = evaluateLong(params->string);
	}

void sfSetdefdatestamp(strList *params)
	{
	CopyStringToBuffer(cfg.datestamp, evaluateString(params->string),
			sizeof(cfg.datestamp) - 1);
	}

void sfSetdefvdatestamp(strList *params)
	{
	CopyStringToBuffer(cfg.vdatestamp, evaluateString(params->string),
			sizeof(cfg.vdatestamp) - 1);
	}

void sfSetdefrprompt(strList *params)
	{
	CopyStringToBuffer(cfg.prompt, evaluateString(params->string),
			sizeof(cfg.prompt) - 1);
	}

void sfSetmsgnym(strList *params)
	{
	label L;

	CopyStringToBuffer(cfg.Lmsg_nym,
			MakeItLower(evaluateString(params->string), L), LABELSIZE);
	CopyStringToBuffer(cfg.Umsg_nym,
			MakeItUpper(evaluateString(params->string), L), LABELSIZE);
	}

void sfSetmsgsnym(strList *params)
	{
	label L;

	CopyStringToBuffer(cfg.Lmsgs_nym,
			MakeItLower(evaluateString(params->string), L), LABELSIZE);
	CopyStringToBuffer(cfg.Umsgs_nym,
			MakeItUpper(evaluateString(params->string), L), LABELSIZE);
	}

void sfSetcreditnym(strList *params)
	{
	label L;

	CopyStringToBuffer(cfg.Lcredit_nym,
			MakeItLower(evaluateString(params->string), L), LABELSIZE);
	CopyStringToBuffer(cfg.Ucredit_nym,
			MakeItUpper(evaluateString(params->string), L), LABELSIZE);
	}

void sfSetcreditsnym(strList *params)
	{
	label L;

	CopyStringToBuffer(cfg.Lcredits_nym,
			MakeItLower(evaluateString(params->string), L), LABELSIZE);
	CopyStringToBuffer(cfg.Ucredits_nym,
			MakeItUpper(evaluateString(params->string), L), LABELSIZE);
	}

void sfSetmsgverb(strList *params)
	{
	label L;

	CopyStringToBuffer(cfg.Lmsg_done,
			MakeItLower(evaluateString(params->string), L), LABELSIZE);
	CopyStringToBuffer(cfg.Umsg_done,
			MakeItUpper(evaluateString(params->string), L), LABELSIZE);
	}

void sfSetborder(strList *params)
	{
	CopyStringToBuffer(&(borders[81 * evaluateInt(params->string)]), 
			evaluateString(params->next->string), 80);
	}

void sfSetdefnetprefix(strList *params)
	{
	CopyStringToBuffer(cfg.netPrefix, evaluateString(params->string), LABELSIZE);
	}

void sfSetnopwecho(strList *params)
	{
	cfg.nopwecho = evaluateInt(params->string);
	}

void sfSetanonauthor(strList *params)
	{
	CopyStringToBuffer(cfg.anonauthor, evaluateString(params->string), LABELSIZE);
	}

void sfSettwirly(strList *params)
	{
	CopyStringToBuffer(cfg.twirly, evaluateString(params->string), LABELSIZE);
	}

void sfSettwirlypause(strList *params)
	{
	cfg.twirlypause = evaluateInt(params->string);
	}

void sfSetmaxfiles(strList *params)
	{
	cfg.maxfiles = evaluateInt(params->string);
	}

void sfSetsetmsgnym(strList *params)
	{
	cfg.msgNym = evaluateBool(params->string);
	}

void sfSetforcelogin(strList *params)
	{
	cfg.forcelogin = evaluateBool(params->string);
	}

void sfSetoffhook(strList *params)
	{
	cfg.offhook = evaluateInt(params->string);
	}

void sfSetnetmail(strList *params)
	{
	cfg.netmail = evaluateBool(params->string);
	}

void sfSetsubhubs(strList *params)
	{
	cfg.subhubs = evaluateInt(params->string);
	}

void sfSetcolors(strList *params)
	{
	cfg.colors = evaluateBool(params->string);
	}

void sfSetmoreprompt(strList *params)
	{
	CopyStringToBuffer(cfg.moreprompt, evaluateString(params->string),
			sizeof(cfg.moreprompt) - 1);
	}

void sfSetsleepprompt(strList *params)
	{
	CopyStringToBuffer(cfg.sleepprompt, evaluateString(params->string),
			sizeof(cfg.sleepprompt) - 1);
	}

void sfSetsetcensor(strList *params)
	{
	cfg.censor = evaluateBool(params->string);
	}

void sfSetcountbeep(strList *params)
	{
	cfg.countbeep = evaluateBool(params->string);
	}

void sfSetsleepcount(strList *params)
	{
	cfg.sleepcount = evaluateInt(params->string);
	}

void sfSetdialmacro(strList *params)
	{
	CopyStringToBuffer(cfg.dialmacro[evaluateInt(params->string)],
			evaluateString(params->next->string), 79);
	}

void sfSetdiskfree(strList *params)
	{
	cfg.diskfree = evaluateLong(params->string);
	}

void sfSetaidechathour(strList *params)
	{
	cfg.aideChatHours[evaluateInt(params->string)] =
		evaluateBool(params->next->string);
	}

void sfSetentersur(strList *params)
	{
	cfg.entersur = evaluateBool(params->string);
	}

void sfSetaidehall(strList *params)
	{
	cfg.aidehall = evaluateBool(params->string);
	}

void sfSetreadluser(strList *params)
	{
	cfg.readluser = evaluateBool(params->string);
	}

void sfSetenterok(strList *params)
	{
	cfg.unlogEnterOk = evaluateBool(params->string);
	}

void sfSetreadok(strList *params)
	{
	cfg.unlogReadOk = evaluateBool(params->string);
	}

void sfSetroomok(strList *params)
	{
	cfg.nonAideRoomOk = evaluateBool(params->string);
	}

void sfSetaidemoderate(strList *params)
	{
	cfg.moderate = evaluateBool(params->string);
	}

void sfSetsurnames(strList *params)
	{
	cfg.surnames = evaluateBool(params->string);
	}

void sfSetnetsurnames(strList *params)
	{
	cfg.netsurname = evaluateBool(params->string);
	}

void sfSettitles(strList *params)
	{
	cfg.titles = evaluateBool(params->string);
	}

void sfSetnettitles(strList *params)
	{
	cfg.nettitles = evaluateBool(params->string);
	}

void sfSetattr(strList *params)
	{
	cfg.attr = evaluateInt(params->string);
	}

void sfSetwattr(strList *params)
	{
	cfg.wattr = evaluateInt(params->string);
	}

void sfSetcattr(strList *params)
	{
	cfg.cattr = evaluateInt(params->string);
	}

void sfSetbattr(strList *params)
	{
	cfg.battr = evaluateInt(params->string);
	}

void sfSetuttr(strList *params)
	{
	cfg.uttr = evaluateInt(params->string);
	}

void sfSetscreensave(strList *params)
	{
	switch (evaluateInt(params->string))
		{
		case 1:
			{
			cfg.screensave = evaluateInt(params->next->string);
			break;
			}

		case 2:
			{
			cfg.fucking_stupid = evaluateBool(params->next->string);
			break;
			}

		case 3:
			{
			cfg.really_fucking_stupid = evaluateBool(params->next->string);
			break;
			}

		case 4:
			{
			cfg.turboClock = evaluateInt(params->next->string);
			break;
			}

		case 5:
			{
			cfg.really_really_fucking_stupid = evaluateBool(params->next->string);
			break;
			}
		}
	}

void sfSetconnectwait(strList *params)
	{
	cfg.connectwait = evaluateInt(params->string);
	}

void sfSetf6pass(strList *params)
	{
	CopyStringToBuffer(cfg.f6pass, evaluateString(params->string), LABELSIZE);
	}

void sfSetmessageroom(strList *params)
	{
	cfg.MessageRoom = evaluateInt(params->string);
	}

void sfSetchaton(strList *params)
	{
	cfg.noChat = !evaluateBool(params->string);
	}

void sfSetbells(strList *params)
	{
	cfg.noBells = evaluateInt(params->string);
	}

void sfSetmcion(strList *params)
	{
	cfg.mci = evaluateBool(params->string);
	}

void sfSetmciname(strList *params)
	{
	CopyStringToBuffer(cfg.mci_name, evaluateString(params->string), LABELSIZE);
	}

void sfSetmcifirstname(strList *params)
	{
	CopyStringToBuffer(cfg.mci_firstname, evaluateString(params->string), LABELSIZE);
	}

void sfSetmcitime(strList *params)
	{
	CopyStringToBuffer(cfg.mci_time, evaluateString(params->string), LABELSIZE);
	}

void sfSetmcidate(strList *params)
	{
	CopyStringToBuffer(cfg.mci_date, evaluateString(params->string), LABELSIZE);
	}

void sfSetmcipoop(strList *params)
	{
	CopyStringToBuffer(cfg.mci_poop, evaluateString(params->string), LABELSIZE);
	}

void sfSetcheckcts(strList *params)
	{
	cfg.checkCTS = evaluateBool(params->string);;
	}

void sfSetreadall(strList *params)
	{
	cfg.readall = evaluateInt(params->string);
	}

void sfSetpoop(strList *params)
	{
	cfg.poop = evaluateInt(params->string);
	}

void sfSetprinterprompt(strList *params)
	{
	cfg.printerprompt = evaluateBool(params->string);
	}

void sfSetscrolltimeout(strList *params)
	{
	cfg.scrollTimeOut = evaluateInt(params->string);
	}

void sfSetmsgcompress(strList *params)
	{
	cfg.msgCompress = evaluateBool(params->string);
	}

void sfSetrestoremode(strList *params)
	{
	cfg.restore_mode = evaluateBool(params->string);
	}

void sfSetexpire(strList *params)
	{
	cfg.expire = evaluateInt(params->string);
	}

void sfSetfuelbarempty(strList *params)
	{
	cfg.fuelbarempty = evaluateInt(params->string);
	}

void sfSetfuelbarfull(strList *params)
	{
	cfg.fuelbarfull = evaluateInt(params->string);
	}
