// --------------------------------------------------------------------------
// Citadel: RunCron.CPP
//
// Code to run cron events.

#include "ctdl.h"
#pragma hdrstop

#include "net.h"
#include "log.h"
#include "cron.h"
#include "events.h"
#include "aplic.h"
#include "cwindows.h"
#include "term.h"


// --------------------------------------------------------------------------
// Contents
//
// do_event 		Actualy do this event


// --------------------------------------------------------------------------
// do_event(): Actually do this event.

Bool CronEventC::Do(void)
	{
	if (cfg.fucking_stupid)
		{
		ScreenSaver.Update();
		}

	SetLastTried();

	statRecord *theStatus;

	if ((theStatus = addStatus()) != NULL)
		{
		updateStatus = TRUE;

		switch (Type)
			{
			case CR_SHELL_1:
			case CR_SHELL_2:
				{
				sprintf(theStatus->theStatus, getmsg(202), String);
				break;
				}

			case CR_CHAT_OFF:
				{
				sprintf(theStatus->theStatus, getmsg(184));
				break;
				}

			case CR_CHAT_ON:
				{
				sprintf(theStatus->theStatus, getmsg(185));
				break;
				}

			case CR_SHUTDOWN:
				{
				sprintf(theStatus->theStatus, getmsg(186), String);
				break;
				}

			case CR_NET:
				{
				sprintf(theStatus->theStatus, getmsg(29), String);
				break;
				}

			case CR_NET69_IN:
				{
				sprintf(theStatus->theStatus, getmsg(203));
				break;
				}

			case CR_NET69_OUT:
				{
				sprintf(theStatus->theStatus, getmsg(207), String);
				break;
				}

			case CR_NET86_IN:
				{
				sprintf(theStatus->theStatus, getmsg(513));
				break;
				}

			case CR_NET86_OUT:
				{
				sprintf(theStatus->theStatus, getmsg(512));
				break;
				}

			case CR_COMMAND:
				{
				sprintf(theStatus->theStatus, getmsg(209), String);
				break;
				}

			default:
				{
				sprintf(theStatus->theStatus, getmsg(210), Type);
				break;
				}
			}

		strcat(theStatus->theStatus, getmsg(371));
		time(&theStatus->theTime);
		StatusLine.Update();
		}

	switch (Type)
		{
		case CR_SHELL_1:
		case CR_SHELL_2:
			{
			char trapstr[128];
			sprintf(trapstr, getmsg(202), String);
			cPrintf(pcts, trapstr);
			trap(trapstr, T_CRON);

			doEvent(EVT_APPLIC);

			RunApplication(String, NULL, TRUE, TRUE);

			CITWINDOW *w = ScreenSaver.IsOn() ? NULL :
					CitWindowsMsg(NULL, getmsg(1611));

			Initport();

			if (w)
				{
				destroyCitWindow(w, FALSE);
				}

			SetDone();

			break;
			}

		case CR_CHAT_OFF:
			{
			char trapstr[128];

			CopyStringToBuffer(trapstr, getmsg(184), sizeof(trapstr) - 1);
			cPrintf(trapstr);
			trap(trapstr, T_CRON);

			cfg.noChat = TRUE;

			SetDone();
			break;
			}

		case CR_CHAT_ON:
			{
			char trapstr[128];

			CopyStringToBuffer(trapstr, getmsg(185), sizeof(trapstr) - 1);
			cPrintf(trapstr);
			trap(trapstr, T_CRON);

			cfg.noChat = FALSE;

			SetDone();
			break;
			}

		case CR_SHUTDOWN:
			{
			char trapstr[128];

			sprintf(trapstr, getmsg(186), String);
			cPrintf(pcts, trapstr);
			trap(trapstr, T_CRON);

			return_code = atoi(String);
			TI()ExitToMsdos = TRUE;

			SetDone();
			break;
			}

		case CR_NET:
			{
			if (!TI()loggedIn)
				{
				char trapstr[128];
				sprintf(trapstr, getmsg(29), String);
				cPrintf(pcts, trapstr);
				trap(trapstr, T_CRON);

				if (net_callout(String))
					{
					did_net(String);
					SetDone();
					}

				setdefaultTerm(2);	// Ansi-CLR
				}
			else
				{
				mPrintfCR(getmsg(187), cfg.Luser_nym);
				}

			break;
			}

		case CR_NET69_IN:
			{
			if (read_net_messages())
				{
				if (!TI()loggedIn)
					{
					char trapstr[128];

					CopyStringToBuffer(trapstr, getmsg(203),
							sizeof(trapstr) - 1);
					cPrintf(trapstr);
					doccr();
					trap(trapstr, T_CRON);

					amZap();
					net69_incorporate();
					SaveAideMess(NULL);

					SetDone();
					}
				else
					{
					CRmPrintfCR(getmsg(204));
					}

				dump_net_messages();
				}
			else 
				{
				cPrintf(getmsg(59));
				}

			break;
			}

		case CR_NET69_OUT:
			{
			if (read_net_messages())
				{
				if (!TI()loggedIn)
					{
					cPrintf(getmsg(205));
					doccr();

					label rnode;
					CopyStringToBuffer(rnode, String, LABELSIZE);

					if (getnode(&TI()node, rnode, MODEM, TRUE))
						{
						if (LoadPersonByName(TI()node->GetName()))
							{
							char trapstr[128];
							sprintf(trapstr, getmsg(207),
									TI()node->GetName());

							cPrintf(pcts, trapstr);
							doccr();
							trap(trapstr, T_CRON);

							LogEntry5 Log5Save(cfg.maxrooms);
							Log5Save.CopyRoomNewPointers(*TI()CurrentUser);

							amZap();

							if (!net69_fetch(TRUE))
								{
								TI()CurrentUser->CopyRoomNewPointers(Log5Save);
								}

							SaveAideMess(NULL);

							TI()CurrentUser->Save(TI()ThisLog);

							SetDone();
							}
						else
							{
							mPrintfCR(getmsg(255), TI()node->GetName());
							break;
							}
						}
					}
				else
					{
					CRmPrintfCR(getmsg(208));
					}

				dump_net_messages();
				}
			else
				{
				cPrintf(getmsg(59));
				}

			break;
			}

		case CR_NET86_IN:
			{
			if (read_net_messages())
				{
				if (!TI()loggedIn)
					{
					label rnode;
					CopyStringToBuffer(rnode, String, LABELSIZE);

					char trapstr[128];
					CopyStringToBuffer(trapstr, getmsg(513),
							sizeof(trapstr) - 1);
					cPrintf(trapstr);
					doccr();

					// Fix this later

					if (getnode(&TI()node, rnode, MODEM, FALSE))
						{
						trap(trapstr, T_CRON);

						amZap();
						net86_incorporate();
						SaveAideMess(NULL);

						SetDone();
						}
					}
				else
					{
					CRmPrintfCR(getmsg(204));
					}

				dump_net_messages();
				}
			else
				{
				cPrintf(getmsg(59));
				}

			break;
			}

		case CR_NET86_OUT:
			{
			if (read_net_messages())
				{
				if (!TI()loggedIn)
					{
					cPrintf(getmsg(512));
					doccr();

					label rnode;
					CopyStringToBuffer(rnode, String, LABELSIZE);

					if (getnode(&TI()node, rnode, MODEM, FALSE))
						{
						if (LoadPersonByName(TI()node->GetName()))
							{
							char trapstr[128];
							sprintf(trapstr, getmsg(207), TI()node->GetName());

							cPrintf(pcts, trapstr);
							doccr();
							trap(trapstr, T_CRON);

							LogEntry5 Log5Save(cfg.maxrooms);
							Log5Save.CopyRoomNewPointers(*TI()CurrentUser);

							amZap();

							if (!net86_fetch())
								{
								TI()CurrentUser->CopyRoomNewPointers(Log5Save);
								}

							SaveAideMess(NULL);

							TI()CurrentUser->Save(TI()ThisLog);

							SetDone();
							}
						else
							{
							mPrintfCR(getmsg(255), TI()node->GetName());
							break;
							}
						}
					}
				else
					{
					CRmPrintfCR(getmsg(208));
					}

				dump_net_messages();
				}
			else
				{
				cPrintf(getmsg(59));
				}

			break;
			}

		case CR_COMMAND:
			{
			char trapstr[128];
			sprintf(trapstr, getmsg(209), String);
			trap(trapstr, T_CRON);

			cPrintf(pcts, trapstr);
			doccr();

			if (runScript(String))
				{
				SetDone();
				}
			else
				{
				SetLastTried();
				}

			break;
			}

		default:
			{
			cPrintf(getmsg(210), Type);
			doCR();
			break;
			}
		}

	if (theStatus)
		{
		updateStatus = TRUE;

		switch (Type)
			{
			case CR_SHELL_1:
			case CR_SHELL_2:
				{
				sprintf(theStatus->theStatus, getmsg(202), String);
				break;
				}

			case CR_CHAT_OFF:
				{
				sprintf(theStatus->theStatus, getmsg(184));
				break;
				}

			case CR_CHAT_ON:
				{
				sprintf(theStatus->theStatus, getmsg(185));
				break;
				}

			case CR_SHUTDOWN:
				{
				sprintf(theStatus->theStatus, getmsg(186), String);
				break;
				}

			case CR_NET:
				{
				sprintf(theStatus->theStatus, getmsg(29), String);
				break;
				}

			case CR_NET69_IN:
				{
				sprintf(theStatus->theStatus, getmsg(203));
				break;
				}

			case CR_NET69_OUT:
				{
				sprintf(theStatus->theStatus, getmsg(207), String);
				break;
				}

			case CR_NET86_IN:
				{
				sprintf(theStatus->theStatus, getmsg(513));
				break;
				}

			case CR_NET86_OUT:
				{
				sprintf(theStatus->theStatus, getmsg(512));
				break;
				}

			case CR_COMMAND:
				{
				sprintf(theStatus->theStatus, getmsg(209), String);
				break;
				}

			default:
				{
				sprintf(theStatus->theStatus, getmsg(210), Type);
				break;
				}
			}

		strcat(theStatus->theStatus, LastAttemptFailed() ?
				getmsg(370) : getmsg(369));

		theStatus->theTime = LastTried;
		StatusLine.Update();
		}

	return (!LastAttemptFailed());
	}
