// --------------------------------------------------------------------------
// Citadel: RoomShow.CPP
//
// Stuff for showing information from the room database

#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "roompriv.h"
#include "boolexpr.h"
#include "log.h"
#include "group.h"
#include "msg.h"
#include "tallybuf.h"
#include "aplic.h"

static void showRoomDescription(void);

// --------------------------------------------------------------------------
// dumpRoom(): tells us # new messages etc.
//
// Input:
//	Bool infoLineAndAutoApp: TRUE to show info line and run room's auto-app;
//		FALSE to not.
//
// Return value:
//	None.

void dumpRoom(Bool infoLineAndAutoApp)
	{
	ulong total, messages, newMsgs;

	total		= GetRoomTotalMessages(TI()thisRoom);
	messages	= GetRoomMessages(TI()thisRoom);
	newMsgs 	= GetRoomNewMessages(TI()thisRoom);

	doCR();

	if (infoLineAndAutoApp)
		{
		if (roomBuf->rbroomtell[0] && !IsRoomVisited(TI()thisRoom))
			{
			showRoomDescription();
			}
		else if (*roomBuf->descript && TI()CurrentUser->IsViewRoomInfoLines())
			{
			mPrintfCR(getmsg(852), roomBuf->descript);
			}
		}

#ifndef WINCIT
	// hmmm... where to put this?
	if (infoLineAndAutoApp && roomBuf->rbflags.IsApplication() &&
			roomBuf->AUTOAPP && !IsRoomVisited(TI()thisRoom))
		{
		ExeAplic();
		}
#endif

	if (TI()CurrentUser->IsAide())
		{
		mPrintf(getmsg(851), ltoac(total));
		}

	mPrintf(getmsg(850), ltoac(messages),
			(messages == 1) ? cfg.Lmsg_nym : cfg.Lmsgs_nym);

	if (newMsgs && TI()loggedIn)
		{
		mPrintf(getmsg(849), ltoac(newMsgs));
		}

	mPrintfCR(getmsg(1433));

	if (IsRoomMail(TI()thisRoom) && TI()loggedIn)
		{
		mPrintfCR(getmsg(924));
		}

	if (IsRoomOldMail(TI()thisRoom) && TI()loggedIn)
		{
		mPrintfCR(getmsg(912));
		}

	if (TI()CurrentUser->IsSysop() &&
			*GetRoomNetID(TI()thisRoom) &&		// maybe IsRoomShared check?
												// definitely not!
			IsNetIDCorrupted(GetRoomNetID(TI()thisRoom)))
		{
		mPrintfCR(getmsg(1317));
		}
	}


// --------------------------------------------------------------------------
// showRoomDescription(): Displays room description
//
// Input:
//	None.
//
// Return value:
//	None.

static void showRoomDescription(void)
	{
	TI()UserControl.SetOutFlag(OUTOK);

	if (TI()CurrentUser->IsViewRoomDesc() && *roomBuf->rbroomtell &&
			!IsRoomVisited(TI()thisRoom) &&
			IsFilenameLegal(roomBuf->rbroomtell, NULL))
		{
		char pathToRoomDesc[128];
		sprintf(pathToRoomDesc, sbs, cfg.roompath, roomBuf->rbroomtell);

		if (filexists(pathToRoomDesc))
			{
			if (!TI()CurrentUser->IsExpert())
				{
				CRmPrintfCR(getmsg(577));
				}

			dumpf(pathToRoomDesc, TRUE, 0);
			doCR();

			TI()UserControl.SetOutFlag(OUTOK);
			}
		else
			{
			mPrintfCR(getmsg(925), cfg.Lroom_nym, roomBuf->rbroomtell);
			}

		doCR();
		}
	}
