/* -------------------------------------------------------------------- */
/*	ROOMMAKE.CPP				Citadel 								*/
/* -------------------------------------------------------------------- */
/*				room code for Citadel bulletin board system 			*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "roompriv.h"
#include "log.h"
#include "group.h"
#include "msg.h"
#include "hall.h"
#include "blurbs.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*		makeRoom() constructs a new room via dialogue with user.		*/
/* -------------------------------------------------------------------- */

Bool makeRoom(Bool GroupOnly)
	{
	label roomname;
	label groupname;
	int groupslot, testslot, newSlot;
	int j;
	m_slot i, t_size;
	Bool test;

	SetDoWhat(ENTERROOM);

	newSlot = FindFreeRoomSlot();

	if (newSlot == CERROR)
		{
		mPrintf(getmsg(61), cfg.Uroom_nym);
		return (FALSE);
		}

	if (!TI()CurrentUser->IsExpert())
		{
		dispBlb(B_NEWROOM);
		doCR();
		}

	do
		{
		do
			{
			char Prompt[128];
			sprintf(Prompt, getmsg(106), cfg.Lroom_nym);

			getString(Prompt, roomname, LABELSIZE, TRUE, ECHO, ns);

			if (roomname[0] == '?')
				{
				TI()MRO.Verbose = FALSE;
				listRooms(0);
				}
			} while (roomname[0] == '?');

		normalizeString(roomname);

		if (!*roomname)
			{
			return (FALSE);
			}

		testslot = RoomExists(roomname);

		test = TRUE;
		if (testslot != CERROR)
			{
			mPrintfCR(getmsg(105), roomname, cfg.Lroom_nym);
			test = FALSE;
			}
		} while (!test);

	memset(roomBuf, 0, sizeof(aRoom));

	if (GroupOnly)
		{
		do
			{
			char String[128];

			sprintf(String, getmsg(929), cfg.Lgroup_nym, cfg.Lroom_nym);
			getString(String, groupname, LABELSIZE, TRUE, ECHO, ns);

			if (*groupname == '?')
				{
				ListGroups(TRUE);
				test = FALSE;
				}
			else
				{
				if (!*groupname)
					{
					getRoom(TI()thisRoom, roomBuf); /* From official release */
					return (FALSE);
					}

				groupslot = FindGroupByPartialName(groupname, FALSE);

				test = TRUE;
				if (groupslot == CERROR || !TI()CurrentUser->IsInGroup(groupslot))
					{
					CRmPrintfCR(getmsg(947), cfg.Lgroup_nym);
					test = FALSE;
					}
				}
			} while (!test);

		roomBuf->rbgrpno = (uchar) groupslot;
		}

	roomBuf->rbflags.SetInuse(TRUE);
	roomBuf->rbflags.SetGroupOnly(GroupOnly);

	char Prompt[128];

	sprintf(Prompt, getmsg(107), cfg.Lroom_nym);
	getNormStr(Prompt, roomBuf->descript, 80, ECHO);

	sprintf(Prompt, getmsg(108), cfg.Lroom_nym);
	roomBuf->rbflags.SetPublic(getYesNo(Prompt, 1));

	sprintf(Prompt, getmsg(930), roomname,
			(roomBuf->rbflags.IsPublic()) ? getmsg(931) : getmsg(932),
			cfg.Lroom_nym);

	if (!getYesNo(Prompt, 0))
		{
		getRoom(TI()thisRoom, roomBuf);
		return (FALSE);
		}

	CopyStringToBuffer(roomBuf->rbname, roomname, LABELSIZE);

	if (roomBuf->rbflags.IsShared())
		{
		label NetID;

		CopyStringToBuffer(NetID, roomname, LABELSIZE);
		stripansi(NetID);
		strip(NetID, '"');

		testslot = IdExists(NetID, FALSE);

		if (testslot != CERROR)
			{
			mPrintf(getmsg(137), NetID);
			}
		else
			{
			strcpy(roomBuf->netID, NetID);
			}
		}

	t_size = sizetable();
	for (i = 0; i < t_size; i++)
		{
		if (getRoomNum(i) == newSlot)
			{
			changeheader(cfg.mtoldest + i, DUMP, 255 /* No change */);
			}
		}

	/* Borgah! */
	if (!roomBuf->rbflags.IsPublic() || roomBuf->rbflags.IsBIO())
		{
		cycleroom(newSlot, FALSE, TRUE);
		}
	else
		{
		cycleroom(newSlot, TRUE, TRUE);
		}

	putRoom(newSlot, roomBuf);

	/* remove and unwindow room from all halls */
	for (j = 0; j < cfg.maxhalls; j++)
		{
		HallData->GetEntry(j)->SetRoomInHall(newSlot, FALSE);
		HallData->GetEntry(j)->SetWindowedIntoHall(newSlot, FALSE);
		}

	/* put room in current hall */
	HallData->GetEntry(TI()thisHall)->SetRoomInHall(newSlot, TRUE);

	/* put room in maintenance hall */
	HallData->GetEntry(1)->SetRoomInHall(newSlot, TRUE);

	HallData->Save();

	Message *Msg = new Message;

	if (Msg)
		{
		Msg->SetTextWithFormat(getmsg(110), roomname,
				roomBuf->rbflags.IsPublic() ? '>' : ')',
				TI()CurrentUser->GetName());

		trap(Msg->GetText(), T_NEWROOM);

		Msg->SetTextWithFormat(getmsg(1369), cfg.Uroom_nym, roomname,
				roomBuf->rbflags.IsPublic() ? '>' : ')',
				TI()CurrentUser->GetName());

		Msg->SetRoomNumber(newSlot);

		systemMessage(Msg);

		/* Do it again because of funky compression stuff. */
		Msg->SetTextWithFormat(getmsg(1369), cfg.Uroom_nym, roomname,
				roomBuf->rbflags.IsPublic() ? '>' : ')',
				TI()CurrentUser->GetName());

		if (roomBuf->rbflags.IsGroupOnly())
			{
			Msg->SetGroup(GroupData->GetEntry(roomBuf->rbgrpno)->GetName());
			}

		Msg->SetRoomNumber(AIDEROOM);

		systemMessage(Msg);

		delete Msg;
		}
	else
		{
		mPrintf(getmsg(188), getmsg(794));
		}

	TI()CurrentUser->SetInRoom(newSlot, TRUE);

	TI()roomsMade++;

	gotoRoom(roomname, FALSE, FALSE, FALSE);

	return (TRUE);
	}
