// Citadel: Room.H
//
// How to use the room subsystem.

// ROOM.CPP
const char *GetRoomName(r_slot RoomIndex);
const char *GetRoomNetID(r_slot RoomIndex);
Bool IsRoomGroupOnly(r_slot RoomIndex);
Bool IsRoomMultiGroup(r_slot RoomIndex);
Bool IsRoomReadOnly(r_slot RoomIndex);
Bool IsRoomModerated(r_slot RoomIndex);
Bool IsRoomDownloadOnly(r_slot RoomIndex);
Bool IsRoomUploadOnly(r_slot RoomIndex);
int GetRoomGroupNumber(r_slot RoomIndex);
const uint *GetRoomGroupExpression(r_slot RoomIndex);
int GetRoomPrivNumber(r_slot RoomIndex);
Bool IsRoomShared(r_slot RoomIndex);
Bool IsRoomDirectory(r_slot RoomIndex);
Bool IsRoomHidden(r_slot RoomIndex);
Bool IsRoomBIO(r_slot RoomIndex);
Bool IsRoomSubject(r_slot RoomIndex);
Bool IsRoomInuse(r_slot RoomIndex);
const char *GetCurrentRoomDescription(void);
Bool IsRoomAnonymous(r_slot RoomIndex);
Bool IsRoomArchive(r_slot RoomIndex);
Bool IsRoomPrivGroup(r_slot RoomIndex);
Bool IsRoomApplication(r_slot RoomIndex);
Bool IsRoomPermanent(r_slot RoomIndex);
Bool IsCurrentRoomExcludable(void);
const char *GetCurrentRoomDirectory(void);
const char *GetCurrentRoomDictionary(void);
Bool IsCurrentRoomAutoApp(void);
const char *GetCurrentRoomApplication(void);
Bool IsRoomGroupModerated(r_slot RoomIndex);


// ROOM2.CPP
r_slot FindFreeRoomSlot(void);
void CreateRoomSummary(char *buffer, r_slot RoomIndex);
char *MakeRoomName(r_slot RoomIndex, char *Buffer);
void LoadCurrentRoom(r_slot RoomIndex);
void DebugAuxmemRoomTab(void);
void destroyRoomTab(void);
void createRoomTab(void);


// ROOMLOW.CPP
r_slot GetRoomPosInTable(r_slot RoomIndex);
r_slot PartialRoomExists(const char *SearchString, r_slot StartRoom, Bool IgnoreHalls);
r_slot RoomExists(const char *RoomName);

extern r_slot		*roomPos;			// room position table


// --------------------------------------------------------------------------
// RoomPosTableToRoom(): Gets a room from position in the roompos table.
//
// Input:
//	r_slot RoomIndex: The index to look up
//
// Return value:
//	r_slot: The room referenced by RoomIndex

inline r_slot RoomPosTableToRoom(r_slot RoomIndex)
	{
	assert(RoomIndex < cfg.maxrooms);
	assert(RoomIndex >= 0);
	assert(roomPos != NULL);

	return (roomPos[RoomIndex]);
	}

// ROOM3 - ICKY STUFF TO BE MOVED LATER
Bool IsNetIDCorrupted(const char *NetID);
r_slot IdExists(const char *id, Bool network);

// SHOWROOM.CPP
void dumpRoom(Bool infoLineAndAutoApp);

// ROOM.CPP
void stepRoom(Bool direction);
void unGotoRoom(void);
void gotoRoom(const char *roomname, Bool skiproom, Bool partial, Bool mailScan);

// ROOM3.CPP
void ListAllRooms(Bool ThisHallOnly, Bool CanGetToRoom, Bool ShowNetID);
void listRooms(ulong what);
void ShowRoomStatus(void);
void printroomVer(r_slot room, Bool numMess);

// ROOMEDIT.CPP
Bool editRoom(void);
void killempties(void);
Bool killroom(const char *name);
Bool moveRoom(int offset, Bool inHall);

// ROOMMAKE.CPP
Bool makeRoom(Bool GroupOnly);
