// temp file

#ifndef WINCIT

#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "roompriv.h"
#include "log.h"
#include "hall.h"
#include "config.h"
#include "msg.h"
#include "tallybuf.h"

/* -------------------------------------------------------------------- */
/*		resizeroomfile() -- resizes room file							*/
/* -------------------------------------------------------------------- */
void resizeroomfile(void)
	{
	int q, i, result, in;

	const char *File2;
	long l;
	char ch;

	FILE *oldfile;
	FILE *newfile;
	aRoom tmpRoom;

	int checkedmaxrooms = 0;
	for (i = 0; i < cfg.maxrooms; i++)
		{
		if (IsRoomInuse(i))
			checkedmaxrooms = i;
		}
	if (checkedmaxrooms % 8)
		{
		checkedmaxrooms = (checkedmaxrooms / 8 + 1) * 8;
		}
	if (checkedmaxrooms > newmaxrooms)
		{
		cPrintf(getcfgmsg(246), newmaxrooms, checkedmaxrooms);
		doccr();
		newmaxrooms = checkedmaxrooms;
		}

	if (newmaxrooms == cfg.maxrooms)
		{
		return;
		}

	cPrintf(getcfgmsg(191), cfg.Lrooms_nym);
	doccr();

	chdir(cfg.homepath);

	/* do room.dat */
	File2 = getcfgmsg(208);
	cPrintf(getcfgmsg(185), roomDat);
	cPrintf(br);
	fclose(roomfl);

	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), getcfgmsg(195));
		}

	if ((oldfile = fopen(roomDat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), roomDat);
		}

	fread(&l, sizeof(l), 1, oldfile);
	fwrite(&l, sizeof(l), 1, newfile);

	for (i = 0; i < cfg.maxrooms && i < newmaxrooms; i++)
		{
		if (!(i % 10))
			{
			cPrintf(getcfgmsg(196), roomDat, ltoac(i));
			cPrintf(br);
			}

		fread(&tmpRoom, sizeof(tmpRoom), 1, oldfile);
		fwrite(&tmpRoom, sizeof(tmpRoom), 1, newfile);
		}

	memset(&tmpRoom, 0, sizeof(tmpRoom));

	for (; i < newmaxrooms; i++)
		{
		if (!(i % 10))
			{
			cPrintf(getcfgmsg(196), roomDat, ltoac(i));
			cPrintf(br);
			}
		fwrite(&tmpRoom, sizeof(tmpRoom), 1, newfile);
		}

	cPrintf(getcfgmsg(196), roomDat, ltoac(i));
	cPrintf(br);

	fclose(newfile);
	fclose(oldfile);
	doccr();

	result = unlink(roomDat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(187), roomDat);
		doccr();
		}

	result = rename(File2, roomDat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(188), File2);
		doccr();
		}

	/* log3.dat */
	File2 = getcfgmsg(158);

	cPrintf(getcfgmsg(185), log3Dat);
	cPrintf(br);

	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), getcfgmsg(197));
		}

	if ((oldfile = fopen(log3Dat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), log3Dat);
		}

	for (q = 0; q < cfg.MAXLOGTAB; q++)
		{
		cPrintf(getcfgmsg(196), log3Dat, ltoac(q));
		cPrintf(br);

		for (i = 0; i < cfg.maxrooms / 8 && i < newmaxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		ch = 0;

		for (; i < newmaxrooms / 8; i++)
			{
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		for (; i < cfg.maxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			}
		}

	cPrintf(getcfgmsg(196), log3Dat, ltoac(q));
	cPrintf(br);

	fclose(newfile);
	fclose(oldfile);
	doccr();

	unlink(log3Dat);
	rename(File2, log3Dat);

	/* log4.dat */
	File2 = getcfgmsg(159);

	cPrintf(getcfgmsg(185), log4Dat);
	cPrintf(br);

	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), getcfgmsg(198));
		}

	if ((oldfile = fopen(log4Dat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), log4Dat);
		}

	for (q = 0; q < cfg.MAXLOGTAB; q++)
		{
		cPrintf(getcfgmsg(196), log4Dat, ltoac(q));
		cPrintf(br);

		for (i = 0; (i < (cfg.maxrooms / 8)) && (i < (newmaxrooms / 8)); i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		ch = 0;

		for (; i < (newmaxrooms / 8); i++)
			{
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		for (; i < (cfg.maxrooms / 8); i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			}
		}

	cPrintf(getcfgmsg(196), log4Dat, ltoac(q));
	cPrintf(br);

	fclose(newfile);
	fclose(oldfile);
	doccr();

	unlink(log4Dat);
	rename(File2, log4Dat);


	/* log5.dat */
	File2 = getcfgmsg(160);

	cPrintf(getcfgmsg(185), log5Dat);
	cPrintf(br);

	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), getcfgmsg(199));
		}

	if ((oldfile = fopen(log5Dat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), log5Dat);
		}

	for (q = 0; q < cfg.MAXLOGTAB; q++)
		{
		cPrintf(getcfgmsg(196), log5Dat, ltoac(q));
		cPrintf(br);

		for (i = 0; (i < cfg.maxrooms) && (i < newmaxrooms); i++)
			{
			fread(&l, sizeof(l), 1, oldfile);
			fwrite(&l, sizeof(l), 1, newfile);
			}

		l = 0;

		for (; i < newmaxrooms; i++)
			{
			fwrite(&l, sizeof(l), 1, newfile);
			}

		for (; i < cfg.maxrooms; i++)
			{
			fread(&l, sizeof(l), 1, oldfile);
			}
		}

	cPrintf(getcfgmsg(196), log5Dat, ltoac(q));
	cPrintf(br);

	fclose(newfile);
	fclose(oldfile);
	doccr();

	unlink(log5Dat);
	rename(File2, log5Dat);


	/* log6.dat */
	File2 = getcfgmsg(161);

	cPrintf(getcfgmsg(185), log6Dat);
	cPrintf(br);

	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), getcfgmsg(200));
		}

	if ((oldfile = fopen(log6Dat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), log6Dat);
		}

	for (q = 0; q < cfg.MAXLOGTAB; q++)
		{
		cPrintf(getcfgmsg(196), log6Dat, ltoac(q));
		cPrintf(br);

		for (i = 0; (i < (cfg.maxrooms / 8)) && (i < (newmaxrooms / 8)); i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		ch = 0;

		for (; i < (newmaxrooms / 8); i++)
			{
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		for (; i < (cfg.maxrooms / 8); i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			}
		}

	cPrintf(getcfgmsg(196), log6Dat, ltoac(q));
	cPrintf(br);

	fclose(newfile);
	fclose(oldfile);
	doccr();

	unlink(log6Dat);
	rename(File2, log6Dat);


	/* roompos.dat */
	if (newmaxrooms < cfg.maxrooms)
		{
		cPrintf(getcfgmsg(201), roomposDat);
		cPrintf(bn);
		/* trash it */
		if ((newfile = fopen(roomposDat, FO_WB)) == NULL)
			{
			illegal(getmsg(661), roomposDat);
			}

		for (i = 0; i < newmaxrooms; i++)
			{
			fwrite(&i, sizeof(i), 1, newfile);
			}
		fclose(newfile);
		}
	else
		{
		File2 = getcfgmsg(209);
		cPrintf(getcfgmsg(185), roomposDat);
		cPrintf(br);
		if ((newfile = fopen(File2, FO_WB)) == NULL)
			{
			illegal(getmsg(8), File2);
			}

		if ((oldfile = fopen(roomposDat, FO_RB)) == NULL)
			{
			illegal(getmsg(83), roomposDat);
			}

		for (i = 0; i < cfg.maxrooms && i < newmaxrooms; i++)
			{
			fread(&in, sizeof(in), 1, oldfile);
			fwrite(&in, sizeof(in), 1, newfile);
			}

		for (; i < newmaxrooms; i++)
			{
			fwrite(&i, sizeof(i), 1, newfile);
			}

		fclose(newfile);
		fclose(oldfile);

		result = unlink(roomposDat);
		if (result == -1)
			{
			cPrintf(getcfgmsg(187), roomposDat);
			doccr();
			}

		result = rename(File2, roomposDat);
		if (result == -1)
			{
			cPrintf(getcfgmsg(188), File2);
			doccr();
			}
		}

	/* hall2.dat */
	File2 = getcfgmsg(210);
	cPrintf(getcfgmsg(185), hall2Dat);
	cPrintf(br);
	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), File2);
		}

	if ((oldfile = fopen(hall2Dat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), hall2Dat);
		}

	for (q = 0; q < cfg.maxhalls; q++)
		{
		cPrintf(getcfgmsg(196), hall2Dat, ltoac(q));
		cPrintf(br);

		for (i = 0; i < cfg.maxrooms / 8 && i < newmaxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		ch = 0;

		for (; i < newmaxrooms / 8; i++)
			{
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		for (; i < cfg.maxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			}
		}

	cPrintf(getcfgmsg(196), hall2Dat, ltoac(q));
	cPrintf(br);

	for (q = 0; q < cfg.maxhalls; q++)
		{
		cPrintf(getcfgmsg(196), hall2Dat, ltoac(q));
		cPrintf(getcfgmsg(282), br);

		for (i = 0; i < cfg.maxrooms / 8 && i < newmaxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		ch = 0;

		for (; i < newmaxrooms / 8; i++)
			{
			fwrite(&ch, sizeof(ch), 1, newfile);
			}

		for (; i < cfg.maxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			}
		}

	cPrintf(getcfgmsg(196), hall2Dat, ltoac(q));
	cPrintf(getcfgmsg(282), br);

	fclose(newfile);
	fclose(oldfile);
	doccr();

	result = unlink(hall2Dat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(187), hall2Dat);
		doccr();
		}

	result = rename(File2, hall2Dat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(188), File2);
		doccr();
		}

	destroyRoomTab();

#ifdef AUXMEM
	m_slot *OldFirstMessageInRoom = FirstMessageInRoom;
	m_slot *OldLastMessageInRoom = LastMessageInRoom;

	FirstMessageInRoom = new m_slot[newmaxrooms];
	LastMessageInRoom = new m_slot[newmaxrooms];

	if (!FirstMessageInRoom || !LastMessageInRoom)
		{
		crashout(getcfgmsg(107));
		}
	else
		{
		memset(FirstMessageInRoom, 0xff, sizeof(m_slot) * newmaxrooms);
		memset(LastMessageInRoom, 0xff, sizeof(m_slot) * newmaxrooms);
		memcpy(FirstMessageInRoom, OldFirstMessageInRoom,
				sizeof(m_slot) * min(cfg.maxrooms, newmaxrooms));
		memcpy(LastMessageInRoom, OldLastMessageInRoom,
				sizeof(m_slot) * min(cfg.maxrooms, newmaxrooms));
		delete [] OldFirstMessageInRoom;
		delete [] OldLastMessageInRoom;
		}
#endif

	cfg.maxrooms = newmaxrooms;
	createRoomTab();

	TI()CurrentUser->LogEntry3::Resize(cfg.maxrooms);
	TI()CurrentUser->LogEntry4::Resize(cfg.maxrooms);
	TI()CurrentUser->LogEntry5::Resize(cfg.maxrooms);
	TI()CurrentUser->LogEntry6::Resize(cfg.maxrooms);

	HallData->Resize(cfg.maxhalls, cfg.maxrooms);


	// I don't know if this is the best place to put this.
#ifdef MULTI
	DestroyTalleyBuffer(ti);
#else
	DestroyTalleyBuffer();
#endif


	delete [] roomPos;

	if (	((roomPos = new r_slot[cfg.maxrooms]) == NULL) ||
			!HallData->IsValid() ||
			!TI()CurrentUser->IsValid() ||
#ifdef MULTI
			!CreateTalleyBuffer(ti)
#else
			!CreateTalleyBuffer()
#endif
			)
		{
		crashout(getcfgmsg(107));
		}

	openFile(roomDat, &roomfl);
	RoomTabBld();

	cPrintf(getcfgmsg(190));
	doccr();
	doccr();
	}
#endif
