/* -------------------------------------------------------------------- */
/*	RESIZE.CPP					Citadel 								*/
/*			file resizer for Citadel bulletin board system. 			*/
/* -------------------------------------------------------------------- */
#ifndef WINCIT
#include "ctdl.h"

#include "config.h"
#include "auxtab.h"
#include "filemake.h"
#include "log.h"
#include "msg.h"
#include "group.h"
#include "hall.h"

/* -------------------------------------------------------------------- */
/*		resizelogfile() -- resizes log file 							*/
/* -------------------------------------------------------------------- */
void resizelogfile(void)
	{
	struct find_t file_buf;
	int i;

	chdir(cfg.homepath);

	// get rid of any log?.tmp files
	unlink(getcfgmsg(156));
	unlink(getcfgmsg(157));
	unlink(getcfgmsg(158));
	unlink(getcfgmsg(159));
	unlink(getcfgmsg(160));
	unlink(getcfgmsg(161));

	// and the LE*.TMP files
	changedir(cfg.logextdir);
	ambigUnlink(getcfgmsg(215), FALSE);
	changedir(cfg.homepath);

	// create new log?.tmp files with new size
	i = cfg.MAXLOGTAB;
	cfg.MAXLOGTAB = newmaxlogtab;
	zapLogFile(TRUE, TRUE);
	cfg.MAXLOGTAB = i;

	for (i = 0; (i < cfg.MAXLOGTAB) && (i < newmaxlogtab); i++)
		{
		cPrintf(getcfgmsg(183), ltoac(LogTab->GetEntry(i)->GetLogIndex()));
		cPrintf(getcfgmsg(282), br);

		/* Load from old files (the .DAT ones) */
		TI()CurrentUser->LogEntry1::ResetFileName();
		TI()CurrentUser->LogEntry2::ResetFileName();
		TI()CurrentUser->LogEntry3::ResetFileName();
		TI()CurrentUser->LogEntry4::ResetFileName();
		TI()CurrentUser->LogEntry5::ResetFileName();
		TI()CurrentUser->LogEntry6::ResetFileName();
		TI()CurrentUser->LogExtensions::ResetFileExtension();

		if (!TI()CurrentUser->Load(LogTab->GetEntry(i)->GetLogIndex()))
			{
			crashout(getcfgmsg(281), getcfgmsg(155));
			}

		/* And save to the new files (the .TMP ones) */
		TI()CurrentUser->LogEntry1::SetFileName(getcfgmsg(156));
		TI()CurrentUser->LogEntry2::SetFileName(getcfgmsg(157));
		TI()CurrentUser->LogEntry3::SetFileName(getcfgmsg(158));
		TI()CurrentUser->LogEntry4::SetFileName(getcfgmsg(159));
		TI()CurrentUser->LogEntry5::SetFileName(getcfgmsg(160));
		TI()CurrentUser->LogEntry6::SetFileName(getcfgmsg(161));
		TI()CurrentUser->LogExtensions::SetFileExtension(getcfgmsg(230));

		if (!TI()CurrentUser->Save(i))
			{
			crashout(getcfgmsg(283), getcfgmsg(155));
			}
		}

	doccr();
	doccr();

	/* Back to using the .DAT files */
	TI()CurrentUser->LogEntry1::ResetFileName();
	TI()CurrentUser->LogEntry2::ResetFileName();
	TI()CurrentUser->LogEntry3::ResetFileName();
	TI()CurrentUser->LogEntry4::ResetFileName();
	TI()CurrentUser->LogEntry5::ResetFileName();
	TI()CurrentUser->LogEntry6::ResetFileName();
	TI()CurrentUser->LogExtensions::ResetFileExtension();

	/* clear RAM buffer out */
	TI()CurrentUser->Clear();

	/* Then clean up - .TMP to .DAT */
	unlink(logDat);
	unlink(log2Dat);
	unlink(log3Dat);
	unlink(log4Dat);
	unlink(log5Dat);
	unlink(log6Dat);

	rename(getcfgmsg(156), logDat);
	rename(getcfgmsg(157), log2Dat);
	rename(getcfgmsg(158), log3Dat);
	rename(getcfgmsg(159), log4Dat);
	rename(getcfgmsg(160), log5Dat);
	rename(getcfgmsg(161), log6Dat);

	changedir(cfg.logextdir);
	ambigUnlink(getcfgmsg(211), FALSE);

	for (i = _dos_findfirst(getcfgmsg(215), _A_NORMAL, &file_buf);
			i == 0; i = _dos_findnext(&file_buf))
		{
		label newname;

		strcpy(newname, file_buf.name);
		strcpy(strchr(newname, '.'), getcfgmsg(285));
		rename(file_buf.name, newname);
		}

	changedir(cfg.homepath);
	}

/* -------------------------------------------------------------------- */
/*		resizehallfile() -- resizes hall file							*/
/* -------------------------------------------------------------------- */
void resizehallfile(void)
	{
	int q, i, result;
	long l;

	const char *File2;
	char ch;

	FILE *oldfile;
	FILE *newfile;
	HallEntry1 tmpHall;

	cPrintf(getcfgmsg(184), cfg.Lhalls_nym);
	doccr();

	chdir(cfg.homepath);

	/* do hall.dat */
	File2 = getcfgmsg(216);

	cPrintf(getcfgmsg(185), hallDat);
	cPrintf(br);

	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), File2);
		}
	if ((oldfile = fopen(hallDat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), hallDat);
		}

	fread(&l, sizeof(l), 1, oldfile);
	fwrite(&l, sizeof(l), 1, newfile);

	for (i = 0; i < cfg.maxhalls && i < newmaxhalls; i++)
		{
		if (!tmpHall.Load(i, oldfile))
			{
			crashout(getcfgmsg(281), getcfgmsg(236));
			}

		if (!tmpHall.Save(i, newfile))
			{
			crashout(getcfgmsg(283), getcfgmsg(236));
			}
		}

	tmpHall.Clear();

	for (; i < newmaxhalls; i++)
		{
		if (!tmpHall.Save(i, newfile))
			{
			crashout(getcfgmsg(283), getcfgmsg(236));
			}
		}

	fclose(newfile);
	fclose(oldfile);

	result = unlink(hallDat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(187), hallDat);
		doccr();
		}

	result = rename(File2, hallDat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(188), File2);
		doccr();
		}

	/* hall2.dat */
	File2 = getcfgmsg(210);

	cPrintf(getcfgmsg(185), hall2Dat);
	cPrintf(br);

	if ((newfile = fopen(File2, FO_WB)) == NULL)
		{
		illegal(getmsg(8), File2);
		}
	if ((oldfile = fopen(hall2Dat, FO_RB)) == NULL)
		{
		illegal(getmsg(83), hall2Dat);
		}

	/* inhall */
	for (q = 0; q < cfg.maxhalls && q < newmaxhalls; q++)
		{
		for (i = 0; i < cfg.maxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			fwrite(&ch, sizeof(ch), 1, newfile);
			}
		}

	ch = 0;

	for (; q < newmaxhalls; q++)
		{
		for (i = 0; i < cfg.maxrooms / 8; i++)
			{
			fwrite(&ch, sizeof(ch), 1, newfile);
			}
		}

	for (; q < cfg.maxhalls; q++)
		{
		for (i = 0; i < cfg.maxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			}
		}

	/* window */
	for (q = 0; q < cfg.maxhalls && q < newmaxhalls; q++)
		{
		for (i = 0; i < cfg.maxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			fwrite(&ch, sizeof(ch), 1, newfile);
			}
		}

	ch = 0;

	for (; q < newmaxhalls; q++)
		{
		for (i = 0; i < cfg.maxrooms / 8; i++)
			{
			fwrite(&ch, sizeof(ch), 1, newfile);
			}
		}

	for (; q < cfg.maxhalls; q++)
		{
		for (i = 0; i < cfg.maxrooms / 8; i++)
			{
			fread(&ch, sizeof(ch), 1, oldfile);
			}
		}

	fclose(newfile);
	fclose(oldfile);

	result = unlink(hall2Dat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(187), hall2Dat);
		doccr();
		}

	result = rename(File2, hall2Dat);
	if (result == -1)
		{
		cPrintf(getcfgmsg(188), File2);
		doccr();
		}

	cfg.maxhalls = newmaxhalls;

	HallData->Resize(cfg.maxhalls, cfg.maxrooms);

	if (!HallData->IsValid())
		{
		crashout(getcfgmsg(107));
		}

	doccr();
	cPrintf(getcfgmsg(190));
	doccr();
	doccr();
	}

/* -------------------------------------------------------------------- */
/*		resizegrpfile() -- resizes group file							*/
/* -------------------------------------------------------------------- */
void resizegrpfile(void)
	{
	int i;
	const char *File2;
	FILE *oldfile;
	FILE *newfile;

	///////////////////////////////////////
	cPrintf(getcfgmsg(191), cfg.Ugroups_nym);
	doccr();

	chdir(cfg.homepath);

	File2 = getcfgmsg(217);
	cPrintf(getcfgmsg(185), grpDat);
	cPrintf(br);

	unlink(File2);

	GroupData->Resize(newmaxgroups);

	zapGrpFile(File2, TRUE);

	Bool Success = FALSE;

	if ((oldfile = fopen(grpDat, FO_RB)) != NULL)
		{
		if ((newfile = fopen(File2, FO_RPB)) != NULL)
			{
			g_slot GroupSlot;

			for (GroupSlot = 0;
					(GroupSlot < cfg.maxgroups) && (GroupSlot < newmaxgroups);
					GroupSlot++)
				{
				GroupEntry TempEntry;

				if (!TempEntry.Load(GroupSlot, oldfile))
					{
					crashout(getcfgmsg(281), getcfgmsg(240));
					}

				if (!TempEntry.Save(GroupSlot, newfile))
					{
					crashout(getcfgmsg(283), getcfgmsg(240));
					}
				}

			Success = TRUE;

			fclose(newfile);
			}

		fclose(oldfile);
		}

	if (!Success)
		{
		crashout(getcfgmsg(218), grpDat);
		}

	/* log2.dat */
	Success = FALSE;

	File2 = getcfgmsg(157);
	cPrintf(getcfgmsg(185), log2Dat);
	cPrintf(br);

	unlink(File2);

	if ((oldfile = fopen(log2Dat, FO_RB)) != NULL)
		{
		if ((newfile = fopen(File2, FO_WB)) != NULL)
			{
			l_index LogIndex;

			for (LogIndex = 0; LogIndex < cfg.MAXLOGTAB; LogIndex++)
				{
				char ch;

				for (i = 0; i < cfg.maxgroups / 8 && i < newmaxgroups / 8; i++)
					{
					fread(&ch, sizeof(ch), 1, oldfile);
					fwrite(&ch, sizeof(ch), 1, newfile);
					}

				ch = 0;

				for (; i < newmaxgroups / 8; i++)
					{
					fwrite(&ch, sizeof(ch), 1, newfile);
					}

				for (; i < cfg.maxgroups / 8; i++)
					{
					fread(&ch, sizeof(ch), 1, oldfile);
					}
				}

			Success = TRUE;

			fclose(newfile);
			}

		fclose(oldfile);
		}

	if (!Success)
		{
		crashout(getcfgmsg(218), log2Dat);
		}

	unlink(grpDat);
	rename(getcfgmsg(217), grpDat);
	unlink(log2Dat);
	rename(File2, log2Dat);

	cfg.maxgroups = newmaxgroups;

	TI()CurrentUser->LogEntry2::Resize(cfg.maxgroups);

	if (!GroupData->IsValid() || !TI()CurrentUser->IsValid())
		{
		crashout(getcfgmsg(107));
		}

	doccr();
	cPrintf(getcfgmsg(190));
	doccr();
	doccr();
	}


/* -------------------------------------------------------------------- */
/*		resizemsgfile() -- resizes message file 						*/
/* -------------------------------------------------------------------- */
void resizemsgfile(void)
	{
	Message *Msg = new Message;

	if (Msg)
		{
		int result;
		char msgFile2[64];

		BFILE *oldmsg;
		BFILE *newmsg;

		const char *msgTmp = getcfgmsg(219);

		sprintf(msgFile2, sbs, cfg.msgpath, msgTmp);

		bufferedClose(msgfl);

		if ((msgfl = bufferedCreate(msgFile2)) == NULL)
			{
			illegal(getmsg(8), getcfgmsg(192));
			}

		cfg.messagek = newmessagek;
		zapMsgFile();
		cfg.catLoc = 0l;

		bufferedClose(msgfl);

		/* open first message file */
		if ((oldmsg = bufferedOpen(msgFile)) == NULL)
			{
			cPrintf(getmsg(78), msgFile);
			doccr();
			delete Msg;
			return;
			}

		/* open temp message file */
		if ((newmsg = bufferedOpen(msgFile2)) == NULL)
			{
			cPrintf(getmsg(78), msgFile2);
			doccr();
			bufferedClose(oldmsg);
			delete Msg;
			return;
			}

		m_slot i, tablesize;
		ulong here;

		tablesize = sizetable();

		for (i = 0; i < tablesize; i++)
			{
			long loc = getLocation(i);

			msgfl = oldmsg;

			bufferedSeek(msgfl, loc);

			Msg->ReadAll(RMC_NORMAL, NULL);

			here = atol(Msg->GetLocalID());

			if (here != cfg.mtoldest + i)
				{
				continue;
				}

			cPrintf(getcfgmsg(193), cfg.Lmsg_nym, ltoac(here));
			cPrintf(br);

			msgfl = newmsg;

			Msg->Store(SMC_RESIZE, NULL);
			}
		doccr();
		doccr();

		bufferedClose(oldmsg);
		bufferedClose(newmsg);

		result = unlink(msgFile);
		if (result == -1)
			{
			cPrintf(getcfgmsg(187), msgDat);
			doccr();
			}

		result = rename(msgFile2, msgFile);
		if (result == -1)
			{
			cPrintf(getcfgmsg(188), msgTmp);
			doccr();
			}

		delete Msg;

		if ((msgfl = bufferedOpen(msgFile)) == NULL)
			{
			illegal(getmsg(78), msgFile);
			}
		}
	else
		{
		crashout(getmsg(188), getcfgmsg(172));
		}
	}
#endif
