/* -------------------------------------------------------------------- */
/*	READLOG.CPP 				Citadel 								*/
/* -------------------------------------------------------------------- */
/*								.RU 									*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "viewlog.h"
#include "log.h"
#include "group.h"
#include "boolexpr.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	Readlog()		handles read userlog								*/
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*	Readlog()		handles read userlog								*/
/* -------------------------------------------------------------------- */
void Readlog(Bool revOrder, OldNewPick whichMess, long howMany)
	{
	l_slot CurrentLogSlot;
	Bool wild = FALSE;
	Bool buser = FALSE;
	int step;
	Bool wow = FALSE;

	SetDoWhat(READUSERLOG);

	if ((cfg.readLog < 0) ||
			(cfg.readLog == 0 && !TI()CurrentUser->IsSysop()) ||
			(cfg.readLog == 1 && !TI()CurrentUser->IsAide()))
		{
		CRmPrintfCR(getmsg(58), cfg.Luser_nym);
		return;
		}

	if (!(cfg.readluser || TI()CurrentUser->IsSysop() ||
			TI()CurrentUser->IsAide()))
		{
		TI()rf.Group = FALSE;
		}

	TI()rf.Text = FALSE;

	if (!ProcessReadFilter(&TI()rf, TI()CurrentUser->IsAide()))
		{
		return;
		}

	if (TI()rf.User)
		{
		if (FindPersonByPartialName(TI()rf.SearchUser) == CERROR)
			{
			if (strpos('?',TI()rf.SearchUser) ||
					strpos('*',TI()rf.SearchUser) ||
					strpos('[',TI()rf.SearchUser))
				{
				wild = TRUE;
				}
			else
				{
				CRmPrintfCR(getmsg(595), TI()rf.SearchUser);
				return;
				}
			}
		else
			{
			CopyStringToBuffer(TI()rf.SearchUser, LogTab->
					GetEntry(FindPersonByPartialName(TI()rf.SearchUser))->
					GetName(), LABELSIZE);
			buser = TRUE;
			}
		}

	TI()UserControl.SetOutFlag(OUTOK);

	if (!TI()CurrentUser->IsExpert())
		{
		CRmPrintfCR(getmsg(577));
		}

	if (!revOrder)
		{
		step = 1;
		CurrentLogSlot = 0;
		}
	else
		{
		step = -1;
		CurrentLogSlot = cfg.MAXLOGTAB - 1;
		}

	for (; ((CurrentLogSlot < cfg.MAXLOGTAB) && (TI()UserControl.GetOutFlag() != OUTSKIP) && (CurrentLogSlot >= 0));
			CurrentLogSlot += step)
		{
		if (TI()UserControl.CheckInput(FALSE))
			{
			return;
			}

		if (LogTab->GetEntry(CurrentLogSlot)->IsInuse())
			{
			/* .RNU .ROU */
			if (whichMess == NewOnly &&
					LogTab->GetEntry(CurrentLogSlot)->GetCallNumber() <=

					(TI()loggedIn ?
					TI()CurrentUser->GetCallNumber() :
					last_console_login_callno))
				{
				continue;
				}

			if (whichMess == OldOnly &&
					LogTab->GetEntry(CurrentLogSlot)->GetCallNumber() >=

					(TI()loggedIn ?
					TI()CurrentUser->GetCallNumber() :
					last_console_login_callno))
				{
				continue;
				}

			if (buser && !SameString(TI()rf.SearchUser,
					LogTab->GetEntry(CurrentLogSlot)->GetName()))
				{
				continue;
				}

			if (wild &&
					!u_match(deansi(LogTab->GetEntry(CurrentLogSlot)->GetName()),
					TI()rf.SearchUser))
				{
				continue;
				}

			if (TI()rf.Group)
				{
				/* We have to actually look at the user's info */
				LogEntry2 Log2(cfg.maxgroups);

				if (Log2.Load(LogTab->GetEntry(CurrentLogSlot)->GetLogIndex()))
					{
					TI()Log2ForGroupTester = &Log2;
					TI()SlotForGroupTester = CurrentLogSlot;

					if (!EvaluateBooleanExpression(TI()rf.SearchGroup,
							GroupWithMetaTester))
						{
						// not "really" in the group - check to see if this
						// is the #SYSOP...

						if (LogTab->GetEntry(CurrentLogSlot)->IsMainSysop())
							{
							// so this is the #SYSOP, show or not...
							if (	// show #SYSOP's groupiness
									cfg.showSysop ||

									// or we are the #SYSOP
									(TI()loggedIn &&
									TI()CurrentUser->IsMainSysop())
									)
								{
								for (g_slot g = 0; g < cfg.maxgroups; g++)
									{
									Log2.SetInGroup(g, TRUE);
									}

								if (!EvaluateBooleanExpression(
										TI()rf.SearchGroup,
										GroupWithMetaTester))
									{
									continue;
									}
								}
							else
								{
								continue;
								}
							}
						else
							{
							continue;
							}
						}
					}
				else
					{
					mPrintf(getmsg(83), log2Dat);
					continue;
					}
				}

			if (	/* This is your account */
					(!CurrentLogSlot && TI()loggedIn) ||

					/* You are an Aide */
					TI()CurrentUser->IsAide() ||

					/* The account is not unlisted */
					!LogTab->GetEntry(CurrentLogSlot)->IsUnlisted())
				{
				LogEntry1 Log1;

				if (Log1.Load(LogTab->GetEntry(CurrentLogSlot)->GetLogIndex()))
					{
					if (TI()MRO.Verbose)
						{
						char dtstr[80];

						strftime(dtstr, 79, (TI()loggedIn) ?
								TI()CurrentUser->GetVerboseDateStamp() :
								cfg.vdatestamp,
								Log1.GetCallTime());

						if ((cfg.surnames || cfg.titles) &&
								TI()CurrentUser->IsViewTitleSurname())
							{
							if (wow)
								{
								doCR();
								}

							wow = TRUE;
							doCR();

							if (*Log1.GetTitle())
								{
								mPrintf(getmsg(93), Log1.GetTitle());
								}

							mPrintf(getmsg(75), Log1.GetName());

							if (*Log1.GetSurname())
								{
								mPrintf(getmsg(93), Log1.GetSurname());
								}

							CRmPrintf(getmsg(70), ltoac(Log1.GetCallNumber()),
									dtstr);
							}
						else
							{
							CRmPrintf(getmsg(68),

									LABELSIZE +
									(strlen(Log1.GetName()) -
									strlen(deansi(Log1.GetName()))),

									Log1.GetName(), ltoac(Log1.GetCallNumber()),
									dtstr);
							}
						}
					else
						{
						doCR();

						if (TI()CurrentUser->IsAide() || Log1.IsNode())
							{
							mPrintf(getmsg(67),

									LABELSIZE +
									(strlen(Log1.GetName()) -
									strlen(deansi(Log1.GetName()))),

									Log1.GetName());
							}
						else
							{
							mPrintf(getmsg(56), Log1.GetName());
							}
						}

					/* A>ide T>wit P>erm N>etuser U>nlist S>ysop */
					if (TI()CurrentUser->IsAide())
						{
						label flags;

						if (cfg.accounting && TI()MRO.Verbose)
							{
							if (Log1.IsAccounting())
								{
								mPrintf(getmsg(53), Log1.GetCredits() / 60);
								}
							else
								{
								mPrintf(getmsg(55), getmsg(54));
								}
							}

						strcpy(flags, getmsg(1517));

						if (Log1.IsAide())			flags[0] = 'A';
						if (Log1.IsProblem())		flags[1] = 'T';
						if (Log1.IsPermanent()) 	flags[2] = 'P';
						if (Log1.IsNetUser())		flags[3] = 'N';
						if (Log1.IsUnlisted())		flags[4] = 'U';
						if (Log1.IsSysop()) 		flags[5] = 'S';
						if (!Log1.IsMail()) 		flags[6] = 'M';
						if (!Log1.IsVerified()) 	flags[7] = 'V';
						if (Log1.IsDungeoned()) 	flags[8] = 'D';

						mPrintf(spcts, flags);
						}

					if (Log1.IsNode())
						{
						mPrintf(getmsg(1243));
						}

					if (howMany)
						{
						if (!--howMany)
							{
							break;
							}
						}
					}
				}
			}

		if (TI()MRO.DotoMessage == REVERSE_READ)
			{
			TI()MRO.DotoMessage = NO_SPECIAL;
			TI()UserControl.SetOutFlag(OUTOK);

			step = -step;
			whichMess = OldAndNew;
			mPrintf(getmsg(1017), (step == 1) ? '+' : '-');
			howMany = 0;
			}
		}

	doCR();
	}
