// readinfo.cpp - temporary? I don't know.

#include "ctdl.h"
#pragma hdrstop

#include "infofile.h"
#include "room.h"
#include "filecmd.h"
#include "msg.h"
#include "log.h"
#include "events.h"

// --------------------------------------------------------------------------
// showinfo(): Display info-buffer.

static void showinfo(directoryinfo *files, CITHANDLE FileInfo)
	{
	const Bool Skinny = TI()CurrentUser->GetWidth() < 41;
	int i;
	int entries;

	assert(files != NULL);
	assert(FileInfo != NULL);

	SetOutOK();

	if (!TI()MRO.Verbose)
		{
		if (!Skinny)
			{
			CRmPrintfCR(getmsg(1051));
			}
		else
			{
			CRmPrintfCR(getmsg(1087));
			mPrintfCR(getmsg(1115));
			}
		}

	for (entries = 0; files[entries].name[0]; ++entries);

	for (i = 0;
			(i < entries && (TI()UserControl.GetOutFlag() != OUTSKIP) &&
					!TI()UserControl.CheckInput(FALSE));
			++i)
		{
		label uploader;
		char comment[65], filename[13], size[20], downtime[20], date[20];
		char ftime[20];
		fInfo *slot;

		CopyStringToBuffer(filename, files[i].name, sizeof(filename) - 1);
		getdstamp(date, files[i].date);
		gettstamp(ftime, files[i].time);
		CopyStringToBuffer(downtime, dltime(files[i].size),
				sizeof(downtime) - 1);
		strcpy(size, ltoac(files[i].size));

		if (GetInfoByName(FileInfo, filename, &slot))
			{
			CopyStringToBuffer(comment, slot->comment, sizeof(comment) - 1);
			CopyStringToBuffer(uploader, slot->uploader, LABELSIZE);
			}
		else
			{
			comment[0] = 0;
			uploader[0] = 0;
			}

		if (	// Not .RK or text matches
				(
				!TI()rf.Text || IsSubstr(deansi(comment), TI()rf.SearchText) ||
						IsSubstr(deansi(uploader), TI()rf.SearchText) ||
						IsSubstr(filename, TI()rf.SearchText)
				)
			&&
				// And not .RB or user matches
				(
				!TI()rf.User || u_match(deansi(uploader), TI()rf.SearchUser)
				)
			)
			{
			if (TI()MRO.Verbose)
				{
				CRmPrintf(getmsg(1052), Skinny ? 19 : 15, getmsg(1053),
						filename);

				if (Skinny)
					{
					doCR();
					}

				mPrintf(getmsg(742), Skinny ? 19 : 17, getmsg(1054), size);

				if (Skinny)
					{
					CRmPrintf(getmsg(1052), 19, getmsg(1), downtime);
					}
				else
					{
					mPrintf(getmsg(1119), downtime);
					}

				CRmPrintf(getmsg(1055), Skinny ? 19 : 15, getmsg(1056),
						date, ftime);

				if (Skinny)
					{
					doCR();
					}

				mPrintfCR(getmsg(742), Skinny ? 19 : 17, getmsg(1057), uploader);

				mPrintfCR(getmsg(1058), Skinny ? 19 : 15, getmsg(1059), comment);
				}
			else
				{
				mPrintf(getmsg(1060), filename, size);

				if (Skinny)
					{
					doCR();
					}
				else
					{
					TI()OC.HangingIndent = atoi(getmsg(1704));
					}

				mPrintfCR(pcts, comment);

				if (Skinny)
					{
					doCR();
					}
				}
			}

		if (TI()MRO.DotoMessage == REVERSE_READ)
			{
			TI()MRO.DotoMessage = NO_SPECIAL;
			SetOutOK();

			TI()MRO.Reverse = !TI()MRO.Reverse;

			qsort(files, entries, sizeof(*files),
					(TI()MRO.Reverse) ? (QSORT_CMP_FNP) revstrcmp :
					(QSORT_CMP_FNP) fwdstrcmp);

			mPrintfCR(getmsg(1017), (!TI()MRO.Reverse) ? '+' : '-');
			i = entries - (i + 1);
			}
		}
	}


// --------------------------------------------------------------------------
// ReadInfoFile(): Menu level .RI routine.

void ReadInfoFile(Bool ask, OldNewPick which)
	{
	label filename;
	directoryinfo *files;
	CITHANDLE FileInfo;

	if (!changedir(GetCurrentRoomDirectory()))
		{
		return;
		}

	SetDoWhat(READINFO);

	doEvent(EVT_READINFO);

	if (ask)
		{
		doCR();
		if (!getNormStr(getmsg(1073), filename, LABELSIZE, ECHO))
			{
			return;
			}
		}
	else
		{
		*filename = 0;
		doCR();
		}

	if (!*filename)
		{
		strcpy(filename, starstar);
		}
	else if (!strchr(filename, '.'))
		{
		strcat(filename, getmsg(1429));
		}
	else if (*filename == '.')
		{
		label filename2;
		CopyStringToBuffer(filename2, filename, sizeof(filename2) - 1);
		*filename = '*';
		CopyStringToBuffer(filename + 1, filename2, sizeof(filename) - 2);
		}

	if (which != OldAndNew)
		{
		if (!getNewOldFileDate())
			{
			return;
			}
		}


	TI()rf.Group = FALSE;	// You cannot .RGI

	if (ProcessReadFilter(&TI()rf, FALSE))
		{
		files = filldirectory(filename, TI()MRO.Date ? 2 : 1, which,
				TI()MRO.Reverse);

		// check for matches
		if (!files || !files[0].name[0])
			{
			CRmPrintfCR(getmsg(1050), filename);
			}
		else if (LoadFileInfoForDirectory(GetCurrentRoomDirectory(),
				&FileInfo))
			// allocate & read in fileinfo buffer
			{
			showinfo(files, FileInfo);

			DisposeFileInfo(FileInfo);
			}

		delete [] files;
		}

	changedir(cfg.homepath);
	}
