// --------------------------------------------------------------------------
// Citadel: ReadCfg.H
//
// Keywords and data for reading CONFIG.CIT.

#ifdef READCFG_CPP

#if defined (__BORLANDC__)
	#define MAS 65532u	// Maximum array size.
#endif

enum ConfigKeywordDataTypeE
	{
	CK_UCHAR,	CK_UCHARHEX,	CK_LONG,	CK_INT,
	CK_UINT,	CK_STR, 		CK_BOOLEAN, CK_SPECIAL,
	CK_PATH,
	};

enum ConfigKeywordIgnoreE
	{
	CK_ALWAYSREAD,	CK_DASHEORC,	CK_DASHC,
	};

enum ConfigKeywordCategoryE
	{
	CK_REQUIRED,	CK_MODEMSETTINGS,	CK_PATHANDFILENAME,
	CK_SYSTEMSIZE,	CK_CONSOLEOPTIONS,	CK_SECURITY,
	CK_SYSSETTINGS, CK_USERCONFIG,		CK_SYSPERSONALITY,
	CK_ACCOUNTING,

	CK_NONE
	};

struct config_keywords
	{
	long dfault;		// the default (if string, index in cfg.msg)
	long min;			// the minimum if numeric, ignored if string
	long max;			// the maximum if numeric, max len if string
	void *where;		// where it goes, unless CK_SPECIAL
	Bool optional : 1;	// if it is optional or not
	Bool allowmany : 1; // if multiple definiations are allowed or not
	uint type : 4;		// ConfigKeywordDataTypeE from above
	uint ignore : 2;	// ConfigKeywordIgnoreE from above
	uint category : 4;	// ConfigKeywordCategoryE from above
	};

#define LSZ LABELSIZE	// cool formatting

static struct config_keywords keywords[] =
	{
	// dflt min max 		where				opt 	many	type
	//		ignore			category

// NODENAME
	{0, 	0,	LSZ,		cfg.nodeTitle,		FALSE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_REQUIRED},

// NODEREGION
	{0, 	0,	LSZ,		cfg.nodeRegion, 	FALSE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_REQUIRED},

// NODECOUNTRY
	{0, 	0,	LSZ,		cfg.nodeCountry,	FALSE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_REQUIRED},

// NODEPHONE
	{0, 	0,	LSZ,		cfg.nodephone,		FALSE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_REQUIRED},

// HOMEPATH
	{0, 	0,	63, 		cfg.homepath,		FALSE,	FALSE,	CK_PATH,
			CK_DASHEORC,	CK_REQUIRED},

// MDATA
	{0, 	1,	4,			&cfg.mdata, 		FALSE,	FALSE,	CK_INT,
			CK_DASHEORC,	CK_REQUIRED},

// SYSOP
	{0, 	0,	LSZ,		cfg.sysop,			FALSE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_REQUIRED},

// ADDRESS
	{0, 	0,	8,			NULL,				FALSE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_REQUIRED},

// MODSETUP
	{251,	0,	63, 		cfg.modsetup,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// MODUNSETUP
	{0, 	0,	63, 		cfg.modunsetup, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// INIT_BAUD
	{PS_2400,0, PS_NUM - 1, &cfg.initbaud,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// DUMB_MODEM
	{0, 	0,	7,			&cfg.dumbmodem, 	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// DOWNSHIFT
	{255,	0,	LSZ,		cfg.downshift,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// HANGUP
	{258,	0,	LSZ,		cfg.hangup, 		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// MIN_BAUD
	{0, 	0,	MS_NUM - 1, &cfg.minbaud,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// DIAL_INIT
	{247,	0,	63, 		cfg.dialsetup,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// DIAL_PREF
	{248,	0,	LSZ,		cfg.dialpref,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// DIAL_RING
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// OFFHOOKSTR
	{259,	0,	LSZ,		cfg.offhookstr, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// HANGUPDELAY
	{0, 	0,	127,		&cfg.hangupdelay,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// CONNECTWAIT
	{0, 	0,	127,		&cfg.connectwait,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// BAUDPAUSE
	{0, 	0,	INT_MAX,	&cfg.baudPause, 	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// OFFHOOK
	{0, 	0,	2,			&cfg.offhook,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// CHECKCTS
	{FALSE, 0,	1,			&cfg.checkCTS,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_MODEMSETTINGS},

// APPLICPATH
	{0, 	0,	63, 		cfg.aplpath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// HELPPATH
	{0, 	0,	63, 		cfg.helppath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// HELPPATH2
	{0, 	0,	63, 		cfg.helppath2,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// ROOMPATH
	{0, 	0,	63, 		cfg.roompath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// SCRIPTPATH
	{0, 	0,	63, 		cfg.ScriptPath, 	TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// TEMPPATH
	{0, 	0,	63, 		cfg.temppath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// TRANSPATH
	{0, 	0,	63, 		cfg.transpath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// DIRPATH
	{0, 	0,	63, 		cfg.dirpath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// DLPATH
	{0, 	0,	63, 		cfg.dlpath, 		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// MSGPATH
	{0, 	0,	63, 		cfg.msgpath,		TRUE,	FALSE,	CK_PATH,
			CK_DASHEORC,	CK_PATHANDFILENAME},

// LOGEXTDIR
	{0, 	0,	63, 		cfg.logextdir,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// LEXPATH
	{0, 	0,	63, 		cfg.lexpath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// RLMPATH
	{0, 	0,	63, 		cfg.rlmpath,		TRUE,	FALSE,	CK_PATH,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// PRINTER
	{0, 	0,	63, 		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

// TRAP_FILE
	{0, 	0,	63, 		cfg.trapfile,		TRUE,	FALSE,	CK_STR,
			CK_DASHEORC,	CK_PATHANDFILENAME},

// DICTIONARY
	{260,	0,	12, 		cfg.dictionary, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_PATHANDFILENAME},

#ifdef AUXMEM
// VIRTMEM
	{279,	0,	63, 		cfg.vmemfile,		TRUE,	FALSE,	CK_STR,
			CK_DASHEORC,	CK_PATHANDFILENAME},
#else
// VIRTMEM
	{0, 	0,	63, 		NULL,				TRUE,	FALSE,	CK_STR,
			CK_DASHEORC,	CK_PATHANDFILENAME},
#endif

// MESSAGEK
	{1024,	16, LONG_MAX,	&cfg.messagek,		TRUE,	FALSE,	CK_LONG,
			CK_DASHC,		CK_SYSTEMSIZE},

#ifdef AUXMEM
// NMESSAGES
	{8000,	0,	LONG_MAX,	&cfg.nmessages, 	TRUE,	FALSE,	CK_LONG,
			CK_DASHC,		CK_SYSTEMSIZE},
#else
// NMESSAGES
	{8000,	0,	INT_MAX,	&cfg.nmessages, 	TRUE,	FALSE,	CK_INT,
			CK_DASHC,		CK_SYSTEMSIZE},
#endif

// MAXLOGTAB
	{128,2,MAS / sizeof(LTable),&cfg.MAXLOGTAB,TRUE, FALSE, CK_INT,
			CK_DASHC,		CK_SYSTEMSIZE},

// MAXROOMS
	{128,	0,	0,			&cfg.maxrooms,		TRUE,	FALSE,	CK_INT,
			CK_DASHC,		CK_SYSTEMSIZE},

// MAXHALLS
	{8, 	0,	0,			&cfg.maxhalls,		TRUE,	FALSE,	CK_INT,
			CK_DASHC,		CK_SYSTEMSIZE},

// MAXGROUPS
	{16,	0,	0,			&cfg.maxgroups, 	TRUE,	FALSE,	CK_INT,
			CK_DASHC,		CK_SYSTEMSIZE},

// MAXFILES
	{150,	0,MAS/sizeof(directoryinfo),&cfg.maxfiles,TRUE,FALSE,CK_INT,
			CK_ALWAYSREAD,	CK_SYSTEMSIZE},

// MAXBORDERS
	{10,	1,	MAS / 81,&cfg.maxborders,	TRUE,	FALSE,	CK_INT,
			CK_DASHEORC,	CK_SYSTEMSIZE},

// MAXJUMPBACK
	{26,2,MAS/sizeof(jumpback),&cfg.maxjumpback,TRUE,FALSE, CK_INT,
			CK_DASHEORC,	CK_SYSTEMSIZE},

// MAXSTAT
	{51,0,MAS/sizeof(statRecord),&cfg.statnum,TRUE, FALSE,	CK_INT,
			CK_DASHEORC,	CK_SYSTEMSIZE},

// ATTR
	{0x0F,	0,	0xFF,		&cfg.attr,			TRUE,	FALSE,	CK_UCHARHEX,
			CK_ALWAYSREAD,	CK_CONSOLEOPTIONS},

// BATTR
	{0x00,	0,	0x0F,		&cfg.battr, 		TRUE,	FALSE,	CK_UCHARHEX,
			CK_ALWAYSREAD,	CK_CONSOLEOPTIONS},

// CATTR
	{0x0E,	0,	0xFF,		&cfg.cattr, 		TRUE,	FALSE,	CK_UCHARHEX,
			CK_ALWAYSREAD,	CK_CONSOLEOPTIONS},

// UTTR
	{0x0D,	0,	0xFF,		&cfg.uttr,			TRUE,	FALSE,	CK_UCHARHEX,
			CK_ALWAYSREAD,	CK_CONSOLEOPTIONS},

// WATTR
	{0x4E,	0,	0xFF,		&cfg.wattr, 		TRUE,	FALSE,	CK_UCHARHEX,
			CK_ALWAYSREAD,	CK_CONSOLEOPTIONS},

// BIOS
	{0, 	0,	1,			&cfg.bios,			TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_CONSOLEOPTIONS},

// WYSIWYG
	{0, 	0,	2,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_CONSOLEOPTIONS},

// LOGIN
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SECURITY},

// NEWUSERAPP
	{0, 	0,	LSZ,		cfg.newuserapp, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SECURITY},

// NEWUSERQUESTIONS
	{0, 0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SECURITY},

// F6PASSWORD
	{0, 	0,	LSZ,		cfg.f6pass, 		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SECURITY},

// FULLCONLOCK
	{0, 	0,	1,			&cfg.FullConLock,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// FORCELOGIN
	{1, 	0,	1,			&cfg.forcelogin,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// ENTEROK
	{1, 	0,	1,			&cfg.unlogEnterOk,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// READOK
	{1, 	0,	1,			&cfg.unlogReadOk,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

#if defined(AUXMEM) || defined(WINCIT)
// MESSAGE_ROOM
	{5, 	-1, INT_MAX,	&cfg.MessageRoom,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},
#else
// MESSAGE_ROOM
	{5, 	-1, 255,		&cfg.MessageRoom,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},
#endif

// READLLOG
	{1, 	0,	1,			&cfg.readluser, 	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// ROOMOK
	{1, 	0,	1,			&cfg.nonAideRoomOk, TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// READALL
	{0, 	0,	2,			&cfg.readall,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// AIDEHALL
	{1, 	0,	1,			&cfg.aidehall,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// MODERATE
	{1, 	0,	1,			&cfg.moderate,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// NOPWECHO
	{48,	0,	255,		&cfg.nopwecho,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// TRAP
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SECURITY},

// SYSOPOK
	{1, 	0,	1,			&cfg.sysopOk,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// SHOWSYSOP
	{1, 	0,	1,			&cfg.showSysop, 	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// NUMROOMS
	{0, 	0,	UINT_MAX,	&cfg.numRooms,		TRUE,	FALSE,	CK_UINT,
			CK_ALWAYSREAD,	CK_SECURITY},

// READLOG
	{2, 	-1, 2,			&cfg.readLog,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// ALLOWCRYPT
	{1, 	0,	2,			&cfg.allowCrypt,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// BADPWPAUSE
	{0, 	0,	INT_MAX,	&cfg.badPwPause,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// PWDAYS
	{0, 	0,	INT_MAX,	&cfg.pwDays,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// CALLLIMIT
	{0, 	0,	INT_MAX,	&cfg.callLimit, 	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// NOCONSOLETRAP
	{0, 	0,	1,			&cfg.NoConsoleTrap, TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SECURITY},

// MAXERROR
	{25,	0,	INT_MAX,	&cfg.maxerror,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SECURITY},

// IDLE_WAIT
	{3, 	0,	INT_MAX,	&cfg.idle,			TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// OLDCOUNT
	{150,	0,	INT_MAX,	&cfg.oldcount,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// UP_DAYS
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// UP_HOURS
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// NETMAIL
	{1, 	0,	1,			&cfg.netmail,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SUBHUBS
	{1, 	0,	4,			&cfg.subhubs,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SCREENSAVE
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SAVERMSG
	{0, 	0,	LSZ,		cfg.SaverMsg,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SCROLL_BACK
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_DASHEORC,	CK_SYSSETTINGS},

// MSGCOMPRESS
	{0, 	0,	1,			&cfg.msgCompress,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// FORWARD
	{0, 	0,	1,			&cfg.forward,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// TIMEOUT
	{5, 	0,	INT_MAX,	&cfg.timeout,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// CONSOLETIMEOUT
	{-1,	0,	INT_MAX,	&cfg.consoletimeout,TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// UNLOGTIMEOUT
	{1, 	0,	INT_MAX,	&cfg.unlogtimeout,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// OUTPUTTIMEOUT
	{-1,	0,	INT_MAX,	&cfg.OutputTimeout, TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SLEEPCOUNT
	{0, 	0,	INT_MAX,	&cfg.sleepcount,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// COUNTBEEP
	{0, 	0,	1,			&cfg.countbeep, 	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// RESTORE_MODE
	{1, 	0,	1,			&cfg.restore_mode,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// DIALMACRO
	{0, 	0,	79, 		NULL,				TRUE,	TRUE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// EXPIRE
	{14,	1,	INT_MAX,	&cfg.expire,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// CIT86COUNTRY
	{0, 	0,	LSZ,		cfg.Cit86Country,	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// CIT86DOMAIN
	{0, 	0,	LSZ,		cfg.Cit86Domain,	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// DISKFREE
	{0, 	0,	LONG_MAX,	&cfg.diskfree,		TRUE,	FALSE,	CK_LONG,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// FILEBUFSIZE
	{4096,	0,	MAS,	&cfg.filebufsize,	TRUE,	FALSE,	CK_UINT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// NOBELLS
	{0, 	0,	2,			&cfg.noBells,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// NOCHAT
	{0, 	0,	1,			&cfg.noChat,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// AIDECHATHRS
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// CHATMAIL
	{0, 	0,	4,			&cfg.chatmail,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// CHATWHY
	{0, 	0,	1,			&cfg.chatwhy,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// CHATFLASH
	{0, 	0,	127,		&cfg.chatflash, 	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SPEECHON
	{0, 	0,	1,			&cfg.speechOn,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// OVREMS
	{0, 	0,	1,			&cfg.ovrEms,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// OVREXT
	{0, 	0,	1,			&cfg.ovrExt,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// CHECKSYSMAIL
	{3, 	0,	3,			&cfg.checkSysMail,	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// MEMFREE
	{102400l,0, LONG_MAX,	&cfg.memfree,		TRUE,	FALSE,	CK_LONG,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SHOWMOVED
	{1, 	0,	1,			&cfg.showmoved, 	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// ALTF3TIME
	{300,	0,	INT_MAX,	&cfg.altF3Time, 	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// ALTF3MSG
	{261,	0,	80, 		cfg.AltF3Msg,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// ALTF3TIMEOUT
	{287,	0,	80, 		cfg.AltF3Timeout,	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// FASTLOGIN
	{0, 	0,	1,			&cfg.FastLogin, 	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// SAVEJB
	{1, 	0,	1,			&cfg.SaveJB,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

#ifdef AUXMEM
// SWAPNOTE
	{0, 	0,	1,			&cfg.SwapNote,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},
#else
// SWAPNOTE
	{1, 	0,	1,			&cfg.SwapNote,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},
#endif

// FASTSCRIPTS
	{0, 	0,	1,			&cfg.FastScripts,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// NEWNODEALERT
	{1, 	0,	1,			&cfg.NewNodeAlert,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// VERBOSECONSOLE
	{1, 	0,	1,			&cfg.VerboseConsole,TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// ALTXPROMPT
	{1, 	0,	1,			&cfg.AltXPrompt,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSSETTINGS},

// NET_PREFIX
	{252,	0,	LSZ,		cfg.netPrefix,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_USERCONFIG},

// DATESTAMP
	{204,	0,	63, 		cfg.datestamp,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_USERCONFIG},

// VDATESTAMP
	{250,	0,	63, 		cfg.vdatestamp, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_USERCONFIG},

// PROMPT
	{253,	0,	63, 		cfg.prompt, 		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_USERCONFIG},

// MOREPROMPT
	{256,	0,	79, 		cfg.moreprompt, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_USERCONFIG},

// AUTOANSI
	{0, 	0,	2,			&cfg.autoansi,		TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ENTER_NAME
	{249,	0,	LSZ,		cfg.enter_name, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// CENSOR
	{0, 	0,	1,			&cfg.censor,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// TWIT_FEATURES
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// SIGNATURE
	{0, 	0,	90, 		NULL,				TRUE,	TRUE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ANONAUTHOR
	{254,	0,	LSZ,		cfg.anonauthor, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// TWITREGION
	{0, 	0,	LSZ,		cfg.twitRegion, 	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// TWITCOUNTRY
	{0, 	0,	LSZ,		cfg.twitCountry,	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// MESSAGE_NYM
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// CREDIT_NYM
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// BORDER
	{0, 	0,	80, 		NULL,				TRUE,	TRUE,	CK_SPECIAL,
			CK_DASHEORC,	CK_SYSPERSONALITY},

// POOP!
	{0, 	-1, 2,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// MCI_FIRSTNAME
	{0, 	0,	LSZ,		cfg.mci_firstname,	TRUE, FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// MCI_NAME
	{0, 	0,	LSZ,		cfg.mci_name,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// MCI_TIME
	{0, 	0,	LSZ,		cfg.mci_time,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// MCI_DATE
	{0, 	0,	LSZ,		cfg.mci_date,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// MCI_POOP
	{0, 	0,	LSZ,		cfg.mci_poop,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// SLEEPPROMPT
	{257,	0,	79, 		cfg.sleepprompt,	TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// TWIRLY
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// FUELBAR
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// SOFTVERB
	{0, 	0,	LSZ,		cfg.softverb,		TRUE,	FALSE,	CK_STR,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ECTWIRLY
	{1, 	0,	1,			&cfg.ecTwirly,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ECUSERLOG
	{1, 	0,	1,			&cfg.ecUserlog, 	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ECSIGNATURE
	{1, 	0,	1,			&cfg.ecSignature,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ECCOLOR
	{1, 	0,	1,			&cfg.ecColor,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// BORDERFREQ
	{20,	0,	65535u, 	&cfg.borderfreq,	TRUE,	FALSE,	CK_UINT,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// MUSIC
	{0, 	0,	1,			&cfg.music, 		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// TWITREV
	{1, 	0,	1,			&cfg.twitrev,		TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// PERSONALHALLOK
	{1, 	0,	1,			&cfg.PersonalHallOK,TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// CHATBELL
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ROOM_NYM
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// HALL_NYM
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// USER_NYM
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// GROUP_NYM
	{0, 	0,	LSZ,		NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// FILTER
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ADCHANCE
	{0, 	0,	100,		&cfg.ad_chance, 	TRUE,	FALSE,	CK_INT,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ADTIME
	{0, 	0,	UINT_MAX,	&cfg.ad_time,		TRUE,	FALSE,	CK_UINT,
			CK_ALWAYSREAD,	CK_SYSPERSONALITY},

// ACCOUNTING
	{0, 	0,	1,			&cfg.accounting,	TRUE,	FALSE,	CK_BOOLEAN,
			CK_ALWAYSREAD,	CK_ACCOUNTING},

// UNLOGGEDBALANCE
	{300,	0,	LONG_MAX,	&cfg.unlogbal,		TRUE,	FALSE,	CK_LONG,
			CK_ALWAYSREAD,	CK_ACCOUNTING},

// end...
	{0, 	0,	0,			NULL,				TRUE,	FALSE,	CK_SPECIAL,
			CK_ALWAYSREAD,	CK_NONE},
	};
#endif

enum ConfigCitKeywordsE
	{
// CK_REQUIRED
	K_NODENAME, 			K_NODEREGION,			K_NODECOUNTRY,
	K_NODEPHONE,			K_HOMEPATH, 			K_MDATA,
	K_SYSOP,				K_ADDRESS,

// CK_MODEMSETTINGS
	K_MODSETUP, 			K_MODUNSETUP,			K_INIT_BAUD,
	K_DUMB_MODEM,			K_DOWNSHIFT,			K_HANGUP,
	K_MIN_BAUD, 			K_DIAL_INIT,			K_DIAL_PREF,
	K_DIAL_RING,			K_OFFHOOKSTR,			K_HANGUPDELAY,
	K_CONNECTWAIT,			K_BAUDPAUSE,			K_OFFHOOK,
	K_CHECKCTS,

// CK_PATHANDFILENAME
	K_APPLICPATH,			K_HELPPATH, 			K_HELPPATH2,
	K_ROOMPATH, 			K_SCRIPTPATH,			K_TEMPPATH,
	K_TRANSPATH,			K_DIRPATH,				K_DLPATH,
	K_MSGPATH,				K_LOGEXTDIR,			K_LEXPATH,
	K_RLMPATH,				K_PRINTER,				K_TRAP_FILE,
	K_DICTIONARY,			K_VIRTMEM,

// CK_SYSTEMSIZE
	K_MESSAGEK, 			K_NMESSAGES,			K_MAXLOGTAB,
	K_MAXROOMS, 			K_MAXHALLS, 			K_MAXGROUPS,
	K_MAXFILES, 			K_MAXBORDERS,			K_MAXJUMPBACK,
	K_MAXSTAT,

// CK_CONSOLEOPTIONS
	K_ATTR, 				K_BATTR,				K_CATTR,
	K_UTTR, 				K_WATTR,				K_BIOS,
	K_WYSIWYG,

// CK_SECURITY
	K_LOGIN,				K_NEWUSERAPP,			K_NEWUSERQUESTIONS,
	K_F6PASSWORD,			K_FULLCONLOCK,			K_FORCELOGIN,
	K_ENTEROK,				K_READOK,				K_MESSAGE_ROOM,
	K_READLLOG, 			K_ROOMOK,				K_READALL,
	K_AIDEHALL, 			K_MODERATE, 			K_NOPWECHO,
	K_TRAP, 				K_SYSOPOK,				K_SHOWSYSOP,
	K_NUMROOMS, 			K_READLOG,				K_ALLOWCRYPT,
	K_BADPWPAUSE,			K_PWDAYS,				K_CALLLIMIT,
	K_NOCONSOLETRAP,		K_MAXERROR,

// CK_SYSSETTINGS
	K_IDLE_WAIT,			K_OLDCOUNT, 			K_UP_DAYS,
	K_UP_HOURS, 			K_NETMAIL,				K_SUBHUBS,
	K_SCREENSAVE,			K_SAVERMSG, 		K_SCROLL_BACK,
	K_MSGCOMPRESS,			K_FORWARD,				K_TIMEOUT,
	K_CONSOLETIMEOUT,		K_UNLOGTIMEOUT, 		K_OUTPUTTIMEOUT,
	K_SLEEPCOUNT,			K_COUNTBEEP,			K_RESTORE_MODE,
	K_DIALMACRO,			K_EXPIRE,				K_CIT86COUNTRY,
	K_CIT86DOMAIN,			K_DISKFREE, 			K_FILEBUFSIZE,
	K_NOBELLS,				K_NOCHAT,				K_AIDECHATHRS,
	K_CHATMAIL, 			K_CHATWHY,				K_CHATFLASH,
	K_SPEECHON, 			K_OVREMS,				K_OVREXT,
	K_CHECKSYSMAIL, 		K_MEMFREE,				K_SHOWMOVED,
	K_ALTF3TIME,			K_ALTF3MSG, 			K_ALTF3TIMEOUT,
	K_FASTLOGIN,			K_SAVEJB,				K_SWAPNOTE,
	K_FASTSCRIPTS,			K_NEWNODEALERT, 		K_VERBOSECONSOLE,
	K_ALTXPROMPT,

// CK_USERCONFIG
	K_NET_PREFIX,			K_DATESTAMP,			K_VDATESTAMP,
	K_PROMPT,				K_MOREPROMPT,

// CK_SYSPERSONALITY
	K_AUTOANSI, 			K_ENTER_NAME,			K_CENSOR,
	K_TWIT_FEATURES,		K_SIGNATURE,			K_ANONAUTHOR,
	K_TWITREGION,			K_TWITCOUNTRY,			K_MESSAGE_NYM,
	K_CREDIT_NYM,			K_BORDER,				K_POOP,
	K_MCI_FIRSTNAME,		K_MCI_NAME, 			K_MCI_TIME,
	K_MCI_DATE, 			K_MCI_POOP, 			K_SLEEPPROMPT,
	K_TWIRLY,				K_FUELBAR,				K_SOFTVERB,
	K_ECTWIRLY, 			K_ECUSERLOG,			K_ECSIGNATURE,
	K_ECCOLOR,				K_BORDERFREQ,			K_MUSIC,
	K_TWITREV,				K_PERSONALHALLOK,		K_CHATBELL,
	K_ROOM_NYM, 			K_HALL_NYM, 			K_USER_NYM,
	K_GROUP_NYM,			K_FILTER,				K_ADCHANCE,
	K_ADTIME,

// CK_ACCOUNTING
	K_ACCOUNTING,			K_UNLOGGEDBALANCE,

	K_NWORDS,
	};

enum ConfigCitDialMacroKeywordsE
	{
	DM_F1,				DM_F2,				DM_F3,
	DM_F4,				DM_F5,				DM_F6,
	DM_F7,				DM_F8,				DM_F9,
	DM_F10, 			DM_F11, 			DM_F12,
	DM_ALT_F1,			DM_ALT_F2,			DM_ALT_F3,
	DM_ALT_F4,			DM_ALT_F5,			DM_ALT_F6,
	DM_ALT_F7,			DM_ALT_F8,			DM_ALT_F9,
	DM_ALT_F10, 		DM_ALT_F11, 		DM_ALT_F12,
	DM_SFT_F1,			DM_SFT_F2,			DM_SFT_F3,
	DM_SFT_F4,			DM_SFT_F5,			DM_SFT_F6,
	DM_SFT_F7,			DM_SFT_F8,			DM_SFT_F9,
	DM_SFT_F10, 		DM_SFT_F11, 		DM_SFT_F12,
	DM_CTL_F1,			DM_CTL_F2,			DM_CTL_F3,
	DM_CTL_F4,			DM_CTL_F5,			DM_CTL_F6,
	DM_CTL_F7,			DM_CTL_F8,			DM_CTL_F9,
	DM_CTL_F10, 		DM_CTL_F11, 		DM_CTL_F12,

	DM_NUMKEYS
	};

enum ConfigCitLoginKeywordsE
	{
	L_CLOSED,			L_VERIFIED, 		L_SYSOP_MESSAGE,
	L_NEW_ACCOUNTS,

	L_NUMLOGIN
	};

enum ConfigCitTwitKeywordsE
	{
	TWIT_MSG_NYMS,		TWIT_BORDER_LINES,	TWIT_TITLES,
	TWIT_NET_TITLES,	TWIT_SURNAMES,		TWIT_NET_SURNAMES,
	TWIT_ENTER_TITLES,	TWIT_COLORS,		TWIT_MCI,

	TWIT_NUM
	};
