// --------------------------------------------------------------------------
// Citadel: Proto.H
//
// Many of Citadel's function prototypes.

#if defined(__BORLANDC__) && !defined(WINCIT)
#define VerifyHeap() assert(heapcheck() > 0)
#else
#define VerifyHeap()
#endif


// ANDY.CPP
void cdecl Andy(const char *Format, const char *Codes, ...);


// APLFILE.CPP
void writeAplFile(void);
void readAplFile(void);


// CARRIER.CPP
void carrdetect(void);
void carrloss(void);
Bool getModStr(char *str, uint len);
int smartbaud(void);
Bool carrier(void);


// CHAT.CPP
void chat(void);
Bool ringSysop(Bool ring, Bool internalChat);


// CONOVL.CPP
void fkey(uint inkey);
void outConRawBs(void);
void cdecl cPrintf(const char *fmt, ...);


// CONSOLE.CPP
void doccr(void);
Bool KBReady(void);
int ciChar(void);
void outCon(char c);
Bool kb_hit(void);
Bool cdecl special_pressed(void);


// CONOVL.CPP
Bool IsConsoleLocked(Bool CheckingF6 = FALSE);


// CONSYSOP.CPP
void doConsoleSysop(void);


// CRON.CPP
void cron_commands(void);
void did_net(const char *callnode);


// CRYPT.CPP
Bool decrypt(char *text, const char *key);
Bool encrypt(char *text, const char *key);


// DISCARD.CPP
long checkDataVer(void);
discardable *readData(int Entry, int StartSubEntry = 0, int EndSubEntry = INT_MAX);
void discardData(discardable *data);


// DO.CPP
void doFileQueue(void);
void doDownload(Bool ex);
void doUpload(Bool ex);
void doEnter(Bool moreYet, char first);
void doList(Bool moreYet, char first);
Bool takeAutoUp(char c);


// DOAIDE.CPP
void doAide(Bool moreYet, char first);


// DOINV.CPP
void doInvite(void);


// DOMISC.CPP
Bool doChat(Bool ring, Bool doInternal);
void doVolkswagen(Bool moreYet, const char *CmdKeys);
void doHelp(Bool expand, const char *HelpFile);
void doIntro(void);
void doLogout(Bool expand, char first);
void doXpert(void);
void doverbose(void);
void doSmallChat(void);
void doY(Bool backwards);
Bool doPoop(char c);
void doWow(Bool dot);
void doBorder(void);
void doFingerEdit(void);
void doFingerList(void);
void doFingerUser(void);
void doFinger(void);
void doReadBull(Bool FromRoomPrompt);


// DOREAD.CPP
void doRead(Bool moreYet, char first);
Bool ProcessReadFilter(ReadFilter *rf, Bool AllowMetaGroups);


// DORMHALL.CPP
void exclude(void);
void doGoto(Bool expand, char skip);
void doGotoMail(void);
void doKnown(Bool moreYet, char first);
void doNext(void);
void doPrevious(void);
void doNextHall(void);
void doPreviousHall(void);
void doPersonal(void);


// DOSYSOP.CPP
void doSysop(void);
void globalverify(void);


// DOWN.CPP
void cdecl crashout(const char *message, ...);
void exitcitadel(void);


// CTDL.CPP
void doAd(Bool force);
void CheckTimeOnSystem(void);


// CWINDOWS.CPP
void CitWindowsTTYUpdate(int sline, int eline);
void CitWindowsProcessKbd(void);
void CitWindowsProcessMouse(void);


// EDIT.CPP
void putheader(Bool first, Message *Msg);
Bool getText(Message *Msg, char *Buffer);
void GetFileMessage(FILE *fl, char *str, int mlen);


// EXTMSG.CPP
Bool read_messages(void);
#define getmsg(nmbr) msgsI[(uint)(nmbr)]

Bool read_net_messages(void);
#define getnetmsg(nmbr) netmsgsI[(uint)(nmbr)]
void dump_net_messages(void);

Bool read_sys_messages(void);
#define getsysmsg(nmbr) sysmsgsI[(uint)(nmbr)]
void dump_sys_messages(void);

Bool read_cfg_messages(void);
#define getcfgmsg(nmbr) cfgmsgsI[(nmbr)]
void dump_cfg_messages(void);

Bool read_ec_messages(void);
#define getecmsg(nmbr) ecmsgsI[(uint)(nmbr)]
void dump_ec_messages(void);

Bool read_fs_messages(void);
#define getfsmsg(nmbr) fsmsgsI[(uint)(nmbr)]
void dump_fs_messages(void);

Bool read_cw_messages(void);
#define getcwmsg(nmbr) cwmsgsI[(uint)(nmbr)]
void dump_cw_messages(void);

Bool read_zm_messages(void);
#define getzmmsg(nmbr) zmmsgsI[(uint)(nmbr)]
void dump_zm_messages(void);

Bool read_db_messages(void);
#define getdbmsg(nmbr) dbmsgsI[(uint)(nmbr)]
void dump_db_messages(void);

void PurgeAllSubMessages(void);
void ReloadAllSubMessages(void);


// FILEBUF.CPP
void bufferedSeek(BFILE *file, long where);
long bufferedTell(BFILE *file);
int bufferedGetc(BFILE *file);
int bufferedEof(BFILE *file);
void bufferedClearerr(BFILE *file);
BFILE *bufferedOpenExist(const char *filename);
BFILE *bufferedOpen(const char *filename);
BFILE *bufferedCreate(const char *filename);
void bufferedClose(BFILE *file);
void bufferedFlush(BFILE *file, Bool DumpBuffer = FALSE);
int bufferedPutc(int c, BFILE *file);
size_t bufferedWrite(void *buf, size_t len, BFILE *file);
#ifdef WINCIT
void bufferedWinCloseTmp(BFILE *file);
void bufferedWinReOpen(BFILE *file);
#else
#define bufferedWinCloseTmp(f)
#define bufferedWinReOpen(f)
#endif


// FILECIT.CPP
Bool citOpen(const char *filename, CitOpenCodes mode, citFILE *cf);
#ifdef WINCIT
int citRead(void *where, int len, int num, citFILE f);
int citWrite(void *where, int len, int num, citFILE f);
int citClose(citFILE *f);
long citSeek(citFILE f, long sw, int whence);
void citWinCloseTmp(citFILE *f);
void citWinReOpen(citFILE *f);
long citTell(citFILE f);
#else
#define citRead fread
#define citWrite fwrite
#define citClose(f) fclose(*f)
#define citSeek fseek
#define citWinCloseTmp(f)
#define citWinReOpen(f)
#define citTell ftell
#endif


// FILES.CPP
int cdecl fwdstrcmp(void *a, void *b);
int cdecl revstrcmp(void *a, void *b);
Bool haveRespProt(void);
const char *nameonly(const char *full);
int ambig(const char *filename);
int ambigUnlink(const char *filename, Bool change);
long bytesfree(void);
Bool IsFilenameLegal(const char *filename, Bool AllowSpace);
directoryinfo *filldirectory(const char *filename, int sort, OldNewPick which, Bool rev);
const char *dltime(long size);
void entrycopy(int element);
void entrymake(struct find_t *file_buf);
uchar getattr(const char *filename);
void hide(const char *filename);
void setattr(const char *filename, uchar attr);
Bool copyfile(const char *source, const char *dest);


// FORMAT.CPP
void normalizeString(char *s);
int strpos(char ch, const char *str);
int substr(const char *str1, const char *str2, Bool StripAnsi);
inline Bool IsSubstr(const char *s1, const char *s2)
	{
	return (substr(s1, s2, TRUE) != CERROR);
	}

const char *deansi(const char *str);
const char *special_deansi(const char *str, const char *strip);
int deansi_str_cmpi(const char *string1, const char *string2);
int deansi_str_cmp(const char *string1, const char *string2);
void stripansi(char *string);
int hasansi(const char *string);
void strip(char *str, char ch);
const char *strip_punct(const char *str);
void strip_special(char *str);


// FMTOVL.CPP
void cdecl sformat(char *str, const char *fmt, const char *val, ...);
int parse_it(char *words[], char input[]);
Bool u_match(register const char *s, register const char *p);
void stripdoubleasterisk(char *str);
char *MakeItUpper(const char *Source, char *Dest);
char *MakeItLower(const char *Source, char *Dest);


// GRPEDIT.CPP
void groupfunc(const char *grpName, const char *userName, Bool addToGroup);
void globalgroup(const char *theGroup, Bool addAll);
void globaluser(void);
int killgroup(const char *gname);
void listgroup(void);
Bool newgroup(const char *name, const char *desc, Bool lock, Bool hide, Bool autoadd);
Bool renamegroup(void);
void OperatorSpecificMembership(void);

int TestGroupExists(const char *TestString);
int TestGroupOrMetaExists(const char *TestString);
void ShowGroup(g_slot Group);
void ShowGroupWithMeta(g_slot Group);
Bool GroupTester(g_slot GroupSlot);
Bool GroupNameTester(g_slot GroupSlot);
Bool GroupWithMetaTester(g_slot GroupSlot);


// HELP.CPP
int dumpf(const char *filename, Bool format, int special);
int dumpfc(const char *filename, Bool format);
void tutorial(const char *filename, const Bool *ShownInternal = NULL);
void hello(void);
void goodbye(void);
void nochat(Bool reset);
void cometochat(void);
int BLBRotate(const char *base, const char *ext, int *reg, int *ansi,
		Bool special, BlurbFiles BlbNum);
void usage(void);
void initMenus(void);
long getMnuOff(int reqMnu, char *menuFile);
void showMenu(MenuNames reqMnu);
void ShowHelpMenu(void);
void youAreHere(void);
void dispBlb(BlurbFiles theBlb);
void dispHlp(HelpFiles theHlp);


// HUF.CPP
Bool compress(char *str);
void decompress(uchar *str);
void freeHufTree(void);
void CheckHufPointer(const void *Check);


// HUFBIT.CPP
extern "C" uchar cdecl decode(const uchar *str);


// INPOVL.CPP
long GetNumberWithBlurb(const char *prompt, long min, long max, long dfault,
		BlurbFiles Blb);
Bool GetStringWithBlurb(const char *prompt, char *buf, int len,
		const char *dfault, BlurbFiles Blb);
Bool getNormStr(const char *prompt, char *s, int size, Bool doEcho);
long getNumber(const char *prompt, long bottom, long top, long dfaultnum, Bool QuestIsSpecial, Bool *QuestionEntered);
Bool getString(const char *prompt, char *buf, int lim, Bool QuestIsSpecial, Bool doEcho, const char *dfault);
int cdecl GetOneKey(const char *prompt, const char *keys, const char dfault, BlurbFiles HelpBlurb, ...);
int getYesNo(const char *prompt, int dfault);
void getFmtString(const char *prompt, char *buf, Bool premature, Bool inclPrompt);


// INPUT.CPP
int BBSCharReady(void);
void setio(void);
int iCharNE(void);
int iChar(void);
Bool IsKeyFromUserReady(void);


// LLSUP.CPP
void disposeLL(void **list);
void *addLL(void **list, uint nodeSize);
void *getNextLL(const void *list);
void *getLLNum(void *list, ulong n);
void deleteLLNode(void **list, ulong n);
void *insertLLNode(void **list, ulong n, int nodeSize);
ulong getLLCount(const void *list);


// LOG2.CPP
void purgeuserlog(void);
Bool killuser(const char *name);


// LOG3.CPP
void newPW(Bool check);
void DoEnterConfiguration(Bool newUser);
void DoUserlogEdit(LogEntry *EditLog, l_index Index);


// LOGIN.CPP
void login(void);
void setlbvisit(void);
void slideLTab(int slot);
l_slot FindPwInHashInTable(const char *in, const char *pw);
void doLogin(Bool moreYet);


// LOGINNEW.CPP
void loginNew(char *initials, char *password);


// LOGOUT.CPP
void terminate(Bool discon);
void setdefaultconfig(Bool keepAnsi);


// MAKETAB.CPP
void RoomTabBld(void);


// MISC.CPP
void compactMemory(int Level = 0);
Bool HaveConnectionToUser(void);
Bool filexists(const char *filename);
uint hash(const char *str);
Bool changedir(const char *path);
const char *ltoac(long num);

#define int_LO(i)			((char) ((i) & 0xff))
#define int_HI(i)			((char) ((i) >> 8))
#define int_JOIN(cl, ch)	(((int) (ch) << 8) | ((int) (cl)))

#define long_LO(l)			((int) ((l) & 0xffff))
#define long_HI(l)			((int) ((l) >> 16))
#define long_JOIN(il, ih)	((long)(((long) ((uint) ih)) << 16) | \
									((long) ((uint) il)))

void getfpath(char *path);
int rlmEvent(int type, long param1, long param2);
void ShowHelpMessage(int msgNumber);
void ClearMsgReadOptions(MsgReadOptions *MROaddr);

int max(int a, int b);
long max(long a, long b);
int min(int a, int b);
long min(long a, long b);
Bool isNumeric(const char *str);
void SetDoWhat(dowhattype NewDoWhat);
FILE *CitFopen(const char *FileName, const char *Mode);
int CitUnlink(const char *Path);
int CitRename(const char *Orig, const char *Dest);
char *CitStrdup(const char *Orig);
DaysE EvaluateDay(const char *Str);
MonthsE EvaluateMonth(const char *Str);
void CitIsIdle(void);
void cdecl noPrintf(const char *, ...);
void noDoCR(void);


// MODEM.CPP
void domcr(void);
void OutStringWithPacing(const char *String, int Pace);
void outstring(const char *string);
void Hangup(void);


// OUTFILE.CPP
void dFormat(const char *string, FILE *file);


// OUTPUT.CPP
void mFormat(const char *string);
void doBS(void);
void doCR(void);
void doBS(int Count);
void doCR(int Count);
void echocharacter(const char c);
void oChar(register char c);
void updcrtpos(const char c);
void cdecl mPrintf(const char *fmt, ...);
void cdecl CRmPrintf(const char *fmt, ...);
void cdecl mPrintfCR(const char *fmt, ...);
void cdecl CRmPrintfCR(const char *fmt, ...);
int getWord(uchar *dest, register const uchar *source, int offset, int lim);
void putWord(const uchar *st);
void cdecl DebugOut(const char *fmt, ...);
void ResetOutputControl(void);


// OUTOVL.CPP
Bool outSpeech(Bool out, const char *st);
void dospCR(void);
void cdecl rmPrintf(const char *fmt, ...);
void prtList(const char *item);
void cdecl CRCRmPrintfCR(const char *fmt, ...);


// PORT.CPP
void Initport(void);
void pHangup(void);
void dumbmodemHangup(void);


// RLM.CPP
int callRLM(RLMlist *theRLM, uint funcOff, long param1, long param2);
Bool initRLM(const char *rlmFileName);
void purgeAllRLMs(void);


// RLMASM.ASM
extern "C" void cdecl citEntryPoint(void);


// in some room file, though it shouldn't be
Bool inExternal(const char *key, const char *str);


// SCRIPT.CPP
Bool runScript(const char *what, void (*InitScript)(ScriptInfoS *si) = NULL);
int evaluateInt(const char *what);
uint evaluateUint(const char *what);
long evaluateLong(const char *what);
ulong evaluateUlong(const char *what);
Bool evaluateBool(const char *what);
const char *evaluateString(const char *what);


// STRFTIME.CPP
void strftime(char *outstr, int maxsize, const char *formatstr, long tnow);


// TIMEDATE.CPP
time_t CitadelTime(time_t *tloc);
int dayofweek(void);
const char *diffstamp(time_t oldtime);
void getdstamp(char *buffer, uint stamp);
void gettstamp(char *buffer, uint stamp);
int hour(void);
void pause(register int ptime);
void netpause(register int ptime);
void twirlypause(register int ptime);
Bool CheckIdleUserTimeout(Bool InOutput);


// TIMEOVL.CPP
time_t net69_time(const char *datestring);
char *net69_gateway_time(time_t time, char *datestring);
void changeDate(void);
void set_date(void);
void gdate(char *line, datestruct *filldate);	// both args mauled
void gtime(char *line, timestruct *filltime);	// both args mauled


// TRAP.CPP
void trap(const char *string, int what);
void SaveAideMess(const char *group = NULL, r_slot RoomNumber = AIDEROOM);
void cdecl amPrintf(const char *fmt, ...);
void amZap(void);
statRecord *addStatus(void);
void addStatusText(const char *string, time_t when);


// USEROUT.CPP
void GiveRoomPrompt(void);
void SetOutOK(void);

// WINDOW.CPP
void setborder(int battr);
void ClearToEndOfLine(void);
void cls(int whatToDo);
void scroll(int row, uchar howmany, uchar attr);
void scroll_bios(int row, uchar howmany, uchar attr);
void cdecl biosstring(uint row, const char *str, uchar attr, Bool phys);
Bool cdecl bioschar(char ch, uchar attr, Bool phys);
void ansi(char c);
Bool save_screen(void);
void restore_screen(void);
void setscreen(void);
void getScreenSize(uchar *Cols, uchar *Rows);
void readcursorsize(uchar *cursorstart, uchar *cursorend);
void outPhys(Bool phys);
void position(int row, int column);
void readpos(int *row, int *column);


#ifndef WINCIT
// WIND.ASM
extern "C"
	{
	void cdecl cls_fast(char attr);
	void cdecl physPosition(uchar row, uchar column);
	void cdecl clearline(uchar row, uchar attr);
	void cdecl physReadpos(const uchar *row, const uchar *column);
	void cdecl fastcpy(void *dest, void *src, uint len);
	void cdecl directstring(uint row, const char *str, uchar attr, Bool phys);
	Bool cdecl directchar(char ch, uchar attr, Bool phys);
	void cdecl fastsetw(void *dest, uint what, uint len);
	void cdecl statDisp(int row, int col, int attr, const char *str);
	int cdecl gmode(void);
	void cdecl cursoff(void);
	void cdecl curson(void);
	void cdecl curshalf(void);
	void interrupt critical_error(...);
	};
#endif


// XMODEM.CPP
Bool xsend(const char *filename, int mode);
Bool xreceive(const char *filename, int mode);


// ZIPFILE.CPP
void readArchive(OldNewPick which);

#ifdef WINCIT
// OUTWIN.CPP
void output(int Column, int Row, LPSTR str);
void updateText(RECT r, HDC hdc);
void DrawBitmap(HDC hdc, HBITMAP hBitmap, short xStart, short yStart);
void resetTextWindow(int attr, Bool resize);

curson(void);
cursoff(void);




void sound(int);
void delay(int);
void nosound(void);


void letWindowsMultitask(void);


// MISC2.CPP
long FAR PASCAL logoWndProc(HWND hwnd, WORD message, WORD wParam, LONG lParam);


// ERROR.CPP
long FAR PASCAL errorWndProc(HWND hwnd, WORD message, WORD wParam, LONG lParam);
long FAR PASCAL trapWndProc(HWND hwnd, WORD message, WORD wParam, LONG lParam);
long FAR PASCAL msgWndProc(HWND hwnd, WORD message, WORD wParam, LONG lParam);
void cdecl errorDisp(const char *fmt, ...);
void cdecl trapDisp(const char *fmt, ...);
void cdecl msgDisp(const char *fmt, ...);
void cdecl msgCaption(const char *fmt, ...);


#define winRet(wow) 	return (wow)
#define winRetN 		return
#define winFclosef(wow) fclose(wow)


#define cPrintfDOS(wow)
#else
#define errorDisp cPrintf
#define msgDisp cPrintf
#define msgCaption cPrintf
#define winRet(wow)
#define winRetN
#define winFclosef(wow)
#define cPrintfDOS(wow) cPrintf(wow)
#define letWindowsMultitask()
#endif


// wowness. some windows/dos memory stuff.
#ifdef WINCIT
#define getMemG(size, num) (void *) MAKELONG(0, \
			GlobalAlloc(GPTR, ((long) size) * ((long) num)))
#define freeMemG(wow) GlobalFree((GLOBALHANDLE) LOWORD((long) wow))
#else
#define getMemG(size, num) _fcalloc(size, num)
#define freeMemG(wow) _ffree(wow)
#endif
