/* -------------------------------------------------------------------- */
/*	PORT.CPP					Citadel 						>>IBM<< */
/* -------------------------------------------------------------------- */
/*	This module should contain all the code specific to the modem		*/
/*	hardware. This is done in an attempt to make the code more portable */
/*																		*/
/*	Note: under the MS-DOS implementation there is also an ASM file 	*/
/*	contains some of the very low-level io rutines. 					*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	pHangup()		breaks modem connection 							*/
/*	Initport()		sets up modem port and modem						*/
/* -------------------------------------------------------------------- */

#ifndef WINCIT
/* -------------------------------------------------------------------- */
/*	Initport()		sets up the modem port and modem. No return value	*/
/* -------------------------------------------------------------------- */
void Initport(void)
	{
	Hangup();

	pause(50);
	TI()SerialPort.Enable();

	TI()SerialPort.SetSpeed(cfg.initbaud);

	outstring(cfg.modsetup);
	outstring(br);

	pause(100);

	StatusLine.Update();
	}

/* -------------------------------------------------------------------- */
/*	pHangup()		breaks the modem connection 						*/
/* -------------------------------------------------------------------- */
void pHangup(void)
	{
	SerialPort.FlushOutput();
	SerialPort.DropDtr();
	SerialPort.RaiseDtr();

	pause(50);

	if (cfg.dumbmodem == 6 || cfg.dumbmodem == 7)
		{
		outstring(cfg.hangup);
		outstring(br);

		if (cfg.hangupdelay)
			{
			pause(cfg.hangupdelay * 100);
			}
		else
			{
			pause(50);
			}
		}
	}

/* -------------------------------------------------------------------- */
/*	dumbmodemHangup()	breaks the modem connection 					*/
/* -------------------------------------------------------------------- */
void dumbmodemHangup(void)
	{
	SerialPort.DropDtr();
	SerialPort.RaiseDtr();
	pause(50);
	}

/* -------------------------------------------------------------------- */
/*	TI()SerialPort.DropDtr() turns dtr off								*/
/* -------------------------------------------------------------------- */
void SerialPortC::DropDtr(void)
	{
	assert(dtrrs);

	Disabled = TRUE;

	(*dtrrs)(0);

	if (cfg.hangupdelay && !(cfg.dumbmodem == 6 || cfg.dumbmodem == 7))
		{
		pause (cfg.hangupdelay * 100);
		}
	else
		{
		pause (50);
		}
	}

/* -------------------------------------------------------------------- */
/*	baud() sets up serial baud rate 0=300 1=1200 2=2400 3=4800 4=9600	*/
/*									5=19.2K 6=38.4K 7=57.6K 8=115.2K	*/
/*		and initializes port for general bbs usage	N81 				*/
/* -------------------------------------------------------------------- */
void SerialPortC::SetSpeed(PortSpeedE NewSpeed)
	{
	Speed = NewSpeed;

	int rs_Baud;

	switch (NewSpeed)
		{
		default: assert(FALSE);

		case PS_300:	{ rs_Baud = 2; break; }
		case PS_600:	{ rs_Baud = 3; break; }
		case PS_1200:	{ rs_Baud = 4; break; }
		case PS_2400:	{ rs_Baud = 5; break; }
		case PS_4800:	{ rs_Baud = 6; break; }
		case PS_9600:	{ rs_Baud = 7; break; }
		case PS_19200:	{ rs_Baud = 8; break; }
		case PS_38400:	{ rs_Baud = 9; break; }
		case PS_57600:	{ rs_Baud = 10; break; }
		case PS_115200: { rs_Baud = 11; break; }
		}

	/* disable interrupts for baud change */
	if (Initialized)
		{
		Deinit();
		}

	assert(initrs);
	(*initrs)((cfg.mdata - 1), rs_Baud, 0, 0, 3, cfg.checkCTS);

	Initialized = TRUE;

	if (cfg.baudPause)
		{
		pause(cfg.baudPause);
		}
	}

/* -------------------------------------------------------------------- */
/*	TI()SerialPort::Output() stuffs a char out the modem port			*/
/* -------------------------------------------------------------------- */
void SerialPortC::Output(uchar Out)
	{
	if ((!TI()OC.Modem && !TI()callout) || TI()OC.inANSI)
		{
		return;
		}

	assert(putrs);
	(*putrs)(Out);
	Transmitted++;

	SetDirty();

	BeenSent[SentEnd] = Out;
	SentEnd = (SentEnd + 1) % KEYBUFSIZE;
	if (SentEnd == SentStart)
		{
		SentStart = (SentStart + 1) % KEYBUFSIZE;
		}
	else
		{
		NumBeenSent++;
		}
	}

#else

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
/////////////////////////////windows stuff////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
/////////////////////////this needs quite a bit of work///////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

static DCB dcb;
static int winComPoo;

/* -------------------------------------------------------------------- */
/*	ringdetect() returns true if the High Speed line is up				*/
/*				 if there is no High Speed line avalible to your		*/
/*				 hardware it should return the ring indicator line		*/
/*				 In this way you can make a custom cable and use it 	*/
/*				 that way												*/
/* -------------------------------------------------------------------- */
int ringdetect(void)
	{
	return (FALSE);
	}

/* -------------------------------------------------------------------- */
/*	TI()SerialPort.IsInputReady() Ostensibly checks to see if input from modem ready	*/
/* -------------------------------------------------------------------- */
int TI()SerialPort.IsInputReady(void)
	{
	return (FALSE);
	}

/* -------------------------------------------------------------------- */
/*	Initport()	sets up the modem port and modem. No return value		*/
/* -------------------------------------------------------------------- */
void Initport(void)
	{
	Hangup();

	pause(50);
	TI()SerialPort.Enable();

	TI()SerialPort.SetSpeed(cfg.initbaud);

	outstring(cfg.modsetup);
	outstring(br);

	pause(10);

	StatusLine.Update();
	}

/* -------------------------------------------------------------------- */
/*	pHangup() breaks the modem connection								*/
/* -------------------------------------------------------------------- */
void pHangup(void)
	{
//	(*flushoutrs)();
	TI()SerialPort.DropDtr();
//	(*dtrrs)(1);
//	pause(50);

	if (cfg.dumbmodem == 6 || cfg.dumbmodem == 7)
		{
		outstring(cfg.hangup);
		outstring(br);
		}

	pause(50);
	}

/* -------------------------------------------------------------------- */
/*	dumbmodemHangup() breaks the modem connection						*/
/* -------------------------------------------------------------------- */
void dumbmodemHangup(void)
	{
	TI()SerialPort.DropDtr();
//	(*dtrrs)(1);
	pause(50);
	}

/* -------------------------------------------------------------------- */
/*	SerialPort.HaveCarrier() returns nonzero on valid carrier, else zero*/
/* -------------------------------------------------------------------- */
int SerialPort.HaveCarrier(void)
	{
	return (FALSE);
	}

/* -------------------------------------------------------------------- */
/*	TI()SerialPort.Input() is bottom-level modem-input routine			*/
/* -------------------------------------------------------------------- */
int TI()SerialPort.Input(void)
	{
	static char wow;
	wow = 0;

	TI()received++;

	ReadComm(dcb.Id, &wow, 1);

	return (0);
	}

/* -------------------------------------------------------------------- */
/*	TI()SerialPort.DropDtr() turns dtr off								*/
/* -------------------------------------------------------------------- */
void TI()SerialPort.DropDtr(void)
	{
	TI()disabled = TRUE;

//	(*dtrrs)(0);

	if (cfg.hangupdelay)
		{
		pause (cfg.hangupdelay * 100);
		}
	else
		{
		pause (50);
		}
	}

/* -------------------------------------------------------------------- */
/*		baud() sets up serial baud rate 0=300; 1=1200; 2=2400; 3=4800	*/
/*										4=9600 5=19.2; 6=38.4			*/
/*										7=57.6; 8 115.2 				*/
/*		and initializes port for general bbs usage	 N81				*/
/* -------------------------------------------------------------------- */
void baud(int baudrate)
	{
	TI()speed = (char) baudrate;

	if (TI()speed == 1) 		dcb.BaudRate = 1200;
	else if (TI()speed == 2)	dcb.BaudRate = 2400;
	else if (TI()speed == 3)	dcb.BaudRate = 4800;
	else if (TI()speed == 4)	dcb.BaudRate = 9600;
	else if (TI()speed == 5)	dcb.BaudRate = 19200;
	else if (TI()speed == 6)	dcb.BaudRate = 38400u;
	else if (TI()speed == 7)	dcb.BaudRate = 57800u;
	else if (TI()speed == 8)	dcb.BaudRate = 57800u;
	else						dcb.BaudRate = 300;

	/* disable interrupts for baud change */
	if (interrupts_enabled)
		{
		portExit();
		}

	SetCommState(&dcb);
//	(*initrs)((cfg.mdata - 1), baudrate, 0, 0, 3, cfg.checkCTS);
	interrupts_enabled = TRUE;
	}

/* -------------------------------------------------------------------- */
/*	TI()SerialPort.Output() stuffs a char out the modem port			*/
/* -------------------------------------------------------------------- */
void TI()SerialPort.Output(uchar ch)
	{
	if ((!TI()OC.Modem && !TI()callout) || TI()OC.inANSI)
		{
		return;
		}

	WriteComm(dcb.Id, &ch, 1);

	++TI()transmitted;	/* keep track of how many chars sent */
	}

/* -------------------------------------------------------------------- */
/*	portInit() sets up the interupt driven I/O package					*/
/* -------------------------------------------------------------------- */
void portInit(void)
	{
	static char comName[5] = "COMx";

	comName[3] = cfg.mdata + '0';

	dcb.Id = OpenComm(comName, 2048, 256);

	if (dcb.Id >= 0)
		{
		interrupts_enabled = TRUE;

		if (TI()speed == 1) 		dcb.BaudRate = 1200;
		else if (TI()speed == 2)	dcb.BaudRate = 2400;
		else if (TI()speed == 3)	dcb.BaudRate = 4800;
		else if (TI()speed == 4)	dcb.BaudRate = 9600;
		else if (TI()speed == 5)	dcb.BaudRate = 19200;
		else if (TI()speed == 6)	dcb.BaudRate = 38400u;
		else if (TI()speed == 7)	dcb.BaudRate = 57800u;
		else if (TI()speed == 8)	dcb.BaudRate = 57800u;
		else						dcb.BaudRate = 300;

		dcb.ByteSize = 8;
		dcb.Parity = NOPARITY;
		dcb.StopBits = ONESTOPBIT;
		dcb.fBinary = TRUE;
		dcb.fRtsDisable = FALSE;
		dcb.fParity = FALSE;
		dcb.fOutxCtsFlow = cfg.checkCTS;
		dcb.fOutxDsrFlow = FALSE;
		dcb.fDtrDisable = FALSE;
		dcb.fOutX = FALSE;
		dcb.fInX = FALSE;
		dcb.fPeChar = FALSE;
		dcb.fNull = FALSE;
		dcb.fChEvt = FALSE;
		dcb.fDtrflow = FALSE;
		dcb.fRtsflow = FALSE;

		SetCommState(&dcb);
		}
	}

/* -------------------------------------------------------------------- */
/*	portExit() removes the interupt driven I/O package					*/
/* -------------------------------------------------------------------- */
void portExit(void)
	{
	interrupts_enabled = FALSE;
	CloseComm(dcb.Id);
	}
#endif
