// --------------------------------------------------------------------------
// Citadel: OutOvl.CPP
//
// Overlayed output functions.

#include "ctdl.h"
#pragma hdrstop

#include "log.h"
#include "msg.h"
#include "outfilt.h"
#include "term.h"


// --------------------------------------------------------------------------
// Contents
//
// rmPrintf()			sends formatted output to modem & console
// prtList()			Print a list of rooms, etc.
// dospCR() 			does CR for entry of initials & pw
// outSpeech()			wow.


// --------------------------------------------------------------------------
// rmPrintf(): Sends formatted output to modem & console.

void cdecl rmPrintf(const char *fmt, ... )
	{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(TI()OC.prtf_buff, fmt, ap);
	va_end(ap);

	if (TI()MRO.DotoMessage == REVERSE_READ)
		{
		TI()MRO.DotoMessage = NO_SPECIAL;
		TI()UserControl.SetOutFlag(OUTOK);

		if (cfg.twitrev)
			{
			char buf[80];

			TI()MRO.Reverse = !TI()MRO.Reverse;
			sprintf(buf, getmsg(1017), TI()MRO.Reverse ? '-' : '+');
			mFormat(buf);
			doCR();
			}
		}

	if (cfg.twitrev && TI()MRO.Reverse)
		{
		stripansi(TI()OC.prtf_buff);
		strrev(TI()OC.prtf_buff);
		}

	mFormat(TI()OC.prtf_buff);
	ResetOutputControl();
	}


// --------------------------------------------------------------------------
// prtList(): Print a list of rooms, etc.

void prtList(const char *item)
	{
	if (item == LIST_START || item == LIST_END)
		{
		if (item == LIST_END)
			{
			if (!TI()PLlisted)
				{
				rmPrintf(getmsg(877));
				}

			rmPrintf(getmsg(795));
			doCR();

			TI()UserControl.ResetOutParagraph();
			}

		TI()PLlisted = FALSE;
		TI()PLfirst = TRUE;
		}
	else
		{
		TI()PLlisted = TRUE;

		if (TI()PLfirst)
			{
			TI()PLfirst = FALSE;
			}
		else
			{
			rmPrintf(getmsg(796));
			}

		if (strlen(item) + 2 + TI()OC.CrtColumn > TI()CurrentUser->GetWidth())
			{
			doCR();
			}

		rmPrintf(pcts, item);
		}
	}


// --------------------------------------------------------------------------
// dospCR(): Does CR for entry of initials & pw.

void dospCR(void)
	{
	EchoType oldecho;

	oldecho = TI()OC.Echo;

	TI()OC.Echo = BOTH;
	setio();

	if (cfg.nopwecho == 1)
		{
		doCR();
		}
	else
		{
		if (onConsole)
			{
			if (SerialPort.HaveCarrier())
				{
				domcr();
				}
			}
		else
			{
			doccr();
			}
		}

	TI()OC.Echo = oldecho;
	setio();
	}


// --------------------------------------------------------------------------
// outSpeech(): Wow.

Bool outSpeech(Bool out, const char *st)
	{
#ifndef WINCIT
	int i, j, k;
	char buf[255];
	uchar wordBuf[MAXWORD + 8];

	if (cfg.speechOn && say_ascii)
		{
		buf[0] = 0;

		for (i = 0; st[i] && (TI()UserControl.CanOutput() ||
				TI()UserControl.GetOutFlag() == OUTPARAGRAPH);)
			{
			if (TI()UserControl.CheckInput(FALSE))
				{
				ResetOutputControl();
				buf[0] = 0;
				break;
				}

			i = getWord(wordBuf, (uchar *) st, i, MAXWORD);

			if (*wordBuf == CTRL_A)
				{
				if (out)
					{
					termCap((char *) wordBuf + 1);
					}
				}
			else if (*wordBuf == CTRL_B)
				{
				if (out)
					{
					localTermCap((char *) wordBuf + 1);
					}
				}
			else
				{
				if (strlen((char *) wordBuf) + strlen(buf) < 255)
					{
					strcat(buf, (char *) wordBuf);
					}
				else
					{
					k = strlen(buf);

					for (j = 0; j < k; j++)
						{
						buf[j] = filt_out[buf[j]];
						}

					(*say_ascii)(buf, k);
					strcpy(buf, (char *) wordBuf);
					}

				if (out)
					{
					putWord(wordBuf);
					}
				}
			}

		k = strlen(buf);
		for (j = 0; j < k; j++)
			{
			buf[j] = filt_out[buf[j]];
			}

		ansi(14);
		TI()OC.MCI_goto = FALSE;
		(*say_ascii)(buf, k);
		return (TRUE);
		}
	else
		{
#endif
		return (FALSE);
#ifndef WINCIT
		}
#endif
	}


void cdecl CRCRmPrintfCR(const char *fmt, ...)
	{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(TI()OC.prtf_buff, fmt, ap);
	va_end(ap);

	doCR(2);
	mFormat(TI()OC.prtf_buff);
	doCR();
	ResetOutputControl();
	}
