/* -------------------------------------------------------------------- */
/*	OUTFILE.CPP 				Citadel 								*/
/* -------------------------------------------------------------------- */
/*	This file contains the formatted file output functions				*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "log.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	dFormat()		Outputs a string to file w/ wordwrap				*/
/*	ddoCR() 		 does a return to file								*/
/*	dputWord()		 Writes one word to file, w/ wordwrap				*/
/*	doChar()		 is the top-level user-output function (one byte)	*/
/*	ddoTAB()		 prints a tab to file								*/
/* -------------------------------------------------------------------- */

static int medium_kludge;

/************************************************************************/
/*		ISBLANK is a special macro used by getword and putword			*/
/************************************************************************/
#define TAB '\t'
#define ISBLANK(cc) ((cc) == ' ' || (cc) == TAB)

/* -------------------------------------------------------------------- */
/*	ddoCR() 		 does a return to file								*/
/* -------------------------------------------------------------------- */
static void ddoCR(FILE *fd)
	{
	if (!TI()OC.Formatting)
		{
		return;
		}

	TI()OC.CrtColumn = 1;

	fputc('\r', fd);
	fputc('\n', fd);

	TI()prevChar = ' ';
	}

/* -------------------------------------------------------------------- */
/*	ddoTAB()		 prints a tab to file								*/
/* -------------------------------------------------------------------- */
static void ddoTAB(FILE *file)
	{
	fputc ('\t', file);
	updcrtpos('\t');
	}


/* -------------------------------------------------------------------- */
/*	doChar()		 is the top-level user-output function (one byte)	*/
/*			sends to file												*/
/*			does conversion to upper-case etc as necessary				*/
/*		Globals modified:		TI()prevChar							*/
/* -------------------------------------------------------------------- */
static void doChar(register char c, FILE *file)
	{
	TI()prevChar = c;				/* for end-of-paragraph code	*/

	if (c == '\t')
		{
		ddoTAB(file);
		return;
		}

	if (TI()CurrentUser->IsUpperOnly())
		{
		c = (char) toupper(c);
		}

	if (c == 10 /* newline */)
		{
		if (TI()OC.Formatting)
			{
			c = ' ';    // doCR() handles real newlines
			}
		else
			{
			TI()OC.Formatting = TRUE;
			ddoCR(file);
			TI()OC.Formatting = FALSE;
			TI()OC.CrtColumn = 1;
			return;
			}
		}

	fputc(c, file);

	updcrtpos(c);
	}

/* -------------------------------------------------------------------- */
/*	dputWord()		 Writes one word to file, w/ wordwrap				*/
/* -------------------------------------------------------------------- */
static void dputWord(const uchar *st, FILE *file)
	{
	register const uchar *s;
	register int newColumn;

	if (!TI()OC.Formatting)
		{
		for (; *st; st++)
			{
			doChar(*st, file);
			}

		return;
		}

// Experimental nifty new word wrap

	if (TI()prevChar == '\n' && ISBLANK(*st)) {
		/* end of paragraph: */
		ddoCR(file);
	}

	for (newColumn = TI()OC.CrtColumn, s = st; *s; s++) {
		if (*s == '\b')
			{
			newColumn--;
			}
		else if (*s == BELL)
			{
			// beeps do nothing to column
			}
		else if (*s != TAB) {
			++newColumn;
		} else {
			while (newColumn++ % 8);
			}
	}

	//////////////////////////////////////////////////////
	if (!(newColumn > TI()CurrentUser->GetWidth()))
	{
		if (isspace(*st) && (((newColumn + medium_kludge) > TI()CurrentUser->GetWidth()) || !medium_kludge))
		{
			TI()OC.CrtColumn += medium_kludge;
			TI()prevChar = *st;
			return;
		}
	}
	//////////////////////////////////////////////////////

	if (newColumn > TI()CurrentUser->GetWidth())
		{
		/* force a carriage return */
		ddoCR(file);

		if (isspace(*st)) {
			return;
		}
	}

	for (; *st; st++) {
		/* worry about words longer than a line */
		if (TI()OC.CrtColumn >= TI()CurrentUser->GetWidth())
			{
			ddoCR(file);
		}
		doChar(*st, file);
	}


	}

/* -------------------------------------------------------------------- */
/*	dFormat()		Outputs a string to file w/ wordwrap				*/
/* -------------------------------------------------------------------- */
void dFormat(const char *string, FILE *file)
	{
	uchar wordBuf[MAXWORD + 8];
	uchar nextwordBuf[MAXWORD + 8];
	int i;
	int j;
	uchar oldcrtColumn = TI()OC.CrtColumn;

	for (i = 0; string[i] && (TI()UserControl.CanOutput() || TI()UserControl.GetOutFlag() == OUTPARAGRAPH);)
		{
		KBReady();
		letWindowsMultitask();

		i = getWord(wordBuf, (uchar *) string, i, MAXWORD);

		//////////////////////////////////////////////////////////////
		j = i;
		do
		{
			j = getWord(nextwordBuf, (uchar *) string, j, MAXWORD);
		} while (string[j] && *nextwordBuf == CTRL_A);

		if ((*wordBuf == '\n' || *wordBuf == '\r') && ISBLANK(*nextwordBuf))
			{
			medium_kludge = 0;
			}
		else
			{
			medium_kludge = strlen((char *)nextwordBuf);
			}
		//////////////////////////////////////////////////////////////

		if (*wordBuf == CTRL_A && *(wordBuf+1) == TERM_FMT_OFF[0])
			{
			TI()OC.Formatting = FALSE;
			}
		else if (*wordBuf == CTRL_A && *(wordBuf+1) == TERM_FMT_ON[0])
			{
			TI()OC.Formatting = TRUE;
			}

		if (*wordBuf == CTRL_A && TI()OC.CrtColumn > strlen(string) - 1)
			{
			TI()OC.CrtColumn -= strlen(string);
			}

		dputWord(wordBuf, file);

		/* printf(">%d\n<", TI()OC.CrtColumn); */
		}

	ResetOutputControl();
	ddoCR(file);
	TI()OC.CrtColumn = oldcrtColumn;
	}
