/* -------------------------------------------------------------------- */
/*	NETCMD.CPP					Citadel 								*/
/* -------------------------------------------------------------------- */
/*					Network command processor for Citadel				*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "room.h"

#include "log.h"
#include "group.h"
#include "net.h"
#include "msg.h"
#include "hall.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	readNetCmdTmp() 	Read and process NETCMD.TMP 					*/
/* -------------------------------------------------------------------- */

const char *netcmdTmp = "NETCMD.TMP";

Message *NetCommandMsg;
Message *NetCmdReplyMsg;

void DoDebugCmd(const char **ncmsg);

void AppendLineToNetCommandReply(const char *str)
	{
	if (NetCmdReplyMsg)
		{
		NetCmdReplyMsg->AppendText(str);
		NetCmdReplyMsg->AppendText(bn);
		}
	}

/* -------------------------------------------------------------------- */
/*	readNetCmdTmp() 	Read and process NETCMD.TMP 					*/
/* -------------------------------------------------------------------- */
void readNetCmdTmp(void)
	{
	assert(NetCommandMsg == NULL);
	assert(NetCmdReplyMsg == NULL);

	NetCommandMsg = new Message;
	NetCmdReplyMsg = new Message;

	if (NetCommandMsg && NetCmdReplyMsg)
		{
		discardable *d;

		if ((d = readData(12)) != NULL)
			{
			char FileName[128];
			FILE *fl;
			const char **ncmsg = (const char **) d->aux;

			sprintf(FileName, sbs, cfg.temppath, netcmdTmp);
			if ((fl = fopen(FileName, FO_RB)) != NULL)
				{
				char **netkeywords = (char **) d->next->aux;
				doccr();
				cPrintf(ncmsg[1]);
				doccr();

				while (NetCommandMsg->ReadAll(RMC_NETWORK, fl) == RMS_OK)
					{
					NetCmdReplyMsg->ClearAll();

					if (*NetCommandMsg->GetSubject() == '*')
						{
						// this is a response
						}
					else
						{
						// this is the originating message

						normalizeString(NetCommandMsg->GetTextPointer());

						for (int i = 0; i < NC_NUM; i++)
							{
							if (SameString(NetCommandMsg->GetSubject(),
									netkeywords[i]))
								{
								break;
								}
							}

						switch (i)
							{
							case NC_DEBUG:
								{
								DoDebugCmd(ncmsg);
								break;
								}

							case NC_ROOMINFO:
								{
								r_slot rm;

								rm = IdExists(NetCommandMsg->GetText(), TRUE);

								if (rm != CERROR)
									{
									CreateRoomSummary(NetCmdReplyMsg->GetTextPointer(), rm);
									}
								else
									{
									char str[128];
									sprintf(str, getmsg(1066), cfg.Lroom_nym,
											NetCommandMsg->GetText());

									NetCmdReplyMsg->SetText(str);
									}

								break;
								}

							case NC_NODELIST:
								{
								int lg;

								for (lg = 0; lg < cfg.MAXLOGTAB; lg++)
									{
									if (LogTab->GetEntry(lg)->IsInuse() &&
											LogTab->GetEntry(lg)->IsNode())
										{
										char str[80];

										sprintf(str, ncmsg[39],
												LogTab->GetEntry(lg)->GetAlias(),
												LogTab->GetEntry(lg)->GetLocID(),
												LogTab->GetEntry(lg)->GetName(),
												bn);

										NetCmdReplyMsg->AppendText(str);
										}
									}

								break;
								}

							case NC_NODEINFO:
								{
								int lg;

								lg = nodexists(NetCommandMsg->GetText());

								if (lg == CERROR)
									{
									char str[128];
									sprintf(str, ncmsg[46], NetCmdReplyMsg->GetText());
									NetCmdReplyMsg->SetText(str);
									}
								else
									{
									NodeCitInfo *nd = NULL;

									if (getnode(&nd, NetCmdReplyMsg->GetText(),
											NOMODCON, TRUE))
										{
										char str[128];

										sprintf(str, ncmsg[48], NetCmdReplyMsg->GetText());
										NetCmdReplyMsg->SetText(str);
										NetCmdReplyMsg->AppendText(bn);

										sprintf(str, ncmsg[49], nd->GetName());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[50], nd->GetOldRegion());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[51], nd->GetAlias(),
												nd->GetLocID());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[52], bauds[nd->GetBaud()]);
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[53], nd->GetDialTimeout());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[54], nd->GetProtocol());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[55], nd->GetWaitTimeout());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[56], nd->GetMailFileName());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[57], nd->GetAutoHall() >= 0
												? HallData->GetEntry(nd->GetAutoHall())->GetName()
												: ncmsg[74]);
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[58], nd->GetAutoGroup() >= 0
												? GroupData->GetEntry(nd->GetAutoGroup())->GetName() :
												ncmsg[74]);
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[59],
												GroupData->GetEntry(nd->GetMapUnknownGroup())->GetName());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[60], nd->GetNetworkType());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[61], nd->GetCreatePacket());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[62], nd->GetExtractPacket());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[63], nd->IsAutoRoom());
										AppendLineToNetCommandReply(str);

//										sprintf(str, ncmsg[64], nd->GetVerbose());
//										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[65], nd->GetRequest());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[66], nd->IsGateway());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[67], nd->GetFetch());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[68], nd->GetNetFail());
										AppendLineToNetCommandReply(str);

										sprintf(str, ncmsg[69], nd->GetRedial());
										AppendLineToNetCommandReply(str);
										}
									else
										{
										NetCmdReplyMsg->SetTextWithFormat(ncmsg[47],
												NetCommandMsg->GetText());
										}

									freeNode(&nd);
									}

								break;
								}

							case NC_POOPCOUNT:
								{
								l_slot lg;

								lg = FindPersonByName(NetCommandMsg->GetText());

								if (lg != CERROR)
									{
									LogEntry1 Log1;

									if (Log1.Load(LogTab->GetEntry(lg)->GetLogIndex()))
										{
										NetCmdReplyMsg->SetTextWithFormat(ncmsg[70],
												Log1.GetName(),
												Log1.GetPoopcount());
										}
									else
										{
										NetCmdReplyMsg->SetTextWithFormat(ncmsg[73],
												LogTab->GetEntry(lg)->GetName());
										}
									}
								else
									{
									NetCmdReplyMsg->SetTextWithFormat(getmsg(595),
											NetCmdReplyMsg->GetText());
									}

								break;
								}

							case NC_POOPUSER:
								{
								NetCmdReplyMsg->SetTextWithFormat(ncmsg[71],
										cfg.poopuser, cfg.maxpoop);
								break;
								}

							case NC_FINGER:
								{
								l_slot lg;

								lg = FindPersonByName(NetCommandMsg->GetText());

								if (lg != CERROR)
									{
									LogExtensions LE(0);

									if (LE.Load(LogTab->GetEntry(lg)->GetLogIndex()))
										{
										if (LE.GetFinger())
											{
											NetCmdReplyMsg->SetTextWithFormat(ncmsg[72],
													LogTab->GetEntry(lg)->GetName());
											NetCmdReplyMsg->AppendText(bn);
											NetCmdReplyMsg->AppendText(LE.GetFinger());
											}
										else
											{
											NetCmdReplyMsg->SetTextWithFormat(getmsg(373),
													LogTab->GetEntry(lg)->GetName());
											}
										}
									else
										{
										NetCmdReplyMsg->SetTextWithFormat(ncmsg[73],
												LogTab->GetEntry(lg)->GetName());
										}
									}
								else
									{
									NetCmdReplyMsg->SetTextWithFormat(getmsg(595),
											NetCmdReplyMsg->GetText());
									}

								break;
								}

							default:
								{
								for (pairedStrings *theCmd = netCmdList; theCmd;
										theCmd = (pairedStrings *) getNextLL(theCmd))
									{
									if (SameString(NetCommandMsg->GetSubject() + 1,
											theCmd->string1))
										{
										break;
										}
									}

								if (theCmd)
									{
									runScript(theCmd->string2);
									}
								else
									{
									NetCmdReplyMsg->SetTextWithFormat(ncmsg[2],
											NetCommandMsg->GetSubject());
									}

								break;
								}
							}

						NetCmdReplyMsg->SetCreationRoom(GetRoomName(MAILROOM));
						NetCmdReplyMsg->SetRoomNumber(MAILROOM);

						NetCmdReplyMsg->SetToUser(NetCommandMsg->GetAuthor());
						NetCmdReplyMsg->SetAuthor(cfg.nodeTitle);

						char Subject[128];
						sprintf(Subject, ncmsg[3], NetCommandMsg->GetSubject());
						Subject[80] = 0;
						NetCmdReplyMsg->SetSubject(Subject);

						if (*NetCommandMsg->GetSourceID())
							{
							NetCmdReplyMsg->SetToNodeName(NetCommandMsg->GetOriginNodeName());
							NetCmdReplyMsg->SetToRegion(NetCommandMsg->GetOriginRegion());
							NetCmdReplyMsg->SetToCountry(NetCommandMsg->GetOriginCountry());
							NetCmdReplyMsg->SetDestinationAddress(oaddress(NetCommandMsg));

							label Buffer;
							NetCmdReplyMsg->SetLocalID(ltoa(cfg.newest + 1, Buffer, 10));

							if (save_mail(NetCmdReplyMsg, FALSE))
								{
								SaveStub(NetCmdReplyMsg, ncmsg[75], cfg.poopdebug);
								}
							else
								{
								cPrintf(ncmsg[4]);
								doccr();
								}
							}
						}
					}

				fclose(fl);
				unlink(FileName);
				doccr();
				}

			discardData(d);
			}
		else
			{
			cPrintf(getmsg(188), getmsg(1363));
			}
		}
	else
		{
		cPrintf(getmsg(188), getmsg(1363));
		}

	delete NetCommandMsg;
	delete NetCmdReplyMsg;

	NetCmdReplyMsg = NULL;
	NetCommandMsg = NULL;
	}
