#include "ctdl.h"
#pragma hdrstop

#include "log.h"
#include "net.h"
#include "tallybuf.h"
#include "menus.h"
#include "miscovl.h"


void net69_menu(void)
	{
	LogEntry SaveLog(cfg.maxrooms, cfg.maxgroups, cfg.maxjumpback);
	Bool loadedlog = FALSE;
	Bool Incorporated = FALSE;

	SetDoWhat(SYSNET69);

	if (!read_net_messages())
		{
		cPrintf(getmsg(59));
		return;
		}

	SaveLog = *TI()CurrentUser;

	const l_slot oldthisLog = TI()ThisLog;
	const Bool OldLoggedIn = TI()loggedIn;

	int ich;
	switch (toupper(ich = iCharNE()))
		{
		case 'F':
			{
			SetDoWhat(S69FETCH);

			mPrintfCR(getnetmsg(103));

			label rnode;
			getNormStr(getnetmsg(104), rnode, LABELSIZE, ECHO);

			if (!*rnode || !getnode(&TI()node, rnode, MODEM, TRUE))
				{
				break;
				}

			if (LoadPersonByName(TI()node->GetName()))
				{
				LogEntry5 Log5(cfg.maxrooms);

				TI()loggedIn = TRUE;

				mPrintfCR(getmsg(207), TI()node->GetName());

				/* fetch uses the loaded node entry */
				TI()menu69 = TRUE;
				loadedlog = TRUE;

				amZap();

				Log5.CopyRoomNewPointers(*TI()CurrentUser);

				if (net69_fetch(TRUE))
					{
					TI()CurrentUser->SetCallNumber(cfg.callno);
					time(&TI()logtimestamp);
					TI()CurrentUser->SetCallTime(TI()logtimestamp);
					slideLTab(TI()ThisSlot);
					}
				else
					{
					TI()CurrentUser->CopyRoomNewPointers(Log5);
					}

				SaveAideMess(NULL);
				}
			else 
				{
				CRmPrintfCR(getmsg(255), TI()node->GetName());
				}

			break;
			}

		case '>':
			{
			SetDoWhat(S86FETCH);

			mPrintfCR(getnetmsg(142));

			label rnode;
			getNormStr(getnetmsg(104), rnode, LABELSIZE, ECHO);

			if (*rnode && getnode(&TI()node, rnode, MODEM, FALSE))
				{
				if (LoadPersonByName(TI()node->GetName()))
					{
					LogEntry5 Log5(cfg.maxrooms);

					TI()loggedIn = TRUE;

					mPrintfCR(getmsg(207), TI()node->GetName());

					/* fetch uses the loaded node entry */
					TI()menu69 = TRUE;
					loadedlog = TRUE;

					amZap();

					Log5.CopyRoomNewPointers(*TI()CurrentUser);

					if (net86_fetch())
						{
						TI()CurrentUser->SetCallNumber(cfg.callno);
						time(&TI()logtimestamp);
						TI()CurrentUser->SetCallTime(TI()logtimestamp);
						slideLTab(TI()ThisSlot);
						}
					else
						{
						TI()CurrentUser->CopyRoomNewPointers(Log5);
						}

					SaveAideMess(NULL);
					}
				else
					{
					CRmPrintfCR(getmsg(255), TI()node->GetName());
					}
				}

			break;
			}

		case 'I':
			{
			SetDoWhat(S69INC);

			mPrintfCR(getnetmsg(105));

			TI()menu69 = TRUE;

			amZap();
			net69_incorporate();
			SaveAideMess(NULL);

			Incorporated = TRUE;

			break;
			}

		case '<':
			{
			SetDoWhat(S86INC);

			mPrintfCR(getnetmsg(143));

			label rnode;
			getNormStr(getnetmsg(104), rnode, LABELSIZE, ECHO);

			if (*rnode && getnode(&TI()node, rnode, MODEM, FALSE))
				{
				TI()menu69 = TRUE;
				amZap();
				net86_incorporate();
				SaveAideMess(NULL);

				Incorporated = TRUE;
				}

			break;
			}

		case 'R':
			{
			SetDoWhat(S69ROOMREQ);

			mPrintfCR(getnetmsg(106));

			label rnode;
			getNormStr(getnetmsg(104), rnode, LABELSIZE, ECHO);

			if (*rnode)
				{
				NetLogEntryC Log;

				if (Log.IsValid())
					{
					if (Log.LoadByName(rnode))
						{
						doCR();

						Log.MakeNet69RoomRequestFile(MODEM);
						}
					else
						{
						CRmPrintfCR(getmsg(255), rnode);
						}
					}
				else
					{
					mPrintf(getmsg(188), getsysmsg(57));
					}
				}

			break;
			}

		case '@':
			{
			mPrintfCR(getnetmsg(112));
			buildaddress();
			break;
			}

		case '?':
			{
			oChar('?');
			SetDoWhat(S69MENU);

			showMenu(M_SYSNET);
			break;
			}

		default:
			{
			BadMenuSelection(ich);
			break;
			}
		}

	TI()menu69 = FALSE;

	if (loadedlog)
		{
		storeLog();

		TI()ThisLog = oldthisLog;
		*TI()CurrentUser = SaveLog;
		TI()loggedIn = OldLoggedIn;
		}

	if (loadedlog || Incorporated)
		{
		roomtalley();
		}

	dump_net_messages();

	freeNode(&TI()node);

	StatusLine.Update();
	}
