// --------------------------------------------------------------------------
// Citadel: MsgScrpt.CPP
//
// Message script

#include "ctdl.h"
#pragma hdrstop

#include "msg.h"
#include "script.h"

// Make copy of message into our own place
void PrepareMsgScriptInit(Message *Msg)
	{
	if (TI()MsgScriptMsg)
		{
		delete TI()MsgScriptMsg;
		}

	TI()MsgScriptMsg = new Message(*Msg);
	}

// If we have a message, copy it to passed message, get rid of ours
Bool CheckMsgScript(Message *Msg)
	{
	if (TI()MsgScriptMsg)
		{
		*Msg = *TI()MsgScriptMsg;

		delete TI()MsgScriptMsg;
		TI()MsgScriptMsg = NULL;

		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
	}

// Make copy of script's message if it has one.
void DeinitMsgScript(ScriptInfoS *si)
	{
	if (TI()MsgScriptMsg)
		{
		delete TI()MsgScriptMsg;
		}

	if (si->UsrMsg)
		{
		TI()MsgScriptMsg = new Message(*si->UsrMsg);
		}
	else
		{
		TI()MsgScriptMsg = NULL;
		}
	}

// Give script our message, and then forget about it.
void InitMsgScript(ScriptInfoS *si)
	{
	si->UsrMsg = TI()MsgScriptMsg;
	TI()MsgScriptMsg = NULL;

	si->DeinitScript = DeinitMsgScript;
	}
