// --------------------------------------------------------------------------
// Citadel: MsgRead2.CPP
//
// Stuff for reading messages (secondary importance)

#include "ctdl.h"
#pragma hdrstop

#include "msg.h"

// --------------------------------------------------------------------------
// Contents
//
// readbymsgno()		sysop fn to read by message #


void ShowWhyMayNotSeeMsg(MaySeeMsgType Why, ulong MsgID);

// --------------------------------------------------------------------------
// readbymsgno(): Sysop fn to read by message #.

void readbymsgno(void)
	{
	label Newest;
	strcpy(Newest, ltoac(cfg.newest));
	CRmPrintfCR(getsysmsg(164), ltoac(cfg.mtoldest), Newest);

	for (;;)
		{
		char prompt[80];
		sprintf(prompt, getsysmsg(165), cfg.Lmsg_nym);
		const long msgno = getNumber(prompt, 0l, LONG_MAX, -1l, FALSE, NULL);

		if (!msgno || msgno < 0)
			{
			return;
			}

		if ((msgno < cfg.mtoldest) || (msgno > cfg.newest))
			{
			CRmPrintfCR(getsysmsg(166));
			}
		else
			{
			const m_slot slot = indexslot(msgno);
			const MaySeeMsgType MaySeeIt = MaySeeIndexMsg(slot);
			// that const is so Richard

			if (MaySeeIt == MSM_GOOD)
				{
				dowhattype oldDowhat;

				TI()MRO.Verbose = TRUE;

				oldDowhat = TI()DoWhat;
				SetDoWhat(READMESSAGE);
				TI()MRO.DotoMessage = NO_SPECIAL;

				Message *Msg = LoadMessageByID(msgno, TRUE, TRUE);
				SetDoWhat(oldDowhat);

				if (Msg)
					{
					if (TI()MRO.DotoMessage == MARK_IT)
						{
						markIt(Msg);
						}

					if (TI()MRO.DotoMessage == PULL_IT)
						{
						pullIt(Msg);
						}

					if (TI()MRO.DotoMessage == CENSOR_IT)
						{
						censorIt(Msg);
						}

					delete Msg;
					}

				TI()UserControl.SetOutFlag(OUTOK);
				doCR();
				}
			else
				{
				ShowWhyMayNotSeeMsg(MaySeeIt, msgno);
				}
			}
		}
	}

void ShowWhyMayNotSeeMsg(MaySeeMsgType Why, ulong MsgID)
	{
	doCR();

	switch (Why)
		{
		case MSM_COPYSCROLLED:
			{
			mPrintf(getmsg(112), ltoac(MsgID), cfg.Lmsg_nym);
			break;
			}

		case MSM_CENSORED:
			{
			mPrintf(getmsg(113), ltoac(MsgID), cfg.Lmsg_nym);
			break;
			}

		case MSM_NOTLOGGEDIN:
			{
			mPrintf(getmsg(114), ltoac(MsgID));
			break;
			}

		case MSM_COPYOWNTWIT:
			{
			mPrintf(getmsg(115), ltoac(MsgID), cfg.Luser_nym, cfg.Lmsg_nym);
			break;
			}

		case MSM_RELEASEDORIG:
			{
			mPrintf(getmsg(116), ltoac(MsgID), cfg.Lmsg_nym);
			break;
			}

		case MSM_TWIT:
			{
			mPrintf(getmsg(117), ltoac(MsgID), cfg.Luser_nym, cfg.Lmsg_nym);
			break;
			}

		case MSM_MODERATED:
			{
			mPrintf(getmsg(118), ltoac(MsgID), cfg.Lmsg_nym);
			break;
			}

		case MSM_NOTINGROUP:
			{
			mPrintf(getmsg(119), ltoac(MsgID), cfg.Lgroup_nym);
			break;
			}

		case MSM_GROUPBAD:
			{
			mPrintf(getmsg(120), ltoac(MsgID), cfg.Ugroup_nym);
			break;
			}

		case MSM_MAIL:
			{
			mPrintf(getmsg(121), ltoac(MsgID));
			break;
			}

		default:		// This can "never" happen.
			{
			mPrintf(getmsg(419));
			break;
			}
		}

	doCR();
	}
