// --------------------------------------------------------------------------
// Citadel: MsgAddr.CPP
//
// Stuff to deal with addressing messages as mail

#include "ctdl.h"
#pragma hdrstop

#include "msg.h"
#include "log.h"
#include "net.h"
#include "maillist.h"

Bool ResolveMessageAddressingIssues(Message *Msg, ModemConsoleE ReportTo)
	{
	void cdecl (*wPrintf)(const char *fmt, ...);
	void (*wDoCR)(void);

	switch (ReportTo)
		{
		case MODEM:
			{
			wPrintf = mPrintf;
			wDoCR = doCR;
			break;
			}

		case CONSOLE:
			{
			wPrintf = cPrintf;
			wDoCR = doccr;
			break;
			}

		default:
			{
			wPrintf = noPrintf;
			wDoCR = noDoCR;
			break;
			}
		}

	l_slot logslot;

	if (*Msg->GetToNodeName())
		{
		logslot = FindPersonByPartialName(Msg->GetToNodeName());
		}
	else
		{
		logslot = FindPersonByPartialName(Msg->GetToUser());
		}

	if (logslot == CERROR && *Msg->GetDestinationAddress())
		{
		logslot = nodexists(Msg->GetDestinationAddress());

		if (logslot != CERROR)
			{
			Msg->SetToNodeName(LogTab->GetEntry(logslot)->GetName());

			label ToAddress;
			strcpy(ToAddress,
					makeaddress(LogTab->GetEntry(logslot)->GetAlias(),
					LogTab->GetEntry(logslot)->GetLocID()));
			Msg->SetDestinationAddress(ToAddress);
			}
		}

	if (logslot == CERROR)
		{
		if (!*Msg->GetToNodeName())
			{
			// forward 'sysop' messages to #sysop if #forward
			if (SameString(Msg->GetToUser(), getmsg(1020)) &&
					cfg.forward &&
					(FindPersonByName(cfg.sysop) != CERROR))
				{
				Msg->SetToUser(cfg.sysop);

				wPrintf(getmsg(1135), cfg.Lmsg_nym, cfg.sysop);
				wDoCR();
				}
			else if (!SameString(Msg->GetToUser(), getmsg(1020)) &&
					!SameString(Msg->GetToUser(), getmsg(1019)) &&
					!IsMailingList(Msg->GetToUser()))
				{
				wDoCR();
				wPrintf(getmsg(595), Msg->GetToUser());
				wDoCR();

				return (FALSE);
				}
			}
		}
	else
		{
		if (*Msg->GetToNodeName())
			{
			Msg->SetToNodeName(LogTab->GetEntry(logslot)->GetName());
			}
		else
			{
			Msg->SetToUser(LogTab->GetEntry(logslot)->GetName());
			}

		if (LogTab->GetEntry(logslot)->IsNode() && !(*Msg->GetToNodeName()))
			{
			Msg->SetToNodeName(Msg->GetToUser());
			Msg->SetToUser(getmsg(1020));

			wPrintf(getmsg(1136), cfg.Umsg_nym, Msg->GetToNodeName());
			wDoCR();
			}
		}

	if (logslot != CERROR && !*Msg->GetToNodeName())
		{
		LogEntry1 Log1;

		if (Log1.Load(LogTab->GetEntry(logslot)->GetLogIndex()) &&
				*(Log1.GetForwardAddr()))
			{
			if (!Log1.IsForwardToNode())
				{
				// Regular forwarding
				l_slot logslot2;

				logslot2 = FindPersonByName(Log1.GetForwardAddr());

				if (logslot2 != CERROR)
					{
					Msg->SetForward(LogTab->GetEntry(logslot2)->GetName());

					wPrintf(getmsg(1137), cfg.Umsg_nym);
					wPrintf(pcts, Msg->GetForward());
					}

				wDoCR();
				}
			else
				{
				// Forwarding to node
				wPrintf(getmsg(1137), cfg.Umsg_nym);

				Msg->SetForward(Log1.GetForwardAddr());
				Msg->SetToNodeName(Log1.GetForwardAddrNode());

				wPrintf(getmsg(101), Log1.GetForwardAddr(),
						Log1.GetForwardAddrNode());
				}
			}
		}

	return (TRUE);
	}