/* -------------------------------------------------------------------- */
/*	MODEM.CPP					Citadel									*/
/* -------------------------------------------------------------------- */
/*	High level modem code, should not need to be changed for porting(?) */
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "log.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	domcr()				print cr on modem, nulls and lf's if needed		*/
/*	outstring()			push a string directly to the modem				*/
/*	SerialPort.Flush()	Flush garbage characters from the modem.		*/
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*	domcr()				print cr on modem, nulls and lf's if needed		*/
/* -------------------------------------------------------------------- */
void domcr(void)
	{
	TI()SerialPort.Output('\r');

	for (int i = TI()CurrentUser->GetNulls(); i; i--)
		{
		TI()SerialPort.Output(0);
		}

	if (TI()CurrentUser->IsLinefeeds())
		{
		TI()SerialPort.Output('\n');
		}
	}

/* -------------------------------------------------------------------- */
/*	outstring()			push a string directly to the modem				*/
/* -------------------------------------------------------------------- */
void OutStringWithPacing(const char *String, int Pace)
	{
	Bool mtmp;

	mtmp = TI()OC.Modem;
	TI()OC.Modem = TRUE;

	while (*String)
		{
		TI()SerialPort.Output(*String++);	/* output string */

		if (Pace)
			{
			pause(Pace);
			}
		}

	TI()OC.Modem = mtmp;
	}

void outstring(const char *string)
	{
	Bool mtmp;

	mtmp = TI()OC.Modem;
	TI()OC.Modem = TRUE;

	while (*string)
		{
		TI()SerialPort.Output(*string++);	/* output string */
		}

	TI()OC.Modem = mtmp;
	}

/* -------------------------------------------------------------------- */
/*	SerialPort.Flush()	Flush garbage characters from the modem.		*/
/* -------------------------------------------------------------------- */
void SerialPortC::Flush(void)
	{
	while (IsInputReady())
		{
		// Don't use Input so Received and BeenReceived are not affected
		assert(getrs);
		(*getrs)();
		}
	}

/* -------------------------------------------------------------------- */
/*	Hangup()			breaks the modem connection						*/
/* -------------------------------------------------------------------- */
void Hangup(void)
	{
	if (!slv_door)
		{
		pHangup();
		}
	else
		{
		TI()modStat = FALSE;		/* hangup simulation ... */
		}
	}
