// --------------------------------------------------------------------------
// Citadel: MemInit.CPP
//
// This is the code to initialize memory


#include "ctdl.h"
#pragma hdrstop

#include "auxtab.h"
#include "msg.h"
#include "log.h"

// --------------------------------------------------------------------------
// Contents
//
// addMtBlock() 	adds another chunk to the mt
// createMsgTab()	does what it says
// destroyMsgTab()	does just that

#ifdef AUXMEM
void destroyMsgTab(void)
	{
	DeleteAuxmemList(&mtList, &msgBlocksInHeap);
	delete [] FirstMessageInRoom;
	delete [] LastMessageInRoom;
	FirstMessageInRoom = NULL;
	LastMessageInRoom = NULL;
	}

void createMsgTab(void)
	{
	m_slot i;

	assert(mtList == NULL);

	for (i = 0; i < cfg.nmessages; i += MSGTABPERPAGE)
		{
		if (!AddAuxmemBlock(&mtList, i, &msgBlocksInHeap, 2))
			{
			crashout(getcfgmsg(114), ltoac(i));
			}
		}

	FirstMessageInRoom = new m_slot[cfg.maxrooms];
	LastMessageInRoom = new m_slot[cfg.maxrooms];

	if (!FirstMessageInRoom || !LastMessageInRoom)
		{
		crashout(getcfgmsg(107));
		}
	else
		{
		memset(FirstMessageInRoom, 0xff, sizeof(m_slot) * cfg.maxrooms);
		memset(LastMessageInRoom, 0xff, sizeof(m_slot) * cfg.maxrooms);
		}
	}
#else

void destroyMsgTab(void)
	{
#ifdef WINCIT
	assert(msgTabWin != NULL);
	delete [] msgTabWin;
	msgTabWin = NULL;
#else
	assert(msgTab_mtmsgflags != NULL);
	delete [] msgTab_mtmsgflags;
	msgTab_mtmsgflags = NULL;

	assert(msgTab_mtmsgLocLO != NULL);
	delete [] msgTab_mtmsgLocLO;
	msgTab_mtmsgLocLO = NULL;

	assert(msgTab_mtmsgLocHI != NULL);
	delete [] msgTab_mtmsgLocHI;
	msgTab_mtmsgLocHI = NULL;

	assert(msgTab_mtroomno != NULL);
	delete [] msgTab_mtroomno;
	msgTab_mtroomno = NULL;

	assert(msgTab_mttohash != NULL);
	delete [] msgTab_mttohash;
	msgTab_mttohash = NULL;

	assert(msgTab_mtauthhash != NULL);
	delete [] msgTab_mtauthhash;
	msgTab_mtauthhash = NULL;

	assert(msgTab_mtomesg != NULL);
	delete [] msgTab_mtomesg;
	msgTab_mtomesg = NULL;
#endif
	}

void createMsgTab(void)
	{
#ifdef WINCIT
	assert(msgTabWin == NULL);

	if ((msgTabWin = new messagetable[cfg.nmessages + 1]) == NULL)
		{
		crashout(getcfgmsg(115));
		}
#else
	assert(msgTab_mtomesg == NULL);
	assert(msgTab_mtroomno == NULL);
	assert(msgTab_mttohash == NULL);
	assert(msgTab_mtmsgflags == NULL);
	assert(msgTab_mtmsgLocLO == NULL);
	assert(msgTab_mtmsgLocHI == NULL);
	assert(msgTab_mtauthhash == NULL);

	msgTab_mtomesg = new uint[cfg.nmessages + 1];
	msgTab_mtroomno = new int[cfg.nmessages + 1];
	msgTab_mttohash = new int[cfg.nmessages + 1];
	msgTab_mtmsgflags = new msgflags[cfg.nmessages + 1];
	msgTab_mtmsgLocLO = new int[cfg.nmessages + 1];
	msgTab_mtmsgLocHI = new int[cfg.nmessages + 1];
	msgTab_mtauthhash = new int[cfg.nmessages + 1];

	if (msgTab_mtmsgflags == NULL || msgTab_mtmsgLocLO == NULL ||
			msgTab_mtmsgLocHI == NULL || msgTab_mtroomno == NULL ||
			msgTab_mttohash == NULL || msgTab_mtauthhash == NULL ||
			msgTab_mtomesg == NULL)
		{
		crashout(getcfgmsg(115));
		}
#endif
	}
#endif

void destroyBorders(void)
	{
	delete [] borders;
	borders = NULL;
	}

void makeBorders(void)
	{
	assert(borders == NULL);

	borders = new char[cfg.maxborders * (BORDERSIZE + 1)];

	if (!borders)
		{
		crashout(getmsg(188), getmsg(1321));
		}

	memset(borders, 0, cfg.maxborders * (BORDERSIZE + 1));
	}

void createLogTab(void)
	{
	assert(LogTab == NULL);

	LogTab = new LogTable(cfg.MAXLOGTAB);

	if (LogTab == NULL || !LogTab->IsValid())
		{
		crashout(getcfgmsg(116));
		}
	}

void destroyLogTab(void)
	{
	if (LogTab)
		{
		delete LogTab;
		}

	LogTab = NULL;
	}
