/* -------------------------------------------------------------------- */
/*	MAKETAB.CPP 				Citadel 								*/
/* -------------------------------------------------------------------- */
/*			table making code for Citadel bulletin board system.		*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "roompriv.h"
#include "log.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/*	RoomTabBld()		builds room.tab, indexes room.dat				*/
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*	logInit()			indexes LOG.DAT 								*/
/* -------------------------------------------------------------------- */
void logInit(void)
	{
	LogEntry1 Log1;
	l_index Index;
	int count = 0;

	msgDisp(getcfgmsg(173), getcfgmsg(155), ltoac(cfg.MAXLOGTAB));
	doccr();

	cfg.callno = 0l;
	cfg.maxpoop = 0;
	cfg.poopuser[0] = 0;

	LogTab->Clear();

	Log1.OpenFile();

	for (Index = 0; Index < cfg.MAXLOGTAB; Index++)
		{
		KBReady();
		letWindowsMultitask();

		msgDisp(getcfgmsg(174), ltoac(Index + 1));
		cPrintfDOS(br);

		if (!Log1.Load(Index))
			{
			crashout(getcfgmsg(281), getcfgmsg(155));
			}

		Log1.Verify();

		// perhaps not in release. perhaps in release. i don't know.
		if (Log1.IsInuse())
			{
			cfg.callno = max((long) cfg.callno, (long) Log1.GetCallNumber());

			if (Log1.GetPoopcount() > cfg.maxpoop)
				{
				cfg.maxpoop = Log1.GetPoopcount();
				strcpy(cfg.poopuser, Log1.GetName());
				}

			count++;
			}
		else
			{
			Log1.SetCallNumber(0);
			Log1.SetPoopcount(0);
			}

		Log1.Save(Index);
		}

	Log1.CloseFile();

	doccr();
	msgDisp(getcfgmsg(175), ltoac(cfg.callno));
	doccr();
	msgDisp(getcfgmsg(176), ltoac(count));
	doccr();
	doccr();

#ifdef WINCIT
	msgDisp(NULL);
#endif

	LogTab->Sort();
	}

/* -------------------------------------------------------------------- */
/*	verifyRoom()		Verifies room entry will not crash the system	*/
/* -------------------------------------------------------------------- */
static void verifyRoom(aRoom *r)
	{
	/* make sure no strings overflow */
	r->rbname[LABELSIZE]		= 0;
	r->netID[LABELSIZE] 		= 0;
	r->modHost[LABELSIZE]		= 0;
	r->exclNetPartner[LABELSIZE]= 0;
	r->archive[12]				= 0;
	r->dictionary[12]			= 0;
	r->rbdirname[63]			= 0;
	r->rbroomtell[12]			= 0;
	r->rbaplic[12]				= 0;
	r->descript[79] 			= 0;

	/* fill any unused areas with emptiness */
	r->UNUSED1 = 0;
	r->UNUSED2 = 0;
	r->UNUSED3 = 0;

	/* don't overindex the group buffer */
	if (r->rbgrpno >= cfg.maxgroups)
		{
		r->rbgrpno = 0;
		}

	if (r->rbPgrpno >= cfg.maxgroups)
		{
		r->rbPgrpno = 0;
		}
	}

/* -------------------------------------------------------------------- */
/*	RoomTabBld()		builds RAM index to ROOM.DAT and displays stats */
/* -------------------------------------------------------------------- */
void RoomTabBld(void)
	{
	r_slot slot = 0, roomCount = 0;
	aRoom rBuf;

	msgDisp(getcfgmsg(173), cfg.Lroom_nym, ltoac(cfg.maxrooms));
	doccr();

	msgDisp(getcfgmsg(177), cfg.Uroom_nym, ltoac(slot));
	cPrintfDOS(br);

	for (; slot < cfg.maxrooms; slot++)
		{
		KBReady();
		letWindowsMultitask();

		getRoom(slot, &rBuf);
		verifyRoom(&rBuf);

		if (!((slot + 1) % 10))
			{
			msgDisp(getcfgmsg(177), cfg.Uroom_nym, ltoac(slot + 1));
			cPrintf(br);
			}

		if (rBuf.rbflags.IsInuse())
			{
			++roomCount;
			}

		getRoomTab(slot)->locked = FALSE;

		putRoom(slot, &rBuf);	// this indexes
		}

	msgDisp(getcfgmsg(177), cfg.Uroom_nym, ltoac(slot));
	cPrintfDOS(br);

	doccr();
	label roomCountStr;
	strcpy(roomCountStr, ltoac(roomCount));
	msgDisp(getcfgmsg(178), roomCountStr, ltoac(cfg.maxrooms),
			cfg.Lrooms_nym);
	doccr();
	doccr();

#ifdef WINCIT
	msgDisp(NULL);
#endif
	}
