// access to log stuff

#include "ctdl.h"
#pragma hdrstop

#include "log.h"
#include "room.h"
#include "group.h"

LogEntry::LogEntry(r_slot NumRooms, g_slot NumGroups, int MaxJumpback) :
	LogEntry2(NumGroups),
	LogEntry3(NumRooms),
	LogEntry4(NumRooms),
	LogEntry5(NumRooms),
	LogEntry6(NumRooms),
	LogExtensions(MaxJumpback)
	{
	}

void LogEntry1Data::Verify(void)
	{
	/* make sure no strings overflow */
	Name[LABELSIZE] 			= 0;
	Initials[LABELSIZE] 		= 0;
	Password[LABELSIZE] 		= 0;
	Surname[LABELSIZE]			= 0;
	Title[LABELSIZE]			= 0;
	RealName[LABELSIZE] 		= 0;
	PhoneNumber[LABELSIZE]		= 0;

	ForwardAddr[LABELSIZE]		= 0;
	ForwardAddrNode[LABELSIZE]	= 0;
	ForwardAddrRegion[LABELSIZE]= 0;

	PromptFormat[63]			= 0;
	DateStamp[63]				= 0;
	VerboseDateStamp[63]		= 0;
	Signature[90]				= 0;
	NetPrefix[LABELSIZE]		= 0;
	MailAddr1[LABELSIZE]		= 0;
	MailAddr2[LABELSIZE]		= 0;
	MailAddr3[LABELSIZE]		= 0;
	Alias[3]					= 0;
	LocID[4]					= 0;
	MorePrompt[79]				= 0;
	Occupation[LABELSIZE]		= 0;
	WhereHear[79]				= 0;

	LastRoom[LABELSIZE] 		= 0;
	LastHall[LABELSIZE] 		= 0;
	DefaultRoom[LABELSIZE]		= 0;
	DefaultHall[LABELSIZE]		= 0;

	if (Sex > SEX_FEMALE || Sex < SEX_UNKNOWN)
		{
		Sex = SEX_UNKNOWN;
		}
	}

LogEntry::LogEntry(const LogEntry &Original) :
	LogEntry1(Original),
	LogEntry2(Original),
	LogEntry3(Original),
	LogEntry4(Original),
	LogEntry5(Original),
	LogEntry6(Original),
	LogExtensions(Original)
	{

	}

LogEntry& LogEntry::operator = (const LogEntry &Original)
	{
	LogEntry1::operator =(Original);
	LogEntry2::operator =(Original);
	LogEntry3::operator =(Original);
	LogEntry4::operator =(Original);
	LogEntry5::operator =(Original);
	LogEntry6::operator =(Original);
	LogExtensions::operator =(Original);

	return (*this);
	}

void LogFlags::CopyFlags(const LogFlags &ToCopy)
	{
	VerifyHeap();
	memcpy(this, &ToCopy, sizeof(LogFlags));
	VerifyHeap();
	}

// I really don't like this one. Copying the virual pointer and all.
LogEntry1& LogEntry1::operator =(const LogEntry1 &Original)
	{
	VerifyHeap();
	memcpy(this, &Original, sizeof(LogEntry1));
	VerifyHeap();

	return (*this);
	}

void LogEntry2::Clear(void)
	{
	VerifyHeap();

	if (IsValid())
		{
		BitBag::Clear();

		VerifyHeap();

		// Always put in NULL.
		SetInGroup(0, TRUE);

		// Then put in any other auto-add groups if we have groups.
		if (GroupData)
			{
			for (g_slot GroupSlot = 1; GroupSlot < cfg.maxgroups; GroupSlot++)
				{
				SetInGroup(GroupSlot,
						GroupData->GetEntry(GroupSlot)->IsAutoAdd());
				}
			}
		}
	}

void LogEntry3::Clear(void)
	{
	VerifyHeap();

	if (IsValid())
		{
		BitBag::Clear();

		VerifyHeap();

		for (r_slot RoomSlot = 0; RoomSlot < cfg.maxrooms; RoomSlot++)
			{
			if (IsRoomInuse(RoomSlot) && !IsRoomHidden(RoomSlot) &&
					!IsRoomBIO(RoomSlot))
				{
				// make public rooms known
				SetInRoom(RoomSlot, TRUE);
				}
			else
				{
				// make private rooms unknown
				SetInRoom(RoomSlot, FALSE);
				}
			}
		}
	}

void LogTable::Clear(void)
	{
	VerifyHeap();

	if (IsValid())
		{
		memset(Table, 0, sizeof(*Table) * TableSize);
		VerifyHeap();

		for (l_slot TableIndex = 0; TableIndex < TableSize; TableIndex++)
			{
			Table[TableIndex].SetLogIndex(TableIndex);
			}
		}
	}

void ListUsers(Bool ListUnlisted)
	{
	CRmPrintfCR(getmsg(962), cfg.Uusers_nym);

	prtList(LIST_START);

	for (l_slot LogSlot = 0; LogSlot < cfg.MAXLOGTAB; LogSlot++)
		{
		if (// slot is in use
			LogTab->GetEntry(LogSlot)->IsInuse() &&

				(
				// and listing the unlisted
				ListUnlisted ||

				// The account is not unlisted
				!LogTab->GetEntry(LogSlot)->IsUnlisted() ||

				// Logged in and it is us (we are always 0).
				(TI()loggedIn && !LogSlot)
				)
			)
			{
			prtList(LogTab->GetEntry(LogSlot)->GetName());
			}
		}

	prtList(LIST_END);
	}
