// --------------------------------------------------------------------------
// Citadel: LogOut.CPP
//
// Overlayed logout log code.

#include "ctdl.h"
#pragma hdrstop

#include "group.h"
#include "room.h"
#include "filecmd.h"
#include "tallybuf.h"
#include "log.h"
#include "net.h"
#include "msg.h"
#include "account.h"
#include "events.h"
#include "blurbs.h"
#include "cfgfiles.h"
#include "cwindows.h"
#include "term.h"


// --------------------------------------------------------------------------
// Contents
//
// terminate()			menu-level routine to exit system
// setdefaultconfig()	sets default new user configuration


// --------------------------------------------------------------------------
// terminate(): Menu-level routine to exit system.

void terminate(Bool discon)
	{
	char dtstr[80];

	if (!TI()altF3Timeout &&
			(cfg.chatmail == 2 && TI()chatReq) || (cfg.chatmail == 3) ||
			(cfg.chatmail == 4))
		{
		if (cfg.chatmail == 2)
			{
			dispBlb(B_CHATTED);
			}

		Message *Msg = new Message;

		if (Msg)
			{
			msgtosysop(Msg);
			delete Msg;
			}
		else
			{
			mPrintf(getmsg(188), getmsg(772));
			}
		}

	if (TI()loggedIn && onConsole)
		{
		last_console_login_callno = cfg.callno;
		}

	TI()OC.Psycho = FALSE;
	TI()chatReq = FALSE;
	const Bool doStore = HaveConnectionToUser();

	if (discon || !doStore)
		{
		sysopNew = FALSE;
		}

	const long balance = TI()CurrentUser->GetCredits();

	TI()UserControl.SetOutFlag(OUTOK);

	if ((doStore && (TI()MRO.Verbose == 2)) ||
			TI()CurrentUser->IsAutoVerbose() ||
			TI()CurrentUser->IsVerboseLogOut() ||
			TI()CurrentUser->IsNode())
		{
		if (TI()CurrentUser->IsNode())
			{
			TI()UserControl.SetOutFlag(IMPERVIOUS); 	// no carrier
			}

		CRmPrintfCR(getmsg(1084), ltoac(cfg.callno));
		mPrintfCR(getmsg(1085), diffstamp(TI()logtimestamp));
		label Entered, L;
		strcpy(Entered, ltoac(TI()MS.Entered));
		mPrintfCR(getmsg(1086), Entered,
				TI()MS.Entered == 1 ? cfg.Lmsg_nym : cfg.Lmsgs_nym,
				ltoac(TI()MS.Read));

		if (cfg.accounting && TI()CurrentUser->IsAccounting())
			{
			long C = (TI()CurrentUserAccount->GetBalanceAtLogin() -
					balance) / 60;

			mPrintfCR(getmsg(1088), ltoac(C),
					(C == 1) ? cfg.Lcredit_nym : cfg.Lcredits_nym, L);

			C = balance / 60;

			mPrintfCR(getmsg(1089), ltoac(C),
					(C == 1) ? cfg.Lcredit_nym : cfg.Lcredits_nym);
			}

		strftime(dtstr, 79, (TI()loggedIn) ?
				TI()CurrentUser->GetVerboseDateStamp() : cfg.vdatestamp, 0l);
		}

	if (doStore && TI()MRO.Verbose)
		{
		goodbye();
		}

	TI()UserControl.SetOutFlag(IMPERVIOUS);

	if (TI()loggedIn)
		{
		if ((TI()MRO.Verbose == 2) || TI()CurrentUser->IsAutoVerbose() ||
				TI()CurrentUser->IsVerboseLogOut() ||
				TI()CurrentUser->IsNode())
			{
			CRmPrintfCR(getmsg(1114), TI()CurrentUser->GetName(), dtstr);
			}
		else
			{
			CRmPrintfCR(getmsg(1090), TI()CurrentUser->GetName());
			}
		}

	TI()thisHall = 0;	// go to Root hall

	if (discon)
		{
		if (SerialPort.HaveCarrier())
			{
			CITWINDOW *w = ScreenSaver.IsOn() ? NULL :
				CitWindowsMsg(NULL, getmsg(1643));

			Hangup();

			if (w)
				{
				destroyCitWindow(w, FALSE);
				}
			}

		//TI()whichIO = MODEM; // I really don't know
		//setio();
		}

	if (!slv_door && !SerialPort.HaveCarrier())
		{
		CITWINDOW *w = ScreenSaver.IsOn() ? NULL : 
				CitWindowsMsg(NULL, getmsg(1611));

		Initport();

		if (w)
			{
			destroyCitWindow(w, FALSE);
			}
		}

	TI()CurrentUser->SetInRoom(TI()thisRoom, TRUE);

	if (!doStore) // if carrier dropped
		{
		char TrapString[128];

		sprintf(TrapString, getmsg(1091));
		trap(TrapString, T_CARRIER);
		}

	// update new pointer only if carrier not dropped
	if (TI()loggedIn && doStore)
		{
		TI()CurrentUser->SetRoomNewPointer(TI()thisRoom, cfg.newest);
		}

	if (TI()loggedIn)
		{
		char trapstr[128];

		TI()CurrentUser->SetCallNumber(cfg.callno);
		TI()CurrentUser->SetCallTime(TI()logtimestamp);

		// for the Minibin() function to calculate #new messages
		TI()CurrentUser->SetLastMessage(cfg.newest);

		TI()CurrentUser->SetTotalTime(TI()CurrentUser->GetTotalTime() +
				(time(NULL) - TI()logtimestamp));

		TI()CurrentUser->SetLogins(TI()CurrentUser->GetLogins() + 1);
		TI()CurrentUser->SetPosted(TI()CurrentUser->GetPosted() +
				TI()MS.Entered);
		TI()CurrentUser->SetRead(TI()CurrentUser->GetRead() + TI()MS.Read);

		TI()CurrentUser->Save(TI()ThisLog);

		// this stuff puts the current room at the end of jumpback,
		// so J will take you back here.
		jumpback jb;

		jb.hall = TI()thisHall;
		jb.room = TI()thisRoom;
		jb.newpointer = TI()CurrentUser->GetRoomNewPointer(TI()thisRoom);
		jb.bypass = WasRoomBypassed(TI()thisRoom);
		jb.newMsgs = GetRoomNewMessages(TI()thisRoom);

		TI()CurrentUser->JumpbackPush(jb);

		TI()loggedIn = FALSE;

#ifndef WINCIT
		if (TI()CurrentUser->IsPrintFile() && TI()OC.Printing)
			{
			TI()OC.Printing = TI()OC.WasPrinting;

			if (!TI()OC.Printing)
				{
				fclose(TI()OC.PrintFile);
				}
			}
#endif

		// trap it
		if (TI()CurrentUser->IsNode())
			{
			if (TI()netError)
				{
				Bool tmp2;

				sprintf(trapstr, getmsg(1094), TI()CurrentUser->GetName());

				tmp2 = cfg.trapit[T_NETWORK];

				if (TI()node->GetNetFail() > 0)
					{
					cfg.trapit[T_NETWORK] = TRUE;
					}
				else if (TI()node->GetNetFail() < 0)
					{
					cfg.trapit[T_NETWORK] = FALSE;
					}

				trap(trapstr, T_NETWORK);

				cfg.trapit[T_NETWORK] = tmp2;

				addStatusText(trapstr, time(NULL));
				}
			else
				{
				sprintf(trapstr, getmsg(1093), TI()CurrentUser->GetName());
				trap(trapstr, T_NETWORK);
				addStatusText(trapstr, time(NULL));
				}
			}
		else
			{
			doEvent(EVT_LOGOUT);

			sprintf(trapstr, getmsg(1092), TI()CurrentUser->GetName());
			trap(trapstr, T_LOGIN);
			}

		const int traptype = TI()CurrentUser->IsNode()
				? T_NETWORK : T_ACCOUNT;

		sprintf(trapstr, getmsg(1095), TI()MS.Entered);
		trap(trapstr, traptype);

		sprintf(trapstr, getmsg(1096), TI()MS.Read);
		trap(trapstr, traptype);

		if (TI()CurrentUser->IsNode())
			{
			sprintf(trapstr, getmsg(1097), TI()expired);
			trap(trapstr, T_NETWORK);

			sprintf(trapstr, getmsg(1098), TI()duplicate);
			trap(trapstr, T_NETWORK);
			}
		else if (cfg.accounting)	// There's just no accounting for nodes
			{
			sprintf(trapstr, getmsg(1099),
					TI()CurrentUserAccount->GetBalanceAtLogin() - balance);
			trap(trapstr, T_ACCOUNT);
			}

		if (TI()MS.AbortedMessage)
			{
			delete TI()MS.AbortedMessage;
			TI()MS.AbortedMessage = NULL;
			}
		}

	setdefaultconfig(FALSE);

	if (discon)
		{
		setdefaultTerm(2); // Ansi-CLR
		}
	else
		{
		setdefaultTerm(0); // TTY
		}

	TI()CurrentUser->SetCredits(discon ? 0L : cfg.unlogtimeout * 60L);
	StatusLine.Update();

	roomtalley();

	LoadCurrentRoom(LOBBY);
	TI()thisRoom = LOBBY;

	clearmsglist();
	clearFileQueue();
	TI()MS.AutoMark = FALSE;
	TI()MS.AutoKill = FALSE;
	TI()MS.AutoCensor = FALSE;
	TI()MS.MarkedID = 0L;

	freeNode(&TI()node);
	TI()netError = FALSE;	// just in case

	Cron.ResetTimer();
	}


// --------------------------------------------------------------------------
// setdefaultconfig(): Sets default new user configuration.

void setdefaultconfig(Bool keepAnsi)
	{
	const Bool oldANSI = TI()CurrentUser->IsIBMANSI();
	const Bool oldCOLOR = TI()CurrentUser->IsIBMColor();
	int oldATT[ATTR_NUM];

	oldATT[ATTR_NORMAL] 	= TI()CurrentUser->GetAttribute(ATTR_NORMAL);
	oldATT[ATTR_BLINK]		= TI()CurrentUser->GetAttribute(ATTR_BLINK);
	oldATT[ATTR_REVERSE]	= TI()CurrentUser->GetAttribute(ATTR_REVERSE);
	oldATT[ATTR_BOLD]		= TI()CurrentUser->GetAttribute(ATTR_BOLD);
	oldATT[ATTR_UNDERLINE]	= TI()CurrentUser->GetAttribute(ATTR_UNDERLINE);

	TI()prevChar = ' '; // why here?

	TI()CurrentUser->Clear();

	// set all default defaults...
	TI()CurrentUser->SetWidth(80);
	TI()CurrentUser->SetCredits(3600);

	TI()CurrentUser->SetLinefeeds(TRUE);
	TI()CurrentUser->SetOldToo(TRUE);
	TI()CurrentUser->SetNetUser(TRUE);
	TI()CurrentUser->SetViewRoomDesc(TRUE);
	TI()CurrentUser->SetEnterBorders(TRUE);
	TI()CurrentUser->SetViewTitleSurname(TRUE);
	TI()CurrentUser->SetViewSubjects(TRUE);
	TI()CurrentUser->SetViewSignatures(TRUE);
	TI()CurrentUser->SetMinibin(TRUE);
	TI()CurrentUser->SetViewRoomInfoLines(TRUE);
	TI()CurrentUser->SetViewHallDescription(TRUE);
	TI()CurrentUser->SetViewBorders(TRUE);

	if (!keepAnsi)
		{
		setdefaultcolors(); // bold, inverse, blink, underline
		}
	else
		{
		TI()CurrentUser->SetAttribute(ATTR_NORMAL,		oldATT[ATTR_NORMAL]);
		TI()CurrentUser->SetAttribute(ATTR_BLINK,		oldATT[ATTR_BLINK]);
		TI()CurrentUser->SetAttribute(ATTR_REVERSE, 	oldATT[ATTR_REVERSE]);
		TI()CurrentUser->SetAttribute(ATTR_BOLD,		oldATT[ATTR_BOLD]);
		TI()CurrentUser->SetAttribute(ATTR_UNDERLINE,	oldATT[ATTR_UNDERLINE]);
		}

	TI()CurrentUser->SetPromptFormat(cfg.prompt);			// "%n^A2%r%e"
	TI()CurrentUser->SetDateStamp(cfg.datestamp);			// "%x %X %p"
	TI()CurrentUser->SetVerboseDateStamp(cfg.vdatestamp);	// "%A %x %X %p"
	TI()CurrentUser->SetNetPrefix(cfg.netPrefix);			// "3*0"
	TI()CurrentUser->SetMorePrompt(cfg.moreprompt); 		// "<more>"

	if (!keepAnsi)
		{
		setdefaultTerm(0);	// TTY
		}

	if (cfg.accounting)
		{
		TI()CurrentUserAccount->Negotiate(TI()CurrentUser);
		}

	changedir(cfg.homepath);

	discardable *du = readData(8);
	if (du)
		{
		FILE *defusr;
		if ((defusr = fopen(citfiles[C_DEFUSER_CIT], FO_R)) != NULL)
			{
			const char **duk = (const char **) du->aux;
			char line[90];
			char *words[256];

			while (fgets(line, 90, defusr) != NULL)
				{
				if (line[0] != '#')
					{
					continue;
					}

				const int count = parse_it(words, line);

				if (count > 1)
					{
					for (int i = 0; i < DUK_NUM; i++)
						{
						if (SameString(words[0] + 1, duk[i]))
							{
							break;
							}
						}

					switch (i)
						{
						case DUK_FORWARD:
							{
							TI()CurrentUser->SetForwardAddr(words[1]);
							break;
							}

						case DUK_SURNAME:
							{
							TI()CurrentUser->SetSurname(words[1]);
							break;
							}

						case DUK_TITLE:
							{
							TI()CurrentUser->SetTitle(words[1]);
							break;
							}

						case DUK_BOLD:
							{
							TI()CurrentUser->SetAttribute(ATTR_BOLD, atoi(words[1]));
							break;
							}

						case DUK_NULLS:
							{
							TI()CurrentUser->SetNulls(atoi(words[1]));
							break;
							}

						case DUK_WIDTH:
							{
							TI()CurrentUser->SetWidth(atoi(words[1]));
							break;
							}

						case DUK_CREDITS:
							{
							TI()CurrentUser->SetCredits(60 * atol(words[1]));
							break;
							}

						case DUK_INVERSE:
							{
							TI()CurrentUser->SetAttribute(ATTR_REVERSE, atoi(words[1]));
							break;
							}

						case DUK_BLINK:
							{
							TI()CurrentUser->SetAttribute(ATTR_BLINK, atoi(words[1]));
							break;
							}

						case DUK_UNDERLINE:
							{
							TI()CurrentUser->SetAttribute(ATTR_UNDERLINE, atoi(words[1]));
							break;
							}

						case DUK_NORMAL:
							{
							TI()CurrentUser->SetAttribute(ATTR_NORMAL, atoi(words[1]));
							break;
							}

						case DUK_PROTOCOL:
							{
							TI()CurrentUser->SetDefaultProtocol(words[1][0]);
							break;
							}

						case DUK_PROMPT:
							{
							TI()CurrentUser->SetPromptFormat(words[1]);
							break;
							}

						case DUK_DSTAMP:
							{
							TI()CurrentUser->SetDateStamp(words[1]);
							break;
							}

						case DUK_VDSTAMP:
							{
							TI()CurrentUser->SetVerboseDateStamp(words[1]);
							break;
							}

						case DUK_SIGNATURE:
							{
							TI()CurrentUser->SetSignature(words[1]);
							break;
							}

						case DUK_NETPREFIX:
							{
							TI()CurrentUser->SetNetPrefix(words[1]);
							break;
							}

						case DUK_ADDR1:
							{
							TI()CurrentUser->SetMailAddr1(words[1]);
							break;
							}

						case DUK_ADDR2:
							{
							TI()CurrentUser->SetMailAddr2(words[1]);
							break;
							}

						case DUK_ADDR3:
							{
							TI()CurrentUser->SetMailAddr3(words[1]);
							break;
							}

						case DUK_POOP:
							{
							TI()CurrentUser->SetPoopcount(atol(words[1]));
							break;
							}

						case DUK_UCMASK:
							{
							TI()CurrentUser->SetUpperOnly(atoi(words[1]));
							break;
							}

						case DUK_EXPERT:
							{
							TI()CurrentUser->SetExpert(atoi(words[1]));
							break;
							}

						case DUK_AIDE:
							{
							TI()CurrentUser->SetAide(atoi(words[1]));
							break;
							}

						case DUK_TABS:
							{
							TI()CurrentUser->SetTabs(atoi(words[1]));
							break;
							}

						case DUK_OLDTOO:
							{
							TI()CurrentUser->SetOldToo(atoi(words[1]));
							break;
							}

						case DUK_UNLISTED:
							{
							TI()CurrentUser->SetUnlisted(atoi(words[1]));
							break;
							}

						case DUK_PERMANENT:
							{
							TI()CurrentUser->SetPermanent(atoi(words[1]));
							break;
							}

						case DUK_SYSOP:
							{
							TI()CurrentUser->SetSysop(atoi(words[1]));
							break;
							}

						case DUK_NODE:
							{
							TI()CurrentUser->SetNode(atoi(words[1]));
							break;
							}

						case DUK_NOACCOUNT:
							{
							TI()CurrentUser->SetAccounting(!atoi(words[1]));
							break;
							}

						case DUK_NOMAIL:
							{
							TI()CurrentUser->SetMail(!atoi(words[1]));
							break;
							}

						case DUK_ROOMTELL:
							{
							TI()CurrentUser->SetViewRoomDesc(atoi(words[1]));
							break;
							}

						case DUK_BORDERS:
							{
							TI()CurrentUser->SetEnterBorders(atoi(words[1]));
							break;
							}

						case DUK_VERIFIED:
							{
							TI()CurrentUser->SetVerified(!atoi(words[1]));
							break;
							}

						case DUK_SURNAMLOK:
							{
							TI()CurrentUser->SetSurnameLocked(atoi(words[1]));
							break;
							}

						case DUK_LOCKHALL:
							{
							TI()CurrentUser->SetDefaultHallLocked(atoi(words[1]));
							break;
							}

						case DUK_DISPLAYTS:
							{
							TI()CurrentUser->SetViewTitleSurname(atoi(words[1]));
							break;
							}

						case DUK_SUBJECTS:
							{
							TI()CurrentUser->SetViewSubjects(atoi(words[1]));
							break;
							}

						case DUK_SIGNATURES:
							{
							TI()CurrentUser->SetViewSignatures(atoi(words[1]));
							break;
							}

						case DUK_DEFAULTHALL:
							{
							TI()CurrentUser->SetDefaultHall(words[1]);
							break;
							}

						case DUK_LINESSCREEN:
							{
							TI()CurrentUser->SetLinesPerScreen(atoi(words[1]));
							break;
							}

						case DUK_FORWARDNODE:
							{
							TI()CurrentUser->SetForwardAddrNode(words[1]);

							if (*words[1])
								{
								TI()CurrentUser->SetForwardToNode(TRUE);
								}

							break;
							}

						case DUK_LFMASK:
							{
							TI()CurrentUser->SetLinefeeds(atoi(words[1]));
							break;
							}

						case DUK_PROBLEM:
							{
							TI()CurrentUser->SetProblem(atoi(words[1]));
							break;
							}

						case DUK_NETUSER:
							{
							TI()CurrentUser->SetNetUser(atoi(words[1]));
							break;
							}

						case DUK_NEXTHALL:
							{
							TI()CurrentUser->SetAutoNextHall(atoi(words[1]));
							break;
							}

						case DUK_PSYCHO:
							{
							TI()CurrentUser->SetPsycho(atoi(words[1]));
							break;
							}

						case DUK_IBMGRAPH:
							{
							TI()CurrentUser->SetIBMGraph(atoi(words[1]));
							break;
							}

						case DUK_IBMANSI:
							{
							TI()CurrentUser->SetIBMANSI(atoi(words[1]));
							break;
							}

						case DUK_IBMCOLOR:
							{
							TI()CurrentUser->SetIBMColor(atoi(words[1]));
							break;
							}

						case DUK_TWIRLY:
							{
							TI()CurrentUser->SetTwirly(atoi(words[1]));
							break;
							}

						case DUK_VERBOSE:
							{
							TI()CurrentUser->SetAutoVerbose(atoi(words[1]));
							break;
							}

						case DUK_MSGPAUSE:
							{
							TI()CurrentUser->SetPauseBetweenMessages(atoi(words[1]));
							break;
							}

						case DUK_MINIBIN:
							{
							TI()CurrentUser->SetMinibin(atoi(words[1]));
							break;
							}

						case DUK_MSGCLS:
							{
							TI()CurrentUser->SetClearScreenBetweenMessages(atoi(words[1]));
							break;
							}

						case DUK_ROOMINFO:
							{
							TI()CurrentUser->SetViewRoomInfoLines(atoi(words[1]));
							break;
							}

						case DUK_HALLTELL:
							{
							TI()CurrentUser->SetViewHallDescription(atoi(words[1]));
							break;
							}

						case DUK_VERBOSECONT:
							{
							TI()CurrentUser->SetVerboseContinue(atoi(words[1]));
							break;
							}

						case DUK_VIEWCENSOR:
							{
							TI()CurrentUser->SetViewCensoredMessages(atoi(words[1]));
							break;
							}

						case DUK_SEEBORDERS:
							{
							TI()CurrentUser->SetViewBorders(atoi(words[1]));
							break;
							}

						case DUK_OUT300:
							{
							TI()CurrentUser->SetOut300(atoi(words[1]));
							break;
							}

						case DUK_LOCKUSIG:
							{
							TI()CurrentUser->SetUserSignatureLocked(atoi(words[1]));
							break;
							}

						case DUK_HIDEEXCL:
							{
							TI()CurrentUser->SetHideMessageExclusions(atoi(words[1]));
							break;
							}

						case DUK_NODOWNLOAD:
							{
							TI()CurrentUser->SetDownload(!atoi(words[1]));
							break;
							}

						case DUK_NOUPLOAD:
							{
							TI()CurrentUser->SetUpload(!atoi(words[1]));
							break;
							}

						case DUK_NOCHAT:
							{
							TI()CurrentUser->SetChat(!atoi(words[1]));
							break;
							}

						case DUK_PRINTFILE:
							{
							TI()CurrentUser->SetPrintFile(atoi(words[1]));
							break;
							}

						case DUK_REALNAME:
							{
							TI()CurrentUser->SetRealName(words[1]);
							break;
							}

						case DUK_PHONENUM:
							{
							TI()CurrentUser->SetPhoneNumber(words[1]);
							break;
							}

						case DUK_SPELLCHECK:
							{
							TI()CurrentUser->SetSpellCheckMode(atoi(words[1]));
							break;
							}

						case DUK_NOMAKEROOM:
							{
							TI()CurrentUser->SetMakeRoom(!atoi(words[1]));
							break;
							}

						case DUK_VERBOSELO:
							{
							TI()CurrentUser->SetVerboseLogOut(atoi(words[1]));
							break;
							}

						case DUK_CONFSAVE:
							{
							TI()CurrentUser->SetConfirmSave(atoi(words[1]));
							break;
							}

						case DUK_CONFABORT:
							{
							TI()CurrentUser->SetConfirmAbort(atoi(words[1]));
							break;
							}

						case DUK_CONFEOABORT:
							{
							TI()CurrentUser->SetConfirmNoEO(atoi(words[1]));
							break;
							}

						case DUK_USEPERSONAL:
							{
							TI()CurrentUser->SetUsePersonalHall(atoi(words[1]));
							break;
							}

						case DUK_YOUAREHERE:
							{
							TI()CurrentUser->SetYouAreHere(atoi(words[1]));
							break;
							}

						case DUK_IBMROOM:
							{
							TI()CurrentUser->SetIBMRoom(atoi(words[1]));
							break;
							}

						case DUK_WIDEROOM:
							{
							TI()CurrentUser->SetWideRoom(atoi(words[1]));
							break;
							}

						case DUK_MUSIC:
							{
							TI()CurrentUser->SetMusic(atoi(words[1]));
							break;
							}

						case DUK_MOREPROMPT:
							{
							TI()CurrentUser->SetMorePrompt(words[1]);
							break;
							}

						case DUK_NUMUSERSHOW:
							{
							TI()CurrentUser->SetNumUserShow(atoi(words[1]));
							break;
							}

						case DUK_CALLLIMIT:
							{
							TI()CurrentUser->SetCallLimit(atoi(words[1]));
							break;
							}

						case DUK_CHECKAPS:
							{
							TI()CurrentUser->SetCheckApostropheS(atoi(words[1]));
							break;
							}

						case DUK_CHECKALLCAPS:
							{
							TI()CurrentUser->SetCheckAllCaps(atoi(words[1]));
							break;
							}

						case DUK_CHECKDIGITS:
							{
							TI()CurrentUser->SetCheckDigits(atoi(words[1]));
							break;
							}

						case DUK_EXCLUDEENCRYPTED:
							{
							TI()CurrentUser->SetExcludeEncryptedMessages(atoi(words[1]));
							break;
							}

						case DUK_SHOWCOMMAS:
							{
							TI()CurrentUser->SetViewCommas(atoi(words[1]));
							break;
							}

						case DUK_PUNPAUSES:
							{
							TI()CurrentUser->SetPUnPauses(atoi(words[1]));
							break;
							}

						case DUK_KUSER:
							{
							TI()CurrentUser->AddKillUser(words[1]);
							break;
							}

						case DUK_KTEXT:
							{
							TI()CurrentUser->AddKillText(words[1]);
							break;
							}

						case DUK_KNODE:
							{
							TI()CurrentUser->AddKillNode(words[1]);
							break;
							}

						case DUK_KREG:
							{
							TI()CurrentUser->AddKillRegion(words[1]);
							break;
							}

						case DUK_TUSER:
							{
							if (count > 2)
								{
								TI()CurrentUser->AddTagUser(words[1], words[2]);
								}

							break;
							}

						case DUK_DICTWORD:
							{
							TI()CurrentUser->AddWordToDictionary(words[1]);
							break;
							}

						case DUK_FINGER:
							{
							TI()CurrentUser->SetFinger(words[1]);
							break;
							}

						case DUK_USERDEF:
							{
							if (count > 2)
								{
								TI()CurrentUser->SetUserDefined(words[1], words[2]);
								}

							break;
							}

						case DUK_REPLACE:
							{
							if (count > 2)
								{
								TI()CurrentUser->AddReplace(words[1], words[2]);
								}

							break;
							}

						case DUK_ROMAN:
							{
							TI()CurrentUser->SetRoman(atoi(words[1]));
							break;
							}

						default:
							{
							doccr();
							cPrintf(getmsg(21), citfiles[C_DEFUSER_CIT], words[0]);
							doccr();
							break;
							}
						}
					}
				}

			fclose(defusr);
			}

		discardData(du);
		}

	if (keepAnsi)
		{
		TI()CurrentUser->SetIBMANSI(oldANSI);
		TI()CurrentUser->SetIBMColor(oldCOLOR);
		}
	}
