#include "ctdl.h"
#pragma hdrstop

#include "net.h"
#include "log.h"
#include "room.h"
#include "msg.h"

void LogExtensions::ClearMessage(void)
	{
	assert(this);
	delete Msg;
	Msg = NULL;
	}

void LogExtensions::Clear(void)
	{
	assert(this);
	VerifyHeap();

	disposeLL((void **) &le_kuser);
	disposeLL((void **) &le_knode);
	disposeLL((void **) &le_ktext);
	disposeLL((void **) &le_kreg);
	disposeLL((void **) &le_tuser);
	disposeLL((void **) &le_replace);
	disposeLL((void **) &le_dict);
	disposeLL((void **) &le_userdef);
	delete [] le_Finger;
	delete Msg;
	le_Finger = NULL;
	Msg = NULL;
	jb_start = jb_end = 0;

	VerifyHeap();
	}

void LogExtensions::SetMessage(Message *NewMsg)
	{
	assert(this);

	if (Msg)
		{
		delete Msg;
		}

	if (NewMsg)
		{
		Msg = new Message;

		if (Msg)
			{
			*Msg = *NewMsg;
			}
		}
	else
		{
		Msg = NULL;
		}
	}

Bool LogExtensions::IsWordInDictionary(const char *Word) const
	{
	assert(this);
	strList *userDict;

	for (userDict = le_dict; userDict;
			userDict = (strList *) getNextLL(userDict))
		{
		if (SameString(Word, userDict->string))
			{
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::RemoveUserTag(const char *User)
	{
	assert(this);
	int i;
	pairedStrings *theTag;

	for (i = 1, theTag = le_tuser; theTag;
			theTag = (pairedStrings *) getNextLL(theTag), i++)
		{
		if (SameString(theTag->string1, User))
			{
			deleteLLNode((void **) &le_tuser, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::RemoveReplace(const char *User)
	{
	assert(this);
	int i;
	pairedStrings *theRepl;

	for (i = 1, theRepl = le_replace; theRepl;
			theRepl = (pairedStrings *) getNextLL(theRepl), i++)
		{
		if (SameString(theRepl->string1, User))
			{
			deleteLLNode((void **) &le_replace, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::RemoveWordFromDictionary(const char *Word)
	{
	assert(this);
	int i;
	strList *theStr;

	for (i = 1, theStr = le_dict; theStr;
			theStr = (strList *) getNextLL(theStr), i++)
		{
		if (SameString(theStr->string, Word))
			{
			deleteLLNode((void **) &le_dict, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

LogExtensions& LogExtensions::operator =(const LogExtensions &Original)
	{
	assert(this);
	VerifyHeap();

	Clear();

	strcpy(FileExtension, Original.FileExtension);
	jb_start = Original.jb_start;
	jb_end = Original.jb_end;
	jb_length = Original.jb_length;

	VerifyHeap();

	if (jb)
		{
		delete [] jb;
		jb = NULL;
		}

	if (Original.Msg)
		{
		Msg = new Message;

		if (Msg)
			{
			*Msg = *Original.Msg;
			}
		}

	VerifyHeap();

	if (Original.jb)
		{
		jb = new jumpback[jb_length];

		if (jb)
			{
			memcpy(jb, Original.jb, sizeof(jumpback) * jb_length);
			}
		}

	if (Original.le_Finger)
		{
		le_Finger = strdup(Original.le_Finger);
		}

	VerifyHeap();

	strList *theStr;

	for (theStr = Original.le_kuser; theStr;
			theStr = (strList *) getNextLL(theStr))
		{
		AddKillUser(theStr->string);
		}

	for (theStr = Original.le_knode; theStr;
			theStr = (strList *) getNextLL(theStr))
		{
		AddKillNode(theStr->string);
		}

	for (theStr = Original.le_ktext; theStr;
			theStr = (strList *) getNextLL(theStr))
		{
		AddKillText(theStr->string);
		}

	for (theStr = Original.le_kreg; theStr;
			theStr = (strList *) getNextLL(theStr))
		{
		AddKillRegion(theStr->string);
		}

	for (theStr = Original.le_dict; theStr;
			theStr = (strList *) getNextLL(theStr))
		{
		AddWordToDictionary(theStr->string);
		}

	pairedStrings *thePair;

	for (thePair = Original.le_tuser; thePair;
			thePair = (pairedStrings *) getNextLL(thePair))
		{
		AddTagUser(thePair->string1, thePair->string2);
		}

	for (thePair = Original.le_replace; thePair;
			thePair = (pairedStrings *) getNextLL(thePair))
		{
		AddReplace(thePair->string1, thePair->string2);
		}

	for (userDefLE *theUserDef = Original.le_userdef; theUserDef;
			theUserDef = (userDefLE *) getNextLL(theUserDef))
		{
		SetUserDefined(theUserDef->Code, theUserDef->Data);
		}

	return (*this);
	}

LogExtensions::LogExtensions(const LogExtensions &Original)
	{
	assert(this);

	memset(this, 0, sizeof(*this));

	*this = Original;
	}

Bool LogExtensions::AddKillUser(const char *User)
	{
	assert(this);
	assert(User);

	if (*User)
		{
		if (IsKillUser(User))
			{
			return (TRUE);
			}
		else
			{
			strList *theStrLL = (strList *) addLL((void **) &le_kuser,
					sizeof(*theStrLL) + strlen(User));

			if (theStrLL)
				{
				strcpy(theStrLL->string, User);
				return (TRUE);
				}
			}
		}

	return (FALSE);
	}

Bool LogExtensions::RemoveKillUser(const char *User)
	{
	assert(this);
	assert(User);

	long i;
	strList *theStr;

	for (i = 1, theStr = le_kuser; theStr; 
			theStr = (strList *) getNextLL(theStr), i++)
		{
		if (SameString(theStr->string, User))
			{
			deleteLLNode((void **) &le_kuser, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::AddKillNode(const char *Node)
	{
	assert(this);
	assert(Node);

	if (*Node)
		{
		if (IsKillNode(Node))
			{
			return (TRUE);
			}
		else
			{
			strList *theStrLL = (strList *) addLL((void **) &le_knode,
					sizeof(*theStrLL) + strlen(Node));

			if (theStrLL)
				{
				strcpy(theStrLL->string, Node);
				return (TRUE);
				}
			}
		}

	return (FALSE);
	}

Bool LogExtensions::RemoveKillNode(const char *Node)
	{
	assert(this);
	assert(Node);

	long i;
	strList *theStr;

	for (i = 1, theStr = le_knode; theStr; 
			theStr = (strList *) getNextLL(theStr), i++)
		{
		if (SameString(theStr->string, Node))
			{
			deleteLLNode((void **) &le_knode, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::AddKillText(const char *Text)
	{
	assert(this);
	assert(Text);

	if (*Text)
		{
		if (IsKillText(Text))
			{
			return (TRUE);
			}
		else
			{
			strList *theStrLL = (strList *) addLL((void **) &le_ktext,
					sizeof(*theStrLL) + strlen(Text));

			if (theStrLL)
				{
				strcpy(theStrLL->string, Text);
				return (TRUE);
				}
			}
		}

	return (FALSE);
	}

Bool LogExtensions::RemoveKillText(const char *Text)
	{
	assert(this);
	assert(Text);

	long i;
	strList *theStr;

	for (i = 1, theStr = le_ktext; theStr; 
			theStr = (strList *) getNextLL(theStr), i++)
		{
		if (SameString(theStr->string, Text))
			{
			deleteLLNode((void **) &le_ktext, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::AddKillRegion(const char *Region)
	{
	assert(this);
	assert(Region);

	if (*Region)
		{
		if (IsKillRegion(Region))
			{
			return (TRUE);
			}
		else
			{
			strList *theStrLL = (strList *) addLL((void **) &le_kreg,
					sizeof(*theStrLL) + strlen(Region));

			if (theStrLL)
				{
				strcpy(theStrLL->string, Region);
				return (TRUE);
				}
			}
		}

	return (FALSE);
	}

Bool LogExtensions::RemoveKillRegion(const char *Region)
	{
	assert(this);
	assert(Region);

	long i;
	strList *theStr;

	for (i = 1, theStr = le_kreg; theStr; 
			theStr = (strList *) getNextLL(theStr), i++)
		{
		if (SameString(theStr->string, Region))
			{
			deleteLLNode((void **) &le_kreg, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::AddTagUser(const char *User, const char *Tag)
	{
	assert(this);
	assert(User);
	assert(Tag);

	if (*User && *Tag)
		{
		pairedStrings *theTag = (pairedStrings *) addLL((void **) &le_tuser,
				sizeof(*theTag));

		if (theTag)
			{
			CopyStringToBuffer(theTag->string1, User, LABELSIZE);
			CopyStringToBuffer(theTag->string2, Tag, LABELSIZE);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::AddReplace(const char *Orig, const char *Repl)
	{
	assert(this);
	assert(Orig);
	assert(Repl);

	if (*Orig && *Repl)
		{
		pairedStrings *theRepl = (pairedStrings *) addLL((void **) &le_replace,
				sizeof(*theRepl));

		if (theRepl)
			{
			CopyStringToBuffer(theRepl->string1, Orig, LABELSIZE);
			CopyStringToBuffer(theRepl->string2, Repl, LABELSIZE);
			return (TRUE);
			}
		}

	return (FALSE);
	}

Bool LogExtensions::AddWordToDictionary(const char *Word)
	{
	assert(this);
	assert(Word);

	if (*Word)
		{
		if (IsWordInDictionary(Word))
			{
			return (TRUE);
			}
		else
			{
			strList *theStrLL = (strList *) addLL((void **) &le_dict,
					sizeof(*theStrLL) + strlen(Word));

			if (theStrLL)
				{
				strcpy(theStrLL->string, Word);
				strupr(theStrLL->string);
				return (TRUE);
				}
			}
		}

	return (FALSE);
	}

Bool LogExtensions::SetUserDefined(const char *Code, const char *Data)
	{
	assert(this);
	assert(Code);
	assert(Data);

	RemoveUserDefined(Code);

	userDefLE *NewDefined = (userDefLE *) addLL((void **) &le_userdef,
			sizeof(userDefLE) + strlen(Data));

	if (NewDefined)
		{
		CopyStringToBuffer(NewDefined->Code, Code, LABELSIZE);
		strcpy(NewDefined->Data, Data);
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
	}

Bool LogExtensions::RemoveUserDefined(const char *Code)
	{
	assert(this);
	assert(Code);

	long i;
	userDefLE *theDef;

	for (i = 1, theDef = le_userdef; theDef; 
			theDef = (userDefLE *) getNextLL(theDef), i++)
		{
		if (SameString(theDef->Code, Code))
			{
			deleteLLNode((void **) &le_userdef, i);
			return (TRUE);
			}
		}

	return (FALSE);
	}

const char *LogExtensions::GetUserDefined(const char *Code) const
	{
	assert(this);
	assert(Code);

	userDefLE *theDef;

	for (theDef = le_userdef; theDef; theDef = (userDefLE *) 
			getNextLL(theDef))
		{
		if (SameString(theDef->Code, Code))
			{
			return (theDef->Data);
			}
		}

	return (NULL);
	}

Bool LogExtensions::IsUserDefined(const char *Code) const
	{
	assert(this);
	assert(Code);

	userDefLE *theDef;

	for (theDef = le_userdef; theDef; theDef = (userDefLE *) 
			getNextLL(theDef))
		{
		if (SameString(theDef->Code, Code))
			{
			return (TRUE);
			}
		}

	return (FALSE);
	}
