// --------------------------------------------------------------------------
// Citadel: LogEdit.CPP
//
// Userlog edit code.

#include "ctdl.h"
#pragma hdrstop

#include "log.h"
#include "room.h"
#include "net.h"
#include "hall.h"
#include "tallybuf.h"
#include "term.h"


// --------------------------------------------------------------------------
// Contents
//
// userEdit()			Edit a user via menu


// --------------------------------------------------------------------------
// userEdit(): Edit a user via menu.

void userEdit(void)
	{
	label who;
	l_slot logslot;

	SetDoWhat(SYSEDIT);

	do
		{
		getString(getmsg(599), who, LABELSIZE, TRUE, ECHO,
				TI()loggedIn ? TI()CurrentUser->GetName() : ns);

		if (*who == '?')
			{
			ListUsers(TI()CurrentUser->IsAide());
			}
		} while (*who == '?');

	normalizeString(who);

	if (!*who)
		{
		return;
		}

	logslot = FindPersonByPartialName(who);

	if (logslot == CERROR)
		{
		CRmPrintfCR(getmsg(595), who);
		}
	else
		{
		Bool editSelf = FALSE;

		LogEntry EditLog(cfg.maxrooms, cfg.maxgroups, cfg.maxjumpback);
		l_index logNo = LogTab->GetEntry(logslot)->GetLogIndex();

		if (SameString(LogTab->GetEntry(logslot)->GetName(),
				TI()CurrentUser->GetName()))
			{
			editSelf = TRUE;
			storeLog();
			}

		if (EditLog.Load(logNo))
			{
			CRmPrintf(getsysmsg(350), EditLog.GetName());

			DoUserlogEdit(&EditLog, logNo);

			if (editSelf)
				{
				if (!TI()CurrentUser->Load(logNo))
					{
					mPrintfCR(getmsg(709));
					}

				roomtalley();
				setlogTerm();	// ??
				}

			// trap it
			char trapstr[256];
			sprintf(trapstr, getsysmsg(154), EditLog.GetName());

			if (EditLog.IsSysop())
				{
				strcat(trapstr, getsysmsg(155));
				}

			if (EditLog.IsAide())
				{
				strcat(trapstr, getsysmsg(156));
				}

			if (EditLog.IsNode())
				{
				strcat(trapstr, getsysmsg(157));
				}

			if (cfg.accounting)
				{
				if (!EditLog.IsAccounting())
					{
					strcat(trapstr, getsysmsg(158));
					}
				else
					{
					label temp;

					long C = EditLog.GetCredits() / 60;

					sprintf(temp, getmsg(1455), ltoac(C), (C == 1) ?
							cfg.Lcredit_nym : cfg.Lcredits_nym);

					strcat(trapstr, temp);
					}
				}

			if (EditLog.IsPermanent())	strcat(trapstr, getsysmsg(159));
			if (EditLog.IsNetUser())	strcat(trapstr, getsysmsg(160));
			if (EditLog.IsProblem())	strcat(trapstr, getsysmsg(161));
			if (!EditLog.IsMail())		strcat(trapstr, getsysmsg(162));
			if (!EditLog.IsVerified())	strcat(trapstr, getsysmsg(163));

			trap(trapstr, T_SYSOP);
			}
		}
	}
