// access to log stuff

#include "ctdl.h"
#pragma hdrstop

#include "log.h"
#include "room.h"

// overrides LOG2.H's function; adds #SYSOP checking to it.
Bool LogEntry::IsInGroup(g_slot GroupSlot) const
	{
	if (
			// really in group
			LogEntry2::IsInGroup(GroupSlot) ||

			// or #SYSOP
			IsMainSysop()
		)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
	}

Bool LogEntry::IsValid(void) const
	{
	if (LogEntry2::IsValid() && LogEntry3::IsValid() &&
			LogEntry4::IsValid() && LogEntry5::IsValid() &&
			LogEntry6::IsValid())
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
	}

void LogEntry::Clear(void)
	{
	VerifyHeap();
	LogEntry1::Clear();
	LogEntry2::Clear();
	LogEntry3::Clear();
	LogEntry4::Clear();
	LogEntry5::Clear();
	LogEntry6::Clear();
	LogExtensions::Clear();
	VerifyHeap();
	}

void LogTable::UpdateTable(const LogEntry1 *Entry, l_index Index)
	{
	l_slot Slot;

	for (Slot = 0; Slot < TableSize; Slot++)
		{
		if (LogTab->GetEntry(Slot)->GetLogIndex() == Index)
			{
			log2tab(LogTab->GetEntry(Slot), Entry, Index);
			break;
			}
		}
	}

void LogTable::SlideTableDown(l_slot HowFar)
	{
	assert(HowFar >= 0);
	assert(HowFar < TableSize);

	if (IsValid())
		{
		l_slot i;

		for (i = HowFar; i > 0; i--)
			{
			Table[i] = Table[i - 1];
			}
		}
	}
