/* -------------------------------------------------------------------- */
/*	This class defines the contents of LOG2.DAT for each user. It		*/
/*	specifies which groups a user is in. See LOG.H for an explanation	*/
/*	of the LogBitBag class, which is used to store this information.	*/
/*	The only two reasons we derive this class are to give it a default	*/
/*	file name for storage on disk, and so we can use nicely-named		*/
/*	functions for access.												*/
/*	Also a "smart" Clear() function...									*/
/* -------------------------------------------------------------------- */
class LogEntry2 : public LogBitBag
	{
public:
	LogEntry2(r_slot NumRooms) : LogBitBag(NumRooms)
		{
		ResetFileName();
		}

	void ResetFileName(void)
		{
		assert(this);
		SetFileName(log2Dat);
		}

	Bool IsInGroup(g_slot GroupSlot) const
		{
		return (BitTest(GroupSlot));
		}

	void SetInGroup(g_slot GroupSlot, Bool InGroup)
		{
		BitSet(GroupSlot, InGroup);
		}

	void Clear(void);
	};
