// --------------------------------------------------------------------------
// Citadel: Log2.CPP
//
// User create and kill code

#include "ctdl.h"
#pragma hdrstop

#include "log.h"

// --------------------------------------------------------------------------
// Contents
//
// purgeuserlog()	From oldest to newest, prompt to kill each entry
// killuser()		sysop special to kill a log entry


// --------------------------------------------------------------------------
// purgeuserlog(): From oldest to newest, prompt to kill each entry.

void purgeuserlog(void)
	{
	l_slot i;
	Bool done = FALSE;

	for (i = cfg.MAXLOGTAB - 1; i >= 0 && !done; i--)
		{
		if (LogTab->GetEntry(i)->IsInuse())
			{
			label UserName;
			CopyStringToBuffer(UserName, LogTab->GetEntry(i)->GetName(),
					LABELSIZE);

			if (!TI()loggedIn ||
					!SameString(TI()CurrentUser->GetName(), UserName))
				{
				char prompt[256];

				sprintf(prompt, getmsg(1241), cfg.Luser_nym, UserName);

				const int response = getYesNo(prompt, 3);

				if (response == 1)
					{
					LogEntry1 Log1;

					Log1.Clear();

					if (Log1.Save(LogTab->GetEntry(i)->GetLogIndex()))
						{
						sprintf(prompt, getsysmsg(86), UserName);
						trap(prompt, T_SYSOP);
						}
					}
				else if (response == 2)
					{
					done = TRUE;
					}
				}
			}
		}
	}

/* -------------------------------------------------------------------- */
/*	killuser()		sysop special to kill a log entry					*/
/* -------------------------------------------------------------------- */
Bool killuser(const char *name)
	{
	label who;
	l_slot logno;
	char line[80];

	if (!name)
		{
		SetDoWhat(SYSKUSER);
		}

	if (name)
		{
		CopyStringToBuffer(who, name, LABELSIZE);
		}
	else
		{
		getNormStr(getmsg(599), who, LABELSIZE, ECHO);
		}

	if (!*who)
		{
		return (FALSE);
		}

	logno = FindPersonByPartialName(who);

	if (logno == CERROR)
		{
		if (!name)
			{
			mPrintfCR(getmsg(595), who);
			}

		return (FALSE);
		}

	CopyStringToBuffer(who, LogTab->GetEntry(logno)->GetName(), LABELSIZE);

	if (TI()loggedIn && SameString(TI()CurrentUser->GetName(), who))
		{
		if (!name)
			{
			mPrintfCR(getsysmsg(83));
			}

		return (FALSE);
		}

	sprintf(line, getsysmsg(84), cfg.Luser_nym, who);

	if (!name && !getYesNo(line, 0))
		{
		return (FALSE);
		}
	else
		{
		char trapstr[256];
		LogEntry1 Log1;

		if (!name)
			{
			CRmPrintfCR(getsysmsg(85), who);
			}

		Log1.Clear();
		if (Log1.Save(LogTab->GetEntry(logno)->GetLogIndex()))
			{
			sprintf(trapstr, getsysmsg(86), who);
			trap(trapstr, T_SYSOP);
			}

		return (TRUE);
		}
	}
