/* -------------------------------------------------------------------- */
/*	This is most of the information we know about each user. This is	*/
/*	stored in LOG.DAT. See also LOG2.H, LOG3.H, LOG4.H, LOG5.H, and 	*/
/*	LOG6.H for the classes used to create LOG2.DAT, LOG3.DAT, LOG4.DAT, */
/*	LOG5.DAT, and LOG6.DAT. Citadel also keeps an index to LOG.DAT for	*/
/*	quick access to data it needs often about users. The structure of	*/
/*	this index is in LOGTAB.H.											*/
/* -------------------------------------------------------------------- */

enum SexE
	{
	SEX_UNKNOWN,	SEX_MALE,		SEX_FEMALE,
	};

// This is separate from LogEntry1 so we can clear it quickly by just doing
// a memset() on it. Because LogStarter has a virtual function, doing a
// memset() on LogEntry1 overwrites the function pointer to it.
class LogEntry1Data
	{
	label	Name;					// caller's name
	label	Initials;				// caller's initials
	label	Password;				// caller's password
	label	Surname;				// users surname
	label	Title;					// users title
	label	RealName;				// Caller's real name.
	label	PhoneNumber;			// Caller's phone number.

	label	ForwardAddr;			// forwarding address (user)
	label	ForwardAddrNode;		// forwarding address (node) or xxx.xxxx
	label	ForwardAddrRegion;		// forwarding address (region)

	char	PromptFormat[64];		// prompt format string
	char	DateStamp[64];			// time/date format string
	char	VerboseDateStamp[64];	// time/date format string
	char	Signature[91];			// user's signature line
	label	NetPrefix;				// Prefix for networked rooms
	label	MailAddr1;				// Mailing address...
	label	MailAddr2;				// Mailing address...
	label	MailAddr3;				// Mailing address...
	char	Alias[4];				// ALIAS.LOCID.PLANET
	char	LocID[5];
	char	MorePrompt[80]; 		// User configurable more prompt
	label	Occupation; 			// What you do.
	char	WhereHear[80];			// Where did you hear about us?

	label	LastRoom;				// room they were in last call
	label	LastHall;				// hall they were in last call
	label	DefaultRoom;			// default room
	label	DefaultHall;			// default hall

	char	PAD1;

	long	BirthDate;				// midnight of birthdate
	long	FirstOn;				// first time on the system
	SexE	Sex;					// Oh so very sexy

	int 	Nulls;					// #Nulls
	int 	Width;					// terminal width
	int 	LinesPerScreen; 		// the number of lines per screen
	int 	attributes[5];			// bold, inverse, blink, underline

	int 	NumUserShow;			// # users to show on login
	char	DefaultProtocol;		// Default protocol

	char	PAD2;

	time_t	CallTime;				// Time/date stamp of last call
	ulong	CallNumber; 			// Which caller # they were
	time_t	TotalTime;				// Total seconds on the system.
	long	Credits;				// Credits for accounting
	long	Logins; 				// How many times.
	long	Posted; 				// Number of messages posted.
	long	Read;					// Number of messages read.
	time_t	PasswordChangeTime; 	// The last time the PW was changed.
	int 	CallsToday; 			// Number of calls today (mid-mid).
	int 	CallLimit;				// Number of calls allowed per day

	ulong	LastMessage;			// newest message on system last call

	ulong	DL_Bytes;
	ulong	UL_Bytes;
	uint	DL_Num;
	uint	UL_Num;

	long	Poopcount;				// How many times have they pooped?

	Bool	DUNGEONED	: 1;		// dungeoned user?
	Bool	FORtOnODE	: 1;		// forward to node?
	Bool	NEXTHALL	: 1;		// Auto Next Hall?
	Bool	BORDERS 	: 1;		// Can they enter borders
	Bool	UNVERIFIED	: 1;		// has the user been verified?
	Bool	SURNAMLOK	: 1;		// surname locked?
	Bool	LOCKHALL	: 1;		// lock default hall
	Bool	PSYCHO		: 1;		// make life a pain in the ass for him
	Bool	DISPLAYTS	: 1;		// display titles/surnames?
	Bool	SUBJECTS	: 1;		// display subjects?
	Bool	SIGNATURES	: 1;		// display signatures?
	Bool	IBMGRAPH	: 1;		// Terminal : IBM graphics characters?
	Bool	IBMANSI 	: 1;		// Terminal : IBM ansi enabled?
	Bool	IBMCOLOR	: 1;		// Terminal : ISO-Color?
	Bool	TWIRLY		: 1;		// twirling cursor at prompts?
	Bool	VERBOSE 	: 1;		// Auto-verbose flag?
	Bool	MSGPAUSE	: 1;		// Pause after each message.
	Bool	MINIBIN 	: 1;		// MiniBin login stats?
	Bool	MSGCLS		: 1;		// Clear screen after message?
	Bool	ROOMINFO	: 1;		// Display room info lines?
	Bool	HALLTELL	: 1;		// Display hall descriptions?
	Bool	VERBOSECONT : 1;		// continue in the icky verbose way?
	Bool	VIEWCENSOR	: 1;		// View censored messages?
	Bool	SEEBORDERS	: 1;		// Can they see borders?
	Bool	OUT300		: 1;		// simulate 300 baud output
	Bool	LOCKUSIG	: 1;		// user signature locked?
	Bool	HIDEEXCL	: 1;		// hide msg exclusion?
	Bool	NODOWNLOAD	: 1;		// user cannot download
	Bool	NOUPLOAD	: 1;		// user cannot upload
	Bool	NOCHAT		: 1;		// user cannot chat?
	Bool	PRINTFILE	: 1;		// turn on printfile when user logs in?
	uint	spellCheck	: 2;		// how the user likes to spell check
	Bool	NOMAKEROOM	: 1;		// if user cannot .ER
	Bool	VERBOSELO	: 1;		// do it verbosely...
	Bool	CONFIRMSAVE : 1;		// confirm save from msg editor?
	Bool	NOCONFABORT : 1;		// don't confirm abort from msg editor
	Bool	CONFIRMNOEO : 1;		// confirm not .EO after abort
	Bool	USEPERSONAL : 1;		// Use personal hall?
	Bool	YOUAREHERE	: 1;		// Dargos is such a God.
	Bool	IBMROOM 	: 1;		// Fred is a genius. Centauri, too.
	Bool	WIDEROOM	: 1;		// ...
	Bool	MUSIC		: 1;		// user can hear it?
	Bool	CHECKAPS	: 1;		// check 'S in spell checker
	Bool	CHECKALLCAP : 1;		// check all caps in spell checker
	Bool	CHECKDIGITS : 1;		// check digits in spell checker
	Bool	EXCLUDECRYPT: 1;		// Exclude encrypted messages.
	Bool	HIDECOMMAS	: 1;		// how's this for user-configurability?
	Bool	PUNPAUSES	: 1;		// Some people acutally want it to...
	Bool	ROMAN		: 1;		// Ho ho ho.
	Bool	UNUSED5 	: 12;		// ...

public:
	void Clear(void)
		{
		VerifyHeap();
		memset(this, 0, sizeof(*this));
		Width = 80;
		VerifyHeap();
		}

	LogEntry1Data(void)
		{
		Clear();
		}

	void Verify(void);

	const char *GetName(void) const
		{
		return (*Name ? Name : getmsg(529));
		}

	void SetName(const char *New)
		{
		CopyStringToBuffer(Name, New, LABELSIZE);
		}

	const char *GetInitials(void) const
		{
		return (Initials);
		}

	void SetInitials(const char *New)
		{
		CopyStringToBuffer(Initials, New, LABELSIZE);
		}

	const char *GetPassword(void) const
		{
		return (Password);
		}

	void SetPassword(const char *New)
		{
		CopyStringToBuffer(Password, New, LABELSIZE);
		}

	const char *GetSurname(void) const
		{
		return (Surname);
		}

	void SetSurname(const char *New)
		{
		CopyStringToBuffer(Surname, New, LABELSIZE);
		}

	const char *GetTitle(void) const
		{
		return (Title);
		}

	void SetTitle(const char *New)
		{
		CopyStringToBuffer(Title, New, LABELSIZE);
		}

	const char *GetRealName(void) const
		{
		return (RealName);
		}

	void SetRealName(const char *New)
		{
		CopyStringToBuffer(RealName, New, LABELSIZE);
		}

	const char *GetPhoneNumber(void) const
		{
		return (PhoneNumber);
		}

	void SetPhoneNumber(const char *New)
		{
		CopyStringToBuffer(PhoneNumber, New, LABELSIZE);
		}

	const char *GetForwardAddr(void) const
		{
		return (ForwardAddr);
		}

	void SetForwardAddr(const char *New)
		{
		CopyStringToBuffer(ForwardAddr, New, LABELSIZE);
		}

	const char *GetForwardAddrNode(void) const
		{
		return (ForwardAddrNode);
		}

	void SetForwardAddrNode(const char *New)
		{
		CopyStringToBuffer(ForwardAddrNode, New, LABELSIZE);
		}

	const char *GetForwardAddrRegion(void) const
		{
		return (ForwardAddrRegion);
		}

	void SetForwardAddrRegion(const char *New)
		{
		CopyStringToBuffer(ForwardAddrRegion, New, LABELSIZE);
		}

	const char *GetPromptFormat(void) const
		{
		return (PromptFormat);
		}

	void SetPromptFormat(const char *New)
		{
		CopyStringToBuffer(PromptFormat, New, sizeof(PromptFormat) - 1);
		}

	const char *GetDateStamp(void) const
		{
		return (DateStamp);
		}

	void SetDateStamp(const char *New)
		{
		CopyStringToBuffer(DateStamp, New, sizeof(DateStamp) - 1);
		}

	const char *GetVerboseDateStamp(void) const
		{
		return (VerboseDateStamp);
		}

	void SetVerboseDateStamp(const char *New)
		{
		CopyStringToBuffer(VerboseDateStamp, New,
				sizeof(VerboseDateStamp) - 1);
		}

	const char *GetSignature(void) const
		{
		return (Signature);
		}

	void SetSignature(const char *New)
		{
		CopyStringToBuffer(Signature, New, sizeof(Signature) - 1);
		}

	const char *GetNetPrefix(void) const
		{
		return (NetPrefix);
		}

	void SetNetPrefix(const char *New)
		{
		CopyStringToBuffer(NetPrefix, New, LABELSIZE);
		}

	const char *GetMailAddr1(void) const
		{
		return (MailAddr1);
		}

	void SetMailAddr1(const char *New)
		{
		CopyStringToBuffer(MailAddr1, New, LABELSIZE);
		}

	const char *GetMailAddr2(void) const
		{
		return (MailAddr2);
		}

	void SetMailAddr2(const char *New)
		{
		CopyStringToBuffer(MailAddr2, New, LABELSIZE);
		}

	const char *GetMailAddr3(void) const
		{
		return (MailAddr3);
		}

	void SetMailAddr3(const char *New)
		{
		CopyStringToBuffer(MailAddr3, New, LABELSIZE);
		}

	const char *GetAlias(void) const
		{
		return (Alias);
		}

	void SetAlias(const char *New)
		{
		CopyStringToBuffer(Alias, New, sizeof(Alias) - 1);
		}

	const char *GetLocID(void) const
		{
		return (LocID);
		}

	void SetLocID(const char *New)
		{
		CopyStringToBuffer(LocID, New, sizeof(LocID) - 1);
		}

	const char *GetMorePrompt(void) const
		{
		return (MorePrompt);
		}

	void SetMorePrompt(const char *New)
		{
		CopyStringToBuffer(MorePrompt, New, sizeof(MorePrompt) - 1);
		}

	const char *GetOccupation(void) const
		{
		return (Occupation);
		}

	void SetOccupation(const char *New)
		{
		CopyStringToBuffer(Occupation, New, LABELSIZE);
		}

	const char *GetWhereHear(void) const
		{
		return (WhereHear);
		}

	void SetWhereHear(const char *New)
		{
		CopyStringToBuffer(WhereHear, New, sizeof(WhereHear) - 1);
		}

	const char *GetLastRoom(void) const
		{
		return (LastRoom);
		}

	void SetLastRoom(const char *New)
		{
		CopyStringToBuffer(LastRoom, New, LABELSIZE);
		}

	const char *GetLastHall(void) const
		{
		return (LastHall);
		}

	void SetLastHall(const char *New)
		{
		CopyStringToBuffer(LastHall, New, LABELSIZE);
		}

	const char *GetDefaultRoom(void) const
		{
		return (DefaultRoom);
		}

	void SetDefaultRoom(const char *New)
		{
		CopyStringToBuffer(DefaultRoom, New, LABELSIZE);
		}

	const char *GetDefaultHall(void) const
		{
		return (DefaultHall);
		}

	void SetDefaultHall(const char *New)
		{
		CopyStringToBuffer(DefaultHall, New, LABELSIZE);
		}

	long GetBirthDate(void) const
		{
		return (BirthDate);
		}

	void SetBirthDate(long New)
		{
		BirthDate = New;
		}

	long GetFirstOn(void) const
		{
		return (FirstOn);
		}

	void SetFirstOn(long New)
		{
		FirstOn = New;
		}

	SexE GetSex(void) const
		{
		return (Sex);
		}

	void SetSex(SexE New)
		{
		Sex = New;
		}

	int GetNulls(void) const
		{
		return (Nulls);
		}

	void SetNulls(int New)
		{
		Nulls = New;
		}

	int GetWidth(void) const
		{
		return (Width);
		}

	void SetWidth(int New)
		{
		Width = New;
		}

	int GetLinesPerScreen(void) const
		{
		return (LinesPerScreen);
		}

	void SetLinesPerScreen(int New)
		{
		LinesPerScreen = New;
		}

	int GetAttribute(LogAttr Which) const
		{
		assert(Which >= 0);
		assert(Which < ATTR_NUM);

		return (attributes[Which]);
		}

	void SetAttribute(LogAttr Which, int New)
		{
		assert(Which >= 0);
		assert(Which < ATTR_NUM);
		assert(New >= 0);
		assert(New < 256);

		attributes[Which] = New;
		}

	int GetNumUserShow(void) const
		{
		return (NumUserShow);
		}

	void SetNumUserShow(int New)
		{
		NumUserShow = New;
		}

	char GetDefaultProtocol(void) const
		{
		return (DefaultProtocol);
		}

	void SetDefaultProtocol(char New)
		{
		DefaultProtocol = New;
		}

	time_t GetCallTime(void) const
		{
		return (CallTime);
		}

	void SetCallTime(time_t New)
		{
		CallTime = New;
		}

	ulong GetCallNumber(void) const
		{
		return (CallNumber);
		}

	void SetCallNumber(ulong New)
		{
		CallNumber = New;
		}

	time_t GetTotalTime(void) const
		{
		return (TotalTime);
		}

	void SetTotalTime(time_t New)
		{
		TotalTime = New;
		}

	long GetCredits(void) const
		{
		return (Credits);
		}

	void SetCredits(long New)
		{
		Credits = New;
		}

	long GetLogins(void) const
		{
		return (Logins);
		}

	void SetLogins(long New)
		{
		Logins = New;
		}

	long GetPosted(void) const
		{
		return (Posted);
		}

	void SetPosted(long New)
		{
		Posted = New;
		}

	long GetRead(void) const
		{
		return (Read);
		}

	void SetRead(long New)
		{
		Read = New;
		}

	time_t GetPasswordChangeTime(void) const
		{
		return (PasswordChangeTime);
		}

	void SetPasswordChangeTime(time_t New)
		{
		PasswordChangeTime = New;
		}

	int GetCallsToday(void) const
		{
		return (CallsToday);
		}

	void SetCallsToday(int New)
		{
		CallsToday = New;
		}

	int GetCallLimit(void) const
		{
		return (CallLimit);
		}

	void SetCallLimit(int New)
		{
		CallLimit = New;
		}

	ulong GetLastMessage(void) const
		{
		return (LastMessage);
		}

	void SetLastMessage(ulong New)
		{
		LastMessage = New;
		}

	ulong GetDL_Bytes(void) const
		{
		return (DL_Bytes);
		}

	void SetDL_Bytes(ulong New)
		{
		DL_Bytes = New;
		}

	ulong GetUL_Bytes(void) const
		{
		return (UL_Bytes);
		}

	void SetUL_Bytes(ulong New)
		{
		UL_Bytes = New;
		}

	uint GetDL_Num(void) const
		{
		return (DL_Num);
		}

	void SetDL_Num(uint New)
		{
		DL_Num = New;
		}

	uint GetUL_Num(void) const
		{
		return (UL_Num);
		}

	void SetUL_Num(uint New)
		{
		UL_Num = New;
		}

	long GetPoopcount(void) const
		{
		return (Poopcount);
		}

	void SetPoopcount(long New)
		{
		Poopcount = New;
		}

	Bool IsDungeoned(void) const
		{
		return (DUNGEONED);
		}

	void SetDungeoned(Bool New)
		{
		DUNGEONED = !!New;
		}

	Bool IsForwardToNode(void) const
		{
		return (FORtOnODE);
		}

	void SetForwardToNode(Bool New)
		{
		FORtOnODE = !!New;
		}

	Bool IsAutoNextHall(void) const
		{
		return (NEXTHALL);
		}

	void SetAutoNextHall(Bool New)
		{
		NEXTHALL = !!New;
		}

	Bool IsEnterBorders(void) const
		{
		return (BORDERS);
		}

	void SetEnterBorders(Bool New)
		{
		BORDERS = !!New;
		}

	Bool IsVerified(void) const
		{
		return (!UNVERIFIED);
		}

	void SetVerified(Bool New)
		{
		UNVERIFIED = !New;
		}

	Bool IsSurnameLocked(void) const
		{
		return (SURNAMLOK);
		}

	void SetSurnameLocked(Bool New)
		{
		SURNAMLOK = !!New;
		}

	Bool IsDefaultHallLocked(void) const
		{
		return (LOCKHALL);
		}

	void SetDefaultHallLocked(Bool New)
		{
		LOCKHALL = !!New;
		}

	Bool IsPsycho(void) const
		{
		return (PSYCHO);
		}

	void SetPsycho(Bool New)
		{
		PSYCHO = !!New;
		}

	Bool IsViewTitleSurname(void) const
		{
		return (DISPLAYTS);
		}

	void SetViewTitleSurname(Bool New)
		{
		DISPLAYTS = !!New;
		}

	Bool IsViewSubjects(void) const
		{
		return (SUBJECTS);
		}

	void SetViewSubjects(Bool New)
		{
		SUBJECTS = !!New;
		}

	Bool IsViewSignatures(void) const
		{
		return (SIGNATURES);
		}

	void SetViewSignatures(Bool New)
		{
		SIGNATURES = !!New;
		}

	Bool IsIBMGraph(void) const
		{
		return (IBMGRAPH);
		}

	void SetIBMGraph(Bool New)
		{
		IBMGRAPH = !!New;
		}

	Bool IsIBMANSI(void) const
		{
		return (IBMANSI);
		}

	void SetIBMANSI(Bool New)
		{
		IBMANSI = !!New;
		}

	Bool IsIBMColor(void) const
		{
		return (IBMCOLOR);
		}

	void SetIBMColor(Bool New)
		{
		IBMCOLOR = !!New;
		}

	Bool IsTwirly(void) const
		{
		return (TWIRLY);
		}

	void SetTwirly(Bool New)
		{
		TWIRLY = !!New;
		}

	Bool IsAutoVerbose(void) const
		{
		return (VERBOSE);
		}

	void SetAutoVerbose(Bool New)
		{
		VERBOSE = !!New;
		}

	Bool IsPauseBetweenMessages(void) const
		{
		return (MSGPAUSE);
		}

	void SetPauseBetweenMessages(Bool New)
		{
		MSGPAUSE = !!New;
		}

	Bool IsMinibin(void) const
		{
		return (MINIBIN);
		}

	void SetMinibin(Bool New)
		{
		MINIBIN = !!New;
		}

	Bool IsClearScreenBetweenMessages(void) const
		{
		return (MSGCLS);
		}

	void SetClearScreenBetweenMessages(Bool New)
		{
		MSGCLS = !!New;
		}

	Bool IsViewRoomInfoLines(void) const
		{
		return (ROOMINFO);
		}

	void SetViewRoomInfoLines(Bool New)
		{
		ROOMINFO = !!New;
		}

	Bool IsViewHallDescription(void) const
		{
		return (HALLTELL);
		}

	void SetViewHallDescription(Bool New)
		{
		HALLTELL = !!New;
		}

	Bool IsVerboseContinue(void) const
		{
		return (VERBOSECONT);
		}

	void SetVerboseContinue(Bool New)
		{
		VERBOSECONT = !!New;
		}

	Bool IsViewCensoredMessages(void) const
		{
		return (VIEWCENSOR);
		}

	void SetViewCensoredMessages(Bool New)
		{
		VIEWCENSOR = !!New;
		}

	Bool IsViewBorders(void) const
		{
		return (SEEBORDERS);
		}

	void SetViewBorders(Bool New)
		{
		SEEBORDERS = !!New;
		}

	Bool IsOut300(void) const
		{
		return (OUT300);
		}

	void SetOut300(Bool New)
		{
		OUT300 = !!New;
		}

	Bool IsUserSignatureLocked(void) const
		{
		return (LOCKUSIG);
		}

	void SetUserSignatureLocked(Bool New)
		{
		LOCKUSIG = !!New;
		}

	Bool IsHideMessageExclusions(void) const
		{
		return (HIDEEXCL);
		}

	void SetHideMessageExclusions(Bool New)
		{
		HIDEEXCL = !!New;
		}

	Bool IsDownload(void) const
		{
		return (!NODOWNLOAD);
		}

	void SetDownload(Bool New)
		{
		NODOWNLOAD = !New;
		}

	Bool IsUpload(void) const
		{
		return (!NOUPLOAD);
		}

	void SetUpload(Bool New)
		{
		NOUPLOAD = !New;
		}

	Bool IsChat(void) const
		{
		return (!NOCHAT);
		}

	void SetChat(Bool New)
		{
		NOCHAT = !New;
		}

	Bool IsPrintFile(void) const
		{
		return (PRINTFILE);
		}

	void SetPrintFile(Bool New)
		{
		PRINTFILE = !!New;
		}

	uint GetSpellCheckMode(void) const
		{
		return (spellCheck);
		}

	void SetSpellCheckMode(uint New)
		{
		assert(New < 4);

		spellCheck = New;
		}

	Bool IsMakeRoom(void) const
		{
		return (!NOMAKEROOM);
		}

	void SetMakeRoom(Bool New)
		{
		NOMAKEROOM = !New;
		}

	Bool IsVerboseLogOut(void) const
		{
		return (VERBOSELO);
		}

	void SetVerboseLogOut(Bool New)
		{
		VERBOSELO = !!New;
		}

	Bool IsConfirmSave(void) const
		{
		return (CONFIRMSAVE);
		}

	void SetConfirmSave(Bool New)
		{
		CONFIRMSAVE = !!New;
		}

	Bool IsConfirmAbort(void) const
		{
		return (!NOCONFABORT);
		}

	void SetConfirmAbort(Bool New)
		{
		NOCONFABORT = !New;
		}

	Bool IsConfirmNoEO(void) const
		{
		return (CONFIRMNOEO);
		}

	void SetConfirmNoEO(Bool New)
		{
		CONFIRMNOEO = !!New;
		}

	Bool IsUsePersonalHall(void) const
		{
		return (cfg.PersonalHallOK && USEPERSONAL);
		}

	void SetUsePersonalHall(Bool New)
		{
		USEPERSONAL = New;
		}

	Bool IsYouAreHere(void) const
		{
		return (YOUAREHERE);
		}

	void SetYouAreHere(Bool New)
		{
		YOUAREHERE = !!New;
		}

	Bool IsIBMRoom(void) const
		{
		return (IBMROOM);
		}

	void SetIBMRoom(Bool New)
		{
		IBMROOM = !!New;
		}

	Bool IsWideRoom(void) const
		{
		return (WIDEROOM);
		}

	void SetWideRoom(Bool New)
		{
		WIDEROOM = !!New;
		}

	Bool IsMusic(void) const
		{
		return (MUSIC);
		}

	void SetMusic(Bool New)
		{
		MUSIC = !!New;
		}

	Bool IsCheckApostropheS(void) const
		{
		return (CHECKAPS);
		}

	void SetCheckApostropheS(Bool New)
		{
		CHECKAPS = !!New;
		}

	Bool IsCheckAllCaps(void) const
		{
		return (CHECKALLCAP);
		}

	void SetCheckAllCaps(Bool New)
		{
		CHECKALLCAP = !!New;
		}

	Bool IsCheckDigits(void) const
		{
		return (CHECKDIGITS);
		}

	void SetCheckDigits(Bool New)
		{
		CHECKDIGITS = !!New;
		}

	Bool IsExcludeEncryptedMessages(void) const
		{
		return (EXCLUDECRYPT);
		}

	void SetExcludeEncryptedMessages(Bool New)
		{
		EXCLUDECRYPT = !!New;
		}

	Bool IsViewCommas(void) const
		{
		return (!HIDECOMMAS);
		}

	void SetViewCommas(Bool New)
		{
		HIDECOMMAS = !New;
		}

	Bool IsPUnPauses(void) const
		{
		return (PUNPAUSES);
		}

	void SetPUnPauses(Bool New)
		{
		PUNPAUSES = !!New;
		}

	Bool IsRoman(void) const
		{
		return (ROMAN);
		}

	void SetRoman(Bool New)
		{
		ROMAN = !!New;
		}

	Bool IsMainSysop(void) const
		{
		return (SameString(Name, cfg.sysop));
		}
	};

class LogEntry1 : public LogFlags, public LogStarter, public LogEntry1Data
	{
public:
	void Clear(void)
		{
		LogFlags::Clear();
		LogEntry1Data::Clear();
		}

	LogEntry1(void)
		{
		Clear();
		ResetFileName();
		}

	LogEntry1& operator =(const LogEntry1 &Original);

	Bool Load(l_index Index);
	Bool Save(l_index Index) const;

	void ResetFileName(void)
		{
		SetFileName(logDat);
		}
	};
