/* -------------------------------------------------------------------- */
/*	LOG.CPP 					Citadel 								*/
/* -------------------------------------------------------------------- */
/*							Local log code								*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "net.h"
#include "log.h"
#include "room.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	FindPersonByName()	returns slot# of named person else CERROR		*/
/*	storeLog()			stores the current log record.					*/
/*	displaypw() 		displays callers name, initials & pw			*/
/*	normalizepw()		This breaks down inits;pw into separate strings */
/* -------------------------------------------------------------------- */

LogTable			*LogTab;			/* RAM index of pippuls 		*/

/* -------------------------------------------------------------------- */
/*	FindPersonByName()	returns slot# of named person else CERROR		*/
/* -------------------------------------------------------------------- */
l_slot FindPersonByName(const char *name)
	{
	label alias;
	CopyStringToBuffer(alias, name, LABELSIZE);
	char *ptr = strchr(alias, '.');
	if (ptr)
		{
		*ptr = 0;	// tie off
		}

	/* check to see if name is in log table */
	for (l_slot i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (LogTab->GetEntry(i)->IsInuse() &&
				(SameString(name, LogTab->GetEntry(i)->GetName()) ||
				SameString(alias, LogTab->GetEntry(i)->GetAlias())))
			{
			return (i);
			}
		}

	return (CERROR);
	}

/* -------------------------------------------------------------------- */
/*	nodexists() 		returns slot# of named person else CERROR		*/
/* -------------------------------------------------------------------- */
int nodexists(const char *name)
	{
	int i;
	char alias[4];
	char locID[5];
	Bool addrsearch = FALSE;

	if (isaddress(name))
		{
		parse_address(name, alias, locID, 0);
		addrsearch = TRUE;
		}

	/* check to see if name is in log table */
	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (LogTab->GetEntry(i)->IsInuse() && LogTab->GetEntry(i)->IsNode())
			{
			if (addrsearch)
				{
				if (	// same alias and...
						SameString(alias, LogTab->GetEntry(i)->GetAlias()) &&

						// either...
						(
							// not searching locIDs or...
							!*locID || 

							// it matches, too
							SameString(locID, LogTab->GetEntry(i)->GetLocID())
						)
					)
					{
					return (i);
					}
				}
			else
				{
				if (SameString(name, LogTab->GetEntry(i)->GetName()))
					{
					return (i);
					}
				}
			}
		}

	return (CERROR);
	}

/* -------------------------------------------------------------------- */
/*	addressexists() 	returns slot# of named person else CERROR		*/
/* -------------------------------------------------------------------- */
int addressexists(const char *name)
	{
	int i;
	char alias[4];
	char locID[5];

	parse_address(name, alias, locID, 0);

	/* check to see if name is in log table */
	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (LogTab->GetEntry(i)->IsInuse())
			{
			if (LogTab->GetEntry(i)->GetAlias()[0] &&
				(SameString(alias, LogTab->GetEntry(i)->GetAlias()) &&
				SameString(locID, LogTab->GetEntry(i)->GetLocID())))
				{
				return (i);
				}
			}
		}

	return (CERROR);
	}

/* -------------------------------------------------------------------- */
/*	FindPersonByPartialName()	returns slot # of partial user name,	*/
/*								else CERROR 							*/
/* -------------------------------------------------------------------- */
l_slot FindPersonByPartialName(const char *name)
	{
	int i, length;
	label da_pn;

	if (strlen(name) > LABELSIZE)
		{
		return (CERROR);
		}

	/* Exact match */
	i = FindPersonByName(name);
	if (i != CERROR)
		{
		return (i);
		}

	strcpy(da_pn, deansi(name));
	length = strlen(da_pn);

	if (!length)
		{
		return (CERROR);
		}

	/* Start of string match */
	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (LogTab->GetEntry(i)->IsInuse())
			{
			if (strnicmp(deansi(LogTab->GetEntry(i)->GetName()), da_pn, length) == SAMESTRING)
				{
				return (i);
				}
			}
		}

	/* Partial match */
	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (LogTab->GetEntry(i)->IsInuse())
			{
			if (IsSubstr(LogTab->GetEntry(i)->GetName(), da_pn))
				{
				return (i);
				}
			}
		}

	return (CERROR);
	}

/* -------------------------------------------------------------------- */
/*	normalizepw()		This breaks down inits;pw into separate strings */
/* -------------------------------------------------------------------- */
void normalizepw(const char *InitPw, char *Initials, char *passWord)
	{
	char *pwptr;
	char *inptr;
	const char *inpwptr;

	inpwptr = InitPw;
	pwptr = passWord;
	inptr = Initials;

	while (*inpwptr != ';')
		{
		*inptr++ = *inpwptr;
		inpwptr++;
		}
	*inptr++ = 0;		// tie off with a null

	inpwptr++;			// step over semicolon

	while (*inpwptr != '\0')
		{
		*pwptr++ = *inpwptr;
		inpwptr++;
		}
	*pwptr++ = 0;		// tie off with a null

	normalizeString(Initials);
	normalizeString(passWord);

	/* don't allow anything over LABELSIZE characters */
	Initials[LABELSIZE] = '\0';
	passWord[LABELSIZE] = '\0';
	}

/* -------------------------------------------------------------------- */
/*	log2tab()			logbuf to logtable converter					*/
/* -------------------------------------------------------------------- */
void log2tab(LTable *Table, const LogEntry1 *Log, l_index Slot)
	{
	Table->CopyFlags(*Log);

	if (Log->IsInuse())
		{
		Table->SetInitialsHash(hash(Log->GetInitials()));
		Table->SetPasswordHash(hash(Log->GetPassword()));
		Table->SetName(Log->GetName());
		Table->SetAlias(Log->GetAlias());
		Table->SetLocID(Log->GetLocID());
		Table->SetCallNumber(Log->GetCallNumber());
		}
	else
		{
		Table->SetInitialsHash(0);
		Table->SetPasswordHash(0);
		Table->SetName(ns);
		Table->SetAlias(ns);
		Table->SetLocID(ns);
		Table->SetCallNumber(0);
		}

	Table->SetLogIndex(Slot);
	}

Bool LoadPersonByName(const char *name)
	{
	l_slot NewPerson;

	NewPerson = FindPersonByName(name);

	if (NewPerson == CERROR)
		{
		return (FALSE);
		}
	else
		{
		TI()ThisSlot = NewPerson;
		TI()ThisLog = LogTab->GetEntry(NewPerson)->GetLogIndex();

		return (TI()CurrentUser->Load(TI()ThisLog));
		}
	}

Bool LogEntry::LoadByName(const char *name)
	{
	l_slot NewPerson;

	NewPerson = FindPersonByName(name);

	if (NewPerson == CERROR)
		{
		return (FALSE);
		}
	else
		{
		return (Load(LogTab->GetEntry(NewPerson)->GetLogIndex()));
		}
	}

/* -------------------------------------------------------------------- */
/*	displaypw() 		displays callers name, initials & pw			*/
/* -------------------------------------------------------------------- */
void displaypw(const char *name, const char *in, const char *pw)
	{
	CRmPrintf(getmsg(1249), name);
	CRmPrintf(pctss, getmsg(1250));
	TI()OC.Echo = CALLER;
	setio();
	mPrintf(pcts, in);
	TI()OC.Echo = BOTH;
	setio();
	CRmPrintf(pctss, getmsg(1251));
	TI()OC.Echo = CALLER;
	setio();
	mPrintf(pcts, pw);
	TI()OC.Echo = BOTH;
	setio();

	doCR();
	}

/* -------------------------------------------------------------------- */
/*	storeLog()			stores the current log record.					*/
/* -------------------------------------------------------------------- */
void storeLog(void)
	{
	if (TI()loggedIn)
		{
		TI()CurrentUser->Save(TI()ThisLog);
		}
	}
