/* -------------------------------------------------------------------- */
/*	LLSUP.CPP					Citadel 								*/
/*					Code for dealing with linked lists					*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

/* -------------------------------------------------------------------- */
/* for this to work, the "next" field of the list has to be the first   */
/* field in each node and be a far pointer								*/
/* -------------------------------------------------------------------- */
/*								Contents								*/
/*																		*/
/*	disposeLL() 	disposes linked list								*/
/*	addLL() 		adds a node at the end								*/
/*	getNextLL() 	gets the next node in the list, or NULL 			*/
/*	getLLNum()		gets the nth entry in a list						*/
/*	deleteLLNode()	deletes the nth node in a list						*/
/*	insertLLNode()	instert before the nth node in a list				*/
/*	getLLCount()	counts the nodes in the list						*/
/* -------------------------------------------------------------------- */

typedef struct eLL
	{
	struct eLL *next;
	} emptyLL;

/* -------------------------------------------------------------------- */
/*	disposeLL() 	disposes linked list								*/
/* -------------------------------------------------------------------- */
void disposeLL(void **list)
	{
	emptyLL *thisNode;

	thisNode = (emptyLL *) *list;

	while (thisNode)
		{
		emptyLL *nxt;

		nxt = thisNode->next;
		delete [] thisNode;
		thisNode = nxt;
		}

	*list = NULL;
	}

/* -------------------------------------------------------------------- */
/*	addLL() 		adds a node at the end								*/
/* -------------------------------------------------------------------- */
void *addLL(void **list, uint nodeSize)
	{
	emptyLL *newNode, *cur;

	newNode = (emptyLL *) new char[nodeSize];
	if (newNode)
		{
		memset(newNode, 0, nodeSize);
		}

	if (*list)
		{
		cur = (emptyLL *) *list;

		while (cur->next)
			{
			cur = cur->next;
			}

		cur->next = newNode;
		}
	else
		{
		/* new list */
		*list = newNode;
		}

	return (newNode);
	}

/* -------------------------------------------------------------------- */
/*	getNextLL() 	gets the next node in the list, or NULL 			*/
/* -------------------------------------------------------------------- */
void *getNextLL(const void *list)
	{
	if (list)
		{
		return (((emptyLL *)list)->next);
		}

	return (NULL);
	}

/* -------------------------------------------------------------------- */
/*	getLLNum()		gets the nth entry in a list						*/
/* -------------------------------------------------------------------- */
void *getLLNum(void *list, ulong n)
	{
	if (n)
		{
		while (--n && list)
			{
			list = ((emptyLL *) list)->next;
			}

		return (list);
		}

	return (NULL);
	}

/* -------------------------------------------------------------------- */
/*	deleteLLNode()	deletes the nth node in a list						*/
/* -------------------------------------------------------------------- */
void deleteLLNode(void **list, ulong n)
	{
	emptyLL *cur = NULL, *prev;

	if (*list && n)
		{
		if (n == 1)
			{
			cur = (emptyLL *) *list;
			*list = cur->next;
			}
		else
			{
			prev = (emptyLL *) getLLNum(*list, n - 1);

			if (prev)
				{
				cur = prev->next;

				if (cur)
					{
					prev->next = cur->next;
					}
				}
			}

		if (cur)
			{
			delete [] cur;
			}
		}
	}

/* -------------------------------------------------------------------- */
/*	insertLLNode()	instert before the nth node in a list				*/
/* -------------------------------------------------------------------- */
void *insertLLNode(void **list, ulong n, int nodeSize)
	{
	if (n)
		{
		emptyLL *newNode, *cur;

		newNode = (emptyLL *) new char[nodeSize];

		if (newNode)
			{
			memset(newNode, 0, nodeSize);

			if (n == 1)
				{
				newNode->next = (emptyLL *) *list;
				*list = newNode;
				}
			else
				{
				cur = (emptyLL *) getLLNum(*list, n - 1);

				if (cur && cur->next)
					{
					newNode->next = cur->next;
					cur->next = newNode;
					}
				else
					{
					// list not that big - just stick at end
					cur = (emptyLL *) *list;

					while (cur->next)
						{
						cur = cur->next;
						}

					cur->next = newNode;
					}
				}
			}

		return (newNode);
		}
	else
		{
		return (NULL);
		}
	}

/* -------------------------------------------------------------------- */
/*	getLLCount()	counts the nodes in the list						*/
/* -------------------------------------------------------------------- */
ulong getLLCount(const void *list)
	{
	ulong i = 0;

	while (list && ++i)
		{
		list = ((emptyLL *)list)->next;
		}

	return (i);
	}
