	/************************************
	*			Input Filtering			*
	*									*
	* ctrl-a	0x01 = ctrl-a	0x01	*
	* backspace 0x08 = bs		0x08	*
	* '\t'		0x09 = '\t'		0x09	*
	* newline	0x0a = null		0x00	*
	* '\r'		0x0d = NEWLINE	0x0a	*
	* ctrlo		0x0f = 'N'		0x4e	*
	* xoff		0x13 = 'P'		0x50	*
	* ctrlz		0x1a = ctrlz	0x1a	*
	* special	0x1b = special	0x1b	*
	* del		0x7f = bs		0x08	*
	*									*
	************************************/

#ifdef INPUTMAIN
/* ASCII only input filter */
extern uchar const filt_in[128] =
	{
	'\x00', '\x01', '\x00', '\x00', '\x00', '\x00', '\x00', '\x00',/*0..x7*/
	'\b',   '\t',   '\x00', '\x00', '\x00', '\n',   '\x00', 'N',
	'\x00', '\x00', '\x00', 'P',    '\x00', '\x00', '\x00', '\x00',/*x10..x17*/
	'\x00', '\x00', '\x1a', '\x1b', '\x00', '\x00', '\x00', '\x00',
	' ', '!', '"', '#', '$', '%', '&', '\x27',      /* x20..x27 */
	'(', ')', '*', '+', ',', '-', '.', '/',
	'0', '1', '2', '3', '4', '5', '6', '7',         /* x30..x37 */
	'8', '9', ':', ';', '<', '=', '>', '?',
	'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G',         /* x40..x47 */
	'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
	'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',         /* x50..x57 */
	'X', 'Y', 'Z', '[', '\x5c', ']', '^', '_',
	'`', 'a', 'b', 'c', 'd', 'e', 'f', 'g',         /* x60..x67 */
	'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
	'p', 'q', 'r', 's', 't', 'u', 'v', 'w',         /* x70..x77 */
	'x', 'y', 'z', '{', '|', '}', '~', '\b',
	};

#else
extern uchar const filt_in[128];
#endif
