/* -------------------------------------------------------------------- */
/*	HALL.CPP						Citadel 								*/
/*				 hall code for Citadel bulletin board system			*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "log.h"
#include "hall.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	hallexists()			returns # of named hall, else CERROR		*/
/*	iswindow()				for .kw .kvw is # room a window 			*/
/*	partialhall()			returns slot of partially named hall		*/
/*	roominhall()			indicates if room# is in hall#				*/
/* -------------------------------------------------------------------- */

HallBuffer	*HallData;					/* Hall data goes here			*/

/* -------------------------------------------------------------------- */
/*	hallexists()		return # of named hall, else CERROR 			*/
/* -------------------------------------------------------------------- */
h_slot hallexists(const char *hallname)
	{
	h_slot i;

	for (i = 0; i < cfg.maxhalls; i++)
		{
		if (HallData->GetEntry(i)->IsInuse() &&
				SameString(hallname, HallData->GetEntry(i)->GetName()))
			{
			return (i);
			}
		}

	return (CERROR);
	}

/* -------------------------------------------------------------------- */
/*		iswindow()	is room a window into accessible halls? 			*/
/* -------------------------------------------------------------------- */
Bool iswindow(r_slot roomslot)
	{
	if (!IsRoomInuse(roomslot))
		{
		return (FALSE);
		}

	// there are no window rooms when in floor mode.
	if (cfg.subhubs == 4)
		{
		return (FALSE);
		}

	int i;
	for (i = 0; i < cfg.maxhalls; i++)
		{
		if (HallData->GetEntry(i)->IsInuse() &&
				HallData->GetEntry(i)->IsWindowedIntoHall(roomslot))
			{
			return (TRUE);
			}
		}

	return (FALSE);
	}

/* -------------------------------------------------------------------- */
/*	partialhall()		returns slot # of partial hall name, else error */
/* -------------------------------------------------------------------- */
h_slot partialhall(const char *hallname)
	{
	h_slot i;
	int length;
	label da_hn;

	if (strlen(deansi(hallname)) > LABELSIZE)
		{
		return (CERROR);
		}

	i = hallexists(hallname);
	if (i != CERROR)
		{
		return (i);
		}

	strcpy(da_hn, deansi(hallname));
	length = strlen(da_hn);

	for (i = 0; i < cfg.maxhalls; i++)
		{
		if (HallData->GetEntry(i)->IsInuse())
			{
			if ((strnicmp(deansi(HallData->GetEntry(i)->GetName()), da_hn,
					length) == SAMESTRING)
					&& TI()CurrentUser->CanAccessHall(i))
				{
				return (i);
				}
			}
		}

	for (i = 0; i < cfg.maxhalls; i++)
		{
		if (HallData->GetEntry(i)->IsInuse())
			{
			if (IsSubstr(HallData->GetEntry(i)->GetName(), da_hn)
					&& TI()CurrentUser->CanAccessHall(i))
				{
				return (i);
				}
			}
		}

	return (CERROR);
	}

/* -------------------------------------------------------------------- */
/*	roominhall()	returns TRUE if room# is in hall#					*/
/* -------------------------------------------------------------------- */
int roominhall(r_slot roomslot, h_slot hallslot)
	{
	if (HallData->GetEntry(hallslot)->IsRoomInHall(roomslot) ||
			(roomslot == LOBBY && cfg.subhubs == 4))
		{
		return (TRUE);
		}

	return (FALSE);
	}
