/* -------------------------------------------------------------------- */
/*								grprdwr.cpp 							*/
/*		group.dat read/write code for Citadel bulletin board system 	*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "group.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

Bool GroupBuffer::Save(const char *Name) const
	{
	assert(this);
	Bool Good = TRUE;
	VerifyHeap();

	if (IsValid())
		{
		FILE *File;
		char FileName[80];

		sprintf(FileName, sbs, cfg.homepath, Name);

		if ((File = fopen(FileName, FO_WB)) != NULL)
			{
			long l = sizeof(GroupEntry);

			fwrite(&l, sizeof(long), 1, File);

			if (fwrite(Groups, sizeof(GroupEntry), NumGroups, File) != NumGroups)
				{
				mPrintf(getmsg(661), FileName);
				Good = FALSE;
				}

			fclose(File);
			}
		else
			{
			mPrintf(getmsg(78), FileName);
			Good = FALSE;
			}
		}
	else
		{
		Good = FALSE;
		}

	VerifyHeap();
	return (Good);
	}

Bool GroupBuffer::Load(const char *Name)
	{
	assert(this);
	Bool Good = TRUE;
	VerifyHeap();

	if (IsValid())
		{
		FILE *File;
		char FileName[80];

		sprintf(FileName, sbs, cfg.homepath, Name);

		if ((File = fopen(FileName, FO_RB)) != NULL)
			{
			fseek(File, sizeof(long), SEEK_SET);

			if (fread(Groups, sizeof(GroupEntry), NumGroups, File) != NumGroups)
				{
				mPrintf(getmsg(83), FileName);
				Good = FALSE;
				}

			fclose(File);

			for (g_slot GroupSlot = 0; GroupSlot < NumGroups; GroupSlot++)
				{
				GetEntry(GroupSlot)->Verify();
				}
			}
		else
			{
			mPrintf(getmsg(78), FileName);
			Good = FALSE;
			}
		}
	else
		{
		Good = FALSE;
		}

	VerifyHeap();
	return (Good);
	}

Bool GroupEntry::Save(g_slot Slot, FILE *File)
	{
	assert(this);
	assert(File != NULL);
	Bool Good = TRUE;

	fseek(File, sizeof(long) + (long) Slot * sizeof(GroupEntry), SEEK_SET);

	if (fwrite(this, sizeof(GroupEntry), 1, File) != 1)
		{
		mPrintf(getmsg(661), grpDat);
		Good = FALSE;
		}

	return (Good);
	}

Bool GroupEntry::Load(g_slot Slot, FILE *File)
	{
	assert(this);
	assert(File != NULL);
	Bool Good = TRUE;

	fseek(File, sizeof(long) + (long) Slot * sizeof(GroupEntry), SEEK_SET);

	if (fread(this, sizeof(GroupEntry), 1, File) != 1)
		{
		mPrintf(getmsg(83), grpDat);
		Good = FALSE;
		}

	return (Good);
	}
