// --------------------------------------------------------------------------
// Citadel: GrpOvl.CPP
//
// Overlayed group code.

#include "ctdl.h"
#pragma hdrstop

#include "group.h"
#include "log.h"


// --------------------------------------------------------------------------
// Contents


void ListGroups(Bool CheckInGroup)
	{
	CRmPrintfCR(getmsg(962), cfg.Ugroups_nym);

	prtList(LIST_START);

	for (g_slot GroupSlot = 0; GroupSlot < cfg.maxgroups; GroupSlot++)
		{
		if (// group is in use
			GroupData->GetEntry(GroupSlot)->IsInuse() &&

				(
				// and in the group
				TI()CurrentUser->IsInGroup(GroupSlot) ||

					(
					// or not checking if in the group
					!CheckInGroup &&

					// and the group is not hidden, or on console
					(!GroupData->GetEntry(GroupSlot)->IsHidden() ||
							onConsole) &&
					// and the group is not locked, or is sysop
					(!GroupData->GetEntry(GroupSlot)->IsLocked() ||
							TI()CurrentUser->IsSysop())
					)
				)
			)
			{
			prtList(GroupData->GetEntry(GroupSlot)->GetName());
			}
		}

	prtList(LIST_END);
	}
