// temporary?

#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "group.h"
#include "log.h"
#include "hall.h"
#include "boolexpr.h"

/* -------------------------------------------------------------------- */
/*	groupseeshall() 		returns true if group can see hall			*/
/* -------------------------------------------------------------------- */
Bool LogEntry::CanAccessHall(h_slot hallslot) const
	{
	assert(this);
	assert(hallslot >= 0);
	assert(hallslot < cfg.maxhalls);

	if (!HallData->GetEntry(hallslot)->IsOwned())
		{
		return (TRUE);
		}

	if (IsMainSysop())
		{
		return (TRUE);
		}

	if (!HallData->GetEntry(hallslot)->IsBoolGroup())
		{
		return (IsInGroup(HallData->GetEntry(hallslot)->GetGroupNumber()));
		}
	else
		{
		TI()Log2ForGroupTester = this;

		return (EvaluateBooleanExpression(HallData->GetEntry(hallslot)->
				GetGroupExpression(), GroupTester));
		}
	}

/* -------------------------------------------------------------------- */
/*	groupseesroom() 		returns true if group can see room			*/
/* -------------------------------------------------------------------- */
Bool LogEntry::HasGroupAccessToRoom(r_slot roomslot) const
	{
	assert(this);
	assert(roomslot >= 0);
	assert(roomslot < cfg.maxrooms);

	if (!IsRoomGroupOnly(roomslot))
		{
		return (TRUE);
		}

	if (IsMainSysop())
		{
		return (TRUE);
		}

	if (!IsRoomMultiGroup(roomslot))
		{
		return (IsInGroup(GetRoomGroupNumber(roomslot)));
		}
	else
		{
		TI()Log2ForGroupTester = this;

		return (EvaluateBooleanExpression(GetRoomGroupExpression(roomslot),
				GroupTester));
		}
	}

/* -------------------------------------------------------------------- */
/*	pgroupseesroom()		returns true if group can see room			*/
/* -------------------------------------------------------------------- */
Bool LogEntry::HasRoomPrivileges(r_slot roomslot) const
	{
	assert(this);
	assert(roomslot >= 0);
	assert(roomslot < cfg.maxrooms);

	return (!IsRoomPrivGroup(roomslot) ||
			IsInGroup(GetRoomPrivNumber(roomslot)));
	}
