/* -------------------------------------------------------------------- */
/*								group.c 								*/
/*				group code for Citadel bulletin board system			*/
/* -------------------------------------------------------------------- */
#include "ctdl.h"
#pragma hdrstop

#include "log.h"

#include "group.h"

/* -------------------------------------------------------------------- */
/*								Contents								*/
/* -------------------------------------------------------------------- */
/*	groupexists()			returns # of named group, else CERROR		*/
/*	groupseeshall() 		indicates if group can see hall #			*/
/*	ingroup()				returns TRUE if log is in named group		*/
/*	partialgroup()			returns slot of partially named group		*/
/* -------------------------------------------------------------------- */

GroupBuffer *GroupData; 				/* Group data goes here 		*/

/* -------------------------------------------------------------------- */
/*	groupexists()			return # of named group, else CERROR		*/
/* -------------------------------------------------------------------- */
g_slot FindGroupByName(const char *TestName)
	{
	g_slot i;

	for (i = 0; i < cfg.maxgroups; i++)
		{
		if (GroupData->GetEntry(i)->IsInuse() &&
				SameString(TestName, GroupData->GetEntry(i)->GetName()))
			{
			return (i);
			}
		}

	return (CERROR);
	}

/* -------------------------------------------------------------------- */
/*	partialgroup()	returns slot # of partial group name, else error	*/
/*					used for .EL Message, .EL Room and .AG .AL			*/
/* -------------------------------------------------------------------- */
g_slot FindGroupByPartialName(const char *TestName, Bool IgnoreInGroup)
	{
	g_slot i;
	int length;
	label da_gn;

	if (strlen(deansi(TestName)) > LABELSIZE)
		{
		return (CERROR);
		}

	i = FindGroupByName(TestName);
	if (i != CERROR && (IgnoreInGroup || TI()CurrentUser->IsAide() ||
			TI()CurrentUser->IsSysop() || TI()CurrentUser->IsInGroup(i)))
		{
		return (i);
		}

	strcpy(da_gn, deansi(TestName));
	length = strlen(da_gn);

	if (!length)
		{
		return (CERROR);
		}

	/* Start of string match */
	for (i = 0; i < cfg.maxgroups; i++)
		{
		if (GroupData->GetEntry(i)->IsInuse())
			{
			if (
					(strnicmp(deansi(GroupData->GetEntry(i)->GetName()),
					da_gn, length) == SAMESTRING) &&


					(IgnoreInGroup || TI()CurrentUser->IsAide() ||
					TI()CurrentUser->IsSysop() || TI()CurrentUser->IsInGroup(i)))
				{
				return (i);
				}
			}
		}

	/* Partial match */
	for (i = 0; i < cfg.maxgroups; i++)
		{
		if (GroupData->GetEntry(i)->IsInuse())
			{
			if (
					IsSubstr(GroupData->GetEntry(i)->GetName(), da_gn) &&


					(IgnoreInGroup || TI()CurrentUser->IsAide() ||
					TI()CurrentUser->IsSysop() || TI()CurrentUser->IsInGroup(i)))
				{
				return (i);
				}
			}
		}

	return (CERROR);
	}
