#include "ctdl.h"
#pragma hdrstop

#include "log.h"
#include "msg.h"

// --------------------------------------------------------------------------
// globalverify(): Does global sweep to verify any un-verified.

void globalverify(void)
	{
	l_slot i;

	SetDoWhat(SYSNUSER);

	TI()UserControl.SetOutFlag(OUTOK);

	for (i = 0; (i < cfg.MAXLOGTAB) && (TI()UserControl.GetOutFlag() != OUTSKIP) &&
			!TI()UserControl.CheckInput(FALSE);
			i++)
		{
		if (LogTab->GetEntry(i)->IsInuse())
			{
			l_index logNo = LogTab->GetEntry(i)->GetLogIndex();
			LogEntry1 Log1;

			if (Log1.Load(logNo))
				{
				Bool Changed = FALSE;

				if (!Log1.IsVerified())
					{
					int yn;

					char Prompt[128];
					sprintf(Prompt, getsysmsg(59), Log1.GetName());

					yn = getYesNo(Prompt, 3);

					if (yn == 2)
						{
						SaveAideMess(NULL);
						return;
						}

					if (yn)
						{
						char trapstr[128];

						Changed = TRUE;

						Log1.SetVerified(TRUE);

						if (TI()loggedIn && SameString(
								TI()CurrentUser->GetName(), Log1.GetName()))
							{
							TI()CurrentUser->SetVerified(TRUE);
							}

						sprintf(trapstr, getsysmsg(60), Log1.GetName(),
								TI()CurrentUser->GetName());

						trap(trapstr, T_SYSOP);
						amPrintf(getmsg(1434), trapstr, bn);
						}
					else if (!SameString(TI()CurrentUser->GetName(),
							Log1.GetName()))
						{
						if (getYesNo(getsysmsg(61), 0))
							{
							char trapstr[128];

							Changed = TRUE;

							CRmPrintfCR(getsysmsg(85), Log1.GetName());

							// trap it
							sprintf(trapstr, getsysmsg(62), Log1.GetName());
							trap(trapstr, T_SYSOP);

							amPrintf(getmsg(1434), trapstr, bn);

							Log1.Clear();
							}
						}
					}
				else if (Log1.IsProblem())
					{
					int yn;

					char Prompt[128];
					sprintf(Prompt, getsysmsg(41), Log1.GetName());

					yn = getYesNo(Prompt, 3);

					if (yn == 2)
						{
						SaveAideMess(NULL);
						return;
						}

					if (yn)
						{
						char trapstr[128];

						Changed = TRUE;

						Log1.SetProblem(FALSE);

						if (TI()loggedIn && SameString(
								TI()CurrentUser->GetName(), Log1.GetName()))
							{
							TI()CurrentUser->SetProblem(FALSE);
							}

						sprintf(trapstr, getsysmsg(42), Log1.GetName(),
								TI()CurrentUser->GetName());

						trap(trapstr, T_SYSOP);
						amPrintf(getmsg(1434), trapstr, bn);
						}
					else if (!SameString(TI()CurrentUser->GetName(),
							Log1.GetName()))
						{
						if (getYesNo(getsysmsg(61), 0))
							{
							char trapstr[128];

							Changed = TRUE;

							CRmPrintfCR(getsysmsg(85), Log1.GetName());

							// trap it
							sprintf(trapstr, getsysmsg(51), Log1.GetName());
							trap(trapstr, T_SYSOP);

							amPrintf(getmsg(1434), trapstr, bn);

							Log1.Clear();
							}
						}
					}

				if (Changed)
					{
					Log1.Save(logNo);
					}
				}
			}
		}

	SaveAideMess(NULL);
	}
