// Citadel: Global.H
//
// Many of the global variables in Citadel.


// --------------------------------------------------------------------------
// initialized variables

// ------------------------------------------------------------ version stuff
extern char version[];
extern long cfgver;
extern long NumericVer;
extern char programName[];

extern uint BoardNameHash;

extern char Author[];
extern char cmpDate[];
extern char cmpTime[];

#ifdef MAIN
// ----------------------------------------------------- file names and stuff
EXTERN const char *etcTab		= "ETC.TAB";
EXTERN const char *msgDat		= "MSG.DAT";
EXTERN const char *hallDat		= "HALL.DAT";
EXTERN const char *hall2Dat 	= "HALL2.DAT";
EXTERN const char *grpDat		= "GRP.DAT";
EXTERN const char *roomDat		= "ROOM.DAT";
EXTERN const char *logDat		= "LOG.DAT";
EXTERN const char *log2Dat		= "LOG2.DAT";
EXTERN const char *log3Dat		= "LOG3.DAT";
EXTERN const char *log4Dat		= "LOG4.DAT";
EXTERN const char *log5Dat		= "LOG5.DAT";
EXTERN const char *log6Dat		= "LOG6.DAT";
EXTERN const char *roomposDat	= "ROOMPOS.DAT";
EXTERN const char *cronTab		= "CRON.TAB";
EXTERN const char *lgTab		= "LOG.TAB";
EXTERN const char *msgTab		= "MSG.TAB";
EXTERN const char *rmTab		= "ROOM.TAB";
EXTERN const char *roomreqIn	= "ROOMREQ.IN";
EXTERN const char *roomreqOut	= "ROOMREQ.OUT";
EXTERN const char *roomreqTmp	= "ROOMREQ.TMP";
EXTERN const char *roomdataIn	= "ROOMDATA.IN";
EXTERN const char *roomdataOut	= "ROOMDATA.OUT";
EXTERN const char *newuserLog	= "NEWUSER.LOG";
EXTERN const char *messageApl	= "MESSAGE.APL";
EXTERN const char *ctdlDat		= "CTDL.DAT";
EXTERN const char *mesgTmp		= "MESG.TMP";
EXTERN const char *roomStar 	= "ROOM.*";
EXTERN const char *outputApl	= "OUTPUT.APL";
EXTERN const char *inputApl 	= "INPUT.APL";
EXTERN const char *readmeApl	= "README.APL";
EXTERN const char *consoleApl	= "CONSOLE.APL";
EXTERN const char *starstar 	= "*.*";
EXTERN const char *ctdlMnu		= "CTDL.MNU";
EXTERN const char *ctdlMna		= "CTDL.MN@";
EXTERN const char *bordersDat	= "BORDERS.DAT";

EXTERN const char *sbs			= "%s\\%s";

EXTERN const char *FO_A 		= "a";
EXTERN const char *FO_AB		= "ab";
EXTERN const char *FO_AP		= "a+";
EXTERN const char *FO_R 		= "r";
EXTERN const char *FO_W 		= "w";
EXTERN const char *FO_WB		= "wb";
EXTERN const char *FO_RB		= "rb";
EXTERN const char *FO_RPB		= "r+b";
EXTERN const char *FO_WPB		= "w+b";

// --------------------------------------------------------------- TERM_STUFF
// CTRL_A Stuff
EXTERN char MCICodes[][3] =
	{
	"rn",   // MCI_REALNAME
	"ln",   // MCI_LASTNAME
	"pn",   // MCI_PHONENUM
	"ad",   // MCI_ADDR
	"lc",   // MCI_LASTCALLD
	"ab",   // MCI_ACCTBAL
	"rm",   // MCI_ROOMNAME
	"hn",   // MCI_HALLNAME
	"nn",   // MCI_NODENAME
	"np",   // MCI_NODEPHONE
	"df",   // MCI_DISKFREE
	"nm",   // MCI_NUMMSGS
	"cl",   // MCI_CLS  
	"cn",   // MCI_CALLNUM
	"sn",   // MCI_SYSOPNAME
	"cr",   // MCI_CONNRATE
	"pr",   // MCI_PORTRATE
	"mr",   // MCI_MSGROOM
	"bp",   // MCI_BEEPNUM
	"gc",   // MCI_GETCHAR
	"gs",   // MCI_GETSTR
	"pc",   // MCI_PUTCHAR
	"ps",   // MCI_PUTSTR
	"bs",   // MCI_BSNUM
	"os",   // MCI_OUTSPEC
	"sl",   // MCI_SLOW
	"pw",   // MCI_PASSWORD
	"in",   // MCI_INITIALS
	"go",   // MCI_GOTO
	"lb",   // MCI_LABEL
	"cm",   // MCI_COMPARE
	"gt",   // MCI_GT   
	"lt",   // MCI_LT   
	"eq",   // MCI_EQ
	"rd",   // MCI_RANDOM
	"as",   // MCI_ASSIGN
	"++",   // MCI_ADD
	"--",   // MCI_SUBTRACT
	"**",   // MCI_TIMES
	"//",   // MCI_DIVIDE
	"an",   // MCI_ASGNNEXT
	"hi",   // MCI_HANGINGINDENT
	};

EXTERN const char *TERM_NORMAL		= "0";
EXTERN const char *TERM_BLINK		= "1";
EXTERN const char *TERM_REVERSE 	= "2";
EXTERN const char *TERM_BOLD		= "3";
EXTERN const char *TERM_UNDERLINE	= "4";
EXTERN const char *TERM_FMT_OFF 	= "5";
EXTERN const char *TERM_FMT_ON		= "6";
EXTERN const char *TERM_SPLCHK_OFF	= "7";
EXTERN const char *TERM_SPLCHK_ON	= "8";
EXTERN const char *TERM_USERNAME	= "N";
EXTERN const char *TERM_FIRSTNAME	= "n";
EXTERN const char *TERM_TIME		= "t";
EXTERN const char *TERM_DATE		= "T";
EXTERN const char *TERM_POOP		= "P";
EXTERN const char *TERM_RND_BACK	= "R";
EXTERN const char *TERM_RND_FORE	= "r";

// CTRL_B Stuff
EXTERN const char *TERM_BS		= "B";
EXTERN const char *TERM_IMPERV	= "I";
EXTERN const char *TERM_PAUSE	= "P";
EXTERN const char *TERM_HANGUP	= "H";
EXTERN const char *TERM_CONT	= "C";
EXTERN const char *TERM_MCI_ON	= "M";
EXTERN const char *TERM_MCI_DEF = "m";

// ----------------------------------------------------------------- messages
EXTERN const char *spcts	= " %s";
EXTERN const char *pcts 	= spcts + 1;
EXTERN const char *justs	= spcts + 2;
EXTERN const char *pctd 	= "%d";
EXTERN const char *pctld	= "%ld";
EXTERN const char *pctlu	= "%lu";
EXTERN const char *pct2d	= "%2d";
EXTERN const char *pctc 	= "%c";
EXTERN const char *pctss	= "%s ";
EXTERN const char *sqst 	= " ?";
EXTERN const char *qst		= sqst + 1;
EXTERN const char *bn		= "\n";
EXTERN const char *br		= "\r";
EXTERN const char *spcspc	= "  ";
EXTERN const char *spc		= spcspc + 1;

// -------------------------------------------------------------------- other
EXTERN int		scrollpos	= 23;		// adjusts for help menu
EXTERN uchar cdecl conRows	= 24;		// 1 fewer than the rows
EXTERN uchar cdecl conCols	= 80;
EXTERN int cdecl conMode	= -1;
EXTERN PortSpeedE slv_baud	= PS_ERROR;
EXTERN int		cmd_mdata	= CERROR;

EXTERN const char *ns		= "";

EXTERN long bauds[] =
	{300, 600, 1200, 2400, 4800, 9600, 19200, 38400l, 57600l, 115200l};

EXTERN long connectbauds[] =
	{300, 600, 1200, 2400, 4800, 7200, 9600, 12000, 14400, 16800, 19200,
	21600, 24000, 26400, 28800, 38400l, 57600l, 115200l, 230400l};

EXTERN int iso_clr[]		= {0, 0x4, 0x2, 0x6, 0x1, 0x5, 0x3, 0x7};

#else

// --------------------------------------------------------------- file names
EXTERN const char *etcTab;
EXTERN const char *msgDat;
EXTERN const char *hallDat;
EXTERN const char *hall2Dat;
EXTERN const char *grpDat;
EXTERN const char *roomDat;
EXTERN const char *logDat;
EXTERN const char *log2Dat;
EXTERN const char *log3Dat;
EXTERN const char *log4Dat;
EXTERN const char *log5Dat;
EXTERN const char *log6Dat;
EXTERN const char *roomposDat;
EXTERN const char *cronTab;
EXTERN const char *lgTab;
EXTERN const char *msgTab;
EXTERN const char *rmTab;
EXTERN const char *roomreqIn;
EXTERN const char *roomreqOut;
EXTERN const char *roomreqTmp;
EXTERN const char *roomdataIn;
EXTERN const char *roomdataOut;
EXTERN const char *newuserLog;
EXTERN const char *messageApl;
EXTERN const char *dohelp;
EXTERN const char *ctdlDat;
EXTERN const char *mesgTmp;
EXTERN const char *roomStar;
EXTERN const char *outputApl;
EXTERN const char *inputApl;
EXTERN const char *readmeApl;
EXTERN const char *consoleApl;
EXTERN const char *starstar;
EXTERN const char *ctdlMnu;
EXTERN const char *ctdlMna;
EXTERN const char *bordersDat;

EXTERN const char *sbs;

EXTERN const char *FO_A;
EXTERN const char *FO_AB;
EXTERN const char *FO_AP;
EXTERN const char *FO_R;
EXTERN const char *FO_W;
EXTERN const char *FO_WB;
EXTERN const char *FO_RB;
EXTERN const char *FO_RPB;
EXTERN const char *FO_WPB;

// --------------------------------------------------------------- TERM_STUFF
EXTERN char MCICodes[][3];

// CTRL_A Stuff
EXTERN const char *TERM_NORMAL;
EXTERN const char *TERM_BLINK;
EXTERN const char *TERM_REVERSE;
EXTERN const char *TERM_BOLD;
EXTERN const char *TERM_UNDERLINE;
EXTERN const char *TERM_FMT_OFF;
EXTERN const char *TERM_FMT_ON;
EXTERN const char *TERM_SPLCHK_OFF;
EXTERN const char *TERM_SPLCHK_ON;
EXTERN const char *TERM_USERNAME;
EXTERN const char *TERM_FIRSTNAME;
EXTERN const char *TERM_TIME;
EXTERN const char *TERM_DATE;
EXTERN const char *TERM_POOP;
EXTERN const char *TERM_RND_BACK;
EXTERN const char *TERM_RND_FORE;

// CTRL_B Stuff
EXTERN const char *TERM_BS;
EXTERN const char *TERM_IMPERV;
EXTERN const char *TERM_PAUSE;
EXTERN const char *TERM_HANGUP;
EXTERN const char *TERM_CONT;
EXTERN const char *TERM_MCI_ON;
EXTERN const char *TERM_MCI_DEF;

// ----------------------------------------------------------------- messages
EXTERN const char *spcts;
EXTERN const char *pcts;
EXTERN const char *justs;
EXTERN const char *pctd;
EXTERN const char *pctld;
EXTERN const char *pctlu;
EXTERN const char *pct2d;
EXTERN const char *pctc;
EXTERN const char *pctss;
EXTERN const char *sqst;
EXTERN const char *qst;
EXTERN const char *bn;
EXTERN const char *br;
EXTERN const char *spc;
EXTERN const char *spcspc;

// -------------------------------------------------------------------- other
EXTERN int		scrollpos;
EXTERN uchar cdecl conRows;
EXTERN uchar cdecl conCols;
EXTERN int cdecl conMode;
EXTERN PortSpeedE slv_baud;
EXTERN int		cmd_mdata;

EXTERN const char	*ns;


EXTERN long bauds[];
EXTERN long connectbauds[];
EXTERN int	iso_clr[];

#endif

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
//							uninitialized variables
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// ------------------------------------------------------- EXTERNAL.CIT stuff
EXTERN protocols	*extProtList;		// our external protocols
EXTERN doors		*extDoorList;		// our doors
EXTERN censor		*censorList;		// things we censor
EXTERN pairedStrings *replaceList;		// things we replace
EXTERN userapps 	*userAppList;		// user apps
EXTERN Bool 		noReplace;			// don't replace this stuff...
EXTERN holidays 	*holidayList;		// all the holidays
EXTERN events		*eventList; 		// events
EXTERN intEvents	*intEventList;		// Internal evnets
EXTERN archivers	*arcList;			// archivers, dude
EXTERN pairedStrings *netCmdList;		// #NETCOMMANDs, even.

// -------------------------------------------------------- screensaver stuff
EXTERN ScreenSaverC ScreenSaver;

// -------------------------------------------------------------------- FILEs
EXTERN citFILE		trapfl; 			// trap file descriptor
EXTERN citFILE		roomfl; 			// Room file descriptor
EXTERN citFILE		journalfl;			// journal file descriptor
EXTERN BFILE		*msgfl; 			// msg file buffer

// --------------------------------------------------------------- structures
EXTERN char 		*borders;			// pointer to borders...
EXTERN AccountInfo	*AccountingData;	// From GRPDATA.CIT

// ------------------------------------------------------------ Message stuff
EXTERN uchar		*encbuf;			// huffman stuff

// ------------------------------------------------------------- Screen stuff
EXTERN Bool cdecl (*charattr)(char, uchar, Bool);
EXTERN void cdecl (*stringattr)(uint, const char *, uchar, Bool);

// -------------------------------------------------------------------- other
EXTERN Bool 			dialout_fkey;	// f-keys in dialout mode
EXTERN Bool 			sysReq; 		// Sysop wants system
EXTERN char 			etcpath[64];	// Path ETC.TAB in
EXTERN Bool 			sysopNew;
EXTERN long 			uptimestamp;	// when the bbs was put up
EXTERN Bool 			sysopkey;		// F6 pressed
EXTERN Bool 			eventkey;		// Alt-E pressed
EXTERN Bool 			forceevent; 	// Alt-F pressed
EXTERN Bool 			repeatevent;	// Alt-R pressed


#ifdef MULTI
EXTERN taskInfo 	*ti;				// task info
#endif

EXTERN char 		fullExePath[80];	// Full path to the .EXE file

EXTERN Bool 		debug;				// print debugging messages?
EXTERN Bool 		readconfigcit;		// Force read of config.cit?

EXTERN CronC		Cron;				// Cron poop.

EXTERN Bool 		grpZap; 			// need to make GRP.DAT
EXTERN Bool 		hallZap;			// need to make HALL?.DAT
EXTERN Bool 		msgZap; 			// need to make MSG.DAT
EXTERN Bool 		logZap; 			// need to make LOG*.DAT
EXTERN Bool 		log2Zap;			// need to make LOG2.DAT
EXTERN Bool 		log3Zap;			// need to make LOG3.DAT
EXTERN Bool 		log4Zap;			// need to make LOG4.DAT
EXTERN Bool 		log5Zap;			// need to make LOG5.DAT
EXTERN Bool 		log6Zap;			// need to make LOG6.DAT
EXTERN Bool 		roomZap;			// need to make ROOM.DAT
EXTERN Bool 		roomposZap; 		// need to make ROOMPOS.DAT

EXTERN Bool 		roomBuild;			// Rebuild room-file?
EXTERN Bool 		hallBuild;			// Rebuild hall-file?

EXTERN Bool 		slv_door;			// citadel as a slave?
EXTERN Bool 		slv_net;
EXTERN label		slv_node;
EXTERN int			return_code;

EXTERN Bool 		login_user; 		// user name from command line
EXTERN Bool 		login_pw;			// login user using in and pw

EXTERN char 		cmd_login[LABELSIZE+LABELSIZE+2];
EXTERN char 		cmd_script[80]; 	// Script to run on startup.

EXTERN int			cmd_nobells;
EXTERN Bool 		cmd_nochat;

EXTERN Bool 		reconfig;			// Ctdl -C hit for reconfigure
EXTERN Bool 		batchmode;			// Don't need -C

EXTERN Bool 		sysMail;			// waiting mail for sysop...

EXTERN Bool 		CitWindowsVid;		// Have to worry about video?
EXTERN Bool 		CitWindowsKbd;		// Have to worry about keyboard?
EXTERN Bool 		CitWindowsCsr;		// Have to worry about cursor?

extern int			hufOrig, hufNew;	// size of compressed stuff

EXTERN char 		msgFile[64];

EXTERN long 		newmessagek;		// New size values
EXTERN int			newmaxlogtab;		// New size values
EXTERN int			newmaxhalls;		// New size values
EXTERN int			newmaxgroups;		// New size values
EXTERN int			newmaxrooms;		// New size values

EXTERN statRecord	*statList;			// the f4 list
EXTERN int			sl_start;			// where valid data starts...
EXTERN int			sl_end; 			// ...and ends
EXTERN Bool 		updateStatus;		// need to update f4 list

EXTERN discardable	*msgs;				// general messages
EXTERN discardable	*netmsgs;			// net messages
EXTERN discardable	*sysmsgs;			// sysop messages
EXTERN discardable	*cfgmsgs;			// configuration messages
EXTERN discardable	*ecmsgs;			// .Enter Configuration messages
EXTERN discardable	*fsmsgs;			// full screen sysop messages
EXTERN discardable	*cwmsgs;			// CitWindows messages
EXTERN discardable	*zmmsgs;			// Zmodem messages
EXTERN discardable	*dbmsgs;			// Debug messages

EXTERN const char	**msgsI;			// Index
EXTERN const char	**netmsgsI; 		// Index
EXTERN const char	**sysmsgsI; 		// Index
EXTERN const char	**cfgmsgsI; 		// Index
EXTERN const char	**ecmsgsI;			// Index
EXTERN const char	**fsmsgsI;			// Index
EXTERN const char	**cwmsgsI;			// Index
EXTERN const char	**zmmsgsI;			// Index
EXTERN const char	**dbmsgsI;			// Index

EXTERN discardable	*dateInfo;			// months, days...
EXTERN const char	**monthTab; 		// Jan, Feb, Mar...
EXTERN const char	**fullmnts; 		// January, February, March...
EXTERN const char	**days; 			// Sun, Mon, Tue...
EXTERN const char	**fulldays; 		// Sunday, Monday, Tuesday...
EXTERN const char	*amPtr, *pmPtr; 	// AM and PM

EXTERN StatusLineC	StatusLine; 		// The status line.

EXTERN uchar		s_conRows;

EXTERN ulong		last_console_login_callno;

EXTERN int			oPhys;

EXTERN label		c86_there;
EXTERN char 		cmdLine[130];

EXTERN char cdecl	*physScreen;		// physical address of screen
EXTERN char cdecl	*dgLogiScreen;		// Copy from ti. This is a Kludge.
EXTERN int cdecl	dgLogiCol;			// Kludge.
EXTERN int cdecl	dgLogiRow;			// Kludge.

EXTERN RLMlist		*RLMmod;			// Initialized RLMs
EXTERN RLMfuncs 	*RLMdo; 			// Callable RLM functions

EXTERN OSTypeE		OSType; 			// What are we running on?
EXTERN int			OSMajor;			// Major version number.
EXTERN int			OSMinor;			// Minor version number.

EXTERN uint cdecl	mouseFlags;
EXTERN uint cdecl	mouseButtons;
EXTERN uint cdecl	mouseX;
EXTERN uint cdecl	mouseY;
EXTERN Bool cdecl	mouseEvent;


// ------------------------------------------------------------- Keyboard Poo
EXTERN void *kbdDriver;
EXTERN label kdDesc;
EXTERN void cdecl (*initkbd)(void);
EXTERN void cdecl (*deinitkbd)(void);
EXTERN int cdecl (*statcon)(void);
EXTERN int cdecl (*getcon)(void);
EXTERN Bool cdecl (*sp_press)(void);

// ---------------------------------------------------------------- Video Poo
EXTERN void *vidDriver;
EXTERN label vdDesc;

// ---------------------------------------------------------------- Sound Poo
EXTERN void *sndDriver;
EXTERN label sdDesc;
EXTERN int cdecl (*init_sound)(void);
EXTERN int cdecl (*close_sound)(void);
EXTERN int cdecl (*get_version)(void);
EXTERN int cdecl (*query_drivers)(void);
EXTERN int cdecl (*query_status)(void);
EXTERN int cdecl (*start_snd_src)(int which, const void *what);
EXTERN int cdecl (*play_sound)(int which);
EXTERN int cdecl (*stop_sound)(int which);
EXTERN int cdecl (*pause_sound)(int which);
EXTERN int cdecl (*resume_sound)(int which);
EXTERN int cdecl (*read_snd_stat)(int which);
EXTERN int cdecl (*set_midi_map)(int map);
EXTERN int cdecl (*get_src_vol)(int which);
EXTERN int cdecl (*set_src_vol)(int which, int vol);
EXTERN int cdecl (*set_fade_pan)(void *what);
EXTERN int cdecl (*strt_fade_pan)(void);
EXTERN int cdecl (*stop_fade_pan)(int which);
EXTERN int cdecl (*pse_fade_pan)(void);
EXTERN int cdecl (*res_fade_pan)(void);
EXTERN int cdecl (*read_fade_pan)(int which);
EXTERN int cdecl (*get_pan_pos)(int which);
EXTERN int cdecl (*set_pan_pos)(int which, int pos);
EXTERN int cdecl (*say_ascii)(const char *what, int len);


// wincit specific data
#ifdef WINCIT
EXTERN int cxChar, cyChar, cxClient, cyClient, haveMainWindow, haveFocus;
EXTERN int topBorder;
EXTERN HWND hwndMain;
EXTERN HANDLE hInstance;

EXTERN HDC memDC;
EXTERN HBITMAP memBM;
#endif
